#include <metal_stdlib>
using namespace metal;

struct PS_INPUT
{
    float4 gl_Position [[position]];
    float2 uv;
    
    float4 color;
};

struct Params
{
    float4 blurAmount;
    float fSinTime0_X;
};

fragment float4 main_metal
(
 PS_INPUT inPs [[stage_in]],
 texture2d<float>    portalTexture                [[texture(0)]],
 sampler                portalSampler    [[sampler(0)]],
 constant Params &params    [[buffer(PARAMETER_SLOT)]]
 )
{
    int i;
    float4 tmpOutColor;
    float  diffuseGlowFactor;
    float2 offsets[4];
    
    offsets[0] = float2(-1.8,  -1.8);
    offsets[1] = float2(-1.8,  1.8);
    offsets[2] = float2(1.8, -1.8);
    offsets[3] = float2(1.8, 1.8);
    
    tmpOutColor = portalTexture.sample( portalSampler, inPs.uv );
    
    diffuseGlowFactor = 0.0113 * (2.0 - max( tmpOutColor.r, tmpOutColor.g ));
    
    
    for (i = 0; i < 4; i++) {
        tmpOutColor += inPs.color * portalTexture.sample( portalSampler, inPs.uv + params.fSinTime0_X * params.blurAmount.x * diffuseGlowFactor * offsets[i] );
    }
    
    tmpOutColor *= float4(0.25, 0.25, 0.25, 1.0);
    
    return tmpOutColor;
    
//    float3 fragColor = RT.sample(samplerState, inPs.uv0).xyz;
//    return float4( fragColor.xyz, 1.0 ) + color;
}

//uniform sampler2D portalTexture;
//uniform vec4 blurAmount;
//uniform float fSinTime0_X;
//
//in vec2 uv;
//in vec4 color;
//
//layout(location = 0) out vec4 o_fragColor;
//
//void main()
//{
//   int i;
//   vec4 tmpOutColor;
//   float  diffuseGlowFactor;
//   vec2 offsets[4];
//
//
//   offsets[0] = vec2(-1.8,  -1.8);
//   offsets[1] = vec2(-1.8,  1.8);
//   offsets[2] = vec2(1.8, -1.8);
//   offsets[3] = vec2(1.8, 1.8);
//
//   tmpOutColor = texture( portalTexture, uv );
//
//
//   diffuseGlowFactor = 0.0113 * (2.0 - max( tmpOutColor.r, tmpOutColor.g ));
//
//
//   for (i = 0; i < 4; i++) {
//      tmpOutColor += color * texture( portalTexture, uv + fSinTime0_X * blurAmount.x * diffuseGlowFactor * offsets[i] );
//   }
//
//   tmpOutColor *= vec4(0.25, 0.25, 0.25, 1.0);
//
//
//   o_fragColor = tmpOutColor;
//}
