
struct PS_INPUT
{
	float4 color : COLOR;
	float2 uv	: TEXCOORD0;
};

Texture2D<float4> portalTexture	: register(t0);
SamplerState samplerState		: register(s0);

uniform float4 blurAmount;
uniform float fSinTime0_X;

float4 main
( 
	PS_INPUT inPs
) : SV_Target
{	
	int i;
	float4 tmpOutColor;
	float  diffuseGlowFactor;
	float2 offsets[4];


	offsets[0] = float2(-1.8, -1.8);
	offsets[1] = float2(-1.8, 1.8);
	offsets[2] = float2(1.8, -1.8);
	offsets[3] = float2(1.8, 1.8);

	tmpOutColor = portalTexture.Sample( samplerState, inPs.uv );   


	diffuseGlowFactor = 0.0113 * (2.0 - max( tmpOutColor.r, tmpOutColor.g ));


	for (i = 0; i < 4; i++) {
	  tmpOutColor += inPs.color * portalTexture.Sample( samplerState, inPs.uv + fSinTime0_X * blurAmount.x * diffuseGlowFactor * offsets[i] );
	}

	tmpOutColor *= float4(0.25, 0.25, 0.25, 1.0);


	return tmpOutColor;
}
