#include <metal_stdlib>
using namespace metal;

struct PS_INPUT
{
    float4 gl_Position [[position]];
    float2 uv;
    
    float4 color;
};

fragment float4 main_metal
(
 PS_INPUT inPs [[stage_in]],
 texture2d<float>    portalTexture                [[texture(0)]],
 sampler                portalSampler    [[sampler(0)]],
 constant Params &params    [[buffer(PARAMETER_SLOT)]]
 )
{
    
    float4 tmpOutColor = inPs.color * portalTexture.sample( portalSampler, inPs.uv );
    
    
    
    return tmpOutColor;
    
//    float3 fragColor = RT.sample(samplerState, inPs.uv0).xyz;
//    return float4( fragColor.xyz, 1.0 ) + color;
}