@insertpiece( SetCrossPlatformSettings )

layout(std140) uniform;
@property( GLES3+ )
@insertpiece( PrecisionDecl )
@end

@insertpiece( Common_Matrix_DeclUnpackMatrix4x4 )

in vec4 vertex;
@property( hlms_colour )in vec4 colour;@end

@foreach( hlms_uv_count, n )
in vec@value( hlms_uv_count@n ) uv@n;@end

in uint drawId;

@insertpiece( custom_vs_attributes )

@property( !hlms_shadowcaster || !hlms_shadow_uses_depth_texture )
@insertpiece( VStoPS_block )
@end

// START UNIFORM DECLARATION
@insertpiece( PassDecl )
@insertpiece( InstanceDecl )

uniform sampler2D worldMatBuf;
@property( texture_matrix )uniform sampler2D animationMatrixBuf;@end
@insertpiece( custom_vs_uniformDeclaration )
@property( hlms_base_instance )uniform uint baseInstance;@end
// END UNIFORM DECLARATION

@property( !hlms_identity_world )
	@piece( worldViewProj )worldViewProj@end
@end @property( hlms_identity_world )
	@property( !hlms_identity_viewproj_dynamic )
		@piece( worldViewProj )pass.viewProj[@value(hlms_identity_viewproj)]@end
	@end @property( hlms_identity_viewproj_dynamic )
		@piece( worldViewProj )pass.viewProj[instance.materialIdx[finalInstancedId].z]@end
		@end
@end

void main()
{
	@insertpiece( custom_vs_preExecution )
	uint finalInstancedId = baseInstance + drawId;
	@property( !hlms_identity_world )
		mat4 worldViewProj;
		worldViewProj = UNPACK_MAT4( worldMatBuf, finalInstancedId );
	@end

@property( !hlms_dual_paraboloid_mapping )
	gl_Position = vertex * @insertpiece( worldViewProj );
@end

@property( hlms_dual_paraboloid_mapping )
	//Dual Paraboloid Mapping
	gl_Position.w	= 1.0f;
	gl_Position.xyz	= (vertex * @insertpiece( worldViewProj )).xyz;
	float L = length( gl_Position.xyz );
	gl_Position.z	+= 1.0f;
	gl_Position.xy	/= gl_Position.z;
	gl_Position.z	= (L - NearPlane) / (FarPlane - NearPlane);
@end

@property( !hlms_shadowcaster )
@property( hlms_colour )	
outInColour = colour;
@end

@property( texture_matrix )	mat4 textureMatrix;@end

@foreach( out_uv_count, n )
	@property( out_uv@n_texture_matrix )
	textureMatrix = UNPACK_MAT4( animationMatrixBuf, (instance.materialIdx[finalInstancedId].x << 4u) + @value( out_uv@n_tex_unit )u );
	outUv@value( out_uv@n_out_uv ).@insertpiece( out_uv@n_swizzle ) = (vec4( uv@value( out_uv@n_source_uv ).xy, 0, 1 ) * textureMatrix).xy;
@end @property( !out_uv@n_texture_matrix )
		outUv@value( out_uv@n_out_uv ).@insertpiece( out_uv@n_swizzle ) = uv@value( out_uv@n_source_uv ).xy;
@end @end

		outDrawId = finalInstancedId;

@end @property( hlms_shadowcaster )
	@property( GLES3+ )
	float shadowConstantBias = uintBitsToFloat( instance.materialIdx[finalInstancedId].y );
	@end

	@property( !hlms_shadow_uses_depth_texture )
		//Linear depth
		@property( GLES3+ )
		outDepth	= (gl_Position.z - pass.depthRange.x + shadowConstantBias * pass.depthRange.y) * pass.depthRange.y;
		outDepth = (outDepth * 0.5) + 0.5;
		@end
	@end

	//We can't make the depth buffer linear without Z out in the fragment shader;
	//however we can use a cheap approximation ("pseudo linear depth")
	//see http://www.yosoygames.com.ar/wp/2014/01/linear-depth-buffer-my-ass/
	gl_Position.z = (gl_Position.z - pass.depthRange.x + shadowConstantBias * pass.depthRange.y) * pass.depthRange.y * gl_Position.w;
@end
	@insertpiece( custom_vs_posExecution )
}
