/*
 * Created by Sebastian Bugiu on 4/9/23, 10:11 PM
 * sebastian.bugiu@headwayentertainment.net
 * Last modified 5/4/22, 3:09 AM
 * Copyright (c) 2023.
 * All rights reserved.
 */

package headwayent.hotshotengine.resource;

import org.apache.commons.io.Charsets;

import headwayent.hotshotengine.ENG_LittleEndianDataInputStream;
import headwayent.hotshotengine.ENG_Utility;
import headwayent.hotshotengine.exception.ENG_InvalidFormatParsingException;
import headwayent.hotshotengine.scriptcompiler.ENG_CompilerUtil;

import java.io.DataInputStream;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.ArrayList;

@Deprecated
public class ENG_PVRTexture {

    private static final int PVR_TEXTURE_FLAG_TYPE_MASK = 0xff;
    private static final byte[] gPVRTexIdentifier = "PVR!".getBytes(Charsets.US_ASCII);

    public enum PVRTextureFlagType {

        kPVRTextureFlagTypePVRTC_2(24),
        kPVRTextureFlagTypePVRTC_4(25);
        private final int type;

        PVRTextureFlagType(int type) {
            this.type = type;
        }

        public int getType() {
            return type;
        }
    }

    static class PVRTexHeader {
                /*
                 * uint32_t headerLength;
                 *
                 * uint32_t height;
                 *
                 * uint32_t width;
                 *
                 * uint32_t numMipmaps;
                 *
                 * uint32_t flags;
                 *
                 * uint32_t dataLength;
                 *
                 * uint32_t bpp;
                 *
                 * uint32_t bitmaskRed;
                 *
                 * uint32_t bitmaskGreen;
                 *
                 * uint32_t bitmaskBlue;
                 *
                 * uint32_t bitmaskAlpha;
                 *
                 * uint32_t pvrTag;
                 *
                 * uint32_t numSurfs;
                 */

        public int headerLength;
        public int height;
        public int width;
        public int numMipmaps;
        public int flags;
        public int dataLength;
        public int bpp;
        public int bitmaskRed;
        public int bitmaskGreen;
        public int bitmaskBlue;
        public int bitmaskAlpha;
        public int pvrTag;
        public int numSurfs;
    }

    private final ArrayList<ByteBuffer> imageData = new ArrayList<>();
    private int name;
    private int width, height;
    private int internalFormat;
    private boolean hasAlpha;

    public ENG_PVRTexture() {

    }

    public ENG_PVRTexture(String fileName, String path) {
        load(fileName, path);
    }

    public ENG_PVRTexture(int id) {
//                load(ENG_Resource.getFileAsStream(id));
    }

    private PVRTexHeader fillHeader(ENG_LittleEndianDataInputStream fp) {
        PVRTexHeader header = new PVRTexHeader();
        try {
            header.headerLength = fp.readInt();
            header.height = fp.readInt();
            header.width = fp.readInt();
            header.numMipmaps = fp.readInt();
            header.flags = fp.readInt();
            header.dataLength = fp.readInt();
            header.bpp = fp.readInt();
            header.bitmaskRed = fp.readInt();
            header.bitmaskGreen = fp.readInt();
            header.bitmaskBlue = fp.readInt();
            header.bitmaskAlpha = fp.readInt();
            header.pvrTag = fp.readInt();
            header.numSurfs = fp.readInt();
        } catch (IOException e) {

            e.printStackTrace();
        }
        return header;
    }

    public void load(DataInputStream id) {
        ENG_LittleEndianDataInputStream fp = null;
        try {
            fp = new ENG_LittleEndianDataInputStream(
                    id);
            PVRTexHeader header = fillHeader(fp);

            int flags;
            int pvrTag;
            int dataLength;
            int dataOffset = 0;
            int dataSize;
            int blockSize;
            int widthBlocks;
            int heightBlocks;
            int width;
            int height;
            int bpp;
            int formatFlags;

            pvrTag = header.pvrTag;

            if (gPVRTexIdentifier[0] != ((pvrTag >> 0) & 0xff)
                    || gPVRTexIdentifier[1] != ((pvrTag >> 8) & 0xff)
                    || gPVRTexIdentifier[2] != ((pvrTag >> 16) & 0xff)
                    || gPVRTexIdentifier[3] != ((pvrTag >> 24) & 0xff)) {
                throw new ENG_InvalidFormatParsingException();
            }

            flags = header.flags;
            formatFlags = flags & PVR_TEXTURE_FLAG_TYPE_MASK;

            if (formatFlags == PVRTextureFlagType.kPVRTextureFlagTypePVRTC_4.getType()
                    || formatFlags == PVRTextureFlagType.kPVRTextureFlagTypePVRTC_2.getType()) {
                imageData.clear();

                //Extension constants not yet defined by the idiots at google!!!
                if (formatFlags == PVRTextureFlagType.kPVRTextureFlagTypePVRTC_4.getType()) {

                    internalFormat = 0;//GL_COMPRESSED_RGBA_PVRTC_4BPPV1_IMG;

                } else if (formatFlags
                        == PVRTextureFlagType.kPVRTextureFlagTypePVRTC_2.getType()) {

                    internalFormat = 0;//GL_COMPRESSED_RGBA_PVRTC_2BPPV1_IMG;
                }

                this.width = width = header.width;
                this.height = height = header.height;

                this.hasAlpha = header.bitmaskAlpha != 0;

                dataLength = header.dataLength;

                while (dataOffset < dataLength) {
                    if (formatFlags
                            == PVRTextureFlagType.kPVRTextureFlagTypePVRTC_4.getType()) {
                        blockSize = 4 * 4; // Pixel by pixel block size for 4bpp

                        widthBlocks = width / 4;

                        heightBlocks = height / 4;

                        bpp = 4;
                    } else {
                        blockSize = 8 * 4; // Pixel by pixel block size for 2bpp

                        widthBlocks = width / 8;

                        heightBlocks = height / 4;

                        bpp = 2;
                    }

                    // Clamp to minimum number of blocks

                    if (widthBlocks < 2) {
                        widthBlocks = 2;
                    }

                    if (heightBlocks < 2) {
                        heightBlocks = 2;
                    }


                    dataSize = widthBlocks * heightBlocks * ((blockSize * bpp) / 8);

                    ByteBuffer buf = ENG_Utility.allocateDirect(dataSize);
                    //     buf.order(ByteOrder.nativeOrder());
                    //     for (int i = 0; i < dataSize; ++i) {
                    try {
                        int read = fp.read(buf.array());
                        if (read != dataSize) {
                            throw new ENG_InvalidFormatParsingException();
                        }
                    } catch (IOException e) {

                        e.printStackTrace();
                    }
                    //    }
                    imageData.add(buf);

                    dataOffset += dataSize;


                    width = Math.max(width >> 1, 1);

                    height = Math.max(height >> 1, 1);
                }
            }
        } finally {
            ENG_CompilerUtil.close(fp);
        }
    }

    public void load(String fileName, String path) {

                /*
                 * ENG_LittleEndianDataInputStream fp = new
                 * ENG_LittleEndianDataInputStream(
                 * ENG_Resource.getFileAsStream(
                 * ENG_Resource.getFileHandle(fileName, path)));
                 */
        load(ENG_Resource.getFileAsStream(fileName, path));


    }

    /**
     * @return the imageData
     */
    public ArrayList<ByteBuffer> getImageData() {
        return imageData;
    }

    /**
     * @return the name
     */
    public int getName() {
        return name;
    }

    /**
     * @return the width
     */
    public int getWidth() {
        return width;
    }

    /**
     * @return the height
     */
    public int getHeight() {
        return height;
    }

    /**
     * @return the internalFormat
     */
    public int getInternalFormat() {
        return internalFormat;
    }

    /**
     * @return the hasAlpha
     */
    public boolean hasAlpha() {
        return hasAlpha;
    }
}
