/*
 * Created by Sebastian Bugiu on 4/9/23, 10:11 PM
 * sebastian.bugiu@headwayentertainment.net
 * Last modified 8/6/21, 5:14 PM
 * Copyright (c) 2023.
 * All rights reserved.
 */

package headwayent.hotshotengine.renderer.nativeinterface.classwrappers;

import headwayent.hotshotengine.ENG_IDisposable;
import headwayent.hotshotengine.android.AndroidRenderWindow;
import headwayent.hotshotengine.renderer.ENG_Camera;
import headwayent.hotshotengine.renderer.ENG_RenderRoot;
import headwayent.hotshotengine.renderer.ENG_RenderWindow;
import headwayent.hotshotengine.renderer.ENG_SceneManager;
import headwayent.hotshotengine.renderer.nativeinterface.pipeline.ENG_ISlowCall;
import headwayent.hotshotengine.renderer.nativeinterface.pipeline.ENG_SlowCallExecutor;

/**
 * Created by sebas on 21.03.2017.
 */

public class ENG_CompositorWorkspaceNativeWrapper extends ENG_NativeClass implements ENG_IDisposable {

    private final String workspaceName;

    public ENG_CompositorWorkspaceNativeWrapper(final ENG_RenderRoot root,
                                                final ENG_SceneManager sceneManager,
                                                final ENG_RenderWindow renderWindow,
                                                final ENG_Camera camera,
                                                final String workspaceName,
                                                final boolean enabled) {
        ENG_SlowCallExecutor.execute(new ENG_ISlowCall() {
            @Override
            public long execute() {
                setPtr(addWorkspace(
                        root.getPointer(),
                        sceneManager.getPointer(),
                        ((AndroidRenderWindow) renderWindow).getPointer(),
                        camera.getPointer(),
                        workspaceName,
                        enabled));
                return 0;
            }
        });
        this.workspaceName = workspaceName;
    }

    @Override
    public void destroy() {
        removeWorkspace(ENG_RenderRoot.getRenderRoot().getPointer(), getPtr());
    }

    public String getWorkspaceName() {
        return workspaceName;
    }

    public static native long addWorkspace(long rootPtr, long sceneManagerPtr, long renderWindowPtr,
                                           long cameraPtr, String workspaceName, boolean enabled);
    public static native void removeWorkspace(long rootPtr, long workspacePtr);
}
