/*
 * Created by Sebastian Bugiu on 4/9/23, 10:11 PM
 * sebastian.bugiu@headwayentertainment.net
 * Last modified 5/4/22, 3:09 AM
 * Copyright (c) 2023.
 * All rights reserved.
 */

package headwayent.hotshotengine;

import headwayent.hotshotengine.renderer.ENG_Image;
import headwayent.hotshotengine.renderer.ENG_Texture;
import headwayent.hotshotengine.renderer.ENG_Texture.TextureUsage;
import headwayent.hotshotengine.renderer.ENG_TextureManager;
import headwayent.hotshotengine.scriptcompiler.ENG_CompilerUtil;
import headwayent.hotshotengine.scriptcompiler.ENG_TextureCompiler;

import java.util.ArrayList;
import java.util.HashMap;

@Deprecated
public class ENG_TextureLoader {

    private static final HashMap<String, ArrayList<ENG_Image>> textureList = new HashMap<>();

    public static void clearTextureList() {
        textureList.clear();
    }

/*	protected static void addTexture(String name, ArrayList<ENG_Image> imgList) {
		textureList.put(name, imgList);
	}
	
	protected static ArrayList<ENG_Image> get(String name) {
		return textureList.get(name);
	}*/

    public static String loadTexture(String nameWithExtension, String path, boolean useShadowBuffer, TextureUsage usage, boolean fromSDCard) {
        return loadTexture(nameWithExtension, path, useShadowBuffer, false, usage, fromSDCard);
    }

    /**
     * @param nameWithExtension
     * @param path
     * @return The name without extension so it can be used to setTextureName in
     * a texture unit
     */
    public static String loadTexture(String nameWithExtension, String path, boolean useShadowBuffer, boolean addToTextureList,
                                     TextureUsage usage, boolean fromSDCard) {
        String textureName = ENG_CompilerUtil.trimFile(nameWithExtension);
        if (!textureList.containsKey(nameWithExtension)) {
            ArrayList<ENG_Image> textureArr = ENG_TextureCompiler.compileTexture(nameWithExtension, path, fromSDCard);
            if (addToTextureList) {
                textureList.put(nameWithExtension, textureArr);
            }

            ENG_Texture texture = ENG_TextureManager.getSingleton().load(textureName, usage.getUsage());
            texture._loadImages(textureArr, useShadowBuffer);

        }
        return textureName;
    }

    public static String loadTexture(String nameWithExtension, String path,
                                     boolean fromSDCard) {
        return loadTexture(nameWithExtension, path, false, TextureUsage.TU_DEFAULT, fromSDCard);
    }
}
