/*
 * Created by Sebastian Bugiu on 4/9/23, 10:11 PM
 * sebastian.bugiu@headwayentertainment.net
 * Last modified 5/4/22, 3:09 AM
 * Copyright (c) 2023.
 * All rights reserved.
 */

package headwayent.hotshotengine;

import headwayent.blackholedarksun.MainApp;
import headwayent.hotshotengine.renderer.*;
import headwayent.hotshotengine.resource.ENG_ModelLink;
import headwayent.hotshotengine.resource.ENG_ModelResource;
import headwayent.hotshotengine.scriptcompiler.ENG_CompilerUtil;

import java.util.ArrayList;
import java.util.HashMap;

import headwayent.hotshotengine.scriptcompiler.ENG_ModelCompiler;
import org.apache.commons.io.FilenameUtils;

@Deprecated
public class ENG_ModelLoader {

    private static final String MODEL_TYPE_MESH = "mesh";

    private static final HashMap<String, ENG_ModelResource> modelNameToModelCompiler = new HashMap<>();
    private static final HashMap<String, ENG_ModelResource> modelFilenameToModelCompiler = new HashMap<>();

    public static void reloadModelList(boolean fromSDCard) {
        for (ENG_ModelResource modelResource : modelFilenameToModelCompiler.values()) {
            loadModelModernized(modelResource.name,
                    modelResource.modelFilename,
                    modelResource.materialFilename,
                    modelResource.linkList,
                    fromSDCard);
        }

    }

    public static void clearModelList() {
        modelNameToModelCompiler.clear();
        modelFilenameToModelCompiler.clear();
    }

    public static void loadModelListModernized(String fileName, String path, boolean fromSDCard) {
        ArrayList<String> file = ENG_CompilerUtil.loadListFromFile(fileName,
                path);

        loadModelListModernized(file, fromSDCard);
    }

    public static void loadModelListModernized(ArrayList<String> file, boolean fromSDCard) {
        ENG_ModelCompiler modelCompiler = new ENG_ModelCompiler();
        for (String m : file) {
            String[] pathAndFileName = ENG_CompilerUtil.getPathAndFileName(m);
            ArrayList<ENG_ModelResource> modelResources = modelCompiler.compile(pathAndFileName[1], pathAndFileName[0], fromSDCard);
            loadModelResourceListModernized(modelResources, fromSDCard);
        }
    }

    public static void loadModelResourceListModernized(ArrayList<ENG_ModelResource> modelResources, boolean fromSDCard) {
        for (ENG_ModelResource modelResource : modelResources) {
            loadModelModernized(modelResource, fromSDCard);
        }
    }

    public static void loadModelModernized(ENG_ModelResource modelResource, boolean fromSDCard) {
        loadModelModernized(modelResource.name,
                modelResource.modelFilename,
                modelResource.materialFilename,
                modelResource.linkList,
                fromSDCard);
        modelNameToModelCompiler.put(modelResource.name, modelResource);
        modelFilenameToModelCompiler.put(modelResource.modelFilename, modelResource);
    }

    // Link list is useless for the mesh format.
    private static void loadModelModernized(String modelName, String modelFilename, String materialFilename, ArrayList<ENG_ModelLink> linkList, boolean fromSDCard) {
        String[] modelPathAndFileName = ENG_CompilerUtil.getPathAndFileName(modelFilename, fromSDCard);
        String[] materialPathAndFileName = ENG_CompilerUtil.getPathAndFileName(materialFilename, fromSDCard);
        String gameResourcesDir = MainApp.getGame().getGameResourcesDir();
        ENG_MaterialLoader.loadMaterial(materialPathAndFileName[1], gameResourcesDir, fromSDCard);
        loadModel(modelPathAndFileName[1], gameResourcesDir, modelName, fromSDCard);
//		linkModelWithMaterial();
    }

    public static void loadModelList(String fileName, String path,
                                     boolean fromSDCard) {
        ArrayList<String> file = ENG_CompilerUtil.loadListFromFile(fileName,
                path);

        for (String m : file) {
            String[] pathAndFileName = ENG_CompilerUtil.getPathAndFileName(m);
            loadModel(pathAndFileName[1], pathAndFileName[0],
                    pathAndFileName[1], fromSDCard);
        }
    }


    /**
     * This loads a ms3d model from a file and creates the necessary meshes and
     * submeshes that get filled with vertex and index data. It also creates the
     * bounding box and the bounding radius for the newly created mesh.
     *
     * @param fileName
     * @param path
     * @param name     The name to be given to the created mesh
     */
    public static void loadModel(String fileName, String path, String name,
                                 boolean fromSDCard) {
        String extension;
        if (fromSDCard) {
            extension = FilenameUtils.getExtension(fileName);
            if (extension.equalsIgnoreCase(MODEL_TYPE_MESH)) {
                loadMeshModel(fileName, path, name);
            } else {
                throw new IllegalArgumentException(fileName + "" +
                        "does not appear to be a valid mode format");
            }
        } else {
            // It can only be a hm model
            throw new UnsupportedOperationException("HM no longer supported");
        }

    }

    private static void loadMeshModel(String fileName, String path, String name) {
        String basename = FilenameUtils.getBaseName(name);
        if (ENG_MeshManager.getSingleton().getByName(basename) == null) {
            new ENG_MeshSerializer().importMesh(
                    path + "/" + fileName,
                    ENG_MeshManager.getSingleton().createManual(
                            basename));
        }
    }
}
