/*
 * Created by Sebastian Bugiu on 4/9/23, 10:11 PM
 * sebastian.bugiu@headwayentertainment.net
 * Last modified 8/6/21, 5:14 PM
 * Copyright (c) 2023.
 * All rights reserved.
 */

package headwayent.blackholedarksun.physics;

/**
 * Created by sebas on 13-Sep-17.
 */

public class PhysicsProperties {

    public enum CollisionGroup {
        NOTHING(0),
        STANDARD(1),
        TRANSPARENT(1 << 1);

        private final short val;

        CollisionGroup(int i) {
            val = (short) i;
        }

        public short getVal() {
            return val;
        }
    }

    public enum CollisionMask {
        STANDARD(CollisionGroup.STANDARD.getVal()),
        TRANSPARENT(CollisionGroup.TRANSPARENT.getVal() | CollisionGroup.STANDARD.getVal());

        private final short val;

        CollisionMask(int val) {
            this.val = (short) val;
        }

        public short getVal() {
            return val;
        }
    }
}
