/*
 * Created by Sebastian Bugiu on 4/9/23, 10:11 PM
 * sebastian.bugiu@headwayentertainment.net
 * Last modified 8/8/21, 5:10 AM
 * Copyright (c) 2023.
 * All rights reserved.
 */

/* The following code was generated by JFlex 1.6.1 */

package headwayent.blackholedarksun.parser;

import java_cup.runtime.*;
import headwayent.blackholedarksun.parser.*;

/**
 * This class is a simple example lexer.
 */

class Lexer implements java_cup.runtime.Scanner {

  /** This character denotes the end of file */
  public static final int YYEOF = -1;

  /** initial size of the lookahead buffer */
  private static final int ZZ_BUFFERSIZE = 16384;

  /** lexical states */
  public static final int YYINITIAL = 0;
  public static final int STRING = 2;

  /**
   * ZZ_LEXSTATE[l] is the state in the DFA for the lexical state l
   * ZZ_LEXSTATE[l+1] is the state in the DFA for the lexical state l
   *                  at the beginning of a line
   * l is of the form l = 2*k, k a non negative integer
   */
  private static final int ZZ_LEXSTATE[] = { 
     0,  0,  1, 1
  };

  /** 
   * Translates characters to character classes
   */
  private static final String ZZ_CMAP_PACKED = 
    "\11\0\1\3\1\2\1\0\1\3\1\1\16\0\4\0\1\3\1\0"+
    "\1\43\1\0\1\0\5\0\1\5\1\6\1\11\1\6\1\10\1\4"+
    "\12\7\7\0\32\0\1\0\1\46\2\0\1\23\1\0\1\21\1\30"+
    "\1\12\1\25\1\16\1\32\1\40\1\37\1\20\1\42\1\26\1\22"+
    "\1\34\1\17\1\24\1\36\1\0\1\33\1\15\1\14\1\13\1\35"+
    "\1\41\1\31\1\27\1\0\1\44\1\0\1\45\1\0\41\0\2\0"+
    "\4\0\4\0\1\0\2\0\1\0\7\0\1\0\4\0\1\0\5\0"+
    "\27\0\1\0\37\0\1\0\u01ca\0\4\0\14\0\16\0\5\0\7\0"+
    "\1\0\1\0\1\0\21\0\160\0\5\0\1\0\2\0\2\0\4\0"+
    "\10\0\1\0\1\0\3\0\1\0\1\0\1\0\24\0\1\0\123\0"+
    "\1\0\213\0\1\0\5\0\2\0\236\0\11\0\46\0\2\0\1\0"+
    "\7\0\47\0\7\0\1\0\1\0\55\0\1\0\1\0\1\0\2\0"+
    "\1\0\2\0\1\0\1\0\10\0\33\0\5\0\3\0\15\0\5\0"+
    "\6\0\1\0\4\0\13\0\5\0\53\0\37\0\4\0\2\0\1\0"+
    "\143\0\1\0\1\0\10\0\1\0\6\0\2\0\2\0\1\0\4\0"+
    "\2\0\12\0\3\0\2\0\1\0\17\0\1\0\1\0\1\0\36\0"+
    "\33\0\2\0\131\0\13\0\1\0\16\0\12\0\41\0\11\0\2\0"+
    "\4\0\1\0\5\0\26\0\4\0\1\0\11\0\1\0\3\0\1\0"+
    "\5\0\22\0\31\0\3\0\104\0\1\0\1\0\13\0\67\0\33\0"+
    "\1\0\4\0\66\0\3\0\1\0\22\0\1\0\7\0\12\0\2\0"+
    "\2\0\12\0\1\0\7\0\1\0\7\0\1\0\3\0\1\0\10\0"+
    "\2\0\2\0\2\0\26\0\1\0\7\0\1\0\1\0\3\0\4\0"+
    "\2\0\1\0\1\0\7\0\2\0\2\0\2\0\3\0\1\0\10\0"+
    "\1\0\4\0\2\0\1\0\3\0\2\0\2\0\12\0\4\0\7\0"+
    "\1\0\5\0\3\0\1\0\6\0\4\0\2\0\2\0\26\0\1\0"+
    "\7\0\1\0\2\0\1\0\2\0\1\0\2\0\2\0\1\0\1\0"+
    "\5\0\4\0\2\0\2\0\3\0\3\0\1\0\7\0\4\0\1\0"+
    "\1\0\7\0\14\0\3\0\1\0\13\0\3\0\1\0\11\0\1\0"+
    "\3\0\1\0\26\0\1\0\7\0\1\0\2\0\1\0\5\0\2\0"+
    "\1\0\1\0\10\0\1\0\3\0\1\0\3\0\2\0\1\0\17\0"+
    "\2\0\2\0\2\0\12\0\1\0\1\0\17\0\3\0\1\0\10\0"+
    "\2\0\2\0\2\0\26\0\1\0\7\0\1\0\2\0\1\0\5\0"+
    "\2\0\1\0\1\0\7\0\2\0\2\0\2\0\3\0\10\0\2\0"+
    "\4\0\2\0\1\0\3\0\2\0\2\0\12\0\1\0\1\0\20\0"+
    "\1\0\1\0\1\0\6\0\3\0\3\0\1\0\4\0\3\0\2\0"+
    "\1\0\1\0\1\0\2\0\3\0\2\0\3\0\3\0\3\0\14\0"+
    "\4\0\5\0\3\0\3\0\1\0\4\0\2\0\1\0\6\0\1\0"+
    "\16\0\12\0\11\0\1\0\7\0\3\0\1\0\10\0\1\0\3\0"+
    "\1\0\27\0\1\0\12\0\1\0\5\0\3\0\1\0\7\0\1\0"+
    "\3\0\1\0\4\0\7\0\2\0\1\0\2\0\6\0\2\0\2\0"+
    "\2\0\12\0\22\0\2\0\1\0\10\0\1\0\3\0\1\0\27\0"+
    "\1\0\12\0\1\0\5\0\2\0\1\0\1\0\7\0\1\0\3\0"+
    "\1\0\4\0\7\0\2\0\7\0\1\0\1\0\2\0\2\0\2\0"+
    "\12\0\1\0\2\0\17\0\2\0\1\0\10\0\1\0\3\0\1\0"+
    "\51\0\2\0\1\0\7\0\1\0\3\0\1\0\4\0\1\0\10\0"+
    "\1\0\10\0\2\0\2\0\2\0\12\0\12\0\6\0\2\0\2\0"+
    "\1\0\22\0\3\0\30\0\1\0\11\0\1\0\1\0\2\0\7\0"+
    "\3\0\1\0\4\0\6\0\1\0\1\0\1\0\10\0\22\0\2\0"+
    "\15\0\60\0\1\0\2\0\7\0\4\0\10\0\10\0\1\0\12\0"+
    "\47\0\2\0\1\0\1\0\2\0\2\0\1\0\1\0\2\0\1\0"+
    "\6\0\4\0\1\0\7\0\1\0\3\0\1\0\1\0\1\0\1\0"+
    "\2\0\2\0\1\0\4\0\1\0\2\0\6\0\1\0\2\0\1\0"+
    "\2\0\5\0\1\0\1\0\1\0\6\0\2\0\12\0\2\0\4\0"+
    "\40\0\1\0\27\0\2\0\6\0\12\0\13\0\1\0\1\0\1\0"+
    "\1\0\1\0\4\0\2\0\10\0\1\0\44\0\4\0\24\0\1\0"+
    "\2\0\5\0\13\0\1\0\44\0\11\0\1\0\71\0\53\0\24\0"+
    "\1\0\12\0\6\0\6\0\4\0\4\0\3\0\1\0\3\0\2\0"+
    "\7\0\3\0\4\0\15\0\14\0\1\0\17\0\2\0\46\0\1\0"+
    "\1\0\5\0\1\0\2\0\53\0\1\0\u014d\0\1\0\4\0\2\0"+
    "\7\0\1\0\1\0\1\0\4\0\2\0\51\0\1\0\4\0\2\0"+
    "\41\0\1\0\4\0\2\0\7\0\1\0\1\0\1\0\4\0\2\0"+
    "\17\0\1\0\71\0\1\0\4\0\2\0\103\0\2\0\3\0\40\0"+
    "\20\0\20\0\125\0\14\0\u026c\0\2\0\21\0\1\0\32\0\5\0"+
    "\113\0\3\0\3\0\17\0\15\0\1\0\4\0\3\0\13\0\22\0"+
    "\3\0\13\0\22\0\2\0\14\0\15\0\1\0\3\0\1\0\2\0"+
    "\14\0\64\0\40\0\3\0\1\0\3\0\2\0\1\0\2\0\12\0"+
    "\41\0\3\0\2\0\12\0\6\0\130\0\10\0\51\0\1\0\1\0"+
    "\5\0\106\0\12\0\35\0\3\0\14\0\4\0\14\0\12\0\12\0"+
    "\36\0\2\0\5\0\13\0\54\0\4\0\21\0\7\0\2\0\6\0"+
    "\12\0\46\0\27\0\5\0\4\0\65\0\12\0\1\0\35\0\2\0"+
    "\13\0\6\0\12\0\15\0\1\0\130\0\5\0\57\0\21\0\7\0"+
    "\4\0\12\0\21\0\11\0\14\0\3\0\36\0\15\0\2\0\12\0"+
    "\54\0\16\0\14\0\44\0\24\0\10\0\12\0\3\0\3\0\12\0"+
    "\44\0\122\0\3\0\1\0\25\0\4\0\1\0\4\0\3\0\2\0"+
    "\11\0\300\0\47\0\25\0\4\0\u0116\0\2\0\6\0\2\0\46\0"+
    "\2\0\6\0\2\0\10\0\1\0\1\0\1\0\1\0\1\0\1\0"+
    "\1\0\37\0\2\0\65\0\1\0\7\0\1\0\1\0\3\0\3\0"+
    "\1\0\7\0\3\0\4\0\2\0\6\0\4\0\15\0\5\0\3\0"+
    "\1\0\7\0\16\0\5\0\32\0\5\0\20\0\2\0\23\0\1\0"+
    "\13\0\5\0\5\0\6\0\1\0\1\0\15\0\1\0\20\0\15\0"+
    "\3\0\33\0\25\0\15\0\4\0\1\0\3\0\14\0\21\0\1\0"+
    "\4\0\1\0\2\0\12\0\1\0\1\0\3\0\5\0\6\0\1\0"+
    "\1\0\1\0\1\0\1\0\1\0\4\0\1\0\13\0\2\0\4\0"+
    "\5\0\5\0\4\0\1\0\21\0\51\0\u0a77\0\57\0\1\0\57\0"+
    "\1\0\205\0\6\0\4\0\3\0\2\0\14\0\46\0\1\0\1\0"+
    "\5\0\1\0\2\0\70\0\7\0\1\0\17\0\1\0\27\0\11\0"+
    "\7\0\1\0\7\0\1\0\7\0\1\0\7\0\1\0\7\0\1\0"+
    "\7\0\1\0\7\0\1\0\7\0\1\0\40\0\57\0\1\0\u01d5\0"+
    "\3\0\31\0\11\0\6\0\1\0\5\0\2\0\5\0\4\0\126\0"+
    "\2\0\2\0\2\0\3\0\1\0\132\0\1\0\4\0\5\0\51\0"+
    "\3\0\136\0\21\0\33\0\65\0\20\0\u0200\0\u19b6\0\112\0\u51cd\0"+
    "\63\0\u048d\0\103\0\56\0\2\0\u010d\0\3\0\20\0\12\0\2\0"+
    "\24\0\57\0\1\0\4\0\12\0\1\0\31\0\7\0\1\0\120\0"+
    "\2\0\45\0\11\0\2\0\147\0\2\0\4\0\1\0\4\0\14\0"+
    "\13\0\115\0\12\0\1\0\3\0\1\0\4\0\1\0\27\0\5\0"+
    "\20\0\1\0\7\0\64\0\14\0\2\0\62\0\21\0\13\0\12\0"+
    "\6\0\22\0\6\0\3\0\1\0\4\0\12\0\34\0\10\0\2\0"+
    "\27\0\15\0\14\0\35\0\3\0\4\0\57\0\16\0\16\0\1\0"+
    "\12\0\46\0\51\0\16\0\11\0\3\0\1\0\10\0\2\0\2\0"+
    "\12\0\6\0\27\0\3\0\1\0\1\0\4\0\60\0\1\0\1\0"+
    "\3\0\2\0\2\0\5\0\2\0\1\0\1\0\1\0\30\0\3\0"+
    "\2\0\13\0\5\0\2\0\3\0\2\0\12\0\6\0\2\0\6\0"+
    "\2\0\6\0\11\0\7\0\1\0\7\0\221\0\43\0\10\0\1\0"+
    "\2\0\2\0\12\0\6\0\u2ba4\0\14\0\27\0\4\0\61\0\u2104\0"+
    "\u016e\0\2\0\152\0\46\0\7\0\14\0\5\0\5\0\1\0\1\0"+
    "\12\0\1\0\15\0\1\0\5\0\1\0\1\0\1\0\2\0\1\0"+
    "\2\0\1\0\154\0\41\0\u016b\0\22\0\100\0\2\0\66\0\50\0"+
    "\15\0\3\0\20\0\20\0\7\0\14\0\2\0\30\0\3\0\31\0"+
    "\1\0\6\0\5\0\1\0\207\0\2\0\1\0\4\0\1\0\13\0"+
    "\12\0\7\0\32\0\4\0\1\0\1\0\32\0\13\0\131\0\3\0"+
    "\6\0\2\0\6\0\2\0\6\0\2\0\3\0\3\0\2\0\3\0"+
    "\2\0\22\0\3\0\4\0\14\0\1\0\32\0\1\0\23\0\1\0"+
    "\2\0\1\0\17\0\2\0\16\0\42\0\173\0\105\0\65\0\210\0"+
    "\1\0\202\0\35\0\3\0\61\0\57\0\37\0\21\0\33\0\65\0"+
    "\36\0\2\0\44\0\4\0\10\0\1\0\5\0\52\0\236\0\2\0"+
    "\12\0\u0356\0\6\0\2\0\1\0\1\0\54\0\1\0\2\0\3\0"+
    "\1\0\2\0\27\0\252\0\26\0\12\0\32\0\106\0\70\0\6\0"+
    "\2\0\100\0\1\0\3\0\1\0\2\0\5\0\4\0\4\0\1\0"+
    "\3\0\1\0\33\0\4\0\3\0\4\0\1\0\40\0\35\0\203\0"+
    "\66\0\12\0\26\0\12\0\23\0\215\0\111\0\u03b7\0\3\0\65\0"+
    "\17\0\37\0\12\0\20\0\3\0\55\0\13\0\2\0\1\0\22\0"+
    "\31\0\7\0\12\0\6\0\3\0\44\0\16\0\1\0\12\0\100\0"+
    "\3\0\60\0\16\0\4\0\13\0\12\0\u04a6\0\53\0\15\0\10\0"+
    "\12\0\u0936\0\u036f\0\221\0\143\0\u0b9d\0\u042f\0\u33d1\0\u0239\0\u04c7\0"+
    "\105\0\13\0\1\0\56\0\20\0\4\0\15\0\u4060\0\2\0\u2163\0"+
    "\5\0\3\0\26\0\2\0\7\0\36\0\4\0\224\0\3\0\u01bb\0"+
    "\125\0\1\0\107\0\1\0\2\0\2\0\1\0\2\0\2\0\2\0"+
    "\4\0\1\0\14\0\1\0\1\0\1\0\7\0\1\0\101\0\1\0"+
    "\4\0\2\0\10\0\1\0\7\0\1\0\34\0\1\0\4\0\1\0"+
    "\5\0\1\0\1\0\3\0\7\0\1\0\u0154\0\2\0\31\0\1\0"+
    "\31\0\1\0\37\0\1\0\31\0\1\0\37\0\1\0\31\0\1\0"+
    "\37\0\1\0\31\0\1\0\37\0\1\0\31\0\1\0\10\0\2\0"+
    "\62\0\u1600\0\4\0\1\0\33\0\1\0\2\0\1\0\1\0\2\0"+
    "\1\0\1\0\12\0\1\0\4\0\1\0\1\0\1\0\1\0\6\0"+
    "\1\0\4\0\1\0\1\0\1\0\1\0\1\0\1\0\3\0\1\0"+
    "\2\0\1\0\1\0\2\0\1\0\1\0\1\0\1\0\1\0\1\0"+
    "\1\0\1\0\1\0\1\0\2\0\1\0\1\0\2\0\4\0\1\0"+
    "\7\0\1\0\4\0\1\0\4\0\1\0\1\0\1\0\12\0\1\0"+
    "\21\0\5\0\3\0\1\0\5\0\1\0\21\0\u1144\0\ua6d7\0\51\0"+
    "\u1035\0\13\0\336\0\u3fe2\0\u021e\0\uffff\0\uffff\0\uffff\0\uffff\0\uffff\0\uffff\0\uffff\0\uffff\0\uffff\0\uffff\0\uffff\0\u05ee\0"+
    "\1\0\36\0\140\0\200\0\360\0\uffff\0\uffff\0\ufe12\0";

  /** 
   * Translates characters to character classes
   */
  private static final char [] ZZ_CMAP = zzUnpackCMap(ZZ_CMAP_PACKED);

  /** 
   * Translates DFA states to action switch labels.
   */
  private static final int [] ZZ_ACTION = zzUnpackAction();

  private static final String ZZ_ACTION_PACKED_0 =
    "\2\0\1\1\2\2\2\1\1\3\1\1\1\4\17\1"+
    "\1\5\1\6\1\7\2\10\1\3\1\10\1\4\1\11"+
    "\1\12\1\13\2\0\1\14\17\0\1\15\10\0\1\16"+
    "\5\0\1\14\1\17\1\20\1\21\1\22\2\13\26\0"+
    "\1\23\10\0\1\24\2\0\1\13\5\0\1\25\1\0"+
    "\1\26\6\0\1\27\13\0\1\30\14\0\1\31\1\32"+
    "\15\0\1\16\13\0\1\33\3\0\1\34\6\0\1\35"+
    "\5\0\1\36\17\0\1\37\1\0\1\40\6\0\1\41"+
    "\25\0\1\42\1\43\2\0\1\24\11\0\1\44\1\45"+
    "\1\46\5\0\1\47\2\0\1\50\17\0\1\51\6\0"+
    "\1\52\10\0\1\53\6\0\1\54\1\55\2\0\1\56"+
    "\3\0\1\57\13\0\1\60\1\61\4\0\1\62\1\63"+
    "\4\0\1\64\12\0\1\65\1\0\1\66\22\0\1\67"+
    "\2\0\1\70\11\0\1\71\1\0\1\72\2\0\1\73"+
    "\11\0\1\74\4\0\1\75\13\0\1\76";

  private static int [] zzUnpackAction() {
    int [] result = new int[415];
    int offset = 0;
    offset = zzUnpackAction(ZZ_ACTION_PACKED_0, offset, result);
    return result;
  }

  private static int zzUnpackAction(String packed, int offset, int [] result) {
    int i = 0;       /* index in packed string  */
    int j = offset;  /* index in unpacked array */
    int l = packed.length();
    while (i < l) {
      int count = packed.charAt(i++);
      int value = packed.charAt(i++);
      do result[j++] = value; while (--count > 0);
    }
    return j;
  }


  /** 
   * Translates a state to a row index in the transition table
   */
  private static final int [] ZZ_ROWMAP = zzUnpackRowMap();

  private static final String ZZ_ROWMAP_PACKED_0 =
    "\0\0\0\47\0\116\0\165\0\116\0\234\0\303\0\303"+
    "\0\352\0\116\0\u0111\0\u0138\0\u015f\0\u0186\0\u01ad\0\u01d4"+
    "\0\u01fb\0\u0222\0\u0249\0\u0270\0\u0297\0\u02be\0\u02e5\0\u030c"+
    "\0\u0333\0\116\0\116\0\116\0\u035a\0\u0381\0\u0381\0\u03a8"+
    "\0\u035a\0\116\0\u03cf\0\u03f6\0\u041d\0\352\0\352\0\u0444"+
    "\0\u046b\0\u0492\0\u04b9\0\u04e0\0\u0507\0\u052e\0\u0555\0\u057c"+
    "\0\u05a3\0\u05ca\0\u05f1\0\u0618\0\u063f\0\u0666\0\116\0\u068d"+
    "\0\u06b4\0\u06db\0\u0702\0\u0729\0\u0750\0\u0777\0\u079e\0\u07c5"+
    "\0\u07ec\0\u0813\0\u083a\0\u0861\0\u0888\0\u03a8\0\116\0\116"+
    "\0\116\0\116\0\u08af\0\116\0\u08d6\0\u08fd\0\u0924\0\u094b"+
    "\0\u0972\0\u0999\0\u09c0\0\u09e7\0\u0a0e\0\u0a35\0\u0a5c\0\u0a83"+
    "\0\u0aaa\0\u0ad1\0\u0af8\0\u0b1f\0\u0b46\0\u0b6d\0\u0b94\0\u0bbb"+
    "\0\u0be2\0\u0c09\0\u0c30\0\u0c57\0\u0c7e\0\u0ca5\0\u0ccc\0\u0cf3"+
    "\0\u0d1a\0\u0d41\0\u0d68\0\u0d8f\0\u0db6\0\u0ddd\0\u08d6\0\u0e04"+
    "\0\u0e2b\0\u0e52\0\u0e79\0\u0ea0\0\116\0\u0ec7\0\116\0\u0eee"+
    "\0\u0f15\0\u0f3c\0\u0f63\0\u0f8a\0\u0fb1\0\116\0\u0fd8\0\u0fff"+
    "\0\u1026\0\u104d\0\u1074\0\u109b\0\u10c2\0\u10e9\0\u1110\0\u1137"+
    "\0\u115e\0\116\0\u1185\0\u11ac\0\u11d3\0\u11fa\0\u1221\0\u1248"+
    "\0\u126f\0\u1296\0\u12bd\0\u12e4\0\u130b\0\u1332\0\116\0\116"+
    "\0\u1359\0\u1380\0\u13a7\0\u13ce\0\u13f5\0\u141c\0\u1443\0\u146a"+
    "\0\u1491\0\u14b8\0\u14df\0\u1506\0\u152d\0\116\0\u1554\0\u157b"+
    "\0\u15a2\0\u15c9\0\u15f0\0\u1617\0\u163e\0\u1665\0\u168c\0\u16b3"+
    "\0\u16da\0\116\0\u1701\0\u1728\0\u174f\0\116\0\u1776\0\u179d"+
    "\0\u17c4\0\u17eb\0\u1812\0\u1839\0\116\0\u1860\0\u1887\0\u18ae"+
    "\0\u18d5\0\u18fc\0\116\0\u1923\0\u194a\0\u1971\0\u1998\0\u19bf"+
    "\0\u19e6\0\u1a0d\0\u1a34\0\u1a5b\0\u1a82\0\u1aa9\0\u1ad0\0\u1af7"+
    "\0\u1b1e\0\u1b45\0\u1b6c\0\u1b93\0\116\0\u1bba\0\u1be1\0\u1c08"+
    "\0\u1c2f\0\u1c56\0\u1c7d\0\116\0\u1ca4\0\u1ccb\0\u1cf2\0\u1d19"+
    "\0\u1d40\0\u1d67\0\u1d8e\0\u1db5\0\u1ddc\0\u1e03\0\u1e2a\0\u1e51"+
    "\0\u1e78\0\u1e9f\0\u1ec6\0\u1eed\0\u1f14\0\u1f3b\0\u1f62\0\u1f89"+
    "\0\u1fb0\0\116\0\116\0\u1fd7\0\u1ffe\0\116\0\u2025\0\u204c"+
    "\0\u2073\0\u209a\0\u20c1\0\u20e8\0\u210f\0\u2136\0\u215d\0\116"+
    "\0\u2184\0\116\0\u21ab\0\u21d2\0\u21f9\0\u2220\0\u2247\0\116"+
    "\0\u226e\0\u2295\0\116\0\u22bc\0\u22e3\0\u230a\0\u2331\0\u2358"+
    "\0\u237f\0\u23a6\0\u23cd\0\u23f4\0\u241b\0\u2442\0\u2469\0\u2490"+
    "\0\u24b7\0\u24de\0\116\0\u2505\0\u252c\0\u2553\0\u257a\0\u25a1"+
    "\0\u25c8\0\u25ef\0\u2616\0\u263d\0\u2664\0\u268b\0\u26b2\0\u26d9"+
    "\0\u2700\0\u2727\0\116\0\u274e\0\u2775\0\u279c\0\u27c3\0\u27ea"+
    "\0\u2811\0\116\0\116\0\u2838\0\u285f\0\116\0\u2886\0\u28ad"+
    "\0\u28d4\0\116\0\u28fb\0\u2922\0\u2949\0\u2970\0\u2997\0\u29be"+
    "\0\u29e5\0\u2a0c\0\u2a33\0\u2a5a\0\u2a81\0\116\0\116\0\u2aa8"+
    "\0\u2acf\0\u2af6\0\u2b1d\0\116\0\116\0\u2b44\0\u2b6b\0\u2b92"+
    "\0\u2bb9\0\116\0\u2be0\0\u2c07\0\u2c2e\0\u2c55\0\u2c7c\0\u2ca3"+
    "\0\u2cca\0\u2cf1\0\u2d18\0\u2d3f\0\116\0\u2d66\0\116\0\u2d8d"+
    "\0\u2db4\0\u2ddb\0\u2e02\0\u2e29\0\u2e50\0\u2e77\0\u2e9e\0\u2ec5"+
    "\0\u2eec\0\u2f13\0\u2f3a\0\u2f61\0\u2f88\0\u2faf\0\u2fd6\0\u2ffd"+
    "\0\u3024\0\116\0\u304b\0\u3072\0\116\0\u3099\0\u30c0\0\u30e7"+
    "\0\u310e\0\u3135\0\u315c\0\u3183\0\u31aa\0\u31d1\0\116\0\u31f8"+
    "\0\116\0\u321f\0\u3246\0\116\0\u326d\0\u3294\0\u32bb\0\u32e2"+
    "\0\u3309\0\u3330\0\u3357\0\u337e\0\u33a5\0\116\0\u33cc\0\u33f3"+
    "\0\u341a\0\u3441\0\116\0\u3468\0\u348f\0\u34b6\0\u34dd\0\u3504"+
    "\0\u352b\0\u3552\0\u3579\0\u35a0\0\u35c7\0\u35ee\0\116";

  private static int [] zzUnpackRowMap() {
    int [] result = new int[415];
    int offset = 0;
    offset = zzUnpackRowMap(ZZ_ROWMAP_PACKED_0, offset, result);
    return result;
  }

  private static int zzUnpackRowMap(String packed, int offset, int [] result) {
    int i = 0;  /* index in packed string  */
    int j = offset;  /* index in unpacked array */
    int l = packed.length();
    while (i < l) {
      int high = packed.charAt(i++) << 16;
      result[j++] = high | packed.charAt(i++);
    }
    return j;
  }

  /** 
   * The transition table of the DFA
   */
  private static final int [] ZZ_TRANS = zzUnpackTrans();

  private static final String ZZ_TRANS_PACKED_0 =
    "\1\3\1\4\2\5\1\6\1\3\1\7\1\10\1\11"+
    "\1\12\1\13\1\14\1\15\1\16\1\17\1\3\1\20"+
    "\1\21\1\22\1\3\1\23\1\24\2\3\1\25\1\3"+
    "\1\26\1\3\1\27\1\3\1\30\1\31\3\3\1\32"+
    "\1\33\1\34\1\3\1\35\2\3\3\35\1\36\1\37"+
    "\1\40\1\41\31\35\1\42\2\35\1\43\51\0\1\5"+
    "\50\0\1\44\1\45\50\0\1\10\1\46\45\0\1\47"+
    "\52\0\1\50\5\0\1\51\2\0\1\52\12\0\1\53"+
    "\24\0\1\54\60\0\1\55\33\0\1\56\1\0\1\57"+
    "\7\0\1\60\7\0\1\61\1\62\26\0\1\63\11\0"+
    "\1\64\34\0\1\65\43\0\1\66\3\0\1\67\13\0"+
    "\1\70\32\0\1\71\3\0\1\72\52\0\1\73\2\0"+
    "\1\74\31\0\1\75\46\0\1\76\63\0\1\77\30\0"+
    "\1\100\1\101\51\0\1\102\1\103\1\0\1\104\40\0"+
    "\1\105\30\0\1\35\2\0\40\35\1\0\2\35\1\0"+
    "\1\35\2\0\4\35\1\37\1\40\32\35\1\0\2\35"+
    "\1\0\1\35\2\0\4\35\1\106\33\35\1\0\2\35"+
    "\15\0\1\107\2\0\1\110\13\0\1\111\7\0\1\112"+
    "\3\0\1\44\1\113\1\114\44\44\5\115\1\116\41\115"+
    "\14\0\1\117\66\0\1\120\46\0\1\121\33\0\1\122"+
    "\43\0\1\123\66\0\1\124\31\0\1\125\37\0\1\126"+
    "\1\0\1\127\61\0\1\130\35\0\1\131\2\0\1\132"+
    "\51\0\1\133\47\0\1\134\41\0\1\135\46\0\1\136"+
    "\42\0\1\137\62\0\1\140\56\0\1\141\32\0\1\142"+
    "\64\0\1\143\24\0\1\144\42\0\1\145\71\0\1\146"+
    "\27\0\1\147\44\0\1\150\45\0\1\151\64\0\1\152"+
    "\34\0\1\153\42\0\1\154\52\0\1\155\27\0\1\114"+
    "\44\0\5\115\1\156\45\115\1\157\1\156\41\115\15\0"+
    "\1\160\47\0\1\161\66\0\1\162\27\0\1\163\52\0"+
    "\1\164\41\0\1\165\63\0\1\166\30\0\1\167\54\0"+
    "\1\170\53\0\1\171\34\0\1\172\71\0\1\173\46\0"+
    "\1\174\30\0\1\175\37\0\1\176\46\0\1\177\53\0"+
    "\1\200\45\0\1\201\65\0\1\202\35\0\1\203\43\0"+
    "\1\204\41\0\1\205\51\0\1\206\46\0\1\207\43\0"+
    "\1\210\42\0\1\211\73\0\1\212\30\0\1\213\54\0"+
    "\1\214\37\0\1\215\50\0\1\216\24\0\4\115\1\114"+
    "\1\156\41\115\12\0\1\217\67\0\1\220\35\0\1\221"+
    "\64\0\1\222\23\0\1\223\45\0\1\224\47\0\1\225"+
    "\55\0\1\226\47\0\1\227\40\0\1\230\52\0\1\231"+
    "\50\0\1\232\41\0\1\233\40\0\1\234\52\0\1\235"+
    "\44\0\1\236\55\0\1\237\41\0\1\240\6\0\1\241"+
    "\40\0\1\242\41\0\1\243\71\0\1\244\30\0\1\245"+
    "\44\0\1\246\53\0\1\247\47\0\1\250\37\0\1\251"+
    "\46\0\1\252\50\0\1\253\51\0\1\254\43\0\1\255"+
    "\46\0\1\256\56\0\1\257\43\0\1\260\61\0\1\261"+
    "\41\0\1\262\31\0\1\263\50\0\1\264\51\0\1\265"+
    "\64\0\1\266\26\0\1\267\52\0\1\270\44\0\1\271"+
    "\62\0\1\272\27\0\1\273\44\0\1\274\71\0\1\275"+
    "\27\0\1\276\53\0\1\277\43\0\1\300\41\0\1\301"+
    "\51\0\1\302\65\0\1\303\26\0\1\304\52\0\1\305"+
    "\37\0\1\306\55\0\1\307\52\0\1\310\44\0\1\311"+
    "\37\0\1\312\46\0\1\313\52\0\1\314\46\0\1\315"+
    "\40\0\1\316\46\0\1\317\1\320\7\0\1\321\10\0"+
    "\1\322\24\0\1\323\50\0\1\324\62\0\1\325\35\0"+
    "\1\326\51\0\1\327\44\0\1\330\42\0\1\331\54\0"+
    "\1\332\46\0\1\333\40\0\1\334\46\0\1\335\2\0"+
    "\1\336\3\0\1\337\41\0\1\340\43\0\1\341\6\0"+
    "\1\342\11\0\1\343\40\0\1\344\34\0\1\345\46\0"+
    "\1\346\61\0\1\347\36\0\1\350\50\0\1\351\46\0"+
    "\1\352\52\0\1\353\55\0\1\354\30\0\1\355\52\0"+
    "\1\356\45\0\1\357\42\0\1\360\43\0\1\361\65\0"+
    "\1\362\42\0\1\363\41\0\1\364\37\0\1\365\52\0"+
    "\1\366\64\0\1\367\25\0\1\370\50\0\1\371\54\0"+
    "\1\372\60\0\1\373\43\0\1\374\37\0\1\375\46\0"+
    "\1\376\44\0\1\377\51\0\1\u0100\35\0\1\u0101\61\0"+
    "\1\u0102\31\0\1\u0103\56\0\1\u0104\62\0\1\u0105\26\0"+
    "\1\u0106\62\0\1\u0107\1\u0108\54\0\1\u0109\43\0\1\u010a"+
    "\24\0\1\u010b\52\0\1\u010c\51\0\1\u010d\42\0\1\u010e"+
    "\45\0\1\u010f\44\0\1\u0110\46\0\1\u0111\51\0\1\u0112"+
    "\45\0\1\u0113\50\0\1\u0114\43\0\1\u0115\62\0\1\u0116"+
    "\36\0\1\u0117\50\0\1\u0118\47\0\1\u0119\42\0\1\u011a"+
    "\44\0\1\u011b\42\0\1\u011c\66\0\1\u011d\32\0\1\u011e"+
    "\54\0\1\u011f\46\0\1\u0120\36\0\1\u0121\57\0\1\u0122"+
    "\40\0\1\u0123\50\0\1\u0124\46\0\1\u0125\50\0\1\u0126"+
    "\41\0\1\u0127\46\0\1\u0128\50\0\1\u0129\51\0\1\u012a"+
    "\52\0\1\u012b\55\0\1\u012c\27\0\1\u012d\67\0\1\u012e"+
    "\21\0\1\u012f\46\0\1\u0130\66\0\1\u0131\30\0\1\u0132"+
    "\50\0\1\u0133\50\0\1\u0134\50\0\1\u0135\37\0\1\u0136"+
    "\44\0\1\u0137\46\0\1\u0138\50\0\1\u0139\57\0\1\u013a"+
    "\40\0\1\u013b\43\0\1\u013c\57\0\1\u013d\45\0\1\u013e"+
    "\47\0\1\u013f\60\0\1\u0140\31\0\1\u0141\41\0\1\u0142"+
    "\54\0\1\u0143\40\0\1\u0144\63\0\1\u0145\53\0\1\u0146"+
    "\46\0\1\u0147\27\0\1\u0148\42\0\1\u0149\52\0\1\u014a"+
    "\47\0\1\u014b\42\0\1\u014c\46\0\1\u014d\45\0\1\u014e"+
    "\53\0\1\u014f\43\0\1\u0150\45\0\1\u0151\57\0\1\u0152"+
    "\53\0\1\u0153\47\0\1\u0154\33\0\1\u0155\51\0\1\u0156"+
    "\36\0\1\u0157\55\0\1\u0158\56\0\1\u0159\36\0\1\u015a"+
    "\35\0\1\u015b\60\0\1\u015c\40\0\1\u015d\44\0\1\u015e"+
    "\51\0\1\u015f\50\0\1\u0160\40\0\1\u0161\56\0\1\u0162"+
    "\35\0\1\u0163\55\0\1\u0164\61\0\1\u0165\32\0\1\u0166"+
    "\51\0\1\u0167\61\0\1\u0168\22\0\1\u0169\60\0\1\u016a"+
    "\44\0\1\u016b\47\0\1\u016c\47\0\1\u016d\54\0\1\u016e"+
    "\52\0\1\u016f\34\0\1\u0170\44\0\1\u0171\42\0\1\u0172"+
    "\54\0\1\u0173\11\0\1\u0174\27\0\1\u0175\62\0\1\u0176"+
    "\31\0\1\u0177\52\0\1\u0178\50\0\1\u0179\52\0\1\u017a"+
    "\42\0\1\u017b\46\0\1\u017c\55\0\1\u017d\37\0\1\u017e"+
    "\55\0\1\u017f\55\0\1\u0180\21\0\1\u0181\65\0\1\u0182"+
    "\51\0\1\u0183\42\0\1\u0184\36\0\1\u0185\46\0\1\u0186"+
    "\41\0\1\u0187\66\0\1\u0188\32\0\1\u0189\60\0\1\u018a"+
    "\36\0\1\u018b\40\0\1\u018c\50\0\1\u018d\43\0\1\u018e"+
    "\66\0\1\u018f\34\0\1\u0190\41\0\1\u0191\52\0\1\u0192"+
    "\46\0\1\u0193\50\0\1\u0194\63\0\1\u0195\23\0\1\u0196"+
    "\63\0\1\u0197\52\0\1\u0198\25\0\1\u0199\64\0\1\u019a"+
    "\32\0\1\u019b\51\0\1\u019c\50\0\1\u019d\41\0\1\u019e"+
    "\61\0\1\u019f\13\0";

  private static int [] zzUnpackTrans() {
    int [] result = new int[13845];
    int offset = 0;
    offset = zzUnpackTrans(ZZ_TRANS_PACKED_0, offset, result);
    return result;
  }

  private static int zzUnpackTrans(String packed, int offset, int [] result) {
    int i = 0;       /* index in packed string  */
    int j = offset;  /* index in unpacked array */
    int l = packed.length();
    while (i < l) {
      int count = packed.charAt(i++);
      int value = packed.charAt(i++);
      value--;
      do result[j++] = value; while (--count > 0);
    }
    return j;
  }


  /* error codes */
  private static final int ZZ_UNKNOWN_ERROR = 0;
  private static final int ZZ_NO_MATCH = 1;
  private static final int ZZ_PUSHBACK_2BIG = 2;

  /* error messages for the codes above */
  private static final String ZZ_ERROR_MSG[] = {
    "Unknown internal scanner error",
    "Error: could not match input",
    "Error: pushback value was too large"
  };

  /**
   * ZZ_ATTRIBUTE[aState] contains the attributes of state <code>aState</code>
   */
  private static final int [] ZZ_ATTRIBUTE = zzUnpackAttribute();

  private static final String ZZ_ATTRIBUTE_PACKED_0 =
    "\2\0\1\11\1\1\1\11\4\1\1\11\17\1\3\11"+
    "\5\1\1\11\2\1\2\0\1\1\17\0\1\11\10\0"+
    "\1\1\5\0\1\1\4\11\1\1\1\11\26\0\1\1"+
    "\10\0\1\1\2\0\1\1\5\0\1\11\1\0\1\11"+
    "\6\0\1\11\13\0\1\11\14\0\2\11\15\0\1\11"+
    "\13\0\1\11\3\0\1\11\6\0\1\11\5\0\1\11"+
    "\17\0\1\1\1\0\1\11\6\0\1\11\25\0\2\11"+
    "\2\0\1\11\11\0\1\11\1\1\1\11\5\0\1\11"+
    "\2\0\1\11\17\0\1\11\6\0\1\1\10\0\1\11"+
    "\6\0\2\11\2\0\1\11\3\0\1\11\13\0\2\11"+
    "\4\0\2\11\4\0\1\11\12\0\1\11\1\0\1\11"+
    "\22\0\1\11\2\0\1\11\11\0\1\11\1\0\1\11"+
    "\2\0\1\11\11\0\1\11\4\0\1\11\13\0\1\11";

  private static int [] zzUnpackAttribute() {
    int [] result = new int[415];
    int offset = 0;
    offset = zzUnpackAttribute(ZZ_ATTRIBUTE_PACKED_0, offset, result);
    return result;
  }

  private static int zzUnpackAttribute(String packed, int offset, int [] result) {
    int i = 0;       /* index in packed string  */
    int j = offset;  /* index in unpacked array */
    int l = packed.length();
    while (i < l) {
      int count = packed.charAt(i++);
      int value = packed.charAt(i++);
      do result[j++] = value; while (--count > 0);
    }
    return j;
  }

  /** the input device */
  private java.io.Reader zzReader;

  /** the current state of the DFA */
  private int zzState;

  /** the current lexical state */
  private int zzLexicalState = YYINITIAL;

  /** this buffer contains the current text to be matched and is
      the source of the yytext() string */
  private char zzBuffer[] = new char[ZZ_BUFFERSIZE];

  /** the textposition at the last accepting state */
  private int zzMarkedPos;

  /** the current text position in the buffer */
  private int zzCurrentPos;

  /** startRead marks the beginning of the yytext() string in the buffer */
  private int zzStartRead;

  /** endRead marks the last character in the buffer, that has been read
      from input */
  private int zzEndRead;

  /** number of newlines encountered up to the start of the matched text */
  private int yyline;

  /** the number of characters up to the start of the matched text */
  private int yychar;

  /**
   * the number of characters from the last newline up to the start of the 
   * matched text
   */
  private int yycolumn;

  /** 
   * zzAtBOL == true <=> the scanner is currently at the beginning of a line
   */
  private boolean zzAtBOL = true;

  /** zzAtEOF == true <=> the scanner is at the EOF */
  private boolean zzAtEOF;

  /** denotes if the user-EOF-code has already been executed */
  private boolean zzEOFDone;
  
  /** 
   * The number of occupied positions in zzBuffer beyond zzEndRead.
   * When a lead/high surrogate has been read from the input stream
   * into the final zzBuffer position, this will have a value of 1;
   * otherwise, it will have a value of 0.
   */
  private int zzFinalHighSurrogate = 0;

  /* user code: */
  StringBuffer string = new StringBuffer();

  private Symbol symbol(int type) {
    return new Symbol(type, yyline, yycolumn);
  }
  private Symbol symbol(int type, Object value) {
    return new Symbol(type, yyline, yycolumn, value);
  }


  /**
   * Creates a new scanner
   *
   * @param   in  the java.io.Reader to read input from.
   */
  Lexer(java.io.Reader in) {
    this.zzReader = in;
  }


  /** 
   * Unpacks the compressed character translation table.
   *
   * @param packed   the packed character translation table
   * @return         the unpacked character translation table
   */
  private static char [] zzUnpackCMap(String packed) {
    char [] map = new char[0x110000];
    int i = 0;  /* index in packed string  */
    int j = 0;  /* index in unpacked array */
    while (i < 2830) {
      int  count = packed.charAt(i++);
      char value = packed.charAt(i++);
      do map[j++] = value; while (--count > 0);
    }
    return map;
  }


  /**
   * Refills the input buffer.
   *
   * @return      <code>false</code>, iff there was new input.
   * 
   * @exception   java.io.IOException  if any I/O-Error occurs
   */
  private boolean zzRefill() throws java.io.IOException {

    /* first: make room (if you can) */
    if (zzStartRead > 0) {
      zzEndRead += zzFinalHighSurrogate;
      zzFinalHighSurrogate = 0;
      System.arraycopy(zzBuffer, zzStartRead,
                       zzBuffer, 0,
                       zzEndRead-zzStartRead);

      /* translate stored positions */
      zzEndRead-= zzStartRead;
      zzCurrentPos-= zzStartRead;
      zzMarkedPos-= zzStartRead;
      zzStartRead = 0;
    }

    /* is the buffer big enough? */
    if (zzCurrentPos >= zzBuffer.length - zzFinalHighSurrogate) {
      /* if not: blow it up */
      char newBuffer[] = new char[zzBuffer.length*2];
      System.arraycopy(zzBuffer, 0, newBuffer, 0, zzBuffer.length);
      zzBuffer = newBuffer;
      zzEndRead += zzFinalHighSurrogate;
      zzFinalHighSurrogate = 0;
    }

    /* fill the buffer with new input */
    int requested = zzBuffer.length - zzEndRead;
    int numRead = zzReader.read(zzBuffer, zzEndRead, requested);

    /* not supposed to occur according to specification of java.io.Reader */
    if (numRead == 0) {
      throw new java.io.IOException("Reader returned 0 characters. See JFlex examples for workaround.");
    }
    if (numRead > 0) {
      zzEndRead += numRead;
      /* If numRead == requested, we might have requested to few chars to
         encode a full Unicode character. We assume that a Reader would
         otherwise never return half characters. */
      if (numRead == requested) {
        if (Character.isHighSurrogate(zzBuffer[zzEndRead - 1])) {
          --zzEndRead;
          zzFinalHighSurrogate = 1;
        }
      }
      /* potentially more input available */
      return false;
    }

    /* numRead < 0 ==> end of stream */
    return true;
  }

    
  /**
   * Closes the input stream.
   */
  public final void yyclose() throws java.io.IOException {
    zzAtEOF = true;            /* indicate end of file */
    zzEndRead = zzStartRead;  /* invalidate buffer    */

    if (zzReader != null)
      zzReader.close();
  }


  /**
   * Resets the scanner to read from a new input stream.
   * Does not close the old reader.
   *
   * All internal variables are reset, the old input stream 
   * <b>cannot</b> be reused (internal buffer is discarded and lost).
   * Lexical state is set to <tt>ZZ_INITIAL</tt>.
   *
   * Internal scan buffer is resized down to its initial length, if it has grown.
   *
   * @param reader   the new input stream 
   */
  public final void yyreset(java.io.Reader reader) {
    zzReader = reader;
    zzAtBOL  = true;
    zzAtEOF  = false;
    zzEOFDone = false;
    zzEndRead = zzStartRead = 0;
    zzCurrentPos = zzMarkedPos = 0;
    zzFinalHighSurrogate = 0;
    yyline = yychar = yycolumn = 0;
    zzLexicalState = YYINITIAL;
    if (zzBuffer.length > ZZ_BUFFERSIZE)
      zzBuffer = new char[ZZ_BUFFERSIZE];
  }


  /**
   * Returns the current lexical state.
   */
  public final int yystate() {
    return zzLexicalState;
  }


  /**
   * Enters a new lexical state
   *
   * @param newState the new lexical state
   */
  public final void yybegin(int newState) {
    zzLexicalState = newState;
  }


  /**
   * Returns the text matched by the current regular expression.
   */
  public final String yytext() {
    return new String( zzBuffer, zzStartRead, zzMarkedPos-zzStartRead );
  }


  /**
   * Returns the character at position <tt>pos</tt> from the 
   * matched text. 
   * 
   * It is equivalent to yytext().charAt(pos), but faster
   *
   * @param pos the position of the character to fetch. 
   *            A value from 0 to yylength()-1.
   *
   * @return the character at position pos
   */
  public final char yycharat(int pos) {
    return zzBuffer[zzStartRead+pos];
  }


  /**
   * Returns the length of the matched text region.
   */
  public final int yylength() {
    return zzMarkedPos-zzStartRead;
  }


  /**
   * Reports an error that occured while scanning.
   *
   * In a wellformed scanner (no or only correct usage of 
   * yypushback(int) and a match-all fallback rule) this method 
   * will only be called with things that "Can't Possibly Happen".
   * If this method is called, something is seriously wrong
   * (e.g. a JFlex bug producing a faulty scanner etc.).
   *
   * Usual syntax/scanner level error handling should be done
   * in error fallback rules.
   *
   * @param   errorCode  the code of the errormessage to display
   */
  private void zzScanError(int errorCode) {
    String message;
    try {
      message = ZZ_ERROR_MSG[errorCode];
    }
    catch (ArrayIndexOutOfBoundsException e) {
      message = ZZ_ERROR_MSG[ZZ_UNKNOWN_ERROR];
    }

    throw new Error(message);
  } 


  /**
   * Pushes the specified amount of characters back into the input stream.
   *
   * They will be read again by then next call of the scanning method
   *
   * @param number  the number of characters to be read again.
   *                This number must not be greater than yylength()!
   */
  public void yypushback(int number)  {
    if ( number > yylength() )
      zzScanError(ZZ_PUSHBACK_2BIG);

    zzMarkedPos -= number;
  }


  /**
   * Contains user EOF-code, which will be executed exactly once,
   * when the end of file is reached
   */
  private void zzDoEOF() throws java.io.IOException {
    if (!zzEOFDone) {
      zzEOFDone = true;
      yyclose();
    }
  }


  /**
   * Resumes scanning until the next regular expression is matched,
   * the end of input is encountered or an I/O-Error occurs.
   *
   * @return      the next token
   * @exception   java.io.IOException  if any I/O-Error occurs
   */
  public java_cup.runtime.Symbol next_token() throws java.io.IOException {
    int zzInput;
    int zzAction;

    // cached fields:
    int zzCurrentPosL;
    int zzMarkedPosL;
    int zzEndReadL = zzEndRead;
    char [] zzBufferL = zzBuffer;
    char [] zzCMapL = ZZ_CMAP;

    int [] zzTransL = ZZ_TRANS;
    int [] zzRowMapL = ZZ_ROWMAP;
    int [] zzAttrL = ZZ_ATTRIBUTE;

    while (true) {
      zzMarkedPosL = zzMarkedPos;

      boolean zzR = false;
      int zzCh;
      int zzCharCount;
      for (zzCurrentPosL = zzStartRead  ;
           zzCurrentPosL < zzMarkedPosL ;
           zzCurrentPosL += zzCharCount ) {
        zzCh = Character.codePointAt(zzBufferL, zzCurrentPosL, zzMarkedPosL);
        zzCharCount = Character.charCount(zzCh);
        switch (zzCh) {
        case '\u000B':
        case '\u000C':
        case '\u0085':
        case '\u2028':
        case '\u2029':
          yyline++;
          yycolumn = 0;
          zzR = false;
          break;
        case '\r':
          yyline++;
          yycolumn = 0;
          zzR = true;
          break;
        case '\n':
          if (zzR)
            zzR = false;
          else {
            yyline++;
            yycolumn = 0;
          }
          break;
        default:
          zzR = false;
          yycolumn += zzCharCount;
        }
      }

      if (zzR) {
        // peek one character ahead if it is \n (if we have counted one line too much)
        boolean zzPeek;
        if (zzMarkedPosL < zzEndReadL)
          zzPeek = zzBufferL[zzMarkedPosL] == '\n';
        else if (zzAtEOF)
          zzPeek = false;
        else {
          boolean eof = zzRefill();
          zzEndReadL = zzEndRead;
          zzMarkedPosL = zzMarkedPos;
          zzBufferL = zzBuffer;
          if (eof) 
            zzPeek = false;
          else 
            zzPeek = zzBufferL[zzMarkedPosL] == '\n';
        }
        if (zzPeek) yyline--;
      }
      zzAction = -1;

      zzCurrentPosL = zzCurrentPos = zzStartRead = zzMarkedPosL;
  
      zzState = ZZ_LEXSTATE[zzLexicalState];

      // set up zzAction for empty match case:
      int zzAttributes = zzAttrL[zzState];
      if ( (zzAttributes & 1) == 1 ) {
        zzAction = zzState;
      }


      zzForAction: {
        while (true) {
    
          if (zzCurrentPosL < zzEndReadL) {
            zzInput = Character.codePointAt(zzBufferL, zzCurrentPosL, zzEndReadL);
            zzCurrentPosL += Character.charCount(zzInput);
          }
          else if (zzAtEOF) {
            zzInput = YYEOF;
            break zzForAction;
          }
          else {
            // store back cached positions
            zzCurrentPos  = zzCurrentPosL;
            zzMarkedPos   = zzMarkedPosL;
            boolean eof = zzRefill();
            // get translated positions and possibly new buffer
            zzCurrentPosL  = zzCurrentPos;
            zzMarkedPosL   = zzMarkedPos;
            zzBufferL      = zzBuffer;
            zzEndReadL     = zzEndRead;
            if (eof) {
              zzInput = YYEOF;
              break zzForAction;
            }
            else {
              zzInput = Character.codePointAt(zzBufferL, zzCurrentPosL, zzEndReadL);
              zzCurrentPosL += Character.charCount(zzInput);
            }
          }
          int zzNext = zzTransL[ zzRowMapL[zzState] + zzCMapL[zzInput] ];
          if (zzNext == -1) break zzForAction;
          zzState = zzNext;

          zzAttributes = zzAttrL[zzState];
          if ( (zzAttributes & 1) == 1 ) {
            zzAction = zzState;
            zzMarkedPosL = zzCurrentPosL;
            if ( (zzAttributes & 8) == 8 ) break zzForAction;
          }

        }
      }

      // store back cached position
      zzMarkedPos = zzMarkedPosL;

      if (zzInput == YYEOF && zzStartRead == zzCurrentPos) {
        zzAtEOF = true;
            zzDoEOF();
          { return new java_cup.runtime.Symbol(sym.EOF); }
      }
      else {
        switch (zzAction < 0 ? zzAction : ZZ_ACTION[zzAction]) {
          case 1: 
            { throw new Error("Illegal character <"+
                                                    yytext()+">");
            }
          case 63: break;
          case 2: 
            { /* ignore whitespace */
            }
          case 64: break;
          case 3: 
            { return symbol(sym.NUMBER, new Integer(yytext()));
            }
          case 65: break;
          case 4: 
            { return symbol(sym.COMMA);
            }
          case 66: break;
          case 5: 
            { string.setLength(0); yybegin(STRING);
            }
          case 67: break;
          case 6: 
            { return symbol(sym.BRACE_OPEN);
            }
          case 68: break;
          case 7: 
            { return symbol(sym.BRACE_CLOSE);
            }
          case 69: break;
          case 8: 
            { string.append( yytext() );
            }
          case 70: break;
          case 9: 
            { yybegin(YYINITIAL);
                                   return symbol(sym.STRING_LITERAL,
                                   string.toString());
            }
          case 71: break;
          case 10: 
            { string.append('\\');
            }
          case 72: break;
          case 11: 
            { /* ignore comment */
            }
          case 73: break;
          case 12: 
            { return symbol(sym.FLOAT, new Float(yytext()));
            }
          case 74: break;
          case 13: 
            { return symbol(sym.ai);
            }
          case 75: break;
          case 14: 
            { return symbol(sym.msecs);
            }
          case 76: break;
          case 15: 
            { string.append('\t');
            }
          case 77: break;
          case 16: 
            { string.append('\n');
            }
          case 78: break;
          case 17: 
            { string.append('\r');
            }
          case 79: break;
          case 18: 
            { string.append('\"');
            }
          case 80: break;
          case 19: 
            { return symbol(sym.object);
            }
          case 81: break;
          case 20: 
            { return symbol(sym.position);
            }
          case 82: break;
          case 21: 
            { return symbol(sym.type);
            }
          case 83: break;
          case 22: 
            { return symbol(sym.secs);
            }
          case 84: break;
          case 23: 
            { return symbol(sym.exit);
            }
          case 85: break;
          case 24: 
            { return symbol(sym.mesh);
            }
          case 86: break;
          case 25: 
            { return symbol(sym.speed);
            }
          case 87: break;
          case 26: 
            { return symbol(sym.spawn);
            }
          case 88: break;
          case 27: 
            { return symbol(sym.skybox);
            }
          case 89: break;
          case 28: 
            { return symbol(sym.attach);
            }
          case 90: break;
          case 29: 
            { return symbol(sym.detach);
            }
          case 91: break;
          case 30: 
            { return symbol(sym.health);
            }
          case 92: break;
          case 31: 
            { return symbol(sym.look_at);
            }
          case 93: break;
          case 32: 
            { return symbol(sym.obj_def);
            }
          case 94: break;
          case 33: 
            { return symbol(sym.CUTSCENE);
            }
          case 95: break;
          case 34: 
            { return symbol(sym.behavior);
            }
          case 96: break;
          case 35: 
            { return symbol(sym.friendly);
            }
          case 97: break;
          case 36: 
            { return symbol(sym.set_speed);
            }
          case 98: break;
          case 37: 
            { return symbol(sym.show_text);
            }
          case 99: break;
          case 38: 
            { return symbol(sym.end_delay);
            }
          case 100: break;
          case 39: 
            { return symbol(sym.light_dir);
            }
          case 101: break;
          case 40: 
            { return symbol(sym.obj_event);
            }
          case 102: break;
          case 41: 
            { return symbol(sym.light_type);
            }
          case 103: break;
          case 42: 
            { return symbol(sym.play_sound);
            }
          case 104: break;
          case 43: 
            { return symbol(sym.start_delay);
            }
          case 105: break;
          case 44: 
            { return symbol(sym.look_at_pos);
            }
          case 106: break;
          case 45: 
            { return symbol(sym.orientation);
            }
          case 107: break;
          case 46: 
            { return symbol(sym.camera_event);
            }
          case 108: break;
          case 47: 
            { return symbol(sym.change_speed);
            }
          case 109: break;
          case 48: 
            { return symbol(sym.camera_attach_event);
            }
          case 110: break;
          case 49: 
            { return symbol(sym.camera_detach_event);
            }
          case 111: break;
          case 50: 
            { return symbol(sym.show_text_pos);
            }
          case 112: break;
          case 51: 
            { return symbol(sym.INITIAL_CONDS);
            }
          case 113: break;
          case 52: 
            { return symbol(sym.parallel_task);
            }
          case 114: break;
          case 53: 
            { return symbol(sym.completion_time);
            }
          case 115: break;
          case 54: 
            { return symbol(sym.change_position);
            }
          case 116: break;
          case 55: 
            { return symbol(sym.light_power_scale);
            }
          case 117: break;
          case 56: 
            { return symbol(sym.change_orientation);
            }
          case 118: break;
          case 57: 
            { return symbol(sym.light_diffuse_color);
            }
          case 119: break;
          case 58: 
            { return symbol(sym.play_sound_from_pos);
            }
          case 120: break;
          case 59: 
            { return symbol(sym.light_specular_color);
            }
          case 121: break;
          case 60: 
            { return symbol(sym.play_sound_from_obj_pos);
            }
          case 122: break;
          case 61: 
            { return symbol(sym.use_skybox_data_from_level);
            }
          case 123: break;
          case 62: 
            { return symbol(sym.ambient_light_upperhemi_lowerhemi_dir);
            }
          case 124: break;
          default:
            zzScanError(ZZ_NO_MATCH);
        }
      }
    }
  }


}
