/*
 * Created by Sebastian Bugiu on 4/9/23, 10:11 PM
 * sebastian.bugiu@headwayentertainment.net
 * Last modified 11/22/21, 9:43 PM
 * Copyright (c) 2023.
 * All rights reserved.
 */

package headwayent.blackholedarksun.menus;

import headwayent.blackholedarksun.APP_Game;
import headwayent.blackholedarksun.components.CameraProperties.CameraType;
import headwayent.blackholedarksun.MainApp;
import headwayent.blackholedarksun.world.WorldManager;
import headwayent.hotshotengine.Bundle;
import headwayent.hotshotengine.gui.simpleview.*;
import headwayent.hotshotengine.gui.simpleview.ENG_ContainerManager.ContainerFactory;
import headwayent.hotshotengine.gui.simpleview.ENG_View.OnClickListener;
import headwayent.hotshotengine.renderer.ENG_ColorValue;
import headwayent.microedition.rms.*;

public class OptionsMenu extends ENG_Container {

    public static final String OVERLAY_ELEMENT_NAME = "overlay_element_name";
    public static final String MENU_NAME = "menu_name";

    public static class OptionsMenuContainerFactory extends ContainerFactory {

        @Override
        public ENG_Container createContainer(String name, Bundle bundle) {

            return new OptionsMenu(name, bundle);
        }

        @Override
        public void destroyContainer(ENG_Container c) {

            c.destroy();
        }

    }

    private final Bundle bundle;

//	public OptionsMenu(String name, String font) {
//		super(name, font, null);
//		
//	}

    public OptionsMenu(String name, Bundle bundle) {
        super(name, bundle);
        

        this.bundle = bundle;
        ENG_TextView titleView = (ENG_TextView) createView("title", "textview", 0.0f, 0.0f, 100.0f, 10.0f);
        final ENG_Checkbox sound = (ENG_Checkbox) createView("sounds", "checkbox", 0.0f, 12.0f, 100.0f, 20.0f);
        final ENG_Checkbox accel = (ENG_Checkbox) createView("accel", "checkbox", 0.0f, 22.0f, 100.0f, 30.0f);
        final ENG_Checkbox invY = (ENG_Checkbox) createView("invy", "checkbox", 0.0f, 32.0f, 100.0f, 40.0f);
        final ENG_Checkbox cameraView = (ENG_Checkbox) createView("cameraview", "checkbox", 0.0f, 42.0f, 100.0f, 50.0f);
        final ENG_Checkbox vibration = (ENG_Checkbox) createView("vibration", "checkbox", 0.0f, 52.0f, 100.0f, 60.0f);
        ENG_Button ok = (ENG_Button) createView("ok", "button", 0.0f, 62.0f, 100.0f, 76.0f);
        ENG_Button cancel = (ENG_Button) createView("cancel", "button", 0.0f, 82.0f, 100.0f, 96.0f);

        titleView.setText("Options");
        sound.setText("Sounds");
        accel.setText("Use phone inclination to control player");
        invY.setText("Invert Y axis");
        cameraView.setText("Set third person camera");
        vibration.setText("Force Feedback");
        ok.setText("OK");
        cancel.setText("Cancel");

        titleView.setTextSize(APP_Game.GORILLA_DEJAVU_LARGE);
        sound.setTextSize(APP_Game.GORILLA_DEJAVU_MEDIUM);
        accel.setTextSize(APP_Game.GORILLA_DEJAVU_MEDIUM);
        invY.setTextSize(APP_Game.GORILLA_DEJAVU_MEDIUM);
        cameraView.setTextSize(APP_Game.GORILLA_DEJAVU_MEDIUM);
        vibration.setTextSize(APP_Game.GORILLA_DEJAVU_MEDIUM);
        ok.setTextSize(APP_Game.GORILLA_DEJAVU_MEDIUM);
        cancel.setTextSize(APP_Game.GORILLA_DEJAVU_MEDIUM);

        ok.setTextColor(ENG_ColorValue.WHITE);
        ok.setNinePatchBackground(APP_Game.GORILLA_DEJAVU_NOT_PRESSED, APP_Game.GORILLA_DEJAVU_PRESSED);
        cancel.setTextColor(ENG_ColorValue.WHITE);
        cancel.setNinePatchBackground(APP_Game.GORILLA_DEJAVU_NOT_PRESSED, APP_Game.GORILLA_DEJAVU_PRESSED);

        sound.setChecked(MainApp.getGame().isSoundsEnabled());
        accel.setChecked(MainApp.getGame().isAccelerometerEnabled());
        invY.setChecked(MainApp.getGame().isInvertYAxis());
        final boolean thirdPersonCamera = MainApp.getGame().isThirdPersonCamera();
        cameraView.setChecked(MainApp.getGame().isThirdPersonCamera());
        vibration.setChecked(MainApp.getGame().isVibrationEnabled());

        ok.setOnClickListener(new OnClickListener() {

            @Override
            public boolean onClick(int x, int y) {


                MainApp.getGame().setSoundsEnabled(sound.isChecked());
                MainApp.getGame().setAccelerometerEnabled(accel.isChecked());
                MainApp.getGame().setInvertYAxis(invY.isChecked());
                MainApp.getGame().setThirdPersonCamera(cameraView.isChecked());
                MainApp.getGame().setVibrationEnabled(vibration.isChecked());
                if (thirdPersonCamera != cameraView.isChecked()// &&
                        /*WorldManager.getSingleton().getLevelState() ==
						LevelState.STARTED*/) {
                    // We must change the camera if in game
                    WorldManager.getSingleton().setCameraType(cameraView.isChecked() ? CameraType.THIRD_PERSON : CameraType.FIRST_PERSON);
//					if (cameraView.isChecked()) {
//						
//					} else {
//						
//					}
                }
                // First set the new variables then recreate the screen

                byte[] b = new byte[8];
//                b[0] = (byte) shipRadioIndex;

                if (MainApp.getGame().getSound().isEnabled()) {
                    b[1] = (byte) 1;
                } else {
                    b[1] = (byte) 0;
                }

                if (MainApp.getGame().isAccelerometerEnabled()) {
                    b[2] = (byte) 1;
                } else {
                    b[2] = (byte) 0;
                }
//                b[3] = (byte) orientationRadioIndex;
                b[4] = MainApp.getGame().isInvertYAxis() ? (byte) 1 : (byte) 0;
                b[5] = MainApp.getGame().isThirdPersonCamera() ? (byte) 1 : (byte) 0;
                b[6] = MainApp.getGame().isVibrationEnabled() ? (byte) 1 : (byte) 0;
//game.setShipOptionsIndex(shipRadioIndex);
//game.setOrientationIndex(orientationRadioIndex);
                try {
                    RecordStore rs = RecordStore.openRecordStore(
//                                MainActivity.getInstance(),
                            "shipoptions", true);
                    RecordEnumeration rsEnum = rs.enumerateRecords(null, null, true);
                    while (rsEnum.hasNextElement()) {
                        try {
                            rs.deleteRecord(rsEnum.nextRecordId());
                        } catch (InvalidRecordIDException e) {

                            e.printStackTrace();
                        } catch (RecordStoreException e) {
                            e.printStackTrace();
                        }
                    }
                    rsEnum.rebuild();
                    rs.addRecord(b, 0, b.length);
                    rsEnum.destroy();
                    rs.closeRecordStore();
                } catch (RecordStoreException e) {
                    //    gameEngine.errorMsg("Could not save the ship options! You will need to reset them the next time " +
                    //            "you play the game");
//                        Toast.makeText(MainActivity.getInstance(),
//                                "Could not save the options! You will need to reset "
//                                + "them the next time "
//                                + "you play the game", Toast.LENGTH_SHORT).show();
                } catch (RecordStoreNotFoundException e) {

                    e.printStackTrace();
                }
                onBackPressed();
                return true;
            }
        });

        cancel.setOnClickListener(new OnClickListener() {

            @Override
            public boolean onClick(int x, int y) {

                onBackPressed();
                return true;
            }
        });
    }

    private void onBackPressed() {
        ENG_ContainerManager.getSingleton().setPreviousContainer();
//		ENG_ContainerManager.getSingleton().destroyContainer(getName());
//		MainApp.getGame().setPreviousMenuName(null);
//		MenuManager.getSingleton().showPreviousMenuOverlay();
//
//		String menuName = bundle.getString(MENU_NAME);
//		String overlayElementName = bundle.getString(OVERLAY_ELEMENT_NAME);
//
//		final MenuOverlay menu = MenuManager.getSingleton()
//				.getMenuOverlayByName(menuName);
//		final ENG_ButtonOverlayElement optionsMenu = ENG_GUIOverlayManager
//				.getSingleton().getButtonOverlayElementByName(
//						overlayElementName);
//
//		menu.addListener(optionsMenu,
//				new MenuButtonContainerActivityStarterListener(menuName,
//						optionsMenu, ENG_ContainerManager.getSingleton()
//								.createContainer(overlayElementName,
//										"OptionsMenu", bundle)));
    }

}
