/*
 * Created by Sebastian Bugiu on 4/9/23, 10:11 PM
 * sebastian.bugiu@headwayentertainment.net
 * Last modified 4/25/16, 7:40 AM
 * Copyright (c) 2023.
 * All rights reserved.
 */

package headwayent.blackholedarksun.components;

import headwayent.hotshotengine.renderer.ENG_Camera;
import headwayent.hotshotengine.renderer.ENG_SceneNode;

import com.artemis.Component;

public class CameraProperties extends Component {

    public enum CameraType {
        FIRST_PERSON, THIRD_PERSON
    }

    private CameraType type;
    private ENG_SceneNode node;
    private ENG_Camera camera;
    private boolean animatedCamera; // When true it means the MovementSystem does not update the camera position and orientation.

    public CameraProperties() {

    }

    public CameraProperties(ENG_Camera camera, ENG_SceneNode node) {
        this.camera = camera;
        this.node = node;
    }

    public void setNode(ENG_SceneNode node) {
        this.node = node;
    }

    public void setCamera(ENG_Camera camera) {
        this.camera = camera;
    }

    public CameraType getType() {
        return type;
    }

    public void setType(CameraType type) {
        this.type = type;
    }

    public ENG_SceneNode getNode() {
        return node;
    }

    public ENG_Camera getCamera() {
        return camera;
    }

    public boolean isAnimatedCamera() {
        return animatedCamera;
    }

    public void setAnimatedCamera(boolean animatedCamera) {
        this.animatedCamera = animatedCamera;
    }
}
