/*
 * Created by Sebastian Bugiu on 4/9/23, 10:11 PM
 * sebastian.bugiu@headwayentertainment.net
 * Last modified 5/17/21, 11:15 PM
 * Copyright (c) 2023.
 * All rights reserved.
 */

package headwayent.blackholedarksun.components;

import headwayent.blackholedarksun.systems.AISystem.VelocityChange;
import headwayent.hotshotengine.ENG_Utility;
import headwayent.hotshotengine.ENG_Vector4D;

import com.artemis.Component;

public class AIProperties extends Component {

    public enum AIState {
        SEEK_CLOSEST_PLAYER, FOLLOW_PLAYER, SHOOT_PLAYER, EVADE_MISSILE,
        COLLISION_RESPONSE, EVADE_HIT, FOLLOW_PLAYER_SHIP, EVADE_LEVEL_LIMITS, REACH_DESTINATION
    }

    private AIState state = AIState.SEEK_CLOSEST_PLAYER;
    private long followedShip = -1;
    private boolean lockedIn;
    private boolean followCountTimeStarted;
    private long followBeginTime;
    private boolean evadingCollision;
    private long evadingCollisionTimeStarted;
    private boolean enemySelected;
    private long enemySelectionTimeStarted;
    private long weaponCooldownTimeStarted;
    private boolean collided;
    private final ENG_Vector4D collisionEvasionDestination = new ENG_Vector4D();
    private float collisionAngleDirection; // -1 or 1
    private boolean axisAndAngleSelected;
    private float currentCollisionAngle;
    private final ENG_Vector4D initialFrontVec = new ENG_Vector4D();
    private boolean initialFrontVecSet;
    private long collisionResponseMovementTime;
    private boolean collisionResponseMovement;
    private int currentHealth;
    private boolean evadingHit;
    private long hitEvasionTime;
    private boolean patroling;
    private long patrolingRotationTimeStarted;
    private final ENG_Vector4D patrolingRotationAxis = new ENG_Vector4D();
    private float patrolAngleDirection;
    private float currentPatrolingRotationAngle;
    private boolean patrolingRotationStarted;
    private long reloaderShipIncrementWeaponNumTime;
    private boolean reloaderShouldLeaveWorld;
    private float reloaderCurrentAwayAngle;
    private VelocityChange currentVelocityChange;
    private final ENG_Vector4D destination = new ENG_Vector4D(true);
    private boolean reachDestination;
    private boolean destinationReached;
    private long currentShootingAtShip = -1;
    private int currentLaunchedProjectiles;
    private long limitProjectilesLaunchedStartTime;
    private boolean limitProjectilesLaunched;
    private boolean evadeHitDirectionSet;
    private int evadeHitAxis;
    private float evadeHitDirection;

    private String entityName;
    private int setStateNum;

//    private boolean ignoreAI; // Used during portal exit so it doesn't look around

    public AIProperties() {

    }

    public AIState getState() {
        return state;
    }

    public void setState(AIState state) {
        this.state = state;
//        if (MainApp.isOutputDebuggingApplicationStateEnabled()) {
//            MainApp.getMainThread().getDebuggingState().getCurrentFrame().getCurrentFrameInterval().addObject("AI_STATE TEMP " + entityName + " " + (setStateNum++), state);
//        }
//        if (MainApp.getMainThread().isInputState()) {
//            System.out.println("AI_STATE TEMP " + entityName + " " + (setStateNum++) + " " + state);
//        }
    }

    public long getFollowedShip() {
        return followedShip;
    }

    public void setFollowedShip(long followedShip) {
        this.followedShip = followedShip;
    }

    public void resetFollowedShip() {
        this.followedShip = -1;
    }

    public boolean isLockedIn() {
        return lockedIn;
    }

    public void setLockedIn(boolean lockedIn) {
        this.lockedIn = lockedIn;
    }

    public boolean isFollowCountTimeStarted() {
        return followCountTimeStarted;
    }

    public void setFollowCountTimeStarted(boolean followCountTimeStarted) {
        this.followCountTimeStarted = followCountTimeStarted;
    }

    public long getFollowBeginTime() {
        return followBeginTime;
    }

    public void setFollowBeginTime(long followBeginTime) {
        this.followBeginTime = followBeginTime;
    }

    public void setFollowBeginTime() {
        this.followBeginTime = ENG_Utility.currentTimeMillis();
    }

    public boolean isEvadingCollision() {
        return evadingCollision;
    }

    public void setEvadingCollision(boolean evadingCollision) {
        this.evadingCollision = evadingCollision;
    }

    public long getEvadingCollisionTimeStarted() {
        return evadingCollisionTimeStarted;
    }

    public void setEvadingCollisionTimeStarted(long evadingCollisionTimeStarted) {
        this.evadingCollisionTimeStarted = evadingCollisionTimeStarted;
    }

    public void setEvadingCollisionTimeStarted() {
        this.evadingCollisionTimeStarted = ENG_Utility.currentTimeMillis();
    }

    public boolean isEnemySelected() {
        return enemySelected;
    }

    public void setEnemySelected(boolean enemySelected) {
        this.enemySelected = enemySelected;
    }

    public long getEnemySelectionTimeStarted() {
        return enemySelectionTimeStarted;
    }

    public void setEnemySelectionTimeStarted(long enemySelectionTimeStarted) {
        this.enemySelectionTimeStarted = enemySelectionTimeStarted;
    }

    public void setEnemySelectionTimeStarted() {
        this.enemySelectionTimeStarted = ENG_Utility.currentTimeMillis();
    }

    public long getWeaponCooldownTimeStarted() {
        return weaponCooldownTimeStarted;
    }

    public void setWeaponCooldownTimeStarted(long weaponCooldownTimeStarted) {
        this.weaponCooldownTimeStarted = weaponCooldownTimeStarted;
    }

    public void setWeaponCooldownTimeStarted() {
        this.weaponCooldownTimeStarted = ENG_Utility.currentTimeMillis();
    }

    public boolean isCollided() {
        return collided;
    }

    public void setCollided(boolean collided) {
        this.collided = collided;
    }

    public int getCurrentHealth() {
        return currentHealth;
    }

    public void setCurrentHealth(int currentHealth) {
        this.currentHealth = currentHealth;
    }

    public boolean isEvadingHit() {
        return evadingHit;
    }

    public void setEvadingHit(boolean evadingHit) {
        this.evadingHit = evadingHit;
    }

    public long getHitEvasionTime() {
        return hitEvasionTime;
    }

    public void setHitEvasionTime() {
        this.hitEvasionTime = ENG_Utility.currentTimeMillis();
    }

    public void setCollisionEvasionDestination(float x, float y, float z) {
        collisionEvasionDestination.set(x, y, z);
    }

    public void setCollisionEvasionDestination(ENG_Vector4D axis) {
        collisionEvasionDestination.set(axis);
    }

    public void getCollisionEvasionDestination(ENG_Vector4D ret) {
        ret.set(collisionEvasionDestination);
    }

    public ENG_Vector4D getCollisionEvasionDestination() {
        return new ENG_Vector4D(collisionEvasionDestination);
    }

    public float getCollisionAngleDirection() {
        return collisionAngleDirection;
    }

    public void setCollisionAngleDirection(float collisionAngleDirection) {
        this.collisionAngleDirection = Math.signum(collisionAngleDirection);
    /*	if ((collisionAngleDirection > 0.0f &&
                collisionAngleDirection - 1.0f > ENG_Math.FLOAT_EPSILON) ||
				(collisionAngleDirection < 0.0f && 
						collisionAngleDirection + 1.0f < -ENG_Math.FLOAT_EPSILON)) {
			throw new IllegalArgumentException("collisionAngleDirection must be " +
					"either 1.0f or 1.0f");
		}*/

    }

    public boolean isAxisAndAngleSelected() {
        return axisAndAngleSelected;
    }

    public void setAxisAndAngleSelected(boolean axisAndAngleSelected) {
        this.axisAndAngleSelected = axisAndAngleSelected;
    }

    public boolean isInitialFrontVecSet() {
        return initialFrontVecSet;
    }

    public void setInitialFrontVecSet(boolean initialFrontVecSet) {
        this.initialFrontVecSet = initialFrontVecSet;
    }

    public ENG_Vector4D getInitialFrontVec() {
        return new ENG_Vector4D(initialFrontVec);
    }

    public void setInitialFrontVec(ENG_Vector4D initialFrontVec) {
        this.initialFrontVec.set(initialFrontVec);
    }

    public float getCurrentCollisionAngle() {
        return currentCollisionAngle;
    }

    public void setCurrentCollisionAngle(float currentCollisionAngle) {
        this.currentCollisionAngle = currentCollisionAngle;
    }

    public long getCollisionResponseMovementTime() {
        return collisionResponseMovementTime;
    }

    public void setCollisionResponseMovementTime() {
        this.collisionResponseMovementTime = ENG_Utility.currentTimeMillis();
    }

    public boolean isCollisionResponseMovement() {
        return collisionResponseMovement;
    }

    public void setCollisionResponseMovement(boolean collisionResponseMovement) {
        this.collisionResponseMovement = collisionResponseMovement;
    }

    public boolean isPatroling() {
        return patroling;
    }

    public void setPatroling(boolean patroling) {
        this.patroling = patroling;
    }

    public long getPatrolingRotationTimeStarted() {
        return patrolingRotationTimeStarted;
    }

    public void setPatrolingRotationTimeStarted() {
        this.patrolingRotationTimeStarted = ENG_Utility.currentTimeMillis();
    }

    public float getCurrentPatrolingRotationAngle() {
        return currentPatrolingRotationAngle;
    }

    public void setCurrentPatrolingRotationAngle(
            float currentPatrolingRotationAngle) {
        this.currentPatrolingRotationAngle = currentPatrolingRotationAngle;
    }

    public ENG_Vector4D getPatrolingRotationAxis() {
        return new ENG_Vector4D(patrolingRotationAxis);
    }

    public void getPatrolingRotationAxis(ENG_Vector4D ret) {
        ret.set(patrolingRotationAxis);
    }

    public void setPatrolingRotationAxis(ENG_Vector4D patrolingRotationAxis) {
        this.patrolingRotationAxis.set(patrolingRotationAxis);
    }

    public boolean isPatrolingRotationStarted() {
        return patrolingRotationStarted;
    }

    public void setPatrolingRotationStarted(boolean patrolingRotationStarted) {
        this.patrolingRotationStarted = patrolingRotationStarted;
    }

    public float getPatrolAngleDirection() {
        return patrolAngleDirection;
    }

    public void setPatrolAngleDirection(float patrolAngleDirection) {
        this.patrolAngleDirection = Math.signum(patrolAngleDirection);
    }

    public long getReloaderShipIncrementWeaponNumTime() {
        return reloaderShipIncrementWeaponNumTime;
    }

    public void setReloaderShipIncrementWeaponNumTime() {
        this.reloaderShipIncrementWeaponNumTime = ENG_Utility.currentTimeMillis();
    }

    public boolean isReloaderShouldLeaveWorld() {
        return reloaderShouldLeaveWorld;
    }

    public void setReloaderShouldLeaveWorld(boolean reloaderShouldLeaveWorld) {
        this.reloaderShouldLeaveWorld = reloaderShouldLeaveWorld;
    }

    public float getReloaderCurrentAwayAngle() {
        return reloaderCurrentAwayAngle;
    }

    public void setReloaderCurrentAwayAngle(float reloaderCurrentAwayAngle) {
        this.reloaderCurrentAwayAngle = reloaderCurrentAwayAngle;
    }

    public VelocityChange getCurrentVelocityChange() {
        return currentVelocityChange;
    }

    public void setCurrentVelocityChange(VelocityChange currentVelocityChange) {
        this.currentVelocityChange = currentVelocityChange;
    }

    /**
     * @return the destination
     */
    public ENG_Vector4D getDestination() {
        return new ENG_Vector4D(destination);
    }

    public void getDestination(ENG_Vector4D ret) {
        ret.set(destination);
    }

    /**
     * @param destination the destination to set
     */
    public void setDestination(ENG_Vector4D destination) {
        this.destination.set(destination);
    }

    /**
     * @return the reachDestination
     */
    public boolean isReachDestination() {
        return reachDestination;
    }

    /**
     * @param reachDestination the reachDestination to set
     */
    public void setReachDestination(boolean reachDestination) {
        this.reachDestination = reachDestination;
    }

    /**
     * @return the currentShootingAtShip
     */
    public long getCurrentShootingAtShip() {
        return currentShootingAtShip;
    }

    /**
     * @param currentShootingAtShip the currentShootingAtShip to set
     */
    public void setCurrentShootingAtShip(long currentShootingAtShip) {
        this.currentShootingAtShip = currentShootingAtShip;
    }

    /**
     * @return the currentLaunchedProjectiles
     */
    public int getCurrentLaunchedProjectiles() {
        return currentLaunchedProjectiles;
    }

    public void incrementCurrentLaunchedProjectiles() {
        ++currentLaunchedProjectiles;
    }

    public void decrementCurrentLaunchedProjectiles() {
        --currentLaunchedProjectiles;
    }

    /**
     * @param currentLaunchedProjectiles the currentLaunchedProjectiles to set
     */
    public void setCurrentLaunchedProjectiles(int currentLaunchedProjectiles) {
        this.currentLaunchedProjectiles = currentLaunchedProjectiles;
    }

    /**
     * @return the limitProjectilesLaunchedStartTime
     */
    public long getLimitProjectilesLaunchedStartTime() {
        return limitProjectilesLaunchedStartTime;
    }

    /**
     * @param limitProjectilesLaunchedStartTime the limitProjectilesLaunchedStartTime to set
     */
    public void setLimitProjectilesLaunchedStartTime() {
        this.limitProjectilesLaunchedStartTime = ENG_Utility.currentTimeMillis();
    }

    /**
     * @return the limitProjectilesLaunched
     */
    public boolean isLimitProjectilesLaunched() {
        return limitProjectilesLaunched;
    }

    /**
     * @param limitProjectilesLaunched the limitProjectilesLaunched to set
     */
    public void setLimitProjectilesLaunched(boolean limitProjectilesLaunched) {
        this.limitProjectilesLaunched = limitProjectilesLaunched;
    }

    /**
     * @return the destinationReached
     */
    public boolean isDestinationReached() {
        return destinationReached;
    }

    /**
     * @param destinationReached the destinationReached to set
     */
    public void setDestinationReached(boolean destinationReached) {
        this.destinationReached = destinationReached;
    }

    public boolean isEvadeHitDirectionSet() {
        return evadeHitDirectionSet;
    }

    public void setEvadeHitDirectionSet(boolean evadeHitDirectionSet) {
        this.evadeHitDirectionSet = evadeHitDirectionSet;
    }

    public int getEvadeHitAxis() {
        return evadeHitAxis;
    }

    public float getEvadeHitDirection() {
        return evadeHitDirection;
    }

    public void setEvadeHitAxisAndDirection(int evadeHitAxis,
                                            float evadeHitDirection) {
        this.evadeHitAxis = evadeHitAxis;
        this.evadeHitDirection = evadeHitDirection;
    }

    public String getEntityName() {
        return entityName;
    }

    public void setEntityName(String entityName) {
        this.entityName = entityName;
    }

    //		public boolean isIgnoreAI() {
//			return ignoreAI;
//		}
//
//		public void setIgnoreAI(boolean ignoreAI) {
//			this.ignoreAI = ignoreAI;
//		}

}
