//
// Created by sebas on 28.02.2017.
//

#include "OgreRoot.h"
#include "HotshotLoadingScreen.h"
#include "OgreOverlayManager.h"
#include "OgreOverlay.h"
#include "OgreRenderWindow.h"
#include "OgreTextureManager.h"
#include "OgreOverlayContainer.h"

namespace Hotshot
{
    void LoadingScreen::showLoadingScreen(::Ogre::RenderWindow *renderWindow)
    {
        if (showingLoadingScreen)
        {
            return;
        }
        if (!loadingScreenLoaded)
        {
            loadLoadingScreenResources(renderWindow);
            loadingScreenLoaded = true;
        }
        ::Ogre::v1::Overlay *loadingScreenOverlay = ::Ogre::v1::OverlayManager::getSingleton().getByName("Core/LoadingScreenOverlay");
        loadingScreenOverlay->show();
        ::Ogre::Root::getSingleton().renderOneFrame();
        showingLoadingScreen = true;
    }

    void LoadingScreen::hideLoadingScreen()
    {
        if (showingLoadingScreen) {
            ::Ogre::v1::OverlayManager::getSingleton().getByName("Core/LoadingScreenOverlay")->hide();
            showingLoadingScreen = false;
        }
    }

    LoadingScreen &LoadingScreen::getSingleton()
    {
        static LoadingScreen ls;
        return ls;
    }

    void LoadingScreen::loadLoadingScreenResources(::Ogre::RenderWindow *renderWindow)
    {
        unsigned int width;
        unsigned int height;
        unsigned int colourDepth;
        int left;
        int top;
        renderWindow->getMetrics(width, height, colourDepth, left, top);
        ::Ogre::v1::Overlay *loadingScreenOverlay = ::Ogre::v1::OverlayManager::getSingleton().getByName("Core/LoadingScreenOverlay");
        ::Ogre::v1::OverlayContainer *loadingScreen = loadingScreenOverlay->getChild("LoadingScreen");
        const ::Ogre::TexturePtr &loadingScreenTexture = ::Ogre::TextureManager::getSingleton().load("loading_screen.png", "Essential");
        float lsWidth = loadingScreenTexture->getWidth();
        float lsHeight = loadingScreenTexture->getHeight();
        loadingScreen->setLeft(width / 2 - lsWidth / 2);
        loadingScreen->setTop(height / 2 - lsHeight / 2);
        loadingScreen->setWidth(lsWidth);
        loadingScreen->setHeight(lsHeight);
    }


}





