#include <metal_stdlib>
using namespace metal;

struct VS_INPUT
{
    float3 position [[attribute(VES_POSITION)]];
    float4 colour [[attribute(VES_DIFFUSE)]];
    float2 uv0 [[attribute(VES_TEXTURE_COORDINATES)]];
};

struct PS_INPUT
{
    float4 gl_Position [[position]];
    float2 uv;
    
    float4 color;
};

vertex PS_INPUT main_metal
(
     VS_INPUT input [[stage_in]],
 
     constant float4x4 &matWorldViewProjection [[buffer(PARAMETER_SLOT)]]
)
{
    PS_INPUT outVs;
    
    outVs.gl_Position    = ( matWorldViewProjection * float4(input.position, 1.0) );
    outVs.color = input.colour;
    outVs.uv  = input.uv0;
    
    return outVs;
}

//uniform mat4 matWorldViewProjection;
//layout(location = 0) in vec3 vertex;
//layout(location = 1) in vec4 colour;
//layout(location = 2) in vec2 uv0;
//
//out vec2 uv;
//out vec4 color;
//
//void main()
//{
//    gl_Position = matWorldViewProjection * vec4(vertex, 1.0);
//    color = colour;
//    uv  = uv0;
//}
