#version 330

uniform sampler2D portalTexture;
uniform vec4 blurAmount;
uniform float fSinTime0_X;

in vec2 uv;
in vec4 color;

out vec4 o_fragColor;

void main()
{
   int i;
   vec4 tmpOutColor;
   float  diffuseGlowFactor;
   vec2 offsets[4];


   offsets[0] = vec2(-1.8,  -1.8);
   offsets[1] = vec2(-1.8,  1.8);
   offsets[2] = vec2(1.8, -1.8);
   offsets[3] = vec2(1.8, 1.8);

   tmpOutColor = texture( portalTexture, uv );   

   
   diffuseGlowFactor = 0.0113 * (2.0 - max( tmpOutColor.r, tmpOutColor.g ));

   
   for (i = 0; i < 4; i++) {
      tmpOutColor += color * texture( portalTexture, uv + fSinTime0_X * blurAmount.x * diffuseGlowFactor * offsets[i] );
   }

   tmpOutColor *= vec4(0.25, 0.25, 0.25, 1.0);

   
   o_fragColor = tmpOutColor;
}
