#include <metal_stdlib>
using namespace metal;

struct PS_INPUT
{
	float2 uv0;
};

fragment float4 main_metal
(
	PS_INPUT inPs [[stage_in]],
	texture2d<float>	RT				[[texture(0)]],
	sampler				samplerState	[[sampler(0)]],
	constant float4 &color	[[buffer(PARAMETER_SLOT)]]
)
{
	float3 fragColor = RT.sample(samplerState, inPs.uv0).xyz;
	return float4( fragColor.xyz, 1.0 ) + color;
}
