#version 300 es

layout(std140) uniform;


precision highp float;
precision highp int;
precision highp sampler2DArray;
precision highp sampler2DShadow;
precision highp sampler2D;
precision highp samplerCube;
precision highp samplerCubeShadow;

uniform mat4 world_view_proj_matrix;
uniform float pointSize;
in vec3 vertex;
in vec4 colour;
in vec2 uv0;
out vec4 color;
out vec2 texCoords;

vec4 decodeColor(float f)
{
	float r = floor(f / (256.0 * 256.0 * 256.0));
	float g = floor((f - r * 256.0 * 256.0 * 256.0) / 256.0 * 256.0);
	float b = floor((f - r * 256.0 * 256.0 * 256.0 - g * 256.0 * 256.0) / 256.0);
	float a = floor(mod(f, 256.0));
	return vec4(r, g, b, a);
}

void main(void)
{
   gl_Position = world_view_proj_matrix * vec4(vertex, 1.0);   
   color = colour;
   texCoords = uv0;
}
