@piece( PrecisionDecl )
precision highp float;
precision highp int;
precision highp sampler2DArray;
precision highp sampler2DShadow;
precision highp sampler2D;
precision highp samplerCube;
precision highp samplerCubeShadow;
@end

@property( GLES3+ )
@piece( PassDecl )
//Uniforms that change per pass
layout(std140) uniform PassBuffer
{
	//Vertex shader
	mat4 viewProj[2];
	@property( hlms_shadowcaster )
		vec4 depthRange;
	@end
	@insertpiece( custom_passBuffer )
} pass;
@end

@piece( MaterialDecl )
struct Material
{
	vec4 alpha_test_threshold;
	vec4 diffuse;

	uvec4 indices0_3;
	uvec4 indices4_7;
};

layout(std140) uniform MaterialBuf
{
	Material m[@insertpiece( materials_per_buffer )];
} materialArray;
@end
@end

@property( GLES3+ )
@piece( InstanceDecl )
//Uniforms that change per Item/Entity
layout(std140) uniform InstanceBuffer
{
	//.x =
	//Contains the material's start index.
	//
	//.y =
	//shadowConstantBias. Send the bias directly to avoid an
	//unnecessary indirection during the shadow mapping pass.
	//Must be loaded with uintBitsToFloat
	//
	//.z =
	//Contains 0 or 1 to index into pass.viewProj[]. Only used
	//if hlms_identity_viewproj_dynamic is set.
	uvec4 materialIdx[4096];
} instance;
@end
@end

@property( GLES3+ )
@piece( VStoPS_block )
	@property( !hlms_shadowcaster )
		flat out uint outDrawId;
		@property( hlms_colour )out vec4 outInColour;@end
		@foreach( out_uv_half_count, n )
			out vec@value( out_uv_half_count@n ) outUv@n;@end
	@end
	@property( hlms_shadowcaster && !hlms_shadow_uses_depth_texture )	out float outDepth;@end
	@insertpiece( custom_VStoPS )
@end
@piece( VStoPS_block_PS )
	@property( !hlms_shadowcaster )
		flat in uint outDrawId;
		@property( hlms_colour )in vec4 outInColour;@end
		@foreach( out_uv_half_count, n )
			in vec@value( out_uv_half_count@n ) outUv@n;@end
	@end
	@property( hlms_shadowcaster && !hlms_shadow_uses_depth_texture )	in float outDepth;@end
	@insertpiece( custom_VStoPS )
@end
@end
