@insertpiece( SetCrossPlatformSettings )

layout(std140) uniform;
#define FRAG_COLOR		0
@property( GLES3+ )
@insertpiece( PrecisionDecl )
@end

@property( hlms_vpos )
in vec4 gl_FragCoord;
@end

@property( GLES3+ )
@property( !hlms_shadowcaster )
layout(location = FRAG_COLOR) out vec4 outColour;
@end @property( hlms_shadowcaster )
layout(location = FRAG_COLOR) out float outColour;
@end
@end

// START UNIFORM DECLARATION
@property( !hlms_shadowcaster )
@insertpiece( MaterialDecl )
@insertpiece( InstanceDecl )
@end
@insertpiece( custom_ps_uniformDeclaration )
// END UNIFORM DECLARATION
@property( GLES3+ )
@insertpiece( VStoPS_block_PS )
@end

@property( !hlms_shadowcaster )
@property( num_array_textures )uniform sampler2DArray	textureMapsArray[@value( num_array_textures )];@end
@property( num_textures )uniform sampler2D	textureMaps[@value( num_textures )];@end

@property( diffuse )@piece( MultiplyDiffuseConst )* material.diffuse@end @end

@property( diffuse_map || alpha_test || diffuse )Material material;@end

void main()
{
	@insertpiece( custom_ps_preExecution )
@property( diffuse_map || alpha_test || diffuse )
	@property( GLES3+ )
	uint materialId	= instance.materialIdx[outDrawId].x;
	@end
	material = materialArray.m[materialId];
@end
	@insertpiece( custom_ps_posMaterialLoad )

@property( !diffuse_map && !diffuse_map0 )
@property( hlms_colour && !diffuse_map )	
@property( GLES3+ )
outColour = outInColour @insertpiece( MultiplyDiffuseConst );
@end
@end
@property( !hlms_colour && !diffuse )	outColour = vec4(1, 1, 1, 1);@end
@property( !hlms_colour && diffuse )	outColour = material.diffuse;@end
@end

@property( diffuse_map )@property( diffuse_map0 )
	//Load base image
	outColour = texture( @insertpiece( SamplerOrigin0 ), @insertpiece( SamplerUV0 ) ).@insertpiece(diffuse_map0_tex_swizzle);@end

@foreach( diffuse_map, n, 1 )@property( diffuse_map@n )
	vec4 topImage@n = texture( @insertpiece( SamplerOrigin@n ), @insertpiece( SamplerUV@n ) ).@insertpiece(diffuse_map@n_tex_swizzle);@end @end

@foreach( diffuse_map, n, 1 )@property( diffuse_map@n )
	@insertpiece( blend_mode_idx@n )@end @end

	@property( hlms_colour )
	@property( GLES3+ )
	outColour *= outInColour @insertpiece( MultiplyDiffuseConst );
	@end
	@end
	@property( !hlms_colour && diffuse )outColour *= material.diffuse;@end
@end

	@insertpiece( custom_ps_preLights )

@property( alpha_test )
	if( material.alpha_test_threshold.x @insertpiece( alpha_test_cmp_func ) outColour.a )
		discard;@end

	@insertpiece( custom_ps_posExecution )
}

@end @property( hlms_shadowcaster )
	@property( hlms_render_depth_only )
		@set( hlms_disable_stage, 1 )
	@end
void main()
{
	@insertpiece( custom_ps_preExecution )
	@property( GLES3+ )
	outColour = outDepth;
	@end
	@insertpiece( custom_ps_posExecution )
}
@end
