#include <jni.h>
#include "HotshotCommon.h"
#include "JniCommon.h"

#if (HOTSHOT_PLATFORM == HOTSHOT_PLATFORM_ANDROID)
#include <android/asset_manager.h>
#include <android/asset_manager_jni.h>
#include <android/native_window.h>
#include <android/native_window_jni.h>
#endif


//#include <GLES2/gl2.h>

#include "OgrePrerequisites.h"
#include "OgreRoot.h"
#include "OgreParticleFXPlugin.h"
#include "OgreException.h"
#include "OgreConfigFile.h"

#include "OgreRenderWindow.h"
#include "OgreViewport.h"
#include "OgreCamera.h"
#include "OgreItem.h"
#include "OgreSceneQuery.h"

#include "OgreHlmsUnlit.h"
#include "OgreHlmsPbs.h"
#include "OgreHlmsManager.h"
#include "OgreArchiveManager.h"

#if (HOTSHOT_PLATFORM == HOTSHOT_PLATFORM_ANDROID)
#include "Android/OgreAPKFileSystemArchive.h"
#include "Android/OgreAPKZipArchive.h"
#endif

#include "Compositor/OgreCompositorManager2.h"
#include "Compositor/OgreCompositorWorkspace.h"

#include "OgreOverlaySystem.h"
#include "OgreOverlayManager.h"
#include "OgreOverlay.h"
#include "OgreOverlayContainer.h"
#include "OgrePanelOverlayElement.h"
#include "OgreTextAreaOverlayElement.h"

#include "OgreTechnique.h"
#include "OgrePass.h"

#include "OgreFontManager.h"

#include "OgreFrameStats.h"

#include "OgreHlmsUnlitDatablock.h"

#include "OgreMeshManager2.h"
#include "OgreMesh2.h"

#include "OgreWindowEventUtilities.h"
#include "OgrePlatform.h"
//#include "OgreGLES3RenderSystem.h"
//#include "OgreGL3PlusRenderSystem.h"
#include "OgreTextureManager.h"
#if (HOTSHOT_PLATFORM == HOTSHOT_PLATFORM_WIN32)
//#include "OgreWin32Window.h"
//#include "OgreWin32EGLWindow.h"
#include "OgreD3D11RenderWindow.h"
#endif


#include "HotshotGorillaGUISprite.h"
#include "HotshotGorillaGUI.h"
#include "HotshotGorillaGUINinePatch.h"
#include "HotshotLoadingScreen.h"
#include "HotshotGorillaGUIScreenRenderable.h"
#include "HotshotGorillaGUIScreen.h"
#include "CommandBufferUtility.h"
#include "FrameEndListenerExecutor.h"
#include "RayQueryExecuteFrameEndListenerExecutor.h"
#include "DynamicOverlayElement.h"
#include "HotshotTiledAnimation.h"
#include <iostream>
#include <OgreBillboardSet.h>
#include <OgreParticleSystem.h>
#include <OgreMaterialManager.h>
#include "HotshotSceneCompositor.h"

#define TEST_RENDERING_THREAD

enum NativeCallsList {
//    NEWROOT = 1,
//    ROOT_INITIALIZE,
    ROOT_CREATERENDERWINDOW = 1,
//    ROOT_CREATESCENEMANAGER,
//    RENDERSYSTEM_SETCONFIGOPTION,
    SCREEN_CREATE,
    SCREEN_DESTROY,
    SCREEN_CREATELAYER,
    SCREEN_DESTROYLAYER,
    SCREEN_RENDERONCE,
    SCREEN_UPDATEVERTEXLISTSIZE,
    ROOT_RENDERONEFRAME,
    SCREEN_SETVISIBLE,

    CREATE_RAY_QUERY,
    DESTROY_RAY_QUERY,
    RAY_QUERY_SETSORTBYDISTANCE,
    RAY_QUERY_EXECUTE,

    GET_VIEWPORT,

    SCENEMANAGER_ITEM_CREATE,
    SCENEMANAGER_ITEM_CREATE_ALL_PARAMS,
    SCENEMANAGER_ITEM_DESTROY,
    SCENEMANAGER_ITEM_DESTROY_ALL,
    SCENEMANAGER_CREATE_PARTICLE_SYSTEM_STRING,
    SCENEMANAGER_CREATE_PARTICLE_SYSTEM_QUOTA_RESOURCE_GROUP,
    SCENEMANAGER_DESTROY_PARTICLE_SYSTEM,
    SCENEMANAGER_DESTROY_ALL_PARTICLE_SYSTEMS,
    SCENEMANAGER_CREATE_BILLBOARD_SET,
    SCENEMANAGER_DESTROY_BILLBOARD_SET,
    SCENEMANAGER_DESTROY_ALL_BILLBOARD_SETS,
    SCENEMANAGER_CLEAR_SCENE,
    SCENEMANAGER_SET_AMBIENT_LIGHT,
    SCENEMANAGER_SET_SKYBOX,
    SCENEMANAGER_SET_SKYBOX_ALL_PARAMS,
    SCENEMANAGER_SET_SKYBOX_ENABLED,
    SCENEMANAGER_CREATE_SCENE_NODE,
    SCENEMANAGER_CREATE_SCENE_NODE_ALL_PARAMS,
    SCENEMANAGER_DESTROY_SCENE_NODE,
    SCENEMANAGER_CREATE_LIGHT,
    SCENEMANAGER_DESTROY_LIGHT,
    SCENEMANAGER_DESTROY_ALL_LIGHTS,


    SCENENODE_CREATE_CHILD,
    SCENENODE_CREATE_CHILD_ALL_PARAMS,
    SCENENODE_REMOVE_AND_DESTROY,
    SCENENODE_REMOVE_AND_DESTROY_ALL_CHILDREN,
    SCENENODE_ATTACH_OBJECT,
    SCENENODE_ATTACH_PARTICLE_SYSTEM,
    SCENENODE_DETACH_OBJECT,
    SCENENODE_DETACH_ALL_OBJECTS,
    SCENENODE_SETPOSITION_XYZ,
    SCENENODE_SETPOSITION_VEC,
    SCENENODE_SETORIENTATION,
    SCENENODE_SETDERIVEDPOSITION_XYZ,
    SCENENODE_SETDERIVEDPOSITION_VEC,
    SCENENODE_SETDERIVEDORIENTATION,
    SCENENODE_SETSCALING_XYZ,
//        SCENENODE_CREATECHILDSCENENODE,
            SCENENODE_LOOKAT,
    SCENENODE_LOOKAT_ALL_PARAMS,
    SCENENODE_SETVISIBLE,
    SCENENODE_FLIPVISIBILITY,

    LIGHT_SET_TYPE,
    LIGHT_SET_SPOTLIGHT_RANGE,
    LIGHT_SET_DIFFUSE_COLOUR,
    LIGHT_SET_SPECULAR_COLOUR,
    LIGHT_SET_ATTENUATION,
    LIGHT_SET_POWER_SCALE,
    LIGHT_SET_ATTENUATION_BASED_ON_RADIUS,
//    LIGHT_SET_POSITION,
    LIGHT_SET_DIRECTION,

    ITEM_SET_DATABLOCK,
    ITEM_SET_VISIBILITY_FLAGS,

    COMPOSITOR_WORKSPACE_SET_ENABLED,

    CAMERA_INVALIDATE_VIEW,
    CAMERA_GET_PROJECTION_MATRIX,
    CAMERA_GET_VIEW_MATRIX,
    CAMERA_IS_VISIBLE_VEC,
    CAMERA_IS_VISIBLE_AXIS_ALIGNED_BOX,

    GET_ITEMS_AABBS,

    MOVABLE_OBJECT_DETACH_FROM_PARENT,

    OVERLAY_MANAGER_CREATE_OVERLAY,
    OVERLAY_MANAGER_DESTROY_OVERLAY_BY_NAME,
    OVERLAY_MANAGER_DESTROY_OVERLAY_BY_PTR,
    OVERLAY_MANAGER_DESTROY_ALL,
    OVERLAY_MANAGER_GET_BY_NAME,
    OVERLAY_MANAGER_UPDATE_DATA,

    OVERLAY_SHOW,
    OVERLAY_HIDE,

    OVERLAY_ELEMENT_SHOW,
    OVERLAY_ELEMENT_HIDE,
    OVERLAY_ELEMENT_SET_LEFT,
    OVERLAY_ELEMENT_SET_TOP,
    OVERLAY_ELEMENT_SET_WIDTH,
    OVERLAY_ELEMENT_SET_HEIGHT,
    OVERLAY_ELEMENT_SET_CAPTION,
    OVERLAY_ELEMENT_SET_METRICS_MODE,
//        OVERLAY_ELEMENT_UPDATE_DATA,

    GPU_PROGRAM_PARAMS_GET_PROGRAM_PARAMS,
    GPU_PROGRAM_PARAMS_SET_NAMED_CONSTANT_COLOUR,
    GPU_PROGRAM_PARAMS_SET_NAMED_CONSTANT_INT,
    GPU_PROGRAM_PARAMS_SET_NAMED_CONSTANT_FLOAT,

    TEXTURE_MANAGER_GET_BY_NAME,
    TEXTURE_MANAGER_GET_BY_NAME_OVERLAY_ELEMENT,

    FRAME_STATS_UPDATE,

    UNLIT_DATABLOCK_SET_USE_COLOUR,
    UNLIT_DATABLOCK_SET_COLOUR,

    DYNAMIC_OVERLAY_ELEM_CTOR,
    DYNAMIC_OVERLAY_ELEM_DTOR,
    DYNAMIC_OVERLAY_ELEM_RESET_TO_INITIAL_TEXTURE,
    DYNAMIC_OVERLAY_ELEM_UPDATE_FINAL_TEXTURE,
    DYNAMIC_OVERLAY_ELEM_SET_POINT_IN_SCREEN_SPACE,
    DYNAMIC_OVERLAY_ELEM_LOCK,
    DYNAMIC_OVERLAY_ELEM_UNLOCK,
    DYNAMIC_OVERLAY_ELEM_SET_AREA_VEC,
    DYNAMIC_OVERLAY_ELEM_SET_AREA,

    TILED_ANIMATION_CREATE,
    TILED_ANIMATION_DESTROY,
    TILED_ANIMATION_UPDATE_CURRENT_FRAME_NUM,

    BILLBOARDSET_CREATE_BILLBOARD,
    BILLBOARDSET_DESTROY_BILLBOARD,
//    BILLBOARDSET_DESTROY_BILLBOARD_BY_ID,
    BILLBOARDSET_SET_COMMON_UP_VECTOR,
    BILLBOARDSET_SET_COMMON_DIRECTION,
    BILLBOARDSET_SET_DEFAULT_DIMENSIONS,
    BILLBOARDSET_SET_MATERIAL_NAME,
    BILLBOARDSET_SET_BILLBOARD_ORIGIN,
    BILLBOARDSET_SET_BILLBOARD_ROTATION_TYPE,
    BILLBOARDSET_SET_BILLBOARD_TYPE,

    MOVABLE_OBJECT_SET_RENDER_QUEUE_GROUP,

    PARTICLE_SYSTEM_SET_MATERIAL_NAME,

    SCENE_COMPOSITOR_INSERT_NODE,
    SCENE_COMPOSITOR_REVERT_NODE,

#ifdef TEST_RENDERING_THREAD

    TEST_CALL_RENDERING_THREAD_DATA_FLUSH1 = 200,
    TEST_CALL_RENDERING_THREAD_DATA_FLUSH2,
    TEST_CALL_RENDERING_THREAD_DATA_FLUSH3,
    TEST_CALL_RENDERING_THREAD_DATA_FLUSH4,
    TEST_CALL_RENDERING_THREAD_DATA_FLUSH_ARRAY1,
    TEST_CALL_RENDERING_THREAD_DATA_FLUSH_ARRAY2,
    TEST_CALL_RENDERING_THREAD_DATA_FLUSH_ARRAY3,
    TEST_CALL_RENDERING_THREAD_DATA_FLUSH_ARRAY4,
    TEST_CALL_RENDERING_THREAD_DATA_FLUSH_INCOMPLETE_RENDER_CHECK_PTR1 = 215,
    TEST_CALL_RENDERING_THREAD_DATA_FLUSH_INCOMPLETE_RENDER_CHECK_PTR2,
    TEST_CALL_RENDERING_THREAD_DATA_FLUSH_INCOMPLETE_RENDER_CHECK_PTR3,
    TEST_CALL_RENDERING_THREAD_DATA_FLUSH_INCOMPLETE_RENDER_CHECK_PTR4,
    TEST_CALL_RENDERING_THREAD_DATA_FLUSH_INCOMPLETE_RENDER_CHECK_ARRAY1,
    TEST_CALL_RENDERING_THREAD_DATA_FLUSH_INCOMPLETE_RENDER_CHECK_ARRAY2,
    TEST_CALL_RENDERING_THREAD_DATA_FLUSH_INCOMPLETE_RENDER_CHECK_ARRAY3,
    TEST_CALL_RENDERING_THREAD_DATA_FLUSH_INCOMPLETE_RENDER_CHECK_ARRAY4,

    TEST_CALL1 = 240,
    TEST_CALL2,
    TEST_CALL3,
    TEST_CALL4,
    TEST_CALL_W_RESPONSE1,
    TEST_CALL_W_RESPONSE2,
    TEST_CALL_W_RESPONSE3,
    TEST_CALL_W_RESPONSE4,
#endif

    FRAME_ID_POS = 255
};

enum GpuProgramParametersType 
{
    GPU_VERTEX = 1,
    GPU_FRAGMENT,
    GPU_GEOMETRY,
    GPU_COMPUTE,
    GPU_TESSELATION_DOMAIN,
    GPU_TESSELATION_HULL,
    GPU_SHADOW_CASTER_VERTEX,
    GPU_SHADOW_CASTER_FRAGMENT
};

#if (HOTSHOT_PLATFORM == HOTSHOT_PLATFORM_ANDROID)
AAssetManager *mgr;
ANativeWindow* window;
#endif

int readingBufferSizeInBytes;
int bufferCount;
jclass byteBufferCls;
jmethodID limit;
jclass systemCls;
jmethodID nanoTime;

jclass vector3DCls;
jmethodID vector3DSet;

Ogre::ParticleFXPlugin* particleFXPlugin;

long long getNanoTime(JNIEnv *env)
{
    return env->CallStaticLongMethod(systemCls, nanoTime);
}

typedef std::vector<Ogre::Item*> ItemList;
ItemList itemList;

typedef std::vector<::FrameEndListenerExecutor*> FrameEndListenerExecutorList;
FrameEndListenerExecutorList frameEndListenerExecutorList;

void addToItemList(Ogre::Item* item)
{
    itemList.push_back(item);
}

void removeFromItemList(Ogre::Item* item)
{
    itemList.erase(std::remove(itemList.begin(), itemList.end(), item), itemList.end());
}

void removeAllFromItemList()
{
    itemList.clear();
}

void addFrameEndListenerExecutor(::FrameEndListenerExecutor* frameEndListenerExecutor)
{
    frameEndListenerExecutorList.push_back(frameEndListenerExecutor);
}

void removeFrameEndListenerExecutor(::FrameEndListenerExecutor* frameEndListenerExecutor)
{
    frameEndListenerExecutorList.erase(std::remove(frameEndListenerExecutorList.begin(), frameEndListenerExecutorList.end(), frameEndListenerExecutor),
                                       frameEndListenerExecutorList.end());
    delete frameEndListenerExecutor;
}

void removeAllFrameEndListenerExecutors()
{
    std::vector<FrameEndListenerExecutor *>::iterator it = frameEndListenerExecutorList.begin();
    const std::vector<FrameEndListenerExecutor *>::iterator &end = frameEndListenerExecutorList.end();
    while (it != end)
    {
        delete *it;
        ++it;
    }
    frameEndListenerExecutorList.clear();
}

extern "C" {
JNIEXPORT void JNICALL
        Java_headwayent_blackholedarksun_BlackholeDarksunMain_glTest(JNIEnv *env, jobject instance);

#if (HOTSHOT_PLATFORM == HOTSHOT_PLATFORM_ANDROID)

JNIEXPORT void JNICALL
        Java_headwayent_blackholedarksunonline_android_AndroidLauncher_setAssetManager(JNIEnv *env,
                                                                                       jobject instance,
                                                                                       jobject assetManager);
JNIEXPORT void JNICALL
Java_headwayent_blackholedarksunonline_android_AndroidLauncher_setGLSurfaceView(JNIEnv *env,
                                                                                jobject instance,
                                                                                jobject surfaceView);
#endif

JNIEXPORT void JNICALL
        Java_headwayent_hotshotengine_renderer_nativeinterface_pipeline_ENG_1RenderingThread_initializeNative(
        JNIEnv *env, jclass type, jint readingBufferSizeInBytes, jint writingBufferSizeInBytes, jint bufferCount);

JNIEXPORT void JNICALL
        Java_headwayent_hotshotengine_renderer_nativeinterface_pipeline_ENG_1RenderingThread_renderOneFrame(
        JNIEnv *env, jclass type, jobject readingBuffer, jobject writingBuffer, jint currentBuffer);

JNIEXPORT jint JNICALL
Java_headwayent_hotshotengine_renderer_nativeinterface_classwrappers_ENG_1IdString_createIdString__Ljava_lang_String_2(
        JNIEnv *env, jclass type, jstring s_);

JNIEXPORT jint JNICALL
Java_headwayent_hotshotengine_renderer_nativeinterface_classwrappers_ENG_1IdString_createIdString__I(
        JNIEnv *env, jclass type, jint val);

JNIEXPORT jint JNICALL
Java_headwayent_hotshotengine_renderer_nativeinterface_classwrappers_ENG_1IdString_append__ILjava_lang_String_2(
        JNIEnv *env, jclass type, jint hash, jstring oth_);

JNIEXPORT jlong JNICALL
Java_headwayent_hotshotengine_renderer_nativeinterface_classwrappers_ENG_1OverlaySystemNativeWrapper_createOverlaySystem(
        JNIEnv *env, jclass type);

JNIEXPORT void JNICALL
Java_headwayent_hotshotengine_renderer_nativeinterface_classwrappers_ENG_1OverlaySystemNativeWrapper_destroyOverlaySystem(
        JNIEnv *env, jclass type, jlong ptr);

JNIEXPORT void JNICALL
        Java_headwayent_blackholedarksun_APP_1Game_setupResources(JNIEnv *env, jclass type, jstring path_, jstring filename_);

JNIEXPORT jlong JNICALL
        Java_headwayent_hotshotengine_renderer_nativeinterface_classwrappers_ENG_1RootNativeWrapper_createRoot(
        JNIEnv *env, jclass type, jstring pluginFileName_, jstring configFileName_,
        jstring logFileName_);

JNIEXPORT void JNICALL
        Java_headwayent_hotshotengine_renderer_nativeinterface_classwrappers_ENG_1RootNativeWrapper_destroyRoot(
        JNIEnv *env, jclass type, jlong ptr);

JNIEXPORT void JNICALL
        Java_headwayent_blackholedarksun_APP_1Game_loadResources__JLjava_lang_String_2(JNIEnv *env,
                                                                                       jclass type,
                                                                                       jlong rootPtr,
                                                                                       jstring path_);

JNIEXPORT jlong JNICALL
        Java_headwayent_hotshotengine_renderer_nativeinterface_classwrappers_ENG_1SceneManagerNativeWrapper_createSceneManager(
        JNIEnv *env, jclass type, jlong rootPtr, jshort typeMask, jint numThreads, jint threadCullingMethod,
        jstring name_);

JNIEXPORT void JNICALL
        Java_headwayent_hotshotengine_renderer_nativeinterface_classwrappers_ENG_1SceneManagerNativeWrapper_destroySceneManager(
        JNIEnv *env, jclass type, jlong rootPtr, jlong ptr);

JNIEXPORT void JNICALL
        Java_headwayent_hotshotengine_renderer_nativeinterface_classwrappers_ENG_1SceneManagerNativeWrapper_addRenderQueueListenerNative(
        JNIEnv *env, jclass type, jlong sceneManagerPtr, jlong renderQueueListener);

JNIEXPORT void JNICALL
        Java_headwayent_hotshotengine_renderer_nativeinterface_classwrappers_ENG_1SceneManagerNativeWrapper_removeRenderQueueListenerNative(
        JNIEnv *env, jclass type, jlong sceneManagerPtr, jlong renderQueueListener);

JNIEXPORT void JNICALL
        Java_headwayent_hotshotengine_renderer_nativeinterface_classwrappers_ENG_1RootNativeWrapper_initialiseNative(
        JNIEnv *env, jclass type, jlong rootPtr, jboolean autoCreateWindow, jstring windowTitle_,
        jstring customCapabilitiesConfig_);

JNIEXPORT jlong JNICALL
        Java_headwayent_hotshotengine_renderer_nativeinterface_classwrappers_ENG_1RootNativeWrapper_getRenderSystemNative(
        JNIEnv *env, jclass type, jlong ptr);

JNIEXPORT void JNICALL
        Java_headwayent_hotshotengine_renderer_nativeinterface_classwrappers_glsles_GLRenderSystemNativeWrapper_setConfigOptionNative(
        JNIEnv *env, jclass type, jlong ptr, jstring name_, jstring value_);

JNIEXPORT jlong JNICALL
        Java_headwayent_hotshotengine_gorillagui_ENG_1TextureAtlas_loadTexture(JNIEnv *env, jclass type,
                                                                               jstring name_, jstring group_);

JNIEXPORT jint JNICALL
Java_headwayent_hotshotengine_gorillagui_ENG_1TextureAtlas_getTextureWidth(JNIEnv *env, jclass type,
                                                                           jlong ptr);

JNIEXPORT jint JNICALL
Java_headwayent_hotshotengine_gorillagui_ENG_1TextureAtlas_getTextureHeight(JNIEnv *env,
                                                                            jclass type,
                                                                            jlong ptr);

JNIEXPORT jint JNICALL
Java_headwayent_hotshotengine_gorillagui_ENG_1TextureAtlas_createNinePatch(JNIEnv *env, jclass type,
                                                                           jlong ptr,
                                                                           jobject ninePatch);

JNIEXPORT void JNICALL
Java_headwayent_hotshotengine_renderer_ENG_1SceneManager_setShadowDirectionalLightExtrusionDistance__JF(
        JNIEnv *env, jclass type, jlong ptr, jfloat distance);

JNIEXPORT void JNICALL
Java_headwayent_hotshotengine_renderer_ENG_1SceneManager_setShadowFarDistance__JF(JNIEnv *env,
                                                                                  jclass type,
                                                                                  jlong ptr,
                                                                                  jfloat distance);

JNIEXPORT jlong JNICALL
Java_headwayent_hotshotengine_renderer_nativeinterface_classwrappers_ENG_1SceneManagerNativeWrapper_createCamera__JLjava_lang_String_2ZZ(
        JNIEnv *env, jclass type, jlong ptr, jstring name_, jboolean isVisible,
        jboolean forCubemapping);

JNIEXPORT void JNICALL
Java_headwayent_hotshotengine_renderer_nativeinterface_classwrappers_ENG_1CameraNativeWrapper_setPosition(
        JNIEnv *env, jclass type, jlong ptr, jfloat x, jfloat y, jfloat z);

JNIEXPORT void JNICALL
Java_headwayent_hotshotengine_renderer_nativeinterface_classwrappers_ENG_1CameraNativeWrapper_lookAt(
        JNIEnv *env, jclass type, jlong ptr, jfloat x, jfloat y, jfloat z);

JNIEXPORT void JNICALL
Java_headwayent_hotshotengine_renderer_nativeinterface_classwrappers_ENG_1CameraNativeWrapper_setNearClipDistance(
        JNIEnv *env, jclass type, jlong ptr, jfloat dist);

JNIEXPORT void JNICALL
Java_headwayent_hotshotengine_renderer_nativeinterface_classwrappers_ENG_1CameraNativeWrapper_setFarClipDistance(
        JNIEnv *env, jclass type, jlong ptr, jfloat dist);

JNIEXPORT void JNICALL
Java_headwayent_hotshotengine_renderer_nativeinterface_classwrappers_ENG_1CameraNativeWrapper_setAutoAspectRatio(
        JNIEnv *env, jclass type, jlong ptr, jboolean aspectRatio);

JNIEXPORT void JNICALL
Java_headwayent_hotshotengine_renderer_nativeinterface_classwrappers_ENG_1CameraNativeWrapper_setAspectRatio__JF(
        JNIEnv *env, jclass type, jlong ptr, jfloat aspectRatio);

JNIEXPORT jstring JNICALL
Java_headwayent_hotshotengine_gorillagui_ENG_1TextureAtlas_getTextureName(JNIEnv *env, jclass type,
                                                                          jlong ptr);

JNIEXPORT void JNICALL
Java_headwayent_hotshotengine_gorillagui_ENG_1TextureAtlas_calculateSpriteCoordinates(JNIEnv *env,
                                                                                      jclass type,
                                                                                      jobject s,
                                                                                      jfloat mInverseTextureSizeX,
                                                                                      jfloat mInverseTextureSizeY);

JNIEXPORT void JNICALL
Java_headwayent_blackholedarksun_APP_1Game_showLoadingScreenNative(JNIEnv *env, jclass type,
                                                                   jlong renderWindowPtr);

JNIEXPORT void JNICALL
Java_headwayent_blackholedarksun_APP_1Game_hideLoadingScreenNative(JNIEnv *env, jclass type);

JNIEXPORT jobjectArray JNICALL
Java_headwayent_hotshotengine_gorillagui_ENG_1SilverBack_createByteBuffersNative(JNIEnv *env,
                                                                                 jclass type,
                                                                                 jint size,
                                                                                 jint count);

JNIEXPORT void JNICALL
Java_headwayent_hotshotengine_gorillagui_ENG_1SilverBack_setMaterialName(JNIEnv *env, jclass type,
                                                                         jstring materialName_);

JNIEXPORT jlong JNICALL
Java_headwayent_hotshotengine_renderer_nativeinterface_classwrappers_ENG_1CompositorWorkspaceNativeWrapper_addWorkspace(
        JNIEnv *env, jclass type, jlong rootPtr, jlong sceneManagerPtr, jlong renderWindowPtr, jlong cameraPtr,
        jstring workspaceName_, jboolean enabled);

JNIEXPORT void JNICALL
Java_headwayent_hotshotengine_renderer_ENG_1RenderRoot_renderOneFrameNative(JNIEnv *env,
                                                                            jclass type,
                                                                            jlong rootPtr);

JNIEXPORT void JNICALL
Java_headwayent_hotshotengine_renderer_nativeinterface_test_TestRenderingThread_testSlowCall1(
        JNIEnv *env, jclass type);

JNIEXPORT jint JNICALL
Java_headwayent_hotshotengine_renderer_nativeinterface_test_TestRenderingThread_testSlowCall2(
        JNIEnv *env, jclass type, jint p);

JNIEXPORT jlong JNICALL
Java_headwayent_hotshotengine_renderer_nativeinterface_test_TestRenderingThread_testSlowCall3(
        JNIEnv *env, jclass type, jint p, jlong l);

JNIEXPORT jboolean JNICALL
Java_headwayent_hotshotengine_renderer_nativeinterface_test_TestRenderingThread_testSlowCall4(
        JNIEnv *env, jclass type, jint p, jbyte b, jboolean boolParam, jshort s);

JNIEXPORT jlong JNICALL
Java_headwayent_hotshotengine_renderer_nativeinterface_classwrappers_ENG_1ViewportNativeWrapper_getViewport(
        JNIEnv *env, jclass type, jlong renderWindowPtr);

extern "C"
JNIEXPORT void JNICALL
Java_headwayent_hotshotengine_gorillagui_ENG_1SilverBack_createDummyNode(JNIEnv *env, jclass type);

extern "C"
JNIEXPORT void JNICALL
Java_headwayent_hotshotengine_gorillagui_ENG_1SilverBack_destroyDummyNode(JNIEnv *env,
                                                                          jclass type);

JNIEXPORT void JNICALL
Java_headwayent_blackholedarksun_BlackholeDarksunMain_initJvmData(JNIEnv *env, jobject instance);

JNIEXPORT void JNICALL
Java_headwayent_hotshotengine_android_AndroidRenderWindow_setWindowProc(JNIEnv *env, jclass type,
                                                                        jclass windowsDisplayClass,
                                                                        jobject javaWindowProc);

}

JNIEXPORT void JNICALL
Java_headwayent_blackholedarksun_BlackholeDarksunMain_glTest(JNIEnv *env, jobject instance) {

//    LOGI("Long live the emperor!");

    Ogre::String pluginsPath;
    Ogre::String mResourcePath;

    Ogre::Root *mRoot = OGRE_NEW Ogre::Root( pluginsPath,
                                 mResourcePath + "ogre.cfg",
                                 mResourcePath + "Ogre.log" );
#if (HOTSHOT_PLATFORM == HOTSHOT_PLATFORM_ANDROID)
    Ogre::ArchiveManager::getSingleton().addArchiveFactory( new Ogre::APKFileSystemArchiveFactory(mgr) );
    Ogre::ArchiveManager::getSingleton().addArchiveFactory( new Ogre::APKZipArchiveFactory(mgr) );
#endif

    mRoot->getRenderSystem()->setConfigOption( "sRGB Gamma Conversion", "Yes" );
    mRoot->initialise(false);

    int width   = 1280;
    int height  = 720;

    Ogre::NameValuePairList params;
    params.insert(std::make_pair("currentGLContext", "true"));
//    Ogre::String winHandle;
//    winHandle = Ogre::StringConverter::toString( (uintptr_t)window );
//    params.insert( std::make_pair("externalWindowHandle",  winHandle) );

    Ogre::String windowTitle("Window title");
    Ogre::RenderWindow *mRenderWindow = Ogre::Root::getSingleton().createRenderWindow( windowTitle, width, height,
                                                                   true, &params );

//    glClearColor(1.0f, 0.0f, 0.0f, 0.0f);
//    glClear(GL_COLOR_BUFFER_BIT);
}

#if (HOTSHOT_PLATFORM == HOTSHOT_PLATFORM_ANDROID)
JNIEXPORT void JNICALL
Java_headwayent_blackholedarksunonline_android_AndroidLauncher_setAssetManager(JNIEnv *env,
                                                                               jobject instance,
                                                                               jobject assetManager) {

    mgr = AAssetManager_fromJava(env, assetManager);

}

JNIEXPORT void JNICALL
Java_headwayent_blackholedarksunonline_android_AndroidLauncher_setGLSurfaceView(JNIEnv *env,
                                                                                jobject instance,
                                                                                jobject surfaceView) {

    window = ANativeWindow_fromSurface(env, surfaceView);
    LOGI("Long live the emperor!");
    assert(window);

}
#endif

void addResourceLocation( const Ogre::String &archName, const Ogre::String &typeName,
                          const Ogre::String &secName )
{
#if OGRE_PLATFORM == OGRE_PLATFORM_APPLE
    // OS X does not set the working directory relative to the app,
        // In order to make things portable on OS X we need to provide
        // the loading with it's own bundle path location
        Ogre::ResourceGroupManager::getSingleton().addResourceLocation(
                    Ogre::String(macBundlePath() + "/" + archName), typeName, secName);
#else
    Ogre::ResourceGroupManager::getSingleton().addResourceLocation(
            archName, typeName, secName);
#endif
}

void setupResources(const Ogre::String &path, const Ogre::String &filename)
{
    // Load resource paths from config file
    Ogre::ConfigFile cf;
    //cf.loadFromResourceSystem(mResourcePath + "resources2.cfg", Ogre::ResourceGroupManager::DEFAULT_RESOURCE_GROUP_NAME, "\t;=", true );
    cf.load(path + "/" + filename);

    // Go through all sections & settings in the file
    Ogre::ConfigFile::SectionIterator seci = cf.getSectionIterator();

    Ogre::String secName, typeName, archName;
    while( seci.hasMoreElements() )
    {
        secName = seci.peekNextKey();
        Ogre::ConfigFile::SettingsMultiMap *settings = seci.getNext();

        if( secName != "Hlms" )
        {
            Ogre::ConfigFile::SettingsMultiMap::iterator i;
            for (i = settings->begin(); i != settings->end(); ++i)
            {
                typeName = i->first;
                archName = i->second;
                addResourceLocation( path + archName, typeName, secName );
            }
        }
    }
}

void registerHlms(Ogre::Root* root, Ogre::String &path)
{
    Ogre::ConfigFile cf;
    cf.load( path + "/resources2.cfg" );

    Ogre::String dataFolder = path + cf.getSetting( "DoNotUseAsResource", "Hlms", "" );

    if( dataFolder.empty() )
        dataFolder = "./";
    else if( *(dataFolder.end() - 1) != '/' )
        dataFolder += "/";

    Ogre::RenderSystem *renderSystem = root->getRenderSystem();

    Ogre::String shaderSyntax = "GLSL";
    if( renderSystem->getName() == "Direct3D11 Rendering Subsystem" )
        shaderSyntax = "HLSL";
    else if( renderSystem->getName() == "OpenGL ES 3.x Rendering Subsystem" )
        shaderSyntax = "GLSLES3";
    else if( renderSystem->getName() == "Metal Rendering Subsystem" )
        shaderSyntax = "Metal";

    Ogre::Archive *archiveLibrary = Ogre::ArchiveManager::getSingletonPtr()->load(
            dataFolder + "Hlms/Common/" + shaderSyntax,
            "FileSystem", true );
    Ogre::Archive *archiveLibraryAny = Ogre::ArchiveManager::getSingletonPtr()->load(
            dataFolder + "Hlms/Common/Any",
            "FileSystem", true );

    Ogre::ArchiveVec library;
    library.push_back( archiveLibrary );
    library.push_back( archiveLibraryAny );

    Ogre::Archive *archiveUnlit = Ogre::ArchiveManager::getSingletonPtr()->load(
            dataFolder + "Hlms/Unlit/" + shaderSyntax,
            "FileSystem", true );

    Ogre::HlmsUnlit *hlmsUnlit = OGRE_NEW Ogre::HlmsUnlit( archiveUnlit, &library );
    Ogre::Root::getSingleton().getHlmsManager()->registerHlms( hlmsUnlit );

    Ogre::Archive *archivePbs = Ogre::ArchiveManager::getSingletonPtr()->load(
            dataFolder + "Hlms/Pbs/" + shaderSyntax,
            "FileSystem", true );
    Ogre::HlmsPbs *hlmsPbs = OGRE_NEW Ogre::HlmsPbs( archivePbs, &library );
    Ogre::Root::getSingleton().getHlmsManager()->registerHlms( hlmsPbs );

    if( renderSystem->getName() == "Direct3D11 Rendering Subsystem" )
    {
        //Set lower limits 512kb instead of the default 4MB per Hlms in D3D 11.0
        //and below to avoid saturating AMD's discard limit (8MB) or
        //saturate the PCIE bus in some low end machines.
        bool supportsNoOverwriteOnTextureBuffers;
        renderSystem->getCustomAttribute( "MapNoOverwriteOnDynamicBufferSRV",
                                          &supportsNoOverwriteOnTextureBuffers );

        if( !supportsNoOverwriteOnTextureBuffers )
        {
            hlmsPbs->setTextureBufferDefaultSize( 512 * 1024 );
            hlmsUnlit->setTextureBufferDefaultSize( 512 * 1024 );
        }
    }
}

void loadResources(Ogre::Root* root, Ogre::String &path)
{
    registerHlms(root, path);

    // Initialise, parse scripts etc
    Ogre::ResourceGroupManager &manager = Ogre::ResourceGroupManager::getSingleton();
    manager.initialiseAllResourceGroups();
}


struct OverlayData
{
    Ogre::String name;
    long long int ptr;
	long long int datablockPtr;
    float left;
    float top;
    float width;
    float height;
    std::vector<OverlayData> children;
    Ogre::RealRect clippingRegion;
    unsigned char type;
    unsigned char metrics;

    OverlayData() : name(""), ptr(0), datablockPtr(0), left(0), top(0), width(0), height(0), type(0), metrics(0) {}

};

void extractOverlayData(::Ogre::v1::OverlayElement* overlayElement, OverlayData* overlayData)
{
    const Ogre::String &typeName = overlayElement->getTypeName();
    if (typeName.compare("Panel") == 0)
    {
        overlayData->type = 0;
    }
    else if (typeName.compare("TextArea") == 0)
    {
        overlayData->type = 1;
    }
	else
	{
		::Ogre::String s("Could not find overlay element type: " + SSTR(typeName));
		LOGI("%s", s.c_str());
		exit(-1);
	}
    overlayData->name = overlayElement->getName();
    overlayData->ptr = getPointerAsLong(overlayElement);
	overlayData->datablockPtr = getPointerAsLong(overlayElement->getDatablock());
    overlayData->metrics = overlayElement->getMetricsMode();
    overlayData->left = overlayElement->getLeft();
    overlayData->top = overlayElement->getTop();
    overlayData->width = overlayElement->getWidth();
    overlayData->height = overlayElement->getHeight();
    overlayElement->_getClippingRegion(overlayData->clippingRegion);
    if (overlayElement->isContainer())
    {
        Ogre::v1::OverlayContainer *overlayContainer = (Ogre::v1::OverlayContainer*) overlayElement;
        Ogre::v1::OverlayContainer::ChildIterator it = overlayContainer->getChildIterator();

        while (it.hasMoreElements())
        {
            OverlayData nextData;
            Ogre::v1::OverlayElement *childElement = it.getNext();
            extractOverlayData(childElement, &nextData);
            overlayData->children.push_back(nextData);
        }
    }
}

void writeOverlayDataFields(char** wbuf, OverlayData* overlayData)
{
    writePtr(wbuf, overlayData->ptr);
	writePtr(wbuf, overlayData->datablockPtr);
    write(wbuf, overlayData->type);
    writeString(wbuf, overlayData->name);
    write(wbuf, overlayData->metrics);
    write(wbuf, overlayData->left);
    write(wbuf, overlayData->top);
    write(wbuf, overlayData->width);
    write(wbuf, overlayData->height);
    write(wbuf, overlayData->clippingRegion.left);
    write(wbuf, overlayData->clippingRegion.top);
    write(wbuf, overlayData->clippingRegion.right);
    write(wbuf, overlayData->clippingRegion.bottom);
}

void writeOverlayData(char** wbuf, OverlayData* overlayData)
{
	writeOverlayDataFields(wbuf, overlayData);
	write(wbuf, overlayData->children.size());
    if (overlayData->children.size() == 0)
    {
        return;
    }
    std::vector<OverlayData>::iterator dataIt = overlayData->children.begin();
    const std::vector<OverlayData>::iterator &dataEndIt = overlayData->children.end();
    while (dataIt != dataEndIt)
    {
        OverlayData &childOverlayData = *dataIt;
//        writeOverlayDataFields(wbuf, &childOverlayData);
        writeOverlayData(wbuf, &childOverlayData);
        ++dataIt;
    }
}

char *writeOverlay(char *wbuf, Ogre::v1::Overlay *overlay) {
    Ogre::v1::Overlay::Overlay2DElementsIterator it = overlay->get2DElementsIterator();
    std::vector<OverlayData> overlayDataList;

    while (it.hasMoreElements()) {
        OverlayData overlayData;
        Ogre::v1::OverlayContainer *overlayContainer = it.getNext();
		// We're also going to need the datablock so initialize and update the container.
		overlayContainer->initialise();
		overlayContainer->_update();
        extractOverlayData(overlayContainer, &overlayData);
        overlayDataList.push_back(overlayData);
    }

    // We only create one overlay per call for now.
    write(&wbuf, 1);
    writePtr(&wbuf, getPointerAsLong(overlay));
    write(&wbuf, overlayDataList.size());
    std::vector<OverlayData>::iterator dataIt = overlayDataList.begin();
    const std::vector<OverlayData>::iterator &dataEndIt = overlayDataList.end();
    while (dataIt != dataEndIt) {
        OverlayData &overlayData = *dataIt;
        writeOverlayData(&wbuf, &overlayData);
//        std::vector<OverlayData>::iterator childIt = overlayData.children.begin();
//        const std::vector<OverlayData>::iterator &childEndIt = overlayData.children.end();
//        while (childIt != childEndIt) {
//            OverlayData &childOverlayData = *childIt;
//            writeOverlayData(&wbuf, &childOverlayData);
//            ++childIt;
//        }
        ++dataIt;
    }
    return wbuf;
}

void extractMessages(JNIEnv *env, char* buf, char* frameIdPos)
{
    // At the address of wbuf we write the frameId if any.
    char* wbuf = (frameIdPos + 1);
    bool renderedOneFrame = false;
    while (*buf != 0)
    {
		// Get rid of the dumbass sign extension.

	    unsigned char* callChar = reinterpret_cast<unsigned char*>(buf++);
        NativeCallsList call = static_cast<NativeCallsList>(*callChar);
//        Ogre::String s("currentCall:  " + SSTR(*callChar) + "\n");
//        LOGI("%s", s.c_str());
        switch (call)
        {
//            case NEWROOT:
//            {
//                Ogre::String pluginsPath = readString(&buf);
//                Ogre::String configPath = readString(&buf);
//                Ogre::String logPath = readString(&buf);
//                Ogre::Root *root = OGRE_NEW Ogre::Root( pluginsPath, configPath, logPath );
//                savePointer(&wbuf, root);
//            }
//                break;
            case ROOT_CREATERENDERWINDOW:
            {
                BufferRead<long long> bufferReadLong;
                BufferRead<int> bufferReadInt;
                BufferRead<bool> bufferReadBool;
                alignPointer(&buf, 4);
                long long int rootPtr = bufferReadLong.read(&buf);
                Ogre::String windowName = readString(&buf);
                int width = bufferReadInt.read(&buf);
                int height = bufferReadInt.read(&buf);
                bool fullscreen = bufferReadBool.read(&buf);
                const std::map<Ogre::String, Ogre::String> &map = readMapStringString(&buf);
                Ogre::Root *root = (Ogre::Root*) getLongAsPointer(rootPtr);
                Ogre::NameValuePairList list;
                for (std::map<Ogre::String, Ogre::String>::const_iterator it = map.begin(); it != map.end(); ++it)
                {
                    list.insert(std::make_pair(it->first, it->second));
                }
                Ogre::RenderWindow *renderWindow = root->createRenderWindow(windowName, width, height, fullscreen,
                                                                            &list);
//                Ogre::Viewport *viewport = renderWindow->getViewport(0);
//                int actLeft, actTop, actWidth, actHeight;
//                viewport->getActualDimensions(actLeft, actTop, actWidth, actHeight);
                alignPointer(&wbuf, 4);
                write(&wbuf, getPointerAsLong(renderWindow));
#if (HOTSHOT_PLATFORM == HOTSHOT_PLATFORM_WIN32)
		        Ogre::D3D11RenderWindowHwnd* win32RenderWindow = (Ogre::D3D11RenderWindowHwnd*) renderWindow;
//				Ogre::Win32Window *win32RenderWindow = (Ogre::Win32Window*) renderWindow;
//				Ogre::Win32EGLWindow *win32RenderWindow = (Ogre::Win32EGLWindow*) renderWindow;
		        HWND windowHandle = win32RenderWindow->getWindowHandle();
				HDC hdc = win32RenderWindow->getHDC();
				write(&wbuf, (long long) windowHandle);
				write(&wbuf, (long long) hdc);
#endif
//                write(&wbuf, getPointerAsLong(viewport));
//                write(&wbuf, actLeft);
//                write(&wbuf, actTop);
//                write(&wbuf, actWidth);
//                write(&wbuf, actHeight);
            }
                break;
            case SCREEN_CREATE:
            {
                BufferRead<unsigned char> charBufferRead;
                BufferRead<long long> bufferReadLong;
                unsigned int bufferLen = charBufferRead.read(&buf);
                alignPointer(&buf, 4);
//                Hotshot::GorillaGUI::createAtlasPtrList(bufferLen);
                Hotshot::Screen *screen = new Hotshot::Screen(bufferLen);
                for (unsigned int i = 0; i < bufferLen; ++i)
                {
                    long long int atlasPtr = bufferReadLong.read(&buf);
                    Ogre::Texture *atlasTexture = (Ogre::Texture*) getLongAsPointer(atlasPtr);
//                    const Ogre::String &atlasName = atlasTexture->getName();
//                    Hotshot::GorillaGUI::setAtlasPtr(atlasTexture, i);
                    screen->setAtlasPtr(atlasTexture, i);
                }
                writePtr(&wbuf, getPointerAsLong(screen));
//                alignPointer(&wbuf, 4);
//                write(&wbuf, getPointerAsLong(screen));
            }
                break;
            case SCREEN_DESTROY:
            {
                BufferRead<long long> bufferReadLong;
                alignPointer(&buf, 4);
                long long int screenPtr = bufferReadLong.read(&buf);
                Hotshot::Screen *screen = (Hotshot::Screen*) getLongAsPointer(screenPtr);
                delete screen;
//                Hotshot::GorillaGUI::destroyAtlasPtrList();
            }
                break;
            case SCREEN_CREATELAYER:
            {
                BufferRead<long long> bufferReadLong;
                BufferRead<unsigned char> charBufferRead;
                alignPointer(&buf, 4);
                long long int screenPtr = bufferReadLong.read(&buf);
                long long int texturePtr = bufferReadLong.read(&buf);
                long long int sceneManagerPtr = bufferReadLong.read(&buf);
                unsigned char queueGroupId = charBufferRead.read(&buf);
                Hotshot::Screen *screen = (Hotshot::Screen*) getLongAsPointer(screenPtr);
                Ogre::Texture *texture = (::Ogre::Texture*) getLongAsPointer(texturePtr);
                Ogre::SceneManager *sceneManager = (::Ogre::SceneManager*) getLongAsPointer(sceneManagerPtr);
                Hotshot::ScreenRenderable *screenRenderable = screen->createScreenRenderable(
                        texture, sceneManager, queueGroupId);
                writePtr(&wbuf, getPointerAsLong(screenRenderable));
//                alignPointer(&wbuf, 4);
//                write(&wbuf, getPointerAsLong(screenRenderable));
            }
                break;
            case SCREEN_DESTROYLAYER:
            {
                BufferRead<unsigned char> charBufferRead;
                BufferRead<long long> bufferReadLong;
                alignPointer(&buf, 4);
                long long int screenPtr = bufferReadLong.read(&buf);
                Hotshot::Screen *screen = (Hotshot::Screen*) getLongAsPointer(screenPtr);
                unsigned char queueGroupIdLen = charBufferRead.read(&buf);
                for (int i = 0; i < queueGroupIdLen; ++i)
                {
                    unsigned char queueGroupId = charBufferRead.read(&buf);
                    screen->destroyScreenRenderable(queueGroupId);
                }
//                Hotshot::ScreenRenderable *screenRenderable = (Hotshot::ScreenRenderable*) getLongAsPointer(screenRenderablePtr);
//                Hotshot::GorillaGUI::destroyScreenRenderable(screenRenderable);
            }
                break;
            case SCREEN_RENDERONCE:
            {
                // Render each screen renderable in group order.
//                Hotshot::GorillaGUI::renderOnce();
                BufferRead<long long> bufferReadLong;
                alignPointer(&buf, 4);
                long long int screenPtr = bufferReadLong.read(&buf);
                Hotshot::Screen *screen = (Hotshot::Screen*) getLongAsPointer(screenPtr);
                screen->renderOnce();
            }
                break;
            case SCREEN_UPDATEVERTEXLISTSIZE:
            {
                BufferRead<long long> bufferReadLong;
                BufferRead<int> bufferReadInt;
                BufferRead<unsigned char> bufferReadChar;
                alignPointer(&buf, 4);
                long long int screenPtr = bufferReadLong.read(&buf);
                int vertexListSize = bufferReadInt.read(&buf);
                unsigned char bufferNum = bufferReadChar.read(&buf);
                unsigned char queueGroupId = bufferReadChar.read(&buf);
                Hotshot::Screen *screen = (Hotshot::Screen*) getLongAsPointer(screenPtr);
                screen->fillVertexBuffer(vertexListSize, queueGroupId, Hotshot::GorillaGUI::getBuffer(bufferNum));
//                Hotshot::ScreenRenderable *screenRenderable = (Hotshot::ScreenRenderable*) getLongAsPointer(screenRenderablePtr);
//                screenRenderable->fillVertexBuffer(vertexListSize, Hotshot::GorillaGUI::getBuffer(bufferNum));
            }
                break;
            case ROOT_RENDERONEFRAME:
            {
                BufferRead<long long> bufferReadLong;
                alignPointer(&buf, 4);
                long long int rootPtr = bufferReadLong.read(&buf);
                Ogre::Root *root = (Ogre::Root*) getLongAsPointer(rootPtr);
#if (HOTSHOT_PLATFORM == HOTSHOT_PLATFORM_WIN32)
				Ogre::WindowEventUtilities::messagePump();
#endif
//                long long renderOneFrameBeginTime = getNanoTime(env);
                root->renderOneFrame();
//                long long renderOneFrameEndTime = getNanoTime(env);
//                long long timeDiff = renderOneFrameEndTime - renderOneFrameBeginTime;
//                Ogre::String s("renderOneFrame time:  " + SSTR(timeDiff) + " LastFPS: " + SSTR(root->getFrameStats()->getFps()) + "\n");
//                LOGI("%s", s.c_str());
                renderedOneFrame = true;


            }
                break;
            case SCREEN_SETVISIBLE:
            {
                BufferRead<long long> bufferReadLong;
                BufferRead<bool> bufferReadBool;
                alignPointer(&buf, 4);
                long long int screenPtr = bufferReadLong.read(&buf);
                bool visible = bufferReadBool.read(&buf);
                Hotshot::Screen *screen = (Hotshot::Screen*) getLongAsPointer(screenPtr);
                screen->setVisible(visible);
//                Hotshot::ScreenRenderable *screenRenderable = (Hotshot::ScreenRenderable*) getLongAsPointer(screenRenderablePtr);
//                screenRenderable->setScreenRenderableVisible(visible);
            }
                break;
            case CREATE_RAY_QUERY:
            {
                BufferRead<long long> bufferReadLong;
                BufferRead<unsigned char> bufferReadChar;
                alignPointer(&buf, 4);
                long long int sceneManagerPtr = bufferReadLong.read(&buf);
                unsigned char ptrFlag = getPointerFlag(&buf);
                alignPointer(&buf, 4);
                long long int raySceneQueryPtr = bufferReadLong.read(&buf);
                const Ogre::Vector4 &origin = readVector4DAsVec(&buf);
                const Ogre::Vector4 &dir = readVector4DAsVec(&buf);
                Ogre::SceneManager *sceneManager = (Ogre::SceneManager*) getLongAsPointer(sceneManagerPtr);
                Ogre::RaySceneQuery *rayQuery = sceneManager->createRayQuery(
                        Ogre::Ray(Ogre::Vector3(origin.x, origin.y, origin.z), Ogre::Vector3(dir.x, dir.y, dir.z)));
                putInPointerMap(raySceneQueryPtr, rayQuery);
                writePtr(&wbuf, getPointerAsLong(rayQuery));
//                alignPointer(&wbuf, 4);
//                write(&wbuf, getPointerAsLong(rayQuery));
            }
                break;
            case DESTROY_RAY_QUERY:
            {
                BufferRead<long long> bufferReadLong;
                alignPointer(&buf, 4);
                long long int sceneManagerPtr = bufferReadLong.read(&buf);
                Ogre::SceneManager *sceneManager = (Ogre::SceneManager*) getLongAsPointer(sceneManagerPtr);
                unsigned char ptrFlag = getPointerFlag(&buf);
                bool ptrJustCreated = isPointerJustCreated(ptrFlag);
                long long int raySceneQueryPtr = bufferReadLong.read(&buf);
                Ogre::RaySceneQuery *raySceneQuery = (Ogre::RaySceneQuery*) getNativePointer(raySceneQueryPtr, ptrJustCreated);
                sceneManager->destroyQuery(raySceneQuery);
                removePointerFromMap(raySceneQueryPtr, ptrJustCreated);
            }
                break;
            case RAY_QUERY_SETSORTBYDISTANCE:
            {
                BufferRead<long long> bufferReadLong;
                BufferRead<bool> bufferReadBool;
                unsigned char ptrFlag = getPointerFlag(&buf);
                bool ptrJustCreated = isPointerJustCreated(ptrFlag);
                long long int raySceneQueryPtr = bufferReadLong.read(&buf);
                bool sortByDistance = bufferReadBool.read(&buf);
                Ogre::RaySceneQuery *raySceneQuery = (Ogre::RaySceneQuery*) getNativePointer(raySceneQueryPtr, ptrJustCreated);
                raySceneQuery->setSortByDistance(sortByDistance);
            }
                break;
            case RAY_QUERY_EXECUTE:
            {
                BufferRead<long long> bufferReadLong;
                alignPointer(&buf, 4);
                long long int sceneManagerPtr = bufferReadLong.read(&buf);
                Ogre::SceneManager *sceneManager = (Ogre::SceneManager*) getLongAsPointer(sceneManagerPtr);
                unsigned char ptrFlag = getPointerFlag(&buf);
                bool ptrJustCreated = isPointerJustCreated(ptrFlag);
                long long int raySceneQueryPtr = bufferReadLong.read(&buf);
                // If the ray scene query fails it's because the aabbs haven't been updated for all objects.
                // This usually happens because you have just created a new item in the scene for which no
                // updateSceneGraph() happened. In order to test if this is the case uncomment the next line.
                // If the problem goes away you know who the culprit was.
                // Make sure you only execute ray queries after everything has been update in the scene graph!!!
//                Ogre::Root::getSingleton().renderOneFrame();
                Ogre::RaySceneQuery *raySceneQuery = (Ogre::RaySceneQuery*) getNativePointer(raySceneQueryPtr, ptrJustCreated);
                addFrameEndListenerExecutor(new RayQueryExecuteFrameEndListenerExecutor(raySceneQuery, sceneManager));
//                Ogre::RaySceneQueryResult & raySceneQueryResult = raySceneQuery->execute();
//                write(&wbuf, raySceneQueryResult.size());
//                Ogre::RaySceneQueryResult::iterator it = raySceneQueryResult.begin();
//                const Ogre::RaySceneQueryResult::iterator &end = raySceneQueryResult.end();
//                while (it != end)
//                {
//                    Ogre::RaySceneQueryResultEntry &entry = *it;
//                    Ogre::Real distance = entry.distance;
//                    Ogre::MovableObject *movableObject = entry.movable;
//                    write(&wbuf, distance);
//                    writePtr(&wbuf, getPointerAsLong(movableObject));
////                    alignPointer(&wbuf, 4);
////                    write(&wbuf, getPointerAsLong(movableObject));
//                    ++it;
//                }
            }
                break;
            case GET_VIEWPORT:
            {
                BufferRead<long long> bufferReadLong;
                alignPointer(&buf, 4);
                long long int renderWindowPtr = bufferReadLong.read(&buf);
                Ogre::RenderWindow *renderWindow = (::Ogre::RenderWindow*) getLongAsPointer(renderWindowPtr);
                Ogre::Viewport *viewport = renderWindow->getViewport(0);
                int actLeft, actTop, actWidth, actHeight;
                viewport->getActualDimensions(actLeft, actTop, actWidth, actHeight);
//                alignPointer(&wbuf, 4);
//                write(&wbuf, getPointerAsLong(renderWindow));
//                write(&wbuf, getPointerAsLong(viewport));
                write(&wbuf, actLeft);
                write(&wbuf, actTop);
                write(&wbuf, actWidth);
                write(&wbuf, actHeight);
            }
                break;
            case SCENEMANAGER_ITEM_CREATE:
            {
                BufferRead<long long> bufferReadLong;
                alignPointer(&buf, 4);
                long long int sceneManagerPtr = bufferReadLong.read(&buf);
                Ogre::SceneManager *sceneManager = (Ogre::SceneManager*) getLongAsPointer(sceneManagerPtr);
                unsigned char ptrFlag = getPointerFlag(&buf);
                bool ptrJustCreated = isPointerJustCreated(ptrFlag);
                long long int itemPtr = bufferReadLong.read(&buf);
                const Ogre::String &meshName = readString(&buf);
                Ogre::Item *item = sceneManager->createItem(meshName);
                addToItemList(item);
                putInPointerMap(itemPtr, item);
                writePtr(&wbuf, getPointerAsLong(item));
//                alignPointer(&wbuf, 4);
//                write(&wbuf, getPointerAsLong(item));
                size_t itemsCount = item->getNumSubItems();
                for (size_t i = 0; i < itemsCount; ++i)
                {
                    Ogre::SubItem *pSubItem = item->getSubItem(i);
                    write(&wbuf, getPointerAsLong(pSubItem));
                }


            }
                break;
            case SCENEMANAGER_ITEM_CREATE_ALL_PARAMS:
            {
                BufferRead<long long> bufferReadLong;
                BufferRead<char> bufferReadChar;
                alignPointer(&buf, 4);
                long long int sceneManagerPtr = bufferReadLong.read(&buf);
                Ogre::SceneManager *sceneManager = (Ogre::SceneManager*) getLongAsPointer(sceneManagerPtr);
                unsigned char ptrFlag = getPointerFlag(&buf);
                bool ptrJustCreated = isPointerJustCreated(ptrFlag);
                long long int itemPtr = bufferReadLong.read(&buf);
                const Ogre::String &meshName = readString(&buf);
                const Ogre::String &groupName = readString(&buf);
                char sceneMemoryMgrTypeChar = bufferReadChar.read(&buf);
                Ogre::Item *item = sceneManager->createItem(meshName, groupName,
                                                            sceneMemoryMgrTypeChar == 0 ? ::Ogre::SCENE_DYNAMIC : ::Ogre::SCENE_STATIC);
                addToItemList(item);
                putInPointerMap(itemPtr, item);
                writePtr(&wbuf, getPointerAsLong(item));
//                alignPointer(&wbuf, 4);
//                write(&wbuf, getPointerAsLong(item));
                size_t itemsCount = item->getNumSubItems();
                for (size_t i = 0; i < itemsCount; ++i)
                {
                    Ogre::SubItem *pSubItem = item->getSubItem(i);
                    write(&wbuf, getPointerAsLong(pSubItem));
                }
            }
                break;
            case SCENEMANAGER_ITEM_DESTROY:
            {
                BufferRead<long long> bufferReadLong;
                alignPointer(&buf, 4);
                long long int sceneManagerPtr = bufferReadLong.read(&buf);
                Ogre::SceneManager *sceneManager = (Ogre::SceneManager*) getLongAsPointer(sceneManagerPtr);
                unsigned char ptrFlag = getPointerFlag(&buf);
                bool ptrJustCreated = isPointerJustCreated(ptrFlag);
                long long int itemPtr = bufferReadLong.read(&buf);
                Ogre::Item *item = (Ogre::Item*) getNativePointer(itemPtr, ptrJustCreated);
                removeFromItemList(item);
                sceneManager->destroyItem(item);
                removePointerFromMap(itemPtr, ptrJustCreated);
            }
                break;
            case SCENEMANAGER_ITEM_DESTROY_ALL:
            {
                BufferRead<long long> bufferReadLong;
                alignPointer(&buf, 4);
                long long int sceneManagerPtr = bufferReadLong.read(&buf);
                Ogre::SceneManager *sceneManager = (Ogre::SceneManager*) getLongAsPointer(sceneManagerPtr);
                removeAllFromItemList();
                sceneManager->destroyAllItems();
            }
                break;
            case SCENEMANAGER_CREATE_PARTICLE_SYSTEM_STRING:
            {
                BufferRead<long long> bufferReadLong;
                alignPointer(&buf, 4);
                long long int sceneManagerPtr = bufferReadLong.read(&buf);
                Ogre::SceneManager *sceneManager = (Ogre::SceneManager*) getLongAsPointer(sceneManagerPtr);
                unsigned char ptrFlag = getPointerFlag(&buf);
                bool ptrJustCreated = isPointerJustCreated(ptrFlag);
                long long int particleSystemPtr = bufferReadLong.read(&buf);
                const Ogre::String &templateName = readString(&buf);
                Ogre::ParticleSystem *pParticleSystem = sceneManager->createParticleSystem(templateName);
                putInPointerMap(particleSystemPtr, pParticleSystem);
                writePtr(&wbuf, getPointerAsLong(pParticleSystem));
//                alignPointer(&wbuf, 4);
//                write(&wbuf, getPointerAsLong(pParticleSystem));
            }
                break;
            case SCENEMANAGER_CREATE_PARTICLE_SYSTEM_QUOTA_RESOURCE_GROUP:
            {
                BufferRead<long long> bufferReadLong;
                BufferRead<int> bufferReadint;
                alignPointer(&buf, 4);
                long long int sceneManagerPtr = bufferReadLong.read(&buf);
                Ogre::SceneManager *sceneManager = (Ogre::SceneManager*) getLongAsPointer(sceneManagerPtr);
                unsigned char ptrFlag = getPointerFlag(&buf);
                bool ptrJustCreated = isPointerJustCreated(ptrFlag);
                long long int particleSystemPtr = bufferReadLong.read(&buf);
                int quota = bufferReadint.read(&buf);
                const Ogre::String &resourceGroup = readString(&buf);
                Ogre::ParticleSystem *pParticleSystem = sceneManager->createParticleSystem(quota, resourceGroup);
                putInPointerMap(particleSystemPtr, pParticleSystem);
                writePtr(&wbuf, getPointerAsLong(pParticleSystem));
//                alignPointer(&wbuf, 4);
//                write(&wbuf, getPointerAsLong(pParticleSystem));
            }
                break;
            case SCENEMANAGER_DESTROY_PARTICLE_SYSTEM:
            {
                BufferRead<long long> bufferReadLong;
                alignPointer(&buf, 4);
                long long int sceneManagerPtr = bufferReadLong.read(&buf);
                Ogre::SceneManager *sceneManager = (Ogre::SceneManager*) getLongAsPointer(sceneManagerPtr);
                unsigned char ptrFlag = getPointerFlag(&buf);
                bool ptrJustCreated = isPointerJustCreated(ptrFlag);
                long long int particleSystemPtr = bufferReadLong.read(&buf);
                Ogre::ParticleSystem *particleSystem= (Ogre::ParticleSystem*) getNativePointer(particleSystemPtr, ptrJustCreated);
                sceneManager->destroyParticleSystem(particleSystem);
                removePointerFromMap(particleSystemPtr, ptrJustCreated);
            }
                break;
            case SCENEMANAGER_DESTROY_ALL_PARTICLE_SYSTEMS:
            {
                BufferRead<long long> bufferReadLong;
                alignPointer(&buf, 4);
                long long int sceneManagerPtr = bufferReadLong.read(&buf);
                Ogre::SceneManager *sceneManager = (Ogre::SceneManager*) getLongAsPointer(sceneManagerPtr);
                sceneManager->destroyAllParticleSystems();
            }
                break;
            case SCENEMANAGER_CREATE_BILLBOARD_SET:
            {
                BufferRead<long long> bufferReadLong;
                BufferRead<unsigned int> bufferReadint;
                alignPointer(&buf, 4);
                long long int sceneManagerPtr = bufferReadLong.read(&buf);
                Ogre::SceneManager *sceneManager = (Ogre::SceneManager*) getLongAsPointer(sceneManagerPtr);
                unsigned char ptrFlag = getPointerFlag(&buf);
                bool ptrJustCreated = isPointerJustCreated(ptrFlag);
                long long int billboardSetPtr = bufferReadLong.read(&buf);
                unsigned int poolSize = bufferReadint.read(&buf);
                const Ogre::String &billboardSetName = readString(&buf);
                Ogre::v1::BillboardSet *pBillboardSet = sceneManager->createBillboardSet(poolSize);
                pBillboardSet->setName(billboardSetName);
                putInPointerMap(billboardSetPtr, pBillboardSet);
                writePtr(&wbuf, getPointerAsLong(pBillboardSet));
//                alignPointer(&wbuf, 4);
//                write(&wbuf, getPointerAsLong(pBillboardSet));
            }
                break;
            case SCENEMANAGER_DESTROY_BILLBOARD_SET:
            {
                BufferRead<long long> bufferReadLong;
                alignPointer(&buf, 4);
                long long int sceneManagerPtr = bufferReadLong.read(&buf);
                Ogre::SceneManager *sceneManager = (Ogre::SceneManager*) getLongAsPointer(sceneManagerPtr);
                unsigned char ptrFlag = getPointerFlag(&buf);
                bool ptrJustCreated = isPointerJustCreated(ptrFlag);
                long long int billboardSetPtr = bufferReadLong.read(&buf);
                Ogre::v1::BillboardSet *billboardSet = (Ogre::v1::BillboardSet*) getNativePointer(billboardSetPtr, ptrJustCreated);
                sceneManager->destroyBillboardSet(billboardSet);
                removePointerFromMap(billboardSetPtr, ptrJustCreated);
            }
                break;
            case SCENEMANAGER_DESTROY_ALL_BILLBOARD_SETS:
            {
                BufferRead<long long> bufferReadLong;
                alignPointer(&buf, 4);
                long long int sceneManagerPtr = bufferReadLong.read(&buf);
                Ogre::SceneManager *sceneManager = (Ogre::SceneManager*) getLongAsPointer(sceneManagerPtr);
                sceneManager->destroyAllBillboardSets();
            }
                break;
            case SCENEMANAGER_CLEAR_SCENE:
            {
                BufferRead<long long> bufferReadLong;
                alignPointer(&buf, 4);
                long long int sceneManagerPtr = bufferReadLong.read(&buf);
                Ogre::SceneManager *sceneManager = (Ogre::SceneManager*) getLongAsPointer(sceneManagerPtr);
                sceneManager->clearScene();
            }
                break;
            case SCENEMANAGER_SET_AMBIENT_LIGHT:
            {
                BufferRead<long long> bufferReadLong;
                BufferRead<float> bufferReadFloat;
                alignPointer(&buf, 4);
                long long int sceneManagerPtr = bufferReadLong.read(&buf);
                Ogre::SceneManager *sceneManager = (Ogre::SceneManager*) getLongAsPointer(sceneManagerPtr);
                const Ogre::ColourValue &upperHemisphere = readColour(&buf);
                const Ogre::ColourValue &lowerHemisphere = readColour(&buf);
                const Ogre::Vector3 &hemishpereDir = readVector3D(&buf);
                float envmapScale = bufferReadFloat.read(&buf);
                sceneManager->setAmbientLight(upperHemisphere, lowerHemisphere, hemishpereDir, envmapScale);
            }
                break;
            case SCENEMANAGER_SET_SKYBOX:
            {
                BufferRead<long long> bufferReadLong;
                BufferRead<bool> bufferReadBool;
                alignPointer(&buf, 4);
                long long int sceneManagerPtr = bufferReadLong.read(&buf);
                Ogre::SceneManager *sceneManager = (Ogre::SceneManager*) getLongAsPointer(sceneManagerPtr);
                bool enabled = bufferReadBool.read(&buf);
                const Ogre::String &materialName = readString(&buf);
                sceneManager->setSkyBox(enabled, materialName);
            }
                break;
            case SCENEMANAGER_SET_SKYBOX_ALL_PARAMS:
            {
                BufferRead<long long> bufferReadLong;
                BufferRead<bool> bufferReadBool;
                BufferRead<unsigned char> bufferReadChar;
                BufferRead<float> bufferReadFloat;
                alignPointer(&buf, 4);
                long long int sceneManagerPtr = bufferReadLong.read(&buf);
                Ogre::SceneManager *sceneManager = (Ogre::SceneManager*) getLongAsPointer(sceneManagerPtr);
                bool enabled = bufferReadBool.read(&buf);
                const Ogre::String &materialName = readString(&buf);
                float distance = bufferReadFloat.read(&buf);
                bool drawFirst = bufferReadBool.read(&buf);
				const Ogre::Quaternion &orientation = readQuaternion(&buf);
                const Ogre::String &groupName = readString(&buf);
                sceneManager->setSkyBox(enabled, materialName, distance, drawFirst, orientation, groupName);
            }
                break;
            case SCENEMANAGER_SET_SKYBOX_ENABLED:
            {
                BufferRead<long long> bufferReadLong;
                BufferRead<bool> bufferReadBool;
                alignPointer(&buf, 4);
                long long int sceneManagerPtr = bufferReadLong.read(&buf);
                Ogre::SceneManager *sceneManager = (Ogre::SceneManager*) getLongAsPointer(sceneManagerPtr);
                bool enabled = bufferReadBool.read(&buf);
                sceneManager->setSkyBoxEnabled(enabled);
            }
                break;
            case SCENEMANAGER_CREATE_SCENE_NODE:
            {
                BufferRead<long long> bufferReadLong;
                alignPointer(&buf, 4);
                long long int sceneManagerPtr = bufferReadLong.read(&buf);
                Ogre::SceneManager *sceneManager = (Ogre::SceneManager*) getLongAsPointer(sceneManagerPtr);
                unsigned char ptrFlag = getPointerFlag(&buf);
                bool ptrJustCreated = isPointerJustCreated(ptrFlag);
                long long int sceneNodePtr = bufferReadLong.read(&buf);
                Ogre::SceneNode *pNode = sceneManager->createSceneNode();
                putInPointerMap(sceneNodePtr, pNode);
                writePtr(&wbuf, getPointerAsLong(pNode));
//                alignPointer(&wbuf, 4);
//                write(&wbuf, getPointerAsLong(pNode));
            }
                break;
            case SCENEMANAGER_CREATE_SCENE_NODE_ALL_PARAMS:
            {
                BufferRead<long long> bufferReadLong;
                BufferRead<unsigned char> bufferReadChar;
                alignPointer(&buf, 4);
                long long int sceneManagerPtr = bufferReadLong.read(&buf);
                Ogre::SceneManager *sceneManager = (Ogre::SceneManager*) getLongAsPointer(sceneManagerPtr);
                unsigned char ptrFlag = getPointerFlag(&buf);
                bool ptrJustCreated = isPointerJustCreated(ptrFlag);
                long long int sceneNodePtr = bufferReadLong.read(&buf);
                unsigned char sceneMemoryMgrTypeChar = bufferReadChar.read(&buf);
                Ogre::SceneNode *pNode = sceneManager->createSceneNode(sceneMemoryMgrTypeChar == 0 ? ::Ogre::SCENE_DYNAMIC : ::Ogre::SCENE_STATIC);
                putInPointerMap(sceneNodePtr, pNode);
                writePtr(&wbuf, getPointerAsLong(pNode));
//                alignPointer(&wbuf, 4);
//                write(&wbuf, getPointerAsLong(pNode));
            }
                break;
            case SCENEMANAGER_DESTROY_SCENE_NODE:
            {
                BufferRead<long long> bufferReadLong;
                alignPointer(&buf, 4);
                long long int sceneManagerPtr = bufferReadLong.read(&buf);
                Ogre::SceneManager *sceneManager = (Ogre::SceneManager*) getLongAsPointer(sceneManagerPtr);
                unsigned char ptrFlag = getPointerFlag(&buf);
                bool ptrJustCreated = isPointerJustCreated(ptrFlag);
                long long int sceneNodePtr = bufferReadLong.read(&buf);
                Ogre::SceneNode *sceneNode= (Ogre::SceneNode*) getNativePointer(sceneNodePtr, ptrJustCreated);
                sceneManager->destroySceneNode(sceneNode);
                removePointerFromMap(sceneNodePtr, ptrJustCreated);
            }
                break;
            case SCENEMANAGER_CREATE_LIGHT:
            {
                BufferRead<long long> bufferReadLong;
                alignPointer(&buf, 4);
                long long int sceneManagerPtr = bufferReadLong.read(&buf);
                Ogre::SceneManager *sceneManager = (Ogre::SceneManager*) getLongAsPointer(sceneManagerPtr);
                unsigned char ptrFlag = getPointerFlag(&buf);
                bool ptrJustCreated = isPointerJustCreated(ptrFlag);
                long long int lightPtr = bufferReadLong.read(&buf);
                Ogre::Light *pLight = sceneManager->createLight();
                putInPointerMap(lightPtr, pLight);
                writePtr(&wbuf, getPointerAsLong(pLight));
//                alignPointer(&wbuf, 4);
//                write(&wbuf, getPointerAsLong(pLight));
            }
                break;
            case SCENEMANAGER_DESTROY_LIGHT:
            {
                BufferRead<long long> bufferReadLong;
                alignPointer(&buf, 4);
                long long int sceneManagerPtr = bufferReadLong.read(&buf);
                Ogre::SceneManager *sceneManager = (Ogre::SceneManager*) getLongAsPointer(sceneManagerPtr);
                unsigned char ptrFlag = getPointerFlag(&buf);
                bool ptrJustCreated = isPointerJustCreated(ptrFlag);
                long long int lightPtr = bufferReadLong.read(&buf);
                Ogre::Light *light= (Ogre::Light*) getNativePointer(lightPtr, ptrJustCreated);
                sceneManager->destroyLight(light);
                removePointerFromMap(lightPtr, ptrJustCreated);
            }
                break;
            case SCENEMANAGER_DESTROY_ALL_LIGHTS:
            {
                BufferRead<long long> bufferReadLong;
                alignPointer(&buf, 4);
                long long int sceneManagerPtr = bufferReadLong.read(&buf);
                Ogre::SceneManager *sceneManager = (Ogre::SceneManager*) getLongAsPointer(sceneManagerPtr);
                sceneManager->destroyAllLights();
            }
                break;
            case SCENENODE_CREATE_CHILD:
            {
                BufferRead<long long> bufferReadLong;
//                alignPointer(&buf, 4);
				unsigned char parentPtrFlag = getPointerFlag(&buf);
				bool parentPtrJustCreated = isPointerJustCreated(parentPtrFlag);
				long long int parentSceneNodePtr = bufferReadLong.read(&buf);
                Ogre::SceneNode *sceneNode = (Ogre::SceneNode*) getNativePointer(parentSceneNodePtr, parentPtrJustCreated);
                unsigned char ptrFlag = getPointerFlag(&buf);
                bool ptrJustCreated = isPointerJustCreated(ptrFlag);
                long long int sceneNodePtr = bufferReadLong.read(&buf);
                Ogre::SceneNode *pNode = sceneNode->createChildSceneNode();
                putInPointerMap(sceneNodePtr, pNode);
                writePtr(&wbuf, getPointerAsLong(pNode));
//                alignPointer(&wbuf, 4);
//                write(&wbuf, getPointerAsLong(pNode));
            }
                break;
            case SCENENODE_CREATE_CHILD_ALL_PARAMS:
            {
                BufferRead<long long> bufferReadLong;
                BufferRead<unsigned char> bufferReadChar;
//                alignPointer(&buf, 4);
				unsigned char parentPtrFlag = getPointerFlag(&buf);
				bool parentPtrJustCreated = isPointerJustCreated(parentPtrFlag);
				long long int parentSceneNodePtr = bufferReadLong.read(&buf);
				Ogre::SceneNode *sceneNode = (Ogre::SceneNode*) getNativePointer(parentSceneNodePtr, parentPtrJustCreated);
                unsigned char ptrFlag = getPointerFlag(&buf);
                bool ptrJustCreated = isPointerJustCreated(ptrFlag);
                long long int sceneNodePtr = bufferReadLong.read(&buf);
                unsigned char sceneMemoryMgrTypeChar = bufferReadChar.read(&buf);
                const Ogre::Vector3 &translate = readVector3D(&buf);
                const Ogre::Quaternion &rotate = readQuaternion(&buf);
                Ogre::SceneNode *pNode = sceneNode->createChildSceneNode(
                        sceneMemoryMgrTypeChar == 0 ? ::Ogre::SCENE_DYNAMIC : ::Ogre::SCENE_STATIC,
                        translate, rotate);
                putInPointerMap(sceneNodePtr, pNode);
                writePtr(&wbuf, getPointerAsLong(pNode));
//                alignPointer(&wbuf, 4);
//                write(&wbuf, getPointerAsLong(pNode));
            }
                break;
            case SCENENODE_REMOVE_AND_DESTROY:
            {
                BufferRead<long long> bufferReadLong;
                alignPointer(&buf, 4);
                long long int parentSceneNodePtr = bufferReadLong.read(&buf);
                Ogre::SceneNode *sceneNodeParent = (Ogre::SceneNode*) getLongAsPointer(parentSceneNodePtr);
                unsigned char ptrFlag = getPointerFlag(&buf);
                bool ptrJustCreated = isPointerJustCreated(ptrFlag);
                long long int sceneNodePtr = bufferReadLong.read(&buf);
                Ogre::SceneNode *sceneNodeChild= (Ogre::SceneNode*) getNativePointer(sceneNodePtr, ptrJustCreated);
                sceneNodeParent->removeAndDestroyChild(sceneNodeChild);
                removePointerFromMap(sceneNodePtr, ptrJustCreated);
            }
                break;
            case SCENENODE_REMOVE_AND_DESTROY_ALL_CHILDREN:
            {
                BufferRead<long long> bufferReadLong;
//                alignPointer(&buf, 4);
                unsigned char ptrFlag = getPointerFlag(&buf);
                bool ptrJustCreated = isPointerJustCreated(ptrFlag);
                long long int parentSceneNodePtr = bufferReadLong.read(&buf);
                Ogre::SceneNode *sceneNodeParent = (Ogre::SceneNode*) getNativePointer(parentSceneNodePtr, ptrJustCreated);
                sceneNodeParent->removeAndDestroyAllChildren();
//                removePointerFromMap(parentSceneNodePtr, ptrJustCreated);
            }
                break;
            case SCENENODE_ATTACH_OBJECT:
            {
                BufferRead<long long> bufferReadLong;
//                alignPointer(&buf, 4);
                unsigned char sceneNodePtrFlag = getPointerFlag(&buf);
                bool sceneNodePtrJustCreated = isPointerJustCreated(sceneNodePtrFlag);
                long long int parentSceneNodePtr = bufferReadLong.read(&buf);
                Ogre::SceneNode *sceneNode = (Ogre::SceneNode*) getNativePointer(parentSceneNodePtr, sceneNodePtrJustCreated);
                unsigned char ptrFlag = getPointerFlag(&buf);
                bool ptrJustCreated = isPointerJustCreated(ptrFlag);
                long long int itemPtr = bufferReadLong.read(&buf);
                Ogre::MovableObject *item = (Ogre::MovableObject*) getNativePointer(itemPtr, ptrJustCreated);
                sceneNode->attachObject(item);
//                putInPointerMap(itemPtr, item);
//                alignPointer(&wbuf, 4);
//                write(&wbuf, getPointerAsLong(item));
            }
                break;
            case SCENENODE_ATTACH_PARTICLE_SYSTEM:
            {
                BufferRead<long long> bufferReadLong;
//                alignPointer(&buf, 4);
                unsigned char sceneNodePtrFlag = getPointerFlag(&buf);
                bool sceneNodePtrJustCreated = isPointerJustCreated(sceneNodePtrFlag);
                long long int parentSceneNodePtr = bufferReadLong.read(&buf);
                Ogre::SceneNode *sceneNode = (Ogre::SceneNode*) getNativePointer(parentSceneNodePtr, sceneNodePtrJustCreated);
                unsigned char ptrFlag = getPointerFlag(&buf);
                bool ptrJustCreated = isPointerJustCreated(ptrFlag);
                long long int itemPtr = bufferReadLong.read(&buf);
                Ogre::MovableObject *item = static_cast<Ogre::MovableObject *>(static_cast<Ogre::ParticleSystem *>(getNativePointer(itemPtr, ptrJustCreated)));
                sceneNode->attachObject(item);
//                putInPointerMap(itemPtr, item);
//                alignPointer(&wbuf, 4);
//                write(&wbuf, getPointerAsLong(item));
            }
                break;
            case SCENENODE_DETACH_OBJECT:
            {
                BufferRead<long long> bufferReadLong;
//                alignPointer(&buf, 4);
                unsigned char sceneNodePtrFlag = getPointerFlag(&buf);
                bool sceneNodePtrJustCreated = isPointerJustCreated(sceneNodePtrFlag);
                long long int parentSceneNodePtr = bufferReadLong.read(&buf);
                Ogre::SceneNode *sceneNode = (Ogre::SceneNode*) getNativePointer(parentSceneNodePtr, sceneNodePtrJustCreated);
                unsigned char ptrFlag = getPointerFlag(&buf);
                bool ptrJustCreated = isPointerJustCreated(ptrFlag);
                long long int itemPtr = bufferReadLong.read(&buf);
                Ogre::MovableObject *item= (Ogre::MovableObject*) getNativePointer(itemPtr, ptrJustCreated);
                sceneNode->detachObject(item);
//                putInPointerMap(itemPtr, item);
//                alignPointer(&wbuf, 4);
//                write(&wbuf, getPointerAsLong(item));
            }
                break;
            case SCENENODE_DETACH_ALL_OBJECTS:
            {
                BufferRead<long long> bufferReadLong;
//                alignPointer(&buf, 4);
                unsigned char sceneNodePtrFlag = getPointerFlag(&buf);
                bool sceneNodePtrJustCreated = isPointerJustCreated(sceneNodePtrFlag);
                long long int parentSceneNodePtr = bufferReadLong.read(&buf);
                Ogre::SceneNode *sceneNode = (Ogre::SceneNode*) getNativePointer(parentSceneNodePtr, sceneNodePtrJustCreated);
                sceneNode->detachAllObjects();
            }
                break;
            case SCENENODE_SETPOSITION_XYZ:
            {
                BufferRead<long long> bufferReadLong;
//                alignPointer(&buf, 4);
                unsigned char sceneNodePtrFlag = getPointerFlag(&buf);
                bool sceneNodePtrJustCreated = isPointerJustCreated(sceneNodePtrFlag);
                long long int parentSceneNodePtr = bufferReadLong.read(&buf);
                Ogre::SceneNode *sceneNode = (Ogre::SceneNode*) getNativePointer(parentSceneNodePtr, sceneNodePtrJustCreated);
                const Ogre::Vector3 &position = readVector3D(&buf);
                sceneNode->setPosition(position);
            }
                break;
            case SCENENODE_SETPOSITION_VEC:
            {
                BufferRead<long long> bufferReadLong;
//                alignPointer(&buf, 4);
                unsigned char sceneNodePtrFlag = getPointerFlag(&buf);
                bool sceneNodePtrJustCreated = isPointerJustCreated(sceneNodePtrFlag);
                long long int parentSceneNodePtr = bufferReadLong.read(&buf);
                Ogre::SceneNode *sceneNode = (Ogre::SceneNode*) getNativePointer(parentSceneNodePtr, sceneNodePtrJustCreated);
                const Ogre::Vector3 &position = readVector3D(&buf);
                sceneNode->setPosition(position);
            }
                break;
            case SCENENODE_SETORIENTATION:
            {
                BufferRead<long long> bufferReadLong;
//                alignPointer(&buf, 4);
                unsigned char sceneNodePtrFlag = getPointerFlag(&buf);
                bool sceneNodePtrJustCreated = isPointerJustCreated(sceneNodePtrFlag);
                long long int parentSceneNodePtr = bufferReadLong.read(&buf);
                Ogre::SceneNode *sceneNode = (Ogre::SceneNode*) getNativePointer(parentSceneNodePtr, sceneNodePtrJustCreated);
                const Ogre::Quaternion &orientation = readQuaternion(&buf);
                sceneNode->setOrientation(orientation);
            }
                break;
            case SCENENODE_SETDERIVEDPOSITION_XYZ:
            {
                BufferRead<long long> bufferReadLong;
//                alignPointer(&buf, 4);
                unsigned char sceneNodePtrFlag = getPointerFlag(&buf);
                bool sceneNodePtrJustCreated = isPointerJustCreated(sceneNodePtrFlag);
                long long int parentSceneNodePtr = bufferReadLong.read(&buf);
                Ogre::SceneNode *sceneNode = (Ogre::SceneNode*) getNativePointer(parentSceneNodePtr, sceneNodePtrJustCreated);
                const Ogre::Vector3 &position = readVector3D(&buf);
                sceneNode->_setDerivedPosition(position);
            }
                break;
            case SCENENODE_SETDERIVEDPOSITION_VEC:
            {
                BufferRead<long long> bufferReadLong;
//                alignPointer(&buf, 4);
                unsigned char sceneNodePtrFlag = getPointerFlag(&buf);
                bool sceneNodePtrJustCreated = isPointerJustCreated(sceneNodePtrFlag);
                long long int parentSceneNodePtr = bufferReadLong.read(&buf);
                Ogre::SceneNode *sceneNode = (Ogre::SceneNode*) getNativePointer(parentSceneNodePtr, sceneNodePtrJustCreated);
                const Ogre::Vector3 &position = readVector3D(&buf);
                sceneNode->_setDerivedPosition(position);
            }
                break;
            case SCENENODE_SETDERIVEDORIENTATION:
            {
                BufferRead<long long> bufferReadLong;
//                alignPointer(&buf, 4);
                unsigned char sceneNodePtrFlag = getPointerFlag(&buf);
                bool sceneNodePtrJustCreated = isPointerJustCreated(sceneNodePtrFlag);
                long long int parentSceneNodePtr = bufferReadLong.read(&buf);
                Ogre::SceneNode *sceneNode = (Ogre::SceneNode*) getNativePointer(parentSceneNodePtr, sceneNodePtrJustCreated);
                const Ogre::Quaternion &orientation = readQuaternion(&buf);
                sceneNode->_setDerivedOrientation(orientation);
            }
                break;
            case SCENENODE_SETSCALING_XYZ:
            {
                BufferRead<long long> bufferReadLong;
//                alignPointer(&buf, 4);
                unsigned char sceneNodePtrFlag = getPointerFlag(&buf);
                bool sceneNodePtrJustCreated = isPointerJustCreated(sceneNodePtrFlag);
                long long int parentSceneNodePtr = bufferReadLong.read(&buf);
                Ogre::SceneNode *sceneNode = (Ogre::SceneNode*) getNativePointer(parentSceneNodePtr, sceneNodePtrJustCreated);
                const Ogre::Vector3 &scale = readVector3D(&buf);
                sceneNode->setScale(scale);
            }
                break;
            case SCENENODE_LOOKAT:
            {
                BufferRead<long long> bufferReadLong;
                BufferRead<unsigned char> bufferReadChar;
//                alignPointer(&buf, 4);
                unsigned char sceneNodePtrFlag = getPointerFlag(&buf);
                bool sceneNodePtrJustCreated = isPointerJustCreated(sceneNodePtrFlag);
                long long int parentSceneNodePtr = bufferReadLong.read(&buf);
                Ogre::SceneNode *sceneNode = (Ogre::SceneNode*) getNativePointer(parentSceneNodePtr, sceneNodePtrJustCreated);
                const Ogre::Vector3 &targetPoint = readVector3D(&buf);
                unsigned char relativeToChar = bufferReadChar.read(&buf);
//                const Ogre::Vector3 &localDirectionVector = readVector3D(&buf);
                ::Ogre::Node::TransformSpace transformSpace = (::Ogre::Node::TransformSpace) relativeToChar;
                sceneNode->lookAt(targetPoint, transformSpace);
            }
                break;
            case SCENENODE_LOOKAT_ALL_PARAMS:
            {
                BufferRead<long long> bufferReadLong;
                BufferRead<unsigned char> bufferReadChar;
//                alignPointer(&buf, 4);
                unsigned char sceneNodePtrFlag = getPointerFlag(&buf);
                bool sceneNodePtrJustCreated = isPointerJustCreated(sceneNodePtrFlag);
                long long int parentSceneNodePtr = bufferReadLong.read(&buf);
                Ogre::SceneNode *sceneNode = (Ogre::SceneNode*) getNativePointer(parentSceneNodePtr, sceneNodePtrJustCreated);
                const Ogre::Vector3 &targetPoint = readVector3D(&buf);
                unsigned char relativeToChar = bufferReadChar.read(&buf);
                const Ogre::Vector3 &localDirectionVector = readVector3D(&buf);
                ::Ogre::Node::TransformSpace transformSpace = (::Ogre::Node::TransformSpace) relativeToChar;
                sceneNode->lookAt(targetPoint, transformSpace, localDirectionVector);
            }
                break;
            case SCENENODE_SETVISIBLE:
            {
                BufferRead<long long> bufferReadLong;
                BufferRead<bool> bufferReadBool;
//                alignPointer(&buf, 4);
                unsigned char sceneNodePtrFlag = getPointerFlag(&buf);
                bool sceneNodePtrJustCreated = isPointerJustCreated(sceneNodePtrFlag);
                long long int parentSceneNodePtr = bufferReadLong.read(&buf);
                Ogre::SceneNode *sceneNode = (Ogre::SceneNode*) getNativePointer(parentSceneNodePtr, sceneNodePtrJustCreated);
                bool visibility = bufferReadBool.read(&buf);
                sceneNode->setVisible(visibility);
            }
                break;
            case SCENENODE_FLIPVISIBILITY:
            {
                BufferRead<long long> bufferReadLong;
                BufferRead<bool> bufferReadBool;
//                alignPointer(&buf, 4);
                unsigned char sceneNodePtrFlag = getPointerFlag(&buf);
                bool sceneNodePtrJustCreated = isPointerJustCreated(sceneNodePtrFlag);
                long long int parentSceneNodePtr = bufferReadLong.read(&buf);
                Ogre::SceneNode *sceneNode = (Ogre::SceneNode*) getNativePointer(parentSceneNodePtr, sceneNodePtrJustCreated);
                sceneNode->flipVisibility();
            }
                break;
            case LIGHT_SET_TYPE:
            {
                BufferRead<long long> bufferReadLong;
                BufferRead<unsigned char> bufferReadChar;
                unsigned char lightPtrFlag = getPointerFlag(&buf);
                bool lightPtrJustCreated = isPointerJustCreated(lightPtrFlag);
                long long int lightPtr = bufferReadLong.read(&buf);
                Ogre::Light *light = (Ogre::Light*) getNativePointer(lightPtr, lightPtrJustCreated);
                unsigned char lightType = bufferReadChar.read(&buf);
                light->setType((Ogre::Light::LightTypes) lightType);
            }
                break;
            case LIGHT_SET_SPOTLIGHT_RANGE:
            {
                BufferRead<long long> bufferReadLong;
                BufferRead<float> bufferReadFloat;
                unsigned char lightPtrFlag = getPointerFlag(&buf);
                bool lightPtrJustCreated = isPointerJustCreated(lightPtrFlag);
                long long int lightPtr = bufferReadLong.read(&buf);
                Ogre::Light *light = (Ogre::Light*) getNativePointer(lightPtr, lightPtrJustCreated);
                float innerAngle = bufferReadFloat.read(&buf);
                float outerAngle = bufferReadFloat.read(&buf);
                float falloff = bufferReadFloat.read(&buf);
                light->setSpotlightRange(Ogre::Radian(innerAngle), Ogre::Radian(outerAngle), falloff);
            }
                break;
            case LIGHT_SET_DIFFUSE_COLOUR:
            {
                BufferRead<long long> bufferReadLong;
                BufferRead<float> bufferReadFloat;
                unsigned char lightPtrFlag = getPointerFlag(&buf);
                bool lightPtrJustCreated = isPointerJustCreated(lightPtrFlag);
                long long int lightPtr = bufferReadLong.read(&buf);
                Ogre::Light *light = (Ogre::Light*) getNativePointer(lightPtr, lightPtrJustCreated);
                float r = bufferReadFloat.read(&buf);
                float g = bufferReadFloat.read(&buf);
                float b = bufferReadFloat.read(&buf);
                light->setDiffuseColour(r, g, b);
            }
                break;
            case LIGHT_SET_SPECULAR_COLOUR:
            {
                BufferRead<long long> bufferReadLong;
                BufferRead<float> bufferReadFloat;
                unsigned char lightPtrFlag = getPointerFlag(&buf);
                bool lightPtrJustCreated = isPointerJustCreated(lightPtrFlag);
                long long int lightPtr = bufferReadLong.read(&buf);
                Ogre::Light *light = (Ogre::Light*) getNativePointer(lightPtr, lightPtrJustCreated);
                float r = bufferReadFloat.read(&buf);
                float g = bufferReadFloat.read(&buf);
                float b = bufferReadFloat.read(&buf);
                light->setSpecularColour(r, g, b);
            }
                break;
            case LIGHT_SET_ATTENUATION:
            {
                BufferRead<long long> bufferReadLong;
                BufferRead<float> bufferReadFloat;
                unsigned char lightPtrFlag = getPointerFlag(&buf);
                bool lightPtrJustCreated = isPointerJustCreated(lightPtrFlag);
                long long int lightPtr = bufferReadLong.read(&buf);
                Ogre::Light *light = (Ogre::Light*) getNativePointer(lightPtr, lightPtrJustCreated);
                const Ogre::Vector4 &vec = readVector4DFull(&buf);
                light->setAttenuation(vec.x, vec.y, vec.z, vec.w);
            }
                break;
            case LIGHT_SET_POWER_SCALE:
            {
                BufferRead<long long> bufferReadLong;
                BufferRead<float> bufferReadFloat;
                unsigned char lightPtrFlag = getPointerFlag(&buf);
                bool lightPtrJustCreated = isPointerJustCreated(lightPtrFlag);
                long long int lightPtr = bufferReadLong.read(&buf);
                Ogre::Light *light = (Ogre::Light*) getNativePointer(lightPtr, lightPtrJustCreated);
                float power = bufferReadFloat.read(&buf);
                light->setPowerScale(power);
            }
                break;
            case LIGHT_SET_ATTENUATION_BASED_ON_RADIUS:
            {
                BufferRead<long long> bufferReadLong;
                BufferRead<float> bufferReadFloat;
                unsigned char lightPtrFlag = getPointerFlag(&buf);
                bool lightPtrJustCreated = isPointerJustCreated(lightPtrFlag);
                long long int lightPtr = bufferReadLong.read(&buf);
                Ogre::Light *light = (Ogre::Light*) getNativePointer(lightPtr, lightPtrJustCreated);
                const Ogre::Vector2 &vec = readVector2D(&buf);
                light->setAttenuationBasedOnRadius(vec.x, vec.y);
            }
                break;
//            case LIGHT_SET_POSITION:
//            {
//                BufferRead<long long> bufferReadLong;
//                BufferRead<float> bufferReadFloat;
//                unsigned char lightPtrFlag = getPointerFlag(&buf);
//                bool lightPtrJustCreated = isPointerJustCreated(lightPtrFlag);
//                long long int lightPtr = bufferReadLong.read(&buf);
//                Ogre::Light *light = (Ogre::Light*) getNativePointer(lightPtr, lightPtrJustCreated);
//                const Ogre::Vector3 &pos = readVector3D(&buf);
//                light->setPosi
//            }
                break;
            case LIGHT_SET_DIRECTION:
            {
                BufferRead<long long> bufferReadLong;
                BufferRead<float> bufferReadFloat;
                unsigned char lightPtrFlag = getPointerFlag(&buf);
                bool lightPtrJustCreated = isPointerJustCreated(lightPtrFlag);
                long long int lightPtr = bufferReadLong.read(&buf);
                Ogre::Light *light = (Ogre::Light*) getNativePointer(lightPtr, lightPtrJustCreated);
                const Ogre::Vector3 &pos = readVector3D(&buf);
                light->setDirection(pos);
            }
                break;
            case ITEM_SET_DATABLOCK:
            {
                BufferRead<long long> bufferReadLong;
                BufferRead<float> bufferReadFloat;
                unsigned char itemPtrFlag = getPointerFlag(&buf);
                bool itemPtrJustCreated = isPointerJustCreated(itemPtrFlag);
                long long int itemPtr = bufferReadLong.read(&buf);
                Ogre::Item *item = (Ogre::Item*) getNativePointer(itemPtr, itemPtrJustCreated);
                const Ogre::String &datablockName = readString(&buf);
                item->setDatablock(datablockName);
            }
                break;
            case ITEM_SET_VISIBILITY_FLAGS:
            {
                BufferRead<long long> bufferReadLong;
                BufferRead<int> bufferReadInt;
                unsigned char itemPtrFlag = getPointerFlag(&buf);
                bool itemPtrJustCreated = isPointerJustCreated(itemPtrFlag);
                long long int itemPtr = bufferReadLong.read(&buf);
                Ogre::Item *item = (Ogre::Item*) getNativePointer(itemPtr, itemPtrJustCreated);
                const int visibilityFlag = bufferReadInt.read(&buf);
                item->setVisibilityFlags(visibilityFlag);
            }
                break;
            case COMPOSITOR_WORKSPACE_SET_ENABLED:
            {
                BufferRead<long long> bufferReadLong;
                BufferRead<unsigned  char> bufferReadChar;
                alignPointer(&buf, 4);
                long long int compositorWorkspacePtr = bufferReadLong.read(&buf);
                Ogre::CompositorWorkspace* compositorWorkspace = (Ogre::CompositorWorkspace*) compositorWorkspacePtr;
                unsigned char enabled = bufferReadChar.read(&buf);
                compositorWorkspace->setEnabled((bool) enabled);
            }
                break;
            case CAMERA_INVALIDATE_VIEW:
            {
                BufferRead<long long> bufferReadLong;
                alignPointer(&buf, 4);
                long long int cameraPtr = bufferReadLong.read(&buf);
                Ogre::Camera* camera = (Ogre::Camera*) cameraPtr;

//                camera->invalidateView();
            }
                break;
            case CAMERA_GET_PROJECTION_MATRIX:
            {
                BufferRead<long long> bufferReadLong;
                alignPointer(&buf, 4);
                long long int cameraPtr = bufferReadLong.read(&buf);
                Ogre::Camera* camera = (Ogre::Camera*) cameraPtr;
                Ogre::Matrix4 projectionMatrix = camera->getProjectionMatrix();
                writeMatrix4(&wbuf, projectionMatrix);
            }
                break;
            case CAMERA_GET_VIEW_MATRIX:
            {
                BufferRead<long long> bufferReadLong;
                alignPointer(&buf, 4);
                long long int cameraPtr = bufferReadLong.read(&buf);
                Ogre::Camera* camera = (Ogre::Camera*) cameraPtr;
                Ogre::Matrix4 viewMatrix = camera->getViewMatrix();
                writeMatrix4(&wbuf, viewMatrix);
            }
                break;
            case CAMERA_IS_VISIBLE_VEC:
            {
                BufferRead<long long> bufferReadLong;
                BufferRead<unsigned char> bufferReadChar;
                alignPointer(&buf, 4);
                long long int cameraPtr = bufferReadLong.read(&buf);
                Ogre::Camera* camera = (Ogre::Camera*) cameraPtr;
                Ogre::Vector4 centre = readVector4DAsPt(&buf);
                bool visible = camera->isVisible(Ogre::Vector3(centre.x, centre.y, centre.z), 0);
                write(&wbuf, (unsigned char) visible);
            }
                break;
            case CAMERA_IS_VISIBLE_AXIS_ALIGNED_BOX:
            {
                BufferRead<long long> bufferReadLong;
                BufferRead<unsigned char> bufferReadChar;
                alignPointer(&buf, 4);
                long long int cameraPtr = bufferReadLong.read(&buf);
                Ogre::Camera* camera = (Ogre::Camera*) cameraPtr;
                const Ogre::AxisAlignedBox &box = readAxisAlignedBox(&buf);
                bool visible = camera->isVisible(box);
                write(&wbuf, (unsigned char) visible);
            }
                break;
            case GET_ITEMS_AABBS:
            {
                std::vector<Ogre::Item *>::iterator it = itemList.begin();
                const std::vector<Ogre::Item *>::iterator &end = itemList.end();
                while (it != end)
                {
                    Ogre::Item* item = *it;
                    const Ogre::Aabb &aabb = item->getWorldAabb();
                    const Ogre::Vector3 &minimum = aabb.getMinimum();
                    const Ogre::Vector3 &maximum = aabb.getMaximum();
                    unsigned int bytesWritten = alignPointer(&wbuf, 4);
                    checkWriteBufferOverflow(bytesWritten);
                    writeVector3D(&wbuf, minimum);
                    writeVector3D(&wbuf, maximum);
                    ++it;
                }
            }
                break;
            case MOVABLE_OBJECT_DETACH_FROM_PARENT:
            {
                BufferRead<long long> bufferReadLong;
                unsigned char itemPtrFlag = getPointerFlag(&buf);
                bool itemPtrJustCreated = isPointerJustCreated(itemPtrFlag);
                long long int itemPtr = bufferReadLong.read(&buf);
                Ogre::MovableObject *movableObject = (Ogre::MovableObject*) getNativePointer(itemPtr, itemPtrJustCreated);
                movableObject->detachFromParent();
            }
                break;
            case OVERLAY_MANAGER_CREATE_OVERLAY:
            {
                BufferRead<long long> bufferReadLong;
				alignPointer(&buf, 4);
                long long int overlayManagerPtr = bufferReadLong.read(&buf);
                Ogre::v1::OverlayManager *overlayManager = (Ogre::v1::OverlayManager*) overlayManagerPtr;
                const Ogre::String &overlayName = readString(&buf);
                Ogre::v1::Overlay *overlay = overlayManager->create(overlayName);
                wbuf = writeOverlay(wbuf, overlay);

            }
                break;
            case OVERLAY_MANAGER_DESTROY_OVERLAY_BY_NAME:
            {
                BufferRead<long long> bufferReadLong;
				alignPointer(&buf, 4);
                long long int overlayManagerPtr = bufferReadLong.read(&buf);
                Ogre::v1::OverlayManager *overlayManager = (Ogre::v1::OverlayManager*) overlayManagerPtr;
                const Ogre::String &overlayName = readString(&buf);
                overlayManager->destroy(overlayName);
            }
                break;
            case OVERLAY_MANAGER_DESTROY_OVERLAY_BY_PTR:
            {
                BufferRead<long long> bufferReadLong;
				alignPointer(&buf, 4);
                long long int overlayManagerPtr = bufferReadLong.read(&buf);
                Ogre::v1::OverlayManager *overlayManager = (Ogre::v1::OverlayManager*) overlayManagerPtr;
                long long int overlayPtr = bufferReadLong.read(&buf);
                Ogre::v1::Overlay *overlay = (Ogre::v1::Overlay*) overlayPtr;
                overlayManager->destroy(overlay);
            }
                break;
            case OVERLAY_MANAGER_DESTROY_ALL:
            {
                BufferRead<long long> bufferReadLong;
				alignPointer(&buf, 4);
                long long int overlayManagerPtr = bufferReadLong.read(&buf);
                Ogre::v1::OverlayManager *overlayManager = (Ogre::v1::OverlayManager*) overlayManagerPtr;
                overlayManager->destroyAll();
            }
                break;
            case OVERLAY_MANAGER_GET_BY_NAME:
            {
                BufferRead<long long> bufferReadLong;
				alignPointer(&buf, 4);
                long long int overlayManagerPtr = bufferReadLong.read(&buf);
                Ogre::v1::OverlayManager *overlayManager = (Ogre::v1::OverlayManager*) overlayManagerPtr;
                const Ogre::String &overlayName = readString(&buf);
                Ogre::v1::Overlay *overlay = overlayManager->getByName(overlayName);
                wbuf = writeOverlay(wbuf, overlay);
            }
                break;
            case OVERLAY_MANAGER_UPDATE_DATA:break;
            case OVERLAY_SHOW:
            {
                BufferRead<long long> bufferReadLong;
				alignPointer(&buf, 4);
                long long int overlayPtr = bufferReadLong.read(&buf);
                Ogre::v1::Overlay *overlay = (Ogre::v1::Overlay*) overlayPtr;
                overlay->show();
            }
                break;
            case OVERLAY_HIDE:
            {
                BufferRead<long long> bufferReadLong;
				alignPointer(&buf, 4);
                long long int overlayPtr = bufferReadLong.read(&buf);
                Ogre::v1::Overlay *overlay = (Ogre::v1::Overlay*) overlayPtr;
                overlay->hide();
            }
                break;
            case OVERLAY_ELEMENT_SHOW:
            {
                BufferRead<long long> bufferReadLong;
				alignPointer(&buf, 4);
                long long int overlayElementPtr = bufferReadLong.read(&buf);
                Ogre::v1::OverlayElement *overlayElement = (Ogre::v1::OverlayElement*) overlayElementPtr;
                overlayElement->show();
            }
                break;
            case OVERLAY_ELEMENT_HIDE:
            {
                BufferRead<long long> bufferReadLong;
				alignPointer(&buf, 4);
                long long int overlayElementPtr = bufferReadLong.read(&buf);
                Ogre::v1::OverlayElement *overlayElement = (Ogre::v1::OverlayElement*) overlayElementPtr;
                overlayElement->hide();
            }
                break;
            case OVERLAY_ELEMENT_SET_LEFT:
            {
                BufferRead<long long> bufferReadLong;
                BufferRead<float> bufferReadFloat;
				alignPointer(&buf, 4);
                long long int overlayElementPtr = bufferReadLong.read(&buf);
                Ogre::v1::OverlayElement *overlayElement = (Ogre::v1::OverlayElement*) overlayElementPtr;
                float val = bufferReadFloat.read(&buf);
                overlayElement->setLeft(val);
            }
                break;
            case OVERLAY_ELEMENT_SET_TOP:
            {
                BufferRead<long long> bufferReadLong;
                BufferRead<float> bufferReadFloat;
				alignPointer(&buf, 4);
                long long int overlayElementPtr = bufferReadLong.read(&buf);
                Ogre::v1::OverlayElement *overlayElement = (Ogre::v1::OverlayElement*) overlayElementPtr;
                float val = bufferReadFloat.read(&buf);
                overlayElement->setTop(val);
            }
                break;
            case OVERLAY_ELEMENT_SET_WIDTH:
            {
                BufferRead<long long> bufferReadLong;
                BufferRead<float> bufferReadFloat;
				alignPointer(&buf, 4);
                long long int overlayElementPtr = bufferReadLong.read(&buf);
                Ogre::v1::OverlayElement *overlayElement = (Ogre::v1::OverlayElement*) overlayElementPtr;
                float val = bufferReadFloat.read(&buf);
                overlayElement->setWidth(val);
            }
                break;
            case OVERLAY_ELEMENT_SET_HEIGHT:
            {
                BufferRead<long long> bufferReadLong;
                BufferRead<float> bufferReadFloat;
				alignPointer(&buf, 4);
                long long int overlayElementPtr = bufferReadLong.read(&buf);
                Ogre::v1::OverlayElement *overlayElement = (Ogre::v1::OverlayElement*) overlayElementPtr;
                float val = bufferReadFloat.read(&buf);
                overlayElement->setHeight(val);
            }
                break;
            case OVERLAY_ELEMENT_SET_CAPTION:
            {
                BufferRead<long long> bufferReadLong;
                BufferRead<float> bufferReadFloat;
				alignPointer(&buf, 4);
                long long int overlayElementPtr = bufferReadLong.read(&buf);
                Ogre::v1::OverlayElement *overlayElement = (Ogre::v1::OverlayElement*) overlayElementPtr;
                const Ogre::String &val = readString(&buf);
                overlayElement->setCaption(val);
            }
                break;
            case OVERLAY_ELEMENT_SET_METRICS_MODE:
            {
                BufferRead<long long> bufferReadLong;
                BufferRead<unsigned char> bufferReadChar;
				alignPointer(&buf, 4);
                long long int overlayElementPtr = bufferReadLong.read(&buf);
                Ogre::v1::OverlayElement *overlayElement = (Ogre::v1::OverlayElement*) overlayElementPtr;
                unsigned char val = bufferReadChar.read(&buf);
                Ogre::v1::GuiMetricsMode mode = (Ogre::v1::GuiMetricsMode) val;
                overlayElement->setMetricsMode(mode);
            }
                break;
            case GPU_PROGRAM_PARAMS_GET_PROGRAM_PARAMS:
            {
                BufferRead<long long> bufferReadLong;
                BufferRead<short> bufferReadShort;
                BufferRead<unsigned char> bufferReadChar;
                unsigned char gpuProgramParamsPtrFlag = getPointerFlag(&buf);
                bool gpuProgramParamsPtrJustCreated = isPointerJustCreated(gpuProgramParamsPtrFlag);
                long long int gpuProgramParamsPtr = bufferReadLong.read(&buf);
                Ogre::GpuProgramParameters *gpuProgramParams = (Ogre::GpuProgramParameters*) getNativePointer(gpuProgramParamsPtr, gpuProgramParamsPtrJustCreated);
                long long int renderablePtr = bufferReadLong.read(&buf);
                Ogre::Renderable *renderable = (Ogre::Renderable*) renderablePtr;
                short technique = bufferReadShort.read(&buf);
                short passVal = bufferReadShort.read(&buf);
                GpuProgramParametersType type = (GpuProgramParametersType) bufferReadChar.read(&buf);
                Ogre::Pass *pass = renderable->getMaterial()->getTechnique(technique)->getPass(passVal);
                Ogre::GpuProgramParametersSharedPtr gpuProgramParametersSharedPtr;
                switch (type)
                {
                    case GPU_VERTEX:
                        gpuProgramParametersSharedPtr = pass->getVertexProgramParameters();
                        break;
                    case GPU_FRAGMENT:
                        gpuProgramParametersSharedPtr = pass->getFragmentProgramParameters();
                        break;
                    case GPU_GEOMETRY:
                        gpuProgramParametersSharedPtr = pass->getGeometryProgramParameters();
                        break;
                    case GPU_COMPUTE:
                        gpuProgramParametersSharedPtr = pass->getComputeProgramParameters();
                        break;
                    case GPU_TESSELATION_DOMAIN:
                        gpuProgramParametersSharedPtr = pass->getTessellationDomainProgramParameters();
                        break;
                    case GPU_TESSELATION_HULL:
                        gpuProgramParametersSharedPtr = pass->getTessellationHullProgramParameters();
                        break;
                    case GPU_SHADOW_CASTER_VERTEX:
                        gpuProgramParametersSharedPtr = pass->getShadowCasterVertexProgramParameters();
                        break;
                    case GPU_SHADOW_CASTER_FRAGMENT:
                        gpuProgramParametersSharedPtr = pass->getShadowCasterFragmentProgramParameters();
                        break;
                }
                writePtr(&wbuf, getPointerAsLong(gpuProgramParametersSharedPtr.getPointer()));
            }
                break;
            case GPU_PROGRAM_PARAMS_SET_NAMED_CONSTANT_COLOUR:
            {
                BufferRead<long long> bufferReadLong;
                unsigned char gpuProgramParamsPtrFlag = getPointerFlag(&buf);
                bool gpuProgramParamsPtrJustCreated = isPointerJustCreated(gpuProgramParamsPtrFlag);
                long long int gpuProgramParamsPtr = bufferReadLong.read(&buf);
                Ogre::GpuProgramParameters *gpuProgramParams = (Ogre::GpuProgramParameters*) getNativePointer(gpuProgramParamsPtr, gpuProgramParamsPtrJustCreated);
                const Ogre::String &paramName = readString(&buf);
                const Ogre::ColourValue &col = readColour(&buf);
                gpuProgramParams->setNamedConstant(paramName, col);
            }
                break;
            case GPU_PROGRAM_PARAMS_SET_NAMED_CONSTANT_INT:
            {
                BufferRead<long long> bufferReadLong;
                BufferRead<int> bufferReadInt;
                unsigned char gpuProgramParamsPtrFlag = getPointerFlag(&buf);
                bool gpuProgramParamsPtrJustCreated = isPointerJustCreated(gpuProgramParamsPtrFlag);
                long long int gpuProgramParamsPtr = bufferReadLong.read(&buf);
                Ogre::GpuProgramParameters *gpuProgramParams = (Ogre::GpuProgramParameters*) getNativePointer(gpuProgramParamsPtr, gpuProgramParamsPtrJustCreated);
                const Ogre::String &paramName = readString(&buf);
                int val = bufferReadInt.read(&buf);
                gpuProgramParams->setNamedConstant(paramName, val);
            }
                break;
            case GPU_PROGRAM_PARAMS_SET_NAMED_CONSTANT_FLOAT:
            {
                BufferRead<long long> bufferReadLong;
                BufferRead<float> bufferReadFloat;
                unsigned char gpuProgramParamsPtrFlag = getPointerFlag(&buf);
                bool gpuProgramParamsPtrJustCreated = isPointerJustCreated(gpuProgramParamsPtrFlag);
                long long int gpuProgramParamsPtr = bufferReadLong.read(&buf);
                Ogre::GpuProgramParameters *gpuProgramParams = (Ogre::GpuProgramParameters*) getNativePointer(gpuProgramParamsPtr, gpuProgramParamsPtrJustCreated);
                const Ogre::String &paramName = readString(&buf);
                float val = bufferReadFloat.read(&buf);
                gpuProgramParams->setNamedConstant(paramName, val);
            }
                break;
            case TEXTURE_MANAGER_GET_BY_NAME:
            {
                BufferRead<long long> bufferReadLong;
                BufferRead<int> bufferReadInt;
                BufferRead<short> bufferReadShort;
				alignPointer(&buf, 4);
                long long int renderablePtr = bufferReadLong.read(&buf);
                Ogre::Renderable *renderable = (Ogre::Renderable*) renderablePtr;
//                short technique = bufferReadShort.read(&buf);
//                short passVal = bufferReadShort.read(&buf);
//                int textureUnitState = bufferReadInt.read(&buf);
                Ogre::HlmsUnlitDatablock *datablock = (Ogre::HlmsUnlitDatablock*) renderable->getDatablock();
                const Ogre::TexturePtr &texturePtr = datablock->getTexture(0);
//                const Ogre::TexturePtr &texture = Ogre::TextureManager::getSingleton().getByName(
//                                        renderable->getMaterial()->getTechnique(technique)->getPass(passVal)->getTextureUnitState(textureUnitState)->getName());
                writePtr(&wbuf, getPointerAsLong(texturePtr.getPointer()));
				write(&wbuf, texturePtr->getWidth());
				write(&wbuf, texturePtr->getHeight());
            }
                break;
            case TEXTURE_MANAGER_GET_BY_NAME_OVERLAY_ELEMENT:
            {
                BufferRead<long long> bufferReadLong;
                BufferRead<int> bufferReadInt;
                BufferRead<short> bufferReadShort;
                alignPointer(&buf, 4);
                long long int renderablePtr = bufferReadLong.read(&buf);
                Ogre::Renderable *renderable = (Ogre::Renderable*) renderablePtr;
//                short technique = bufferReadShort.read(&buf);
//                short passVal = bufferReadShort.read(&buf);
//                int textureUnitState = bufferReadInt.read(&buf);
                Ogre::v1::OverlayElement *overlayElement = (Ogre::v1::OverlayElement*) renderablePtr;
				overlayElement->initialise();
//				overlayElement->show();
                overlayElement->_update();
                Ogre::HlmsUnlitDatablock *datablock = (Ogre::HlmsUnlitDatablock*) overlayElement->getDatablock();
                const Ogre::TexturePtr &texturePtr = datablock->getTexture(0);
//                const Ogre::TexturePtr &texture = Ogre::TextureManager::getSingleton().getByName(
//                                        renderable->getMaterial()->getTechnique(technique)->getPass(passVal)->getTextureUnitState(textureUnitState)->getName());
                writePtr(&wbuf, getPointerAsLong(texturePtr.getPointer()));
				write(&wbuf, texturePtr->getWidth());
				write(&wbuf, texturePtr->getHeight());
            }
                break;
            case FRAME_STATS_UPDATE:
            {
                BufferRead<long long> bufferReadLong;
				alignPointer(&buf, 4);
                long long int rootPtr = bufferReadLong.read(&buf);
                Ogre::Root *root = (Ogre::Root*) rootPtr;
                const Ogre::FrameStats *frameStats = root->getFrameStats();
                write(&wbuf, frameStats->getFps());
                write(&wbuf, frameStats->getAvgFps());
                write(&wbuf, frameStats->getBestTime());
                write(&wbuf, frameStats->getWorstTime());
                write(&wbuf, frameStats->getLastTime());
                write(&wbuf, frameStats->getAvgTime());
            }
                break;
            case UNLIT_DATABLOCK_SET_USE_COLOUR:
            {
                BufferRead<long long> bufferReadLong;
                BufferRead<unsigned char> bufferReadChar;
                alignPointer(&buf, 4);
                long long int datablockPtr = bufferReadLong.read(&buf);
                unsigned char useColour = bufferReadChar.read(&buf);
                Ogre::HlmsUnlitDatablock *datablock = (Ogre::HlmsUnlitDatablock*) datablockPtr;
                datablock->setUseColour(useColour);
            }
                break;
            case UNLIT_DATABLOCK_SET_COLOUR:
            {
                BufferRead<long long> bufferReadLong;
                alignPointer(&buf, 4);
                long long int datablockPtr = bufferReadLong.read(&buf);
                const Ogre::ColourValue &colour = readColour(&buf);
                Ogre::HlmsUnlitDatablock *datablock = (Ogre::HlmsUnlitDatablock*) datablockPtr;
                datablock->setColour(colour);
            }
                break;
            case DYNAMIC_OVERLAY_ELEM_CTOR:
            {
                BufferRead<long long> bufferReadLong;
                alignPointer(&buf, 4);
                long long int elemPtr = bufferReadLong.read(&buf);
                std::string textureName = readString(&buf);
                std::string groupName = readString(&buf);
                Ogre::v1::OverlayElement *element = (Ogre::v1::OverlayElement*) elemPtr;
                Hotshot::DynamicOverlayElement *dynamicOverlayElement = new Hotshot::DynamicOverlayElement(element, textureName, groupName);
                writePtr(&wbuf, getPointerAsLong(dynamicOverlayElement));
            }
                break;
            case DYNAMIC_OVERLAY_ELEM_DTOR:
            {
                BufferRead<long long> bufferReadLong;
                alignPointer(&buf, 4);
                long long int elemPtr = bufferReadLong.read(&buf);
                Hotshot::DynamicOverlayElement *dynamicOverlayElement = (Hotshot::DynamicOverlayElement*) elemPtr;
                delete dynamicOverlayElement;
            }
                break;
            case DYNAMIC_OVERLAY_ELEM_RESET_TO_INITIAL_TEXTURE:
            {
                BufferRead<long long> bufferReadLong;
                alignPointer(&buf, 4);
                long long int elemPtr = bufferReadLong.read(&buf);
                Hotshot::DynamicOverlayElement *dynamicOverlayElement = (Hotshot::DynamicOverlayElement*) elemPtr;
                dynamicOverlayElement->resetToInitialTexture();
            }
                break;
            case DYNAMIC_OVERLAY_ELEM_UPDATE_FINAL_TEXTURE:
            {
                BufferRead<long long> bufferReadLong;
                alignPointer(&buf, 4);
                long long int elemPtr = bufferReadLong.read(&buf);
                Hotshot::DynamicOverlayElement *dynamicOverlayElement = (Hotshot::DynamicOverlayElement*) elemPtr;
                dynamicOverlayElement->updateFinalTexture();
            }
                break;
            case DYNAMIC_OVERLAY_ELEM_SET_POINT_IN_SCREEN_SPACE:
            {
                BufferRead<long long> bufferReadLong;
                BufferRead<int> bufferReadInt;
                BufferRead<float> bufferReadFloat;
                BufferRead<unsigned char> bufferReadChar;
                alignPointer(&buf, 4);
                long long int elemPtr = bufferReadLong.read(&buf);
                float x = bufferReadFloat.read(&buf);
                float y = bufferReadFloat.read(&buf);
                int pixelLen = bufferReadInt.read(&buf);
                Ogre::ColourValue colour = readColour(&buf);
                bool overwriteTransparentPixels = (bool) bufferReadChar.read(&buf);
                Hotshot::DynamicOverlayElement *dynamicOverlayElement = (Hotshot::DynamicOverlayElement*) elemPtr;
                dynamicOverlayElement->setPointScreenSpace(x, y, pixelLen, colour, overwriteTransparentPixels);
            }
                break;
            case DYNAMIC_OVERLAY_ELEM_LOCK:
            {
                BufferRead<long long> bufferReadLong;
                alignPointer(&buf, 4);
                long long int elemPtr = bufferReadLong.read(&buf);
                Hotshot::DynamicOverlayElement *dynamicOverlayElement = (Hotshot::DynamicOverlayElement*) elemPtr;
                dynamicOverlayElement->lock();
            }
                break;
            case DYNAMIC_OVERLAY_ELEM_UNLOCK:
            {
                BufferRead<long long> bufferReadLong;
                alignPointer(&buf, 4);
                long long int elemPtr = bufferReadLong.read(&buf);
                Hotshot::DynamicOverlayElement *dynamicOverlayElement = (Hotshot::DynamicOverlayElement*) elemPtr;
                dynamicOverlayElement->unlock();
            }
                break;
            case DYNAMIC_OVERLAY_ELEM_SET_AREA_VEC:
            {
                BufferRead<long long> bufferReadLong;
                BufferRead<int> bufferReadInt;
                BufferRead<unsigned char> bufferReadChar;
                alignPointer(&buf, 4);
                long long int elemPtr = bufferReadLong.read(&buf);
                Hotshot::DynamicOverlayElement *dynamicOverlayElement = (Hotshot::DynamicOverlayElement*) elemPtr;
                int left = bufferReadInt.read(&buf);
                int top = bufferReadInt.read(&buf);
                int right = bufferReadInt.read(&buf);
                int bottom = bufferReadInt.read(&buf);
                int front = bufferReadInt.read(&buf);
                int back = bufferReadInt.read(&buf);
                std::vector<Ogre::ColourValue> list;
                int listSize = bufferReadInt.read(&buf);
                for (int i = 0; i < listSize; ++i) {
                    Ogre::ColourValue value = readColour(&buf);
                    list.push_back(value);
                }
                bool overwriteTransparentPixels = (bool) bufferReadChar.read(&buf);
                Ogre::Box box(left, top, right, bottom, front, back);
                dynamicOverlayElement->setArea(box, list, overwriteTransparentPixels);
            }
                break;
            case DYNAMIC_OVERLAY_ELEM_SET_AREA:
            {
                BufferRead<long long> bufferReadLong;
                BufferRead<int> bufferReadInt;
                BufferRead<unsigned char> bufferReadChar;
                alignPointer(&buf, 4);
                long long int elemPtr = bufferReadLong.read(&buf);
                Hotshot::DynamicOverlayElement *dynamicOverlayElement = (Hotshot::DynamicOverlayElement*) elemPtr;
                int left = bufferReadInt.read(&buf);
                int top = bufferReadInt.read(&buf);
                int right = bufferReadInt.read(&buf);
                int bottom = bufferReadInt.read(&buf);
                int front = bufferReadInt.read(&buf);
                int back = bufferReadInt.read(&buf);
                Ogre::ColourValue value = readColour(&buf);
                bool overwriteTransparentPixels = (bool) bufferReadChar.read(&buf);
                Ogre::Box box(left, top, right, bottom, front, back);
                dynamicOverlayElement->setArea(box, value, overwriteTransparentPixels);
            }
                break;
            case TILED_ANIMATION_CREATE:
            {
                BufferRead<long long> bufferReadLong;
                BufferRead<int> bufferReadInt;
                BufferRead<float> bufferReadFloat;
//                alignPointer(&buf, 4);
                unsigned char tiledAnimationPtrFlag = getPointerFlag(&buf);
                bool tiledAnimationPtrJustCreated = isPointerJustCreated(tiledAnimationPtrFlag);
                long long int tiledAnimationPtr = bufferReadLong.read(&buf);
                unsigned char billboardSetPtrFlag = getPointerFlag(&buf);
                bool billboardSetPtrJustCreated = isPointerJustCreated(billboardSetPtrFlag);
                long long int billboardSetPtr = bufferReadLong.read(&buf);
                ::Ogre::v1::BillboardSet *billboardSet  = (::Ogre::v1::BillboardSet *) getNativePointer(billboardSetPtr, billboardSetPtrJustCreated); // What if we don't find it in the release build???
                Ogre::String name = readString(&buf);
                Ogre::String unlitMaterialName = readString(&buf);
                float speed = bufferReadFloat.read(&buf);
                int horizontalFramesNum = bufferReadInt.read(&buf);
                int verticalFramesNum = bufferReadInt.read(&buf);
                Hotshot::TiledAnimation *tiledAnimation = new Hotshot::TiledAnimation(*billboardSet, name, unlitMaterialName, speed, horizontalFramesNum, verticalFramesNum);
                
                putInPointerMap(tiledAnimationPtr, tiledAnimation);
                writePtr(&wbuf, getPointerAsLong(tiledAnimation));
            }
                break;
            case TILED_ANIMATION_DESTROY:
            {
                BufferRead<long long> bufferReadLong;
//                alignPointer(&buf, 4);
                unsigned char ptrFlag = getPointerFlag(&buf);
                bool ptrJustCreated = isPointerJustCreated(ptrFlag);
                long long int tiledAnimationPtr = bufferReadLong.read(&buf);
                Hotshot::TiledAnimation *tiledAnimation = (Hotshot::TiledAnimation*) getNativePointer(tiledAnimationPtr, ptrJustCreated);
                removePointerFromMap(tiledAnimationPtr, ptrJustCreated);
                delete tiledAnimation;

            }
                break;
            case TILED_ANIMATION_UPDATE_CURRENT_FRAME_NUM:
            {
                BufferRead<long long> bufferReadLong;
                unsigned char ptrFlag = getPointerFlag(&buf);
                bool ptrJustCreated = isPointerJustCreated(ptrFlag);
                long long int tiledAnimationPtr = bufferReadLong.read(&buf);
                Hotshot::TiledAnimation *tiledAnimation = (Hotshot::TiledAnimation*) getNativePointer(tiledAnimationPtr, ptrJustCreated);
                int currentFrameNum = tiledAnimation->getCurrentFrameNum();
                write(&wbuf, currentFrameNum);
            }
                break;
            case BILLBOARDSET_CREATE_BILLBOARD:
            {
                BufferRead<long long> bufferReadLong;
//                alignPointer(&buf, 4);
                unsigned char billboardSetPtrFlag = getPointerFlag(&buf);
                bool billboardSetPtrJustCreated = isPointerJustCreated(billboardSetPtrFlag);
                long long int billboardSetPtr = bufferReadLong.read(&buf);
                ::Ogre::v1::BillboardSet *billboardSet  = (::Ogre::v1::BillboardSet *) getNativePointer(billboardSetPtr, billboardSetPtrJustCreated); // What if we don't find it in the release build???
                unsigned char billboardPtrFlag = getPointerFlag(&buf);
                bool billboardPtrJustCreated = isPointerJustCreated(billboardPtrFlag);
                long long int billboardPtr = bufferReadLong.read(&buf);
                Ogre::Vector3 pos = readVector3D(&buf);
                Ogre::ColourValue colour = readColour(&buf);
                Ogre::v1::Billboard *billboard = billboardSet->createBillboard(pos, colour);

                putInPointerMap(billboardPtr, billboard);
                writePtr(&wbuf, getPointerAsLong(billboard));
            }
                break;
            case BILLBOARDSET_DESTROY_BILLBOARD:
            {
                BufferRead<long long> bufferReadLong;
//                alignPointer(&buf, 4);
                unsigned char billboardSetPtrFlag = getPointerFlag(&buf);
                bool billboardSetPtrJustCreated = isPointerJustCreated(billboardSetPtrFlag);
                long long int billboardSetPtr = bufferReadLong.read(&buf);
                ::Ogre::v1::BillboardSet *billboardSet  = (::Ogre::v1::BillboardSet *) getNativePointer(billboardSetPtr, billboardSetPtrJustCreated); // What if we don't find it in the release build???
                unsigned char billboardPtrFlag = getPointerFlag(&buf);
                bool billboardPtrJustCreated = isPointerJustCreated(billboardPtrFlag);
                long long int billboardPtr = bufferReadLong.read(&buf);
                Ogre::v1::Billboard *billboard = (::Ogre::v1::Billboard*) getNativePointer(billboardPtr, billboardPtrJustCreated);
                billboardSet->removeBillboard(billboard);
                removePointerFromMap(billboardPtr, billboardPtrJustCreated);
            }
                break;
//            case BILLBOARDSET_DESTROY_BILLBOARD_BY_ID: // Using the pos means we do not know to removePointerFromMap()
//            {
//                BufferRead<long long> bufferReadLong;
//                BufferRead<int> bufferReadInt;
//                alignPointer(&buf, 4);
//                unsigned char billboardSetPtrFlag = getPointerFlag(&buf);
//                bool billboardSetPtrJustCreated = isPointerJustCreated(billboardSetPtrFlag);
//                long long int billboardSetPtr = bufferReadLong.read(&buf);
//                ::Ogre::v1::BillboardSet *billboardSet  = (::Ogre::v1::BillboardSet *) getNativePointer(billboardSetPtr, billboardSetPtrJustCreated); // What if we don't find it in the release build???
//                int pos = bufferReadInt.read(&buf);
//                billboardSet->removeBillboard(pos);
//                removePointerFromMap(billboardPtr, billboardPtrJustCreated);
//            }
                break;
            case BILLBOARDSET_SET_COMMON_UP_VECTOR:
            {
                BufferRead<long long> bufferReadLong;
                unsigned char ptrFlag = getPointerFlag(&buf);
                bool billboardSetPtrJustCreated = isPointerJustCreated(ptrFlag);
                long long int billboardSetPtr = bufferReadLong.read(&buf);
                ::Ogre::v1::BillboardSet *billboardSet  = (::Ogre::v1::BillboardSet *) getNativePointer(billboardSetPtr, billboardSetPtrJustCreated);
                const Ogre::Vector3 &upVector = readVector3D(&buf);
                billboardSet->setCommonUpVector(upVector);
            }
                break;
            case BILLBOARDSET_SET_COMMON_DIRECTION:
            {
                BufferRead<long long> bufferReadLong;
                unsigned char ptrFlag = getPointerFlag(&buf);
                bool billboardSetPtrJustCreated = isPointerJustCreated(ptrFlag);
                long long int billboardSetPtr = bufferReadLong.read(&buf);
                ::Ogre::v1::BillboardSet *billboardSet  = (::Ogre::v1::BillboardSet *) getNativePointer(billboardSetPtr, billboardSetPtrJustCreated);
                const Ogre::Vector3 &commonDirection = readVector3D(&buf);
                billboardSet->setCommonDirection(commonDirection);
            }
                break;
            case BILLBOARDSET_SET_DEFAULT_DIMENSIONS:
            {
                BufferRead<long long> bufferReadLong;
                BufferRead<float> bufferReadFloat;
                unsigned char ptrFlag = getPointerFlag(&buf);
                bool billboardSetPtrJustCreated = isPointerJustCreated(ptrFlag);
                long long int billboardSetPtr = bufferReadLong.read(&buf);
                ::Ogre::v1::BillboardSet *billboardSet  = (::Ogre::v1::BillboardSet *) getNativePointer(billboardSetPtr, billboardSetPtrJustCreated);
                float xDim = bufferReadFloat.read(&buf);
                float yDim = bufferReadFloat.read(&buf);
                billboardSet->setDefaultDimensions(xDim, yDim);
            }
                break;
            case BILLBOARDSET_SET_MATERIAL_NAME:
            {
                BufferRead<long long> bufferReadLong;
                unsigned char ptrFlag = getPointerFlag(&buf);
                bool billboardSetPtrJustCreated = isPointerJustCreated(ptrFlag);
                long long int billboardSetPtr = bufferReadLong.read(&buf);
                ::Ogre::v1::BillboardSet *billboardSet  = (::Ogre::v1::BillboardSet *) getNativePointer(billboardSetPtr, billboardSetPtrJustCreated);
                const Ogre::String &materialName = readString(&buf);
                const Ogre::String &groupName = readString(&buf);
                billboardSet->setMaterialName(materialName, groupName);
            }
                break;
            case BILLBOARDSET_SET_BILLBOARD_ORIGIN:
            {
                BufferRead<long long> bufferReadLong;
                BufferRead<unsigned char> bufferReadChar;
                unsigned char ptrFlag = getPointerFlag(&buf);
                bool billboardSetPtrJustCreated = isPointerJustCreated(ptrFlag);
                long long int billboardSetPtr = bufferReadLong.read(&buf);
                ::Ogre::v1::BillboardSet *billboardSet  = (::Ogre::v1::BillboardSet *) getNativePointer(billboardSetPtr, billboardSetPtrJustCreated);
                unsigned char origin = bufferReadChar.read(&buf);
                billboardSet->setBillboardOrigin((Ogre::v1::BillboardOrigin) origin);
            }
                break;
            case BILLBOARDSET_SET_BILLBOARD_ROTATION_TYPE:
            {
                BufferRead<long long> bufferReadLong;
                BufferRead<unsigned char> bufferReadChar;
                unsigned char ptrFlag = getPointerFlag(&buf);
                bool billboardSetPtrJustCreated = isPointerJustCreated(ptrFlag);
                long long int billboardSetPtr = bufferReadLong.read(&buf);
                ::Ogre::v1::BillboardSet *billboardSet  = (::Ogre::v1::BillboardSet *) getNativePointer(billboardSetPtr, billboardSetPtrJustCreated);
                unsigned char rotationType = bufferReadChar.read(&buf);
                billboardSet->setBillboardRotationType((Ogre::v1::BillboardRotationType) rotationType);
            }
                break;
            case BILLBOARDSET_SET_BILLBOARD_TYPE:
            {
                BufferRead<long long> bufferReadLong;
                BufferRead<unsigned char> bufferReadChar;
                unsigned char ptrFlag = getPointerFlag(&buf);
                bool billboardSetPtrJustCreated = isPointerJustCreated(ptrFlag);
                long long int billboardSetPtr = bufferReadLong.read(&buf);
                ::Ogre::v1::BillboardSet *billboardSet  = (::Ogre::v1::BillboardSet *) getNativePointer(billboardSetPtr, billboardSetPtrJustCreated);
                unsigned char type = bufferReadChar.read(&buf);
                billboardSet->setBillboardType((Ogre::v1::BillboardType) type);
            }
                break;
            case MOVABLE_OBJECT_SET_RENDER_QUEUE_GROUP:
            {
                BufferRead<long long> bufferReadLong;
                BufferRead<unsigned char> bufferReadChar;
                unsigned char movableObjectPtrFlag = getPointerFlag(&buf);
                bool movableObjectPtrJustCreated = isPointerJustCreated(movableObjectPtrFlag);
                long long int movableObjectPtr = bufferReadLong.read(&buf);
                ::Ogre::MovableObject *movableObject  = (::Ogre::MovableObject *) getNativePointer(movableObjectPtr, movableObjectPtrJustCreated);
                unsigned char renderQueueGroup = bufferReadChar.read(&buf);
                movableObject->setRenderQueueGroup(renderQueueGroup);
            }
                break;
            case PARTICLE_SYSTEM_SET_MATERIAL_NAME:
            {
                BufferRead<long long> bufferReadLong;
                unsigned char particleSystemPtrFlag = getPointerFlag(&buf);
                bool particleSystemPtrJustCreated = isPointerJustCreated(particleSystemPtrFlag);
                long long int particleSystemPtr = bufferReadLong.read(&buf);
                ::Ogre::ParticleSystem *particleSystem  = (::Ogre::ParticleSystem *) getNativePointer(particleSystemPtr, particleSystemPtrJustCreated);
                Ogre::String materialName = readString(&buf);
                particleSystem->setMaterialName(materialName);
            }
                break;
            case SCENE_COMPOSITOR_INSERT_NODE:
            {
                BufferRead<long long> bufferReadLong;
                BufferRead<float> bufferReadFloat;
                alignPointer(&buf, 4);
                long long int sceneCompositorPtr = bufferReadLong.read(&buf);
                long long int workspacePtr = bufferReadLong.read(&buf);
                Ogre::String workspaceName = readString(&buf);
                Ogre::String baseNodeName = readString(&buf);
                Ogre::String nodeToInsertName = readString(&buf);
                Ogre::String previousNodeName = readString(&buf);
                Ogre::ColourValue rgba = readColour(&buf);
                float scaleStep = bufferReadFloat.read(&buf);
                Hotshot::SceneCompositor *sceneCompositor = (Hotshot::SceneCompositor*) sceneCompositorPtr;
                Ogre::CompositorWorkspace *workspace = (::Ogre::CompositorWorkspace*) workspacePtr;
                long long int compositorAnimationId = sceneCompositor->startCompositorAnimation(workspace, workspaceName,
                                                                                              baseNodeName, nodeToInsertName,
                                                                                                previousNodeName, rgba, scaleStep);
                alignPointer(&wbuf, 4);
                write(&wbuf, compositorAnimationId);
            }
                break;
            case SCENE_COMPOSITOR_REVERT_NODE:
            {
                BufferRead<long long> bufferReadLong;
                alignPointer(&buf, 4);
                long long int sceneCompositorPtr = bufferReadLong.read(&buf);
                long long int compositorId = bufferReadLong.read(&buf);
                Hotshot::SceneCompositor *sceneCompositor = (Hotshot::SceneCompositor*) sceneCompositorPtr;
                sceneCompositor->stopCompositorAnimation(compositorId);
            }
                break;
            case FRAME_ID_POS:
            {
                // Execute the remaining frame end listeners.
                std::vector<FrameEndListenerExecutor *>::iterator it = frameEndListenerExecutorList.begin();
//                const std::vector<FrameEndListenerExecutor *>::iterator &end = frameEndListenerExecutorList.end();
                while (it != frameEndListenerExecutorList.end())
                {
                    FrameEndListenerExecutor *frameEndListenerExecutor = *it;
                    if (renderedOneFrame || !frameEndListenerExecutor->isExecuteAfterRenderOneFrame())
                    {
                        // Temporary hack to get the current frame num to compare it with the java side.
//                        int currentFrameNum = Hotshot::GorillaGUI::getCurrentFrameNum();
//                        Ogre::String s("renderOneFrame currentFrameNum:  " + SSTR(currentFrameNum) + "\n");
//                        LOGI("%s", s.c_str());
//                        s = ("Write buffer size before frameEndListenerExecutor: " + SSTR(getCurrentWriteBufferWrittenSize()) + "\n");
//                        LOGI("%s", s.c_str());
                        wbuf = frameEndListenerExecutor->execute(wbuf);
//                        s = ("Write buffer size after frameEndListenerExecutor: " + SSTR(getCurrentWriteBufferWrittenSize()) + "\n");
//                        LOGI("%s", s.c_str());
                        delete frameEndListenerExecutor;
                        it = frameEndListenerExecutorList.erase(it);
                    }
                    else
                    {
                        ++it;
                    }
                }
                *frameIdPos = *buf++;
                if (renderedOneFrame)
                {
                    *frameIdPos = (*frameIdPos | (char) 0x80);
                }
                // The frame id is guaranteed to be the last thing in the buffer.
                return;
            }
                break;
#ifdef TEST_RENDERING_THREAD
            case TEST_CALL1:
            {
                
            }
                break;
            case TEST_CALL2:
            {

            }
                break;
            case TEST_CALL3:
            {

            }
                break;
            case TEST_CALL4:
            {

            }
                break;
            case TEST_CALL_W_RESPONSE1:
            {
                BufferRead<int> bufferRead;
                int i = bufferRead.read(&buf);
                const Ogre::String &first = readString(&buf);
                const Ogre::String &second = readString(&buf);
                write(&wbuf, i);
//                LOGI("%s", "TEST_CALL_W_RESPONSE1");
            }
                break;
            case TEST_CALL_W_RESPONSE2:
            {
                BufferRead<double> doubleBufferRead;
                BufferRead<char> charBufferRead;
                BufferRead<long long> longBufferRead;
                alignPointer(&buf, 4);
                double i = doubleBufferRead.read(&buf);
                char c = charBufferRead.read(&buf);
                alignPointer(&buf, 4);
                long long l = longBufferRead.read(&buf);
                const Ogre::String &first = readString(&buf);
                const Ogre::String &second = readString(&buf);
                alignPointer(&wbuf, 4);
                write(&wbuf, i);
                write(&wbuf, c);
                alignPointer(&wbuf, 4);
                write(&wbuf, l);
//                LOGI("%s", "TEST_CALL_W_RESPONSE2");
            }
                break;
            case TEST_CALL_W_RESPONSE3:
            {
                const Ogre::Vector4 &vector4 = readVector4DFull(&buf);
                const Ogre::String &first = readString(&buf);
                const Ogre::String &second = readString(&buf);
                writeVector4DFull(&wbuf, vector4);
                writeString(&wbuf, first);
//                LOGI("%s", "TEST_CALL_W_RESPONSE3");
            }
                break;
            case TEST_CALL_W_RESPONSE4:
            {
                const std::map<Ogre::String, int> &map = readMapStringInt(&buf);
                const Ogre::Vector4 &vector4 = readVector4DAsPt(&buf);
                const Ogre::String &first = readString(&buf);
                const Ogre::String &second = readString(&buf);
//                LOGI("%i", map.size());
                write(&wbuf, map.size());
                writeVector4D(&wbuf, vector4);
//                LOGI("%s", "TEST_CALL_W_RESPONSE4");
            }
                break;
            case TEST_CALL_RENDERING_THREAD_DATA_FLUSH1:
            {
                BufferRead<long long> longBufferRead;
                alignPointer(&buf, 4);
                long long l = longBufferRead.read(&buf);
                alignPointer(&wbuf, 4);
                write(&wbuf, l);
//                LOGI("%s", "TEST_CALL_RENDERING_THREAD_DATA_FLUSH1");
            }
                break;
            case TEST_CALL_RENDERING_THREAD_DATA_FLUSH2:
            {
                BufferRead<long long> longBufferRead;
                alignPointer(&buf, 4);
                long long l = longBufferRead.read(&buf);
                alignPointer(&wbuf, 4);
                write(&wbuf, l);
//                LOGI("%s", "TEST_CALL_RENDERING_THREAD_DATA_FLUSH2");
            }
                break;
            case TEST_CALL_RENDERING_THREAD_DATA_FLUSH3:
            {
                BufferRead<long long> longBufferRead;
                alignPointer(&buf, 4);
                long long l = longBufferRead.read(&buf);
                alignPointer(&wbuf, 4);
                write(&wbuf, l);
//                LOGI("%s", "TEST_CALL_RENDERING_THREAD_DATA_FLUSH3");
            }
                break;
            case TEST_CALL_RENDERING_THREAD_DATA_FLUSH4:
            {
                BufferRead<long long> longBufferRead;
                alignPointer(&buf, 4);
                long long l = longBufferRead.read(&buf);
                alignPointer(&wbuf, 4);
                write(&wbuf, l);
//                LOGI("%s", "TEST_CALL_RENDERING_THREAD_DATA_FLUSH4");
            }
                break;
            case TEST_CALL_RENDERING_THREAD_DATA_FLUSH_ARRAY1:
            {
                BufferRead<long long> longBufferRead;
                alignPointer(&buf, 4);
                long long l1 = longBufferRead.read(&buf);
                long long l2 = longBufferRead.read(&buf);
                long long l3 = longBufferRead.read(&buf);
                long long l4 = longBufferRead.read(&buf);
                alignPointer(&wbuf, 4);
                write(&wbuf, l1);
                write(&wbuf, l2);
                write(&wbuf, l3);
                write(&wbuf, l4);
//                LOGI("%s", "TEST_CALL_RENDERING_THREAD_DATA_FLUSH_ARRAY1");
            }
                break;
            case TEST_CALL_RENDERING_THREAD_DATA_FLUSH_ARRAY2:
            {
                BufferRead<long long> longBufferRead;
                alignPointer(&buf, 4);
                long long l1 = longBufferRead.read(&buf);
                long long l2 = longBufferRead.read(&buf);
                long long l3 = longBufferRead.read(&buf);
                long long l4 = longBufferRead.read(&buf);
                alignPointer(&wbuf, 4);
                write(&wbuf, l1);
                write(&wbuf, l2);
                write(&wbuf, l3);
                write(&wbuf, l4);
//                LOGI("%s", "TEST_CALL_RENDERING_THREAD_DATA_FLUSH_ARRAY2");
            }
                break;
            case TEST_CALL_RENDERING_THREAD_DATA_FLUSH_ARRAY3:
            {
                BufferRead<long long> longBufferRead;
                alignPointer(&buf, 4);
                long long l1 = longBufferRead.read(&buf);
                long long l2 = longBufferRead.read(&buf);
                long long l3 = longBufferRead.read(&buf);
                long long l4 = longBufferRead.read(&buf);
                alignPointer(&wbuf, 4);
                write(&wbuf, l1);
                write(&wbuf, l2);
                write(&wbuf, l3);
                write(&wbuf, l4);
//                LOGI("%s", "TEST_CALL_RENDERING_THREAD_DATA_FLUSH_ARRAY3");

            }
                break;
            case TEST_CALL_RENDERING_THREAD_DATA_FLUSH_ARRAY4:
            {
                BufferRead<long long> longBufferRead;
                alignPointer(&buf, 4);
                long long l1 = longBufferRead.read(&buf);
                long long l2 = longBufferRead.read(&buf);
                long long l3 = longBufferRead.read(&buf);
                long long l4 = longBufferRead.read(&buf);
                alignPointer(&wbuf, 4);
                write(&wbuf, l1);
                write(&wbuf, l2);
                write(&wbuf, l3);
                write(&wbuf, l4);
//                LOGI("%s", "TEST_CALL_RENDERING_THREAD_DATA_FLUSH_ARRAY4");
            }
                break;
            case TEST_CALL_RENDERING_THREAD_DATA_FLUSH_INCOMPLETE_RENDER_CHECK_PTR1:
            {

            }
                break;
            case TEST_CALL_RENDERING_THREAD_DATA_FLUSH_INCOMPLETE_RENDER_CHECK_PTR2:
            {

            }
                break;
            case TEST_CALL_RENDERING_THREAD_DATA_FLUSH_INCOMPLETE_RENDER_CHECK_PTR3:
            {

            }
                break;
            case TEST_CALL_RENDERING_THREAD_DATA_FLUSH_INCOMPLETE_RENDER_CHECK_PTR4:
            {

            }
                break;
            case TEST_CALL_RENDERING_THREAD_DATA_FLUSH_INCOMPLETE_RENDER_CHECK_ARRAY1:
            {

            }
                break;
            case TEST_CALL_RENDERING_THREAD_DATA_FLUSH_INCOMPLETE_RENDER_CHECK_ARRAY2:
            {

            }
                break;
            case TEST_CALL_RENDERING_THREAD_DATA_FLUSH_INCOMPLETE_RENDER_CHECK_ARRAY3:
            {

            }
                break;
            case TEST_CALL_RENDERING_THREAD_DATA_FLUSH_INCOMPLETE_RENDER_CHECK_ARRAY4:
            {

            }
                break;

#endif
            default:break;

        }
    }
}

JNIEXPORT void JNICALL
Java_headwayent_hotshotengine_renderer_nativeinterface_pipeline_ENG_1RenderingThread_initializeNative(
        JNIEnv *env, jclass type, jint readingBufferSizeInBytes, jint writingBufferSizeInBytes, jint bufferCount) {

    ::readingBufferSizeInBytes = readingBufferSizeInBytes;
    ::writingBufferSizeInBytes = writingBufferSizeInBytes;
    ::bufferCount = bufferCount;
    byteBufferCls = env->FindClass("java/nio/ByteBuffer");
    limit = env->GetMethodID(byteBufferCls, "limit", "(I)Ljava/nio/Buffer;");

    vector3DCls = env->FindClass("headwayent/hotshotengine/ENG_Vector3D");
    vector3DSet = env->GetMethodID(vector3DCls, "set", "(FFF)V");

    systemCls = env->FindClass("java/lang/System");
    nanoTime = env->GetStaticMethodID(systemCls, "nanoTime", "()J");
}

JNIEXPORT void JNICALL
Java_headwayent_hotshotengine_renderer_nativeinterface_pipeline_ENG_1RenderingThread_renderOneFrame(
        JNIEnv *env, jclass type, jobject readingBuffer, jobject writingBuffer, jint currentBuffer) {

    char *buf = (char*)env->GetDirectBufferAddress(readingBuffer);
    buf += ::readingBufferSizeInBytes * currentBuffer;
    char *wbuf = (char*)env->GetDirectBufferAddress(writingBuffer);
    // We need to clear the response buffer because we might register an end frame listener
    // end the current rendered frame might contain the same frame id that is required by the
    // new frame listener, which will result in the wrong data being read from the response
    // buffer. By resetting the value we make sure that when the frame ends, the response
    // buffer actually contains the data for that respective frame id and not from a previous
    // listener. We don't need to clear the whole buffer since only the first byte is checked.
    // Each frame listener knows for how many bytes to listen to so it doesn't matter that
    // there might be extra bytes with useless values from a previous listener.
    *wbuf = 0;
#ifdef NATIVE_DEBUG
    resetWriteBufferOverflow();
#endif

    Hotshot::GorillaGUI::setCurrentFrameNum(currentBuffer);

    extractMessages(env, buf, wbuf);

//    Ogre::Root::getSingleton().renderOneFrame();

}

JNIEXPORT jint JNICALL
Java_headwayent_hotshotengine_renderer_nativeinterface_classwrappers_ENG_1IdString_createIdString__Ljava_lang_String_2(
        JNIEnv *env, jclass type, jstring s_) {
    const char *s = env->GetStringUTFChars(s_, 0);

    Ogre::IdString str(s);

    env->ReleaseStringUTFChars(s_, s);
    return str.mHash;
}

JNIEXPORT jint JNICALL
Java_headwayent_hotshotengine_renderer_nativeinterface_classwrappers_ENG_1IdString_createIdString__I(
        JNIEnv *env, jclass type, jint val) {

    Ogre::IdString str(val);
    return str.mHash;

}

JNIEXPORT jint JNICALL
Java_headwayent_hotshotengine_renderer_nativeinterface_classwrappers_ENG_1IdString_append__ILjava_lang_String_2(
        JNIEnv *env, jclass type, jint hash, jstring oth_) {
    const char *oth = env->GetStringUTFChars(oth_, 0);

    Ogre::IdString str;
    str.mHash = (Ogre::uint32) hash;
    str += Ogre::IdString(oth);

    env->ReleaseStringUTFChars(oth_, oth);
    return str.mHash;
}

JNIEXPORT jlong JNICALL
Java_headwayent_hotshotengine_renderer_nativeinterface_classwrappers_ENG_1OverlaySystemNativeWrapper_createOverlaySystem(
        JNIEnv *env, jclass type) {

    Ogre::v1::OverlaySystem *overlaySystem = OGRE_NEW Ogre::v1::OverlaySystem();
    return getPointerAsLong(overlaySystem);

}

JNIEXPORT void JNICALL
Java_headwayent_hotshotengine_renderer_nativeinterface_classwrappers_ENG_1OverlaySystemNativeWrapper_destroyOverlaySystem(
        JNIEnv *env, jclass type, jlong ptr) {

    Ogre::v1::OverlaySystem *overlaySystem = (Ogre::v1::OverlaySystem*) getLongAsPointer(ptr);
    OGRE_DELETE overlaySystem;

}

extern "C"
JNIEXPORT jlong JNICALL
Java_headwayent_hotshotengine_renderer_nativeinterface_classwrappers_ENG_1OverlayManagerNativeWrapper_getOverlayManager(
        JNIEnv *env, jclass type) {

    Ogre::v1::OverlayManager &manager = Ogre::v1::OverlayManager::getSingleton();
    return getPointerAsLong(&manager);

}

extern "C"
JNIEXPORT jlong JNICALL
Java_headwayent_hotshotengine_renderer_nativeinterface_classwrappers_ENG_1FontManagerNativeWrapper_getFontManager(
        JNIEnv *env, jclass type) {

    Ogre::FontManager &manager = Ogre::FontManager::getSingleton();
    return getPointerAsLong(&manager);

}

JNIEXPORT void JNICALL
Java_headwayent_blackholedarksun_APP_1Game_setupResources(JNIEnv *env, jclass type, jstring path_, jstring filename_) {
    const char *path = env->GetStringUTFChars(path_, 0);
    const char *filename = env->GetStringUTFChars(filename_, 0);

    const Ogre::String &pathStr = Ogre::String(path);
    const Ogre::String &filenameStr = Ogre::String(filename);
    setupResources(pathStr, filenameStr);

    env->ReleaseStringUTFChars(path_, path);
}

JNIEXPORT jlong JNICALL
Java_headwayent_hotshotengine_renderer_nativeinterface_classwrappers_ENG_1RootNativeWrapper_createRoot(
        JNIEnv *env, jclass type, jstring pluginFileName_, jstring configFileName_,
        jstring logFileName_) {
    const char *pluginFileName = env->GetStringUTFChars(pluginFileName_, 0);
    const char *configFileName = env->GetStringUTFChars(configFileName_, 0);
    const char *logFileName = env->GetStringUTFChars(logFileName_, 0);

    Ogre::String pluginsPath(pluginFileName);
    Ogre::String configPath(configFileName);
    Ogre::String logPath(logFileName);

    Ogre::Root *root = OGRE_NEW Ogre::Root( pluginsPath, configPath, logPath );
#if ((HOTSHOT_PLATFORM == HOTSHOT_PLATFORM_ANDROID) || (HOTSHOT_PLATFORM == HOTSHOT_PLATFORM_WIN32))
    particleFXPlugin = OGRE_NEW Ogre::ParticleFXPlugin();
    root->installPlugin(particleFXPlugin);
#endif

    env->ReleaseStringUTFChars(pluginFileName_, pluginFileName);
    env->ReleaseStringUTFChars(configFileName_, configFileName);
    env->ReleaseStringUTFChars(logFileName_, logFileName);

    return getPointerAsLong(root);
}

JNIEXPORT void JNICALL
Java_headwayent_hotshotengine_renderer_nativeinterface_classwrappers_ENG_1RootNativeWrapper_destroyRoot(
        JNIEnv *env, jclass type, jlong ptr) {

    Ogre::Root *root = (Ogre::Root*) getLongAsPointer(ptr);
#if ((HOTSHOT_PLATFORM == HOTSHOT_PLATFORM_ANDROID) || (HOTSHOT_PLATFORM == HOTSHOT_PLATFORM_WIN32))
    OGRE_DELETE particleFXPlugin;
#endif
    OGRE_DELETE root;

}

JNIEXPORT void JNICALL
Java_headwayent_blackholedarksun_APP_1Game_loadResources__JLjava_lang_String_2(JNIEnv *env,
                                                                               jclass type,
                                                                               jlong rootPtr,
                                                                               jstring path_) {
    const char *path = env->GetStringUTFChars(path_, 0);

    Ogre::String pathStr(path);
    Ogre::Root *root = (Ogre::Root*) getLongAsPointer(rootPtr);
    loadResources(root, pathStr);

    env->ReleaseStringUTFChars(path_, path);
}

JNIEXPORT jlong JNICALL
Java_headwayent_hotshotengine_renderer_nativeinterface_classwrappers_ENG_1SceneManagerNativeWrapper_createSceneManager(
        JNIEnv *env, jclass type, jlong rootPtr, jshort typeMask, jint numThreads, jint threadCullingMethod,
        jstring name_) {
    const char *name = env->GetStringUTFChars(name_, 0);

    Ogre::Root *root = (Ogre::Root*) getLongAsPointer(rootPtr);
    Ogre::String instanceName(name);
    Ogre::SceneManager *sceneManager = root->createSceneManager((Ogre::SceneTypeMask) typeMask, (size_t) numThreads,
                                                                (Ogre::InstancingThreadedCullingMethod) threadCullingMethod, instanceName);

    env->ReleaseStringUTFChars(name_, name);
    
    return getPointerAsLong(sceneManager);
}

JNIEXPORT void JNICALL
Java_headwayent_hotshotengine_renderer_nativeinterface_classwrappers_ENG_1SceneManagerNativeWrapper_destroySceneManager(
        JNIEnv *env, jclass type, jlong rootPtr, jlong ptr) {

    Ogre::Root *root = (Ogre::Root*) getLongAsPointer(rootPtr);
    Ogre::SceneManager *sceneManager = (Ogre::SceneManager*) getLongAsPointer(ptr);

    root->destroySceneManager(sceneManager);
}

JNIEXPORT void JNICALL
Java_headwayent_hotshotengine_renderer_nativeinterface_classwrappers_ENG_1SceneManagerNativeWrapper_addRenderQueueListenerNative(
        JNIEnv *env, jclass type, jlong sceneManagerPtr, jlong renderQueueListener) {

    Ogre::SceneManager *sceneManager = (Ogre::SceneManager*) getLongAsPointer(sceneManagerPtr);
    Ogre::RenderQueueListener *listener = (Ogre::RenderQueueListener*) getLongAsPointer(renderQueueListener);
    sceneManager->addRenderQueueListener(listener);

}

JNIEXPORT void JNICALL
Java_headwayent_hotshotengine_renderer_nativeinterface_classwrappers_ENG_1SceneManagerNativeWrapper_removeRenderQueueListenerNative(
        JNIEnv *env, jclass type, jlong sceneManagerPtr, jlong renderQueueListener) {

    Ogre::SceneManager *sceneManager = (Ogre::SceneManager*) getLongAsPointer(sceneManagerPtr);
    Ogre::RenderQueueListener *listener = (Ogre::RenderQueueListener*) getLongAsPointer(renderQueueListener);
    sceneManager->removeRenderQueueListener(listener);

}

JNIEXPORT void JNICALL
Java_headwayent_hotshotengine_renderer_nativeinterface_classwrappers_ENG_1RootNativeWrapper_initialiseNative(
        JNIEnv *env, jclass type, jlong rootPtr, jboolean autoCreateWindow, jstring windowTitle_,
        jstring customCapabilitiesConfig_) {
    const char *windowTitle = env->GetStringUTFChars(windowTitle_, 0);
    const char *customCapabilitiesConfig = env->GetStringUTFChars(customCapabilitiesConfig_, 0);

    Ogre::Root *root = (Ogre::Root*) getLongAsPointer(rootPtr);
    Ogre::String windowTitleStr(windowTitle);
    Ogre::String customCapabilitiesConfigStr(customCapabilitiesConfig);
    root->initialise(autoCreateWindow, windowTitleStr, customCapabilitiesConfigStr);

    env->ReleaseStringUTFChars(windowTitle_, windowTitle);
    env->ReleaseStringUTFChars(customCapabilitiesConfig_, customCapabilitiesConfig);
}

JNIEXPORT jlong JNICALL
Java_headwayent_hotshotengine_renderer_nativeinterface_classwrappers_ENG_1RootNativeWrapper_getRenderSystemNative(
        JNIEnv *env, jclass type, jlong ptr) {

    Ogre::Root *root = (Ogre::Root*) getLongAsPointer(ptr);
    Ogre::RenderSystem *renderSystem = root->getRenderSystem();
    return getPointerAsLong(renderSystem);

}

JNIEXPORT void JNICALL
Java_headwayent_hotshotengine_renderer_nativeinterface_classwrappers_glsles_GLRenderSystemNativeWrapper_setConfigOptionNative(
        JNIEnv *env, jclass type, jlong ptr, jstring name_, jstring value_) {
    const char *name = env->GetStringUTFChars(name_, 0);
    const char *value = env->GetStringUTFChars(value_, 0);

    Ogre::RenderSystem *renderSystem = (Ogre::RenderSystem*) getLongAsPointer(ptr);
    Ogre::String nameStr(name);
    Ogre::String valueStr(value);
    renderSystem->setConfigOption(nameStr, valueStr);

    env->ReleaseStringUTFChars(name_, name);
    env->ReleaseStringUTFChars(value_, value);
}

JNIEXPORT jlong JNICALL
Java_headwayent_hotshotengine_gorillagui_ENG_1TextureAtlas_loadTexture(JNIEnv *env, jclass type,
                                                                       jstring name_, jstring group_) {
    const char *name = env->GetStringUTFChars(name_, 0);
    const char *group = env->GetStringUTFChars(group_, 0);

    Ogre::TexturePtr texture = Ogre::TextureManager::getSingleton().load(name, group);

    long long int pointerAsLong = getPointerAsLong(texture.get());

    env->ReleaseStringUTFChars(name_, name);
    env->ReleaseStringUTFChars(group_, group);
    
    return pointerAsLong;
}

JNIEXPORT jint JNICALL
Java_headwayent_hotshotengine_gorillagui_ENG_1TextureAtlas_getTextureWidth(JNIEnv *env, jclass type,
                                                                           jlong ptr) {

    const Ogre::Texture* texturePtr = (Ogre::Texture*) getLongAsPointer(ptr);
    return texturePtr->getWidth();

}

JNIEXPORT jint JNICALL
Java_headwayent_hotshotengine_gorillagui_ENG_1TextureAtlas_getTextureHeight(JNIEnv *env,
                                                                            jclass type,
                                                                            jlong ptr) {

    const Ogre::Texture* texturePtr = (Ogre::Texture*) getLongAsPointer(ptr);
    return texturePtr->getHeight();

}

JNIEXPORT jstring JNICALL
Java_headwayent_hotshotengine_gorillagui_ENG_1TextureAtlas_getTextureName(JNIEnv *env, jclass type,
                                                                          jlong ptr) {

    const Ogre::Texture* texturePtr = (Ogre::Texture*) getLongAsPointer(ptr);
    return env->NewStringUTF(texturePtr->getName().c_str());
}

JNIEXPORT jint JNICALL
Java_headwayent_hotshotengine_gorillagui_ENG_1TextureAtlas_createNinePatch(JNIEnv *env, jclass type,
                                                                           jlong ptr,
                                                                           jobject ninePatch) {

    Ogre::Texture* texturePtr = (Ogre::Texture*) getLongAsPointer(ptr);
    return Hotshot::GorillaGUI::createNinePatch(env, texturePtr, ninePatch);

}

JNIEXPORT void JNICALL
Java_headwayent_hotshotengine_gorillagui_ENG_1TextureAtlas_calculateSpriteCoordinates(JNIEnv *env,
                                                                                      jclass type,
                                                                                      jobject s,
                                                                                      jfloat mInverseTextureSizeX,
                                                                                      jfloat mInverseTextureSizeY) {

    Hotshot::Sprite sprite = Hotshot::Sprite::readSprite(env, s);
    Hotshot::GorillaGUI::calculateSpriteCoordinates(sprite, mInverseTextureSizeX, mInverseTextureSizeY);
    Hotshot::Sprite::writeSprite(env, s, sprite);

}

JNIEXPORT void JNICALL
Java_headwayent_hotshotengine_renderer_ENG_1SceneManager_setShadowDirectionalLightExtrusionDistance__JF(
        JNIEnv *env, jclass type, jlong ptr, jfloat distance) {

    Ogre::SceneManager *sceneManager = (Ogre::SceneManager*) getLongAsPointer(ptr);
    sceneManager->setShadowDirectionalLightExtrusionDistance(distance);

}

JNIEXPORT void JNICALL
Java_headwayent_hotshotengine_renderer_ENG_1SceneManager_setShadowFarDistance__JF(JNIEnv *env,
                                                                                  jclass type,
                                                                                  jlong ptr,
                                                                                  jfloat distance) {

    Ogre::SceneManager *sceneManager = (Ogre::SceneManager*) getLongAsPointer(ptr);
    sceneManager->setShadowFarDistance(distance);

}

JNIEXPORT jlong JNICALL
Java_headwayent_hotshotengine_renderer_nativeinterface_classwrappers_ENG_1SceneManagerNativeWrapper_createCamera__JLjava_lang_String_2ZZ(
        JNIEnv *env, jclass type, jlong ptr, jstring name_, jboolean isVisible,
        jboolean forCubemapping) {
    const char *name = env->GetStringUTFChars(name_, 0);

    Ogre::SceneManager *sceneManager = (Ogre::SceneManager*) getLongAsPointer(ptr);
    Ogre::Camera *pCamera = sceneManager->createCamera(name, isVisible, forCubemapping);

    // By default the camera is attached to the root node. But the Ogre root node isn't the same with the java root node.
    // We cannot detach the camera from root node because we can no longer do lookAt further down the road.
//    pCamera->detachFromParent();

    env->ReleaseStringUTFChars(name_, name);
    return getPointerAsLong(pCamera);
}

JNIEXPORT void JNICALL
Java_headwayent_hotshotengine_renderer_nativeinterface_classwrappers_ENG_1CameraNativeWrapper_setPosition(
        JNIEnv *env, jclass type, jlong ptr, jfloat x, jfloat y, jfloat z) {

    Ogre::Camera *camera = (Ogre::Camera*) getLongAsPointer(ptr);
    camera->setPosition(x, y, z);

}

JNIEXPORT void JNICALL
Java_headwayent_hotshotengine_renderer_nativeinterface_classwrappers_ENG_1CameraNativeWrapper_lookAt(
        JNIEnv *env, jclass type, jlong ptr, jfloat x, jfloat y, jfloat z) {

    Ogre::Camera *camera = (Ogre::Camera*) getLongAsPointer(ptr);
    camera->lookAt(x, y, z);

}

JNIEXPORT void JNICALL
Java_headwayent_hotshotengine_renderer_nativeinterface_classwrappers_ENG_1CameraNativeWrapper_setNearClipDistance(
        JNIEnv *env, jclass type, jlong ptr, jfloat dist) {

    Ogre::Camera *camera = (Ogre::Camera*) getLongAsPointer(ptr);
    camera->setNearClipDistance(dist);

}

JNIEXPORT void JNICALL
Java_headwayent_hotshotengine_renderer_nativeinterface_classwrappers_ENG_1CameraNativeWrapper_setFarClipDistance(
        JNIEnv *env, jclass type, jlong ptr, jfloat dist) {

    Ogre::Camera *camera = (Ogre::Camera*) getLongAsPointer(ptr);
    camera->setFarClipDistance(dist);

}

JNIEXPORT void JNICALL
Java_headwayent_hotshotengine_renderer_nativeinterface_classwrappers_ENG_1CameraNativeWrapper_setAutoAspectRatio(
        JNIEnv *env, jclass type, jlong ptr, jboolean aspectRatio) {

    Ogre::Camera *camera = (Ogre::Camera*) getLongAsPointer(ptr);
    camera->setAutoAspectRatio(aspectRatio);

}

JNIEXPORT void JNICALL
Java_headwayent_hotshotengine_renderer_nativeinterface_classwrappers_ENG_1CameraNativeWrapper_setAspectRatio__JF(
        JNIEnv *env, jclass type, jlong ptr, jfloat aspectRatio) {

    Ogre::Camera *camera = (Ogre::Camera*) getLongAsPointer(ptr);
    camera->setAspectRatio(aspectRatio);

}

JNIEXPORT void JNICALL
Java_headwayent_blackholedarksun_APP_1Game_showLoadingScreenNative(JNIEnv *env, jclass type,
                                                                   jlong renderWindowPtr) {

    Ogre::RenderWindow *renderWindow = (Ogre::RenderWindow*) getLongAsPointer(renderWindowPtr);
    Hotshot::LoadingScreen::getSingleton().showLoadingScreen(renderWindow);

}

JNIEXPORT void JNICALL
Java_headwayent_blackholedarksun_APP_1Game_hideLoadingScreenNative(JNIEnv *env, jclass type) {

    Hotshot::LoadingScreen::getSingleton().hideLoadingScreen();

}

JNIEXPORT jobjectArray JNICALL
Java_headwayent_hotshotengine_gorillagui_ENG_1SilverBack_createByteBuffersNative(JNIEnv *env,
                                                                                 jclass type,
                                                                                 jint size,
                                                                                 jint count) {

    return Hotshot::GorillaGUI::createByteBuffers(env, size, count);

}

JNIEXPORT void JNICALL
Java_headwayent_hotshotengine_gorillagui_ENG_1SilverBack_setMaterialName(JNIEnv *env, jclass type,
                                                                         jstring materialName_) {
    const char *materialName = env->GetStringUTFChars(materialName_, 0);
    Ogre::String materialNameStr(materialName);

    Hotshot::ScreenRenderable::setMaterialName(materialNameStr);

    env->ReleaseStringUTFChars(materialName_, materialName);
}

Ogre::CompositorWorkspace *
setupCompositor(const Ogre::Root *root, Ogre::SceneManager *sceneManager,
                Ogre::RenderWindow *renderWindow, Ogre::Camera *camera,
                const Ogre::String &workspaceNameStr, bool enabled) {
    Ogre::CompositorManager2 *compositorManager = root->getCompositorManager2();
    Ogre::CompositorWorkspace *compositorWorkspace = compositorManager->addWorkspace(sceneManager, renderWindow, camera,
                                                                                     workspaceNameStr, enabled );
    return compositorWorkspace;
}

JNIEXPORT jlong JNICALL
Java_headwayent_hotshotengine_renderer_nativeinterface_classwrappers_ENG_1CompositorWorkspaceNativeWrapper_addWorkspace(
        JNIEnv *env, jclass type, jlong rootPtr, jlong sceneManagerPtr, jlong renderWindowPtr, jlong cameraPtr,
        jstring workspaceName_, jboolean enabled) {
    const char *workspaceName = env->GetStringUTFChars(workspaceName_, 0);

    Ogre::Root *root = (Ogre::Root*) getLongAsPointer(rootPtr);
    Ogre::SceneManager *sceneManager = (Ogre::SceneManager*) getLongAsPointer(sceneManagerPtr);
    Ogre::RenderWindow *renderWindow = (Ogre::RenderWindow*) getLongAsPointer(renderWindowPtr);
    Ogre::Camera *camera = (Ogre::Camera*) getLongAsPointer(cameraPtr);
    Ogre::String workspaceNameStr(workspaceName);

    Ogre::CompositorWorkspace *compositorWorkspace = setupCompositor(root, sceneManager,
                                                                     renderWindow, camera,
                                                                     workspaceNameStr, enabled);

    env->ReleaseStringUTFChars(workspaceName_, workspaceName);

    return getPointerAsLong(compositorWorkspace);
}

JNIEXPORT void JNICALL
Java_headwayent_hotshotengine_renderer_ENG_1RenderRoot_renderOneFrameNative(JNIEnv *env,
                                                                            jclass type,
                                                                            jlong rootPtr) {

    Ogre::Root *root = (Ogre::Root*) getLongAsPointer(rootPtr);
    root->renderOneFrame();

}

JNIEXPORT void JNICALL
Java_headwayent_hotshotengine_renderer_nativeinterface_test_TestRenderingThread_testSlowCall1(
        JNIEnv *env, jclass type) {

//    LOGI("%s", "TEST_SLOW_CALL_1");

}

JNIEXPORT jint JNICALL
Java_headwayent_hotshotengine_renderer_nativeinterface_test_TestRenderingThread_testSlowCall2(
        JNIEnv *env, jclass type, jint p) {

//    LOGI("%s", "TEST_SLOW_CALL_2");

    return 1234;

}

JNIEXPORT jlong JNICALL
Java_headwayent_hotshotengine_renderer_nativeinterface_test_TestRenderingThread_testSlowCall3(
        JNIEnv *env, jclass type, jint p, jlong l) {

//    LOGI("%s", "TEST_SLOW_CALL_3");

    return 12345678;

}

JNIEXPORT jboolean JNICALL
Java_headwayent_hotshotengine_renderer_nativeinterface_test_TestRenderingThread_testSlowCall4(
        JNIEnv *env, jclass type, jint p, jbyte b, jboolean boolParam, jshort s) {

//    LOGI("%s", "TEST_SLOW_CALL_4");

    return true;

}

JNIEXPORT jlong JNICALL
Java_headwayent_hotshotengine_renderer_nativeinterface_classwrappers_ENG_1ViewportNativeWrapper_getViewport(
        JNIEnv *env, jclass type, jlong renderWindowPtr) {

    Ogre::RenderWindow *renderWindow = (::Ogre::RenderWindow*) getLongAsPointer(renderWindowPtr);
    Ogre::Viewport *viewport = renderWindow->getViewport(0);
    return getPointerAsLong(viewport);
}

JNIEXPORT void JNICALL
Java_headwayent_blackholedarksun_BlackholeDarksunMain_initJvmData(JNIEnv *env, jobject instance) {

#if (HOTSHOT_PLATFORM == HOTSHOT_PLATFORM_WIN32)
    initJavaVM(env);
#endif

}

JNIEXPORT void JNICALL
Java_headwayent_hotshotengine_android_AndroidRenderWindow_setWindowProc(JNIEnv *env, jclass type,
                                                                        jclass clazz,
                                                                        jobject wndProc) {

    windowsDisplayClass = (jclass) env->NewGlobalRef(clazz);
    javaWindowProc = env->FromReflectedMethod(wndProc);

}

extern "C"
JNIEXPORT void JNICALL
Java_headwayent_blackholedarksun_physics_PhysicsUtility_getAabb__JLjava_lang_String_2Ljava_lang_String_2Lheadwayent_hotshotengine_ENG_1Vector3D_2Lheadwayent_hotshotengine_ENG_1Vector3D_2(
        JNIEnv *env, jclass type, jlong rootPtr, jstring meshName_, jstring groupName_, jobject centre,
        jobject halfSize) {
    const char *meshName = env->GetStringUTFChars(meshName_, 0);
    const char *groupName = env->GetStringUTFChars(groupName_, 0);

    Ogre::Root *root = (Ogre::Root*) getLongAsPointer(rootPtr);
    Ogre::String groupNameOgre = Ogre::ResourceGroupManager::AUTODETECT_RESOURCE_GROUP_NAME;
    const Ogre::MeshPtr &ptr = Ogre::MeshManager::getSingleton().load(meshName, groupNameOgre);
    const Ogre::Aabb &aabb = ptr->getAabb();

    env->CallVoidMethod(centre, vector3DSet, aabb.mCenter.x, aabb.mCenter.y, aabb.mCenter.z);
    env->CallVoidMethod(halfSize, vector3DSet, aabb.mHalfSize.x, aabb.mHalfSize.y, aabb.mHalfSize.z);

    env->ReleaseStringUTFChars(meshName_, meshName);
    env->ReleaseStringUTFChars(groupName_, groupName);
}

extern "C"
JNIEXPORT void JNICALL
Java_headwayent_hotshotengine_renderer_nativeinterface_classwrappers_ENG_1CompositorWorkspaceNativeWrapper_removeWorkspace(
        JNIEnv *env, jclass type, jlong rootPtr, jlong workspacePtr) {

    Ogre::Root *root = (Ogre::Root*) getLongAsPointer(rootPtr);
    Ogre::CompositorWorkspace* compositorWorkspace = (Ogre::CompositorWorkspace*) workspacePtr;
    root->getCompositorManager2()->removeWorkspace(compositorWorkspace);

}

extern "C"
JNIEXPORT void JNICALL
Java_headwayent_blackholedarksunonline_desktop_DesktopLauncher_test(JNIEnv *env, jclass type) {

    LOGI("hi!\n");
//    std::cout << "hi!";
//    printf("hi there!");
//    fflush(stdout);

}

extern "C"
JNIEXPORT void JNICALL
Java_headwayent_hotshotengine_gorillagui_ENG_1SilverBack_createDummyNode(JNIEnv *env, jclass type) {

    Hotshot::GorillaGUI::createDummyNode();

}

extern "C"
JNIEXPORT void JNICALL
Java_headwayent_hotshotengine_gorillagui_ENG_1SilverBack_destroyDummyNode(JNIEnv *env,
                                                                          jclass type) {

    Hotshot::GorillaGUI::destroyDummyNode();

}

extern "C"
JNIEXPORT jlong JNICALL
Java_headwayent_hotshotengine_renderer_ENG_1SceneManager_getRootSceneNode__JB(JNIEnv *env,
                                                                              jclass type,
                                                                              jlong ptr,
                                                                              jbyte sceneNodeType) {

    Ogre::SceneManager *sceneManager = (::Ogre::SceneManager*) ptr;
    Ogre::SceneNode *rootSceneNode = sceneManager->getRootSceneNode((Ogre::SceneMemoryMgrTypes) sceneNodeType);
    return getPointerAsLong(rootSceneNode);
}

extern "C"
JNIEXPORT void JNICALL
Java_headwayent_hotshotengine_renderer_ENG_1SceneManager_setV1FastRenderQueue__JB(JNIEnv *env,
                                                                                  jclass type,
                                                                                  jlong ptr,
                                                                                  jbyte v1FastRenderQueue) {

    Ogre::SceneManager *sceneManager = (::Ogre::SceneManager*) ptr;
    sceneManager->getRenderQueue()->setRenderQueueMode(v1FastRenderQueue, Ogre::RenderQueue::V1_FAST);
}

extern "C"
JNIEXPORT jlong JNICALL
Java_headwayent_hotshotengine_renderer_nativeinterface_classwrappers_ENG_1SceneCompositorWrapper_createSceneCompositor(
        JNIEnv *env, jclass type) {

    Hotshot::SceneCompositor *sceneCompositor = new Hotshot::SceneCompositor();
    return getPointerAsLong(sceneCompositor);

}

extern "C"
JNIEXPORT void JNICALL
Java_headwayent_hotshotengine_renderer_nativeinterface_classwrappers_ENG_1SceneCompositorWrapper_destroySceneCompositor(
        JNIEnv *env, jclass type, jlong ptr) {

    Hotshot::SceneCompositor *sceneCompositor = (Hotshot::SceneCompositor*) ptr;
    delete sceneCompositor;

}