package headwayent.blackholedarksun.levelresource;

import headwayent.blackholedarksun.levelresource.LevelEndCond.EndCond;

import java.util.ArrayList;
import java.util.HashMap;

public class LevelEvent {

    public enum DelayType {
        SECS, MSECS;

        public static DelayType getDelayType(String type) {
            if (SECS.toString().equalsIgnoreCase(type)) {
                return SECS;
            }
            if (MSECS.toString().equalsIgnoreCase(type) || "ms".equalsIgnoreCase(type)) {
                return MSECS;
            }
            throw new IllegalArgumentException(type + " is an invalid delay type");
        }
    }

    public enum EventState {
        NONE, STARTABLE, STARTED, WON, LOST, CONNECTION_LOST
    }

    public String name;
    public final ArrayList<String> prevCondList = new ArrayList<>();
    public final ComparatorNode prevCondEndRoot = new ComparatorNode();
    public int delay;
    public DelayType delayType;
    public final ArrayList<LevelObject> spawn = new ArrayList<>();
    public final ArrayList<String> exitObjects = new ArrayList<>();
    public LevelEndCond endCond;

    // For use in World Manager
    public EventState state = EventState.NONE;
    /*	public boolean eventWon, eventLost;
        public boolean eventCompleted;
        public boolean eventStarted;
        public boolean eventStartable;*/
    public long currentStartingTime;
    public final HashMap<String, EndCond> winEndCondList = new HashMap<>();
    public final HashMap<String, EndCond> lossEndCondList = new HashMap<>();
//	public ArrayList<Entity> exitEntities = new ArrayList<Entity>();
}
