package com.javafx.experiments.utils3d;

import headwayent.hotshotengine.*;
import javafx.scene.PerspectiveCamera;
import javafx.scene.transform.Affine;

public class Utility {

    /*
     * returns 3D direction from the Camera position to the mouse
     * in the Scene space
     */

    public static ENG_Vector3D unProjectDirection(PerspectiveCamera camera,
                                                  ENG_Quaternion cameraOrientation,
                                                  double sceneX, double sceneY,
                                                  double sWidth, double sHeight) {
        double tanOfHalfFOV = Math.tan(Math.toRadians(camera.getFieldOfView()) * 0.5f);
        ENG_Vector3D vMouse = new ENG_Vector3D(tanOfHalfFOV * (2 * sceneX / sWidth - 1),
                tanOfHalfFOV * (2 * sceneY / sWidth - sHeight / sWidth), 0);
//        ENG_Vector4D vMouse4D = new ENG_Vector4D(vMouse.x, vMouse.y, vMouse.z, 1.0f);
        System.out.println("vMouse before orientation: " + vMouse);
        vMouse = cameraOrientation.mul(vMouse);
        System.out.println("vMouse after orientation: " + vMouse);
//        vMouse4D = cameraOrientation.mul(vMouse4D);
//        System.out.println("vMouse4D after orientation: " + vMouse4D);
        return vMouse;
    }

    public static void setAffine(ENG_Matrix4 trans, Affine transform) {
        transform.setMxx(trans.get(0, 0));
        transform.setMxy(trans.get(0, 1));
        transform.setMxz(trans.get(0, 2));
        transform.setTx(trans.get(0, 3));
        transform.setMyx(trans.get(1, 0));
        transform.setMyy(trans.get(1, 1));
        transform.setMyz(trans.get(1, 2));
        transform.setTy(trans.get(1, 3));
        transform.setMzx(trans.get(2, 0));
        transform.setMzy(trans.get(2, 1));
        transform.setMzz(trans.get(2, 2));
        transform.setTz(trans.get(2, 3));
    }

    public static float randomPointOnAxis(double min, double max) {
        return ENG_Utility.rangeRandom(null, (float) min, (float) max);
    }
}
