/*
 * Decompiled with CFR 0.152.
 */
package com.badlogic.gdx.sqlite.desktop;

import com.badlogic.gdx.Gdx;
import com.badlogic.gdx.sql.Database;
import com.badlogic.gdx.sql.DatabaseCursor;
import com.badlogic.gdx.sql.DatabaseManager;
import com.badlogic.gdx.sql.SQLiteGdxException;
import com.badlogic.gdx.sqlite.desktop.DesktopCursor;
import com.badlogic.gdx.sqlite.desktop.SQLiteDatabaseHelper;
import com.badlogic.gdx.utils.GdxRuntimeException;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;

public class DesktopDatabaseManager
implements DatabaseManager {
    public Database getNewDatabase(String dbName, int dbVersion, String dbOnCreateQuery, String dbOnUpgradeQuery) {
        return new DesktopDatabase(dbName, dbVersion, dbOnCreateQuery, dbOnUpgradeQuery);
    }

    private class DesktopDatabase
    implements Database {
        private SQLiteDatabaseHelper helper = null;
        private final String dbName;
        private final int dbVersion;
        private final String dbOnCreateQuery;
        private final String dbOnUpgradeQuery;
        private Connection connection = null;
        private Statement stmt = null;

        private DesktopDatabase(String dbName, int dbVersion, String dbOnCreateQuery, String dbOnUpgradeQuery) {
            this.dbName = dbName;
            this.dbVersion = dbVersion;
            this.dbOnCreateQuery = dbOnCreateQuery;
            this.dbOnUpgradeQuery = dbOnUpgradeQuery;
        }

        public void setupDatabase() {
            try {
                Class.forName("org.sqlite.JDBC");
            }
            catch (ClassNotFoundException e) {
                Gdx.app.log("DATABASE", "Unable to load the SQLite JDBC driver. There might be a problem with your build path or project setup.", (Exception)e);
                throw new GdxRuntimeException((Throwable)e);
            }
        }

        public void openOrCreateDatabase() throws SQLiteGdxException {
            if (this.helper == null) {
                this.helper = new SQLiteDatabaseHelper(this.dbName, this.dbVersion, this.dbOnCreateQuery, this.dbOnUpgradeQuery);
            }
            try {
                this.connection = DriverManager.getConnection("jdbc:sqlite:" + this.dbName);
                this.stmt = this.connection.createStatement();
                this.helper.onCreate(this.stmt);
            }
            catch (SQLException e) {
                throw new SQLiteGdxException((Throwable)e);
            }
        }

        public void closeDatabase() throws SQLiteGdxException {
            try {
                this.stmt.close();
                this.connection.close();
            }
            catch (SQLException e) {
                throw new SQLiteGdxException((Throwable)e);
            }
        }

        public void execSQL(String sql) throws SQLiteGdxException {
            try {
                this.stmt.executeUpdate(sql);
            }
            catch (SQLException e) {
                throw new SQLiteGdxException((Throwable)e);
            }
        }

        public DatabaseCursor rawQuery(String sql) throws SQLiteGdxException {
            DesktopCursor lCursor = new DesktopCursor();
            try {
                ResultSet resultSetRef = this.stmt.executeQuery(sql);
                lCursor.setNativeCursor(resultSetRef);
                return lCursor;
            }
            catch (SQLException e) {
                throw new SQLiteGdxException((Throwable)e);
            }
        }

        public DatabaseCursor rawQuery(DatabaseCursor cursor, String sql) throws SQLiteGdxException {
            DesktopCursor lCursor = (DesktopCursor)cursor;
            try {
                ResultSet resultSetRef = this.stmt.executeQuery(sql);
                lCursor.setNativeCursor(resultSetRef);
                return lCursor;
            }
            catch (SQLException e) {
                throw new SQLiteGdxException((Throwable)e);
            }
        }
    }
}

