/*
 * Decompiled with CFR 0.152.
 */
package com.badlogic.gdx.sqlite.desktop;

import com.badlogic.gdx.Gdx;
import com.badlogic.gdx.sql.DatabaseCursor;
import com.badlogic.gdx.sql.SQLiteGdxRuntimeException;
import java.sql.Blob;
import java.sql.ResultSet;
import java.sql.SQLException;

public class DesktopCursor
implements DatabaseCursor {
    private ResultSet resultSet = null;

    public byte[] getBlob(int columnIndex) {
        try {
            Blob blob = this.resultSet.getBlob(columnIndex + 1);
            return blob.getBytes(1L, (int)blob.length());
        }
        catch (SQLException e) {
            Gdx.app.log("DATABASE", "There was an error in getting the blob", (Exception)e);
            throw new SQLiteGdxRuntimeException((Throwable)e);
        }
    }

    public double getDouble(int columnIndex) {
        try {
            return this.resultSet.getDouble(columnIndex + 1);
        }
        catch (SQLException e) {
            Gdx.app.log("DATABASE", "There was an error in getting the double", (Exception)e);
            throw new SQLiteGdxRuntimeException((Throwable)e);
        }
    }

    public float getFloat(int columnIndex) {
        try {
            return this.resultSet.getFloat(columnIndex + 1);
        }
        catch (SQLException e) {
            Gdx.app.log("DATABASE", "There was an error in getting the float", (Exception)e);
            throw new SQLiteGdxRuntimeException((Throwable)e);
        }
    }

    public int getInt(int columnIndex) {
        try {
            return this.resultSet.getInt(columnIndex + 1);
        }
        catch (SQLException e) {
            Gdx.app.log("DATABASE", "There was an error in getting the int", (Exception)e);
            throw new SQLiteGdxRuntimeException((Throwable)e);
        }
    }

    public long getLong(int columnIndex) {
        try {
            return this.resultSet.getLong(columnIndex + 1);
        }
        catch (SQLException e) {
            Gdx.app.log("DATABASE", "There was an error in getting the long", (Exception)e);
            throw new SQLiteGdxRuntimeException((Throwable)e);
        }
    }

    public short getShort(int columnIndex) {
        try {
            return this.resultSet.getShort(columnIndex + 1);
        }
        catch (SQLException e) {
            Gdx.app.log("DATABASE", "There was an error in getting the short", (Exception)e);
            throw new SQLiteGdxRuntimeException((Throwable)e);
        }
    }

    public String getString(int columnIndex) {
        try {
            return this.resultSet.getString(columnIndex + 1);
        }
        catch (SQLException e) {
            Gdx.app.log("DATABASE", "There was an error in getting the string", (Exception)e);
            throw new SQLiteGdxRuntimeException((Throwable)e);
        }
    }

    public boolean next() {
        try {
            return this.resultSet.next();
        }
        catch (SQLException e) {
            Gdx.app.log("DATABASE", "There was an error in moving the cursor to next", (Exception)e);
            throw new SQLiteGdxRuntimeException((Throwable)e);
        }
    }

    public int getCount() {
        return this.getRowCount(this.resultSet);
    }

    public void close() {
        try {
            this.resultSet.close();
        }
        catch (SQLException e) {
            Gdx.app.log("DATABASE", "There was an error in closing the cursor", (Exception)e);
            throw new SQLiteGdxRuntimeException((Throwable)e);
        }
    }

    private int getRowCount(ResultSet resultSet) {
        if (resultSet == null) {
            return 0;
        }
        try {
            resultSet.last();
            int n = resultSet.getRow();
            return n;
        }
        catch (SQLException e) {
            throw new SQLiteGdxRuntimeException((Throwable)e);
        }
        finally {
            try {
                resultSet.beforeFirst();
            }
            catch (SQLException e) {
                Gdx.app.log("DATABASE", "There was an error counting the number of results", (Exception)e);
            }
        }
    }

    public void setNativeCursor(ResultSet resultSetRef) {
        this.resultSet = resultSetRef;
    }
}

