/*
 * Decompiled with CFR 0.152.
 */
package com.badlogic.gdx.backends.iosrobovm;

import com.badlogic.gdx.Gdx;
import com.badlogic.gdx.Input;
import com.badlogic.gdx.InputProcessor;
import com.badlogic.gdx.backends.iosrobovm.IOSApplication;
import com.badlogic.gdx.backends.iosrobovm.IOSApplicationConfiguration;
import com.badlogic.gdx.backends.iosrobovm.custom.UIAcceleration;
import com.badlogic.gdx.backends.iosrobovm.custom.UIAccelerometer;
import com.badlogic.gdx.backends.iosrobovm.custom.UIAccelerometerDelegate;
import com.badlogic.gdx.backends.iosrobovm.custom.UIAccelerometerDelegateAdapter;
import com.badlogic.gdx.utils.Array;
import com.badlogic.gdx.utils.GdxRuntimeException;
import com.badlogic.gdx.utils.Pool;
import java.lang.reflect.Field;
import java.util.Iterator;
import org.robovm.apple.audiotoolbox.AudioServices;
import org.robovm.apple.coregraphics.CGPoint;
import org.robovm.apple.coregraphics.CGRect;
import org.robovm.apple.foundation.NSExtensions;
import org.robovm.apple.foundation.NSObject;
import org.robovm.apple.foundation.NSRange;
import org.robovm.apple.uikit.UIAlertView;
import org.robovm.apple.uikit.UIAlertViewDelegate;
import org.robovm.apple.uikit.UIAlertViewDelegateAdapter;
import org.robovm.apple.uikit.UIAlertViewStyle;
import org.robovm.apple.uikit.UIDevice;
import org.robovm.apple.uikit.UIKeyboardType;
import org.robovm.apple.uikit.UIReturnKeyType;
import org.robovm.apple.uikit.UITextAutocapitalizationType;
import org.robovm.apple.uikit.UITextAutocorrectionType;
import org.robovm.apple.uikit.UITextField;
import org.robovm.apple.uikit.UITextFieldDelegate;
import org.robovm.apple.uikit.UITextFieldDelegateAdapter;
import org.robovm.apple.uikit.UITextSpellCheckingType;
import org.robovm.apple.uikit.UITouch;
import org.robovm.apple.uikit.UITouchPhase;
import org.robovm.apple.uikit.UIView;
import org.robovm.objc.annotation.Method;
import org.robovm.rt.VM;
import org.robovm.rt.bro.NativeObject;
import org.robovm.rt.bro.annotation.MachineSizedUInt;
import org.robovm.rt.bro.annotation.Pointer;

public class IOSInput
implements Input {
    static final int MAX_TOUCHES = 20;
    private static final int POINTER_NOT_FOUND = -1;
    private static final NSObjectWrapper<UITouch> UI_TOUCH_WRAPPER = new NSObjectWrapper<UITouch>(UITouch.class);
    static final NSObjectWrapper<UIAcceleration> UI_ACCELERATION_WRAPPER = new NSObjectWrapper<UIAcceleration>(UIAcceleration.class);
    IOSApplication app;
    IOSApplicationConfiguration config;
    int[] deltaX = new int[20];
    int[] deltaY = new int[20];
    int[] touchX = new int[20];
    int[] touchY = new int[20];
    long[] touchDown = new long[20];
    int numTouched = 0;
    boolean justTouched = false;
    Pool<TouchEvent> touchEventPool = new Pool<TouchEvent>(){

        protected TouchEvent newObject() {
            return new TouchEvent();
        }
    };
    Array<TouchEvent> touchEvents = new Array();
    TouchEvent currentEvent = null;
    float[] acceleration = new float[3];
    float[] rotation = new float[3];
    float[] R = new float[9];
    InputProcessor inputProcessor = null;
    boolean hasVibrator;
    protected UIAccelerometerDelegate accelerometerDelegate;
    boolean compassSupported;
    boolean keyboardCloseOnReturn;
    private UITextField textfield = null;
    private final UITextFieldDelegate textDelegate = new UITextFieldDelegateAdapter(){

        public boolean shouldChangeCharacters(UITextField textField, NSRange range, String string) {
            int i = 0;
            while ((long)i < range.getLength()) {
                IOSInput.this.app.input.inputProcessor.keyTyped('\b');
                ++i;
            }
            if (string.isEmpty()) {
                if (range.getLength() > 0L) {
                    Gdx.graphics.requestRendering();
                }
                return false;
            }
            char[] chars = new char[string.length()];
            string.getChars(0, string.length(), chars, 0);
            for (int i2 = 0; i2 < chars.length; ++i2) {
                IOSInput.this.app.input.inputProcessor.keyTyped(chars[i2]);
            }
            Gdx.graphics.requestRendering();
            return true;
        }

        public boolean shouldEndEditing(UITextField textField) {
            textField.setText("x");
            Gdx.graphics.requestRendering();
            return true;
        }

        public boolean shouldReturn(UITextField textField) {
            if (IOSInput.this.keyboardCloseOnReturn) {
                IOSInput.this.setOnscreenKeyboardVisible(false);
            }
            IOSInput.this.app.input.inputProcessor.keyDown(66);
            IOSInput.this.app.input.inputProcessor.keyTyped('\r');
            Gdx.graphics.requestRendering();
            return false;
        }
    };
    UIAlertViewDelegate delegate;

    public IOSInput(IOSApplication app) {
        this.app = app;
        this.config = app.config;
        this.keyboardCloseOnReturn = app.config.keyboardCloseOnReturn;
    }

    void setupPeripherals() {
        this.setupAccelerometer();
        this.setupCompass();
        UIDevice device = UIDevice.getCurrentDevice();
        if (device.getModel().equalsIgnoreCase("iphone")) {
            this.hasVibrator = true;
        }
    }

    protected void setupCompass() {
        if (this.config.useCompass) {
            // empty if block
        }
    }

    protected void setupAccelerometer() {
        if (this.config.useAccelerometer) {
            this.accelerometerDelegate = new UIAccelerometerDelegateAdapter(){

                @Method(selector="accelerometer:didAccelerate:")
                public void didAccelerate(UIAccelerometer accelerometer, @Pointer long valuesPtr) {
                    UIAcceleration values = UI_ACCELERATION_WRAPPER.wrap(valuesPtr);
                    float x = (float)values.getX() * 10.0f;
                    float y = (float)values.getY() * 10.0f;
                    float z = (float)values.getZ() * 10.0f;
                    IOSInput.this.acceleration[0] = -x;
                    IOSInput.this.acceleration[1] = -y;
                    IOSInput.this.acceleration[2] = -z;
                }
            };
            UIAccelerometer.getSharedAccelerometer().setDelegate(this.accelerometerDelegate);
            UIAccelerometer.getSharedAccelerometer().setUpdateInterval(this.config.accelerometerUpdate);
        }
    }

    public float getAccelerometerX() {
        return this.acceleration[0];
    }

    public float getAccelerometerY() {
        return this.acceleration[1];
    }

    public float getAccelerometerZ() {
        return this.acceleration[2];
    }

    public float getAzimuth() {
        if (!this.compassSupported) {
            return 0.0f;
        }
        return this.rotation[0];
    }

    public float getPitch() {
        if (!this.compassSupported) {
            return 0.0f;
        }
        return this.rotation[1];
    }

    public float getRoll() {
        if (!this.compassSupported) {
            return 0.0f;
        }
        return this.rotation[2];
    }

    public void getRotationMatrix(float[] matrix) {
        if (matrix.length != 9) {
            return;
        }
    }

    public int getX() {
        return this.touchX[0];
    }

    public int getX(int pointer) {
        return this.touchX[pointer];
    }

    public int getDeltaX() {
        return this.deltaX[0];
    }

    public int getDeltaX(int pointer) {
        return this.deltaX[pointer];
    }

    public int getY() {
        return this.touchY[0];
    }

    public int getY(int pointer) {
        return this.touchY[pointer];
    }

    public int getDeltaY() {
        return this.deltaY[0];
    }

    public int getDeltaY(int pointer) {
        return this.deltaY[pointer];
    }

    public boolean isTouched() {
        for (int pointer = 0; pointer < 20; ++pointer) {
            if (this.touchDown[pointer] == 0L) continue;
            return true;
        }
        return false;
    }

    public boolean justTouched() {
        return this.justTouched;
    }

    public boolean isTouched(int pointer) {
        return this.touchDown[pointer] != 0L;
    }

    public boolean isButtonPressed(int button) {
        return button == 0 && this.numTouched > 0;
    }

    public boolean isKeyPressed(int key) {
        return false;
    }

    public boolean isKeyJustPressed(int key) {
        return false;
    }

    public void getTextInput(Input.TextInputListener listener, String title, String text, String hint) {
        this.buildUIAlertView(listener, title, text, hint).show();
    }

    public void setOnscreenKeyboardVisible(boolean visible) {
        if (this.textfield == null) {
            this.createDefaultTextField();
        }
        if (visible) {
            this.textfield.becomeFirstResponder();
            this.textfield.setDelegate(this.textDelegate);
        } else {
            this.textfield.resignFirstResponder();
        }
    }

    public void setKeyboardCloseOnReturnKey(boolean shouldClose) {
        this.keyboardCloseOnReturn = shouldClose;
    }

    public UITextField getKeyboardTextField() {
        if (this.textfield == null) {
            this.createDefaultTextField();
        }
        return this.textfield;
    }

    private void createDefaultTextField() {
        this.textfield = new UITextField(new CGRect(10.0, 10.0, 100.0, 50.0));
        this.textfield.setKeyboardType(UIKeyboardType.Default);
        this.textfield.setReturnKeyType(UIReturnKeyType.Done);
        this.textfield.setAutocapitalizationType(UITextAutocapitalizationType.None);
        this.textfield.setAutocorrectionType(UITextAutocorrectionType.No);
        this.textfield.setSpellCheckingType(UITextSpellCheckingType.No);
        this.textfield.setHidden(true);
        this.textfield.setText("x");
        this.app.getUIViewController().getView().addSubview((UIView)this.textfield);
    }

    private UIAlertView buildUIAlertView(final Input.TextInputListener listener, String title, String text, String placeholder) {
        this.delegate = new UIAlertViewDelegateAdapter(){

            public void clicked(UIAlertView view, long clicked) {
                if (clicked == 0L) {
                    listener.canceled();
                } else if (clicked == 1L) {
                    UITextField textField = view.getTextField(0L);
                    listener.input(textField.getText());
                }
                IOSInput.this.delegate = null;
            }

            public void cancel(UIAlertView view) {
                listener.canceled();
                IOSInput.this.delegate = null;
            }
        };
        UIAlertView uiAlertView = new UIAlertView();
        uiAlertView.setTitle(title);
        uiAlertView.addButton("Cancel");
        uiAlertView.addButton("Ok");
        uiAlertView.setAlertViewStyle(UIAlertViewStyle.PlainTextInput);
        uiAlertView.setDelegate(this.delegate);
        UITextField textField = uiAlertView.getTextField(0L);
        textField.setPlaceholder(placeholder);
        textField.setText(text);
        return uiAlertView;
    }

    public void vibrate(int milliseconds) {
        AudioServices.playSystemSound((int)4095);
    }

    public void vibrate(long[] pattern, int repeat) {
    }

    public void cancelVibrate() {
    }

    public long getCurrentEventTime() {
        return this.currentEvent.timestamp;
    }

    public void setCatchBackKey(boolean catchBack) {
    }

    public boolean isCatchBackKey() {
        return false;
    }

    public void setCatchMenuKey(boolean catchMenu) {
    }

    public boolean isCatchMenuKey() {
        return false;
    }

    public void setInputProcessor(InputProcessor processor) {
        this.inputProcessor = processor;
    }

    public InputProcessor getInputProcessor() {
        return this.inputProcessor;
    }

    public boolean isPeripheralAvailable(Input.Peripheral peripheral) {
        if (peripheral == Input.Peripheral.Accelerometer && this.config.useAccelerometer) {
            return true;
        }
        if (peripheral == Input.Peripheral.MultitouchScreen) {
            return true;
        }
        if (peripheral == Input.Peripheral.Vibrator) {
            return this.hasVibrator;
        }
        if (peripheral == Input.Peripheral.Compass) {
            return this.compassSupported;
        }
        return false;
    }

    public int getRotation() {
        switch (this.app.uiApp.getStatusBarOrientation()) {
            case LandscapeLeft: {
                return 270;
            }
            case PortraitUpsideDown: {
                return 180;
            }
            case LandscapeRight: {
                return 90;
            }
        }
        return 0;
    }

    public Input.Orientation getNativeOrientation() {
        switch (this.app.uiApp.getStatusBarOrientation()) {
            case LandscapeLeft: 
            case LandscapeRight: {
                return Input.Orientation.Landscape;
            }
        }
        return Input.Orientation.Portrait;
    }

    public void setCursorCatched(boolean catched) {
    }

    public boolean isCursorCatched() {
        return false;
    }

    public void setCursorPosition(int x, int y) {
    }

    protected void onTouch(long touches) {
        this.toTouchEvents(touches);
        Gdx.graphics.requestRendering();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void processEvents() {
        Array<TouchEvent> array = this.touchEvents;
        synchronized (array) {
            this.justTouched = false;
            Iterator iterator = this.touchEvents.iterator();
            while (iterator.hasNext()) {
                TouchEvent event;
                this.currentEvent = event = (TouchEvent)iterator.next();
                switch (event.phase) {
                    case Began: {
                        if (this.inputProcessor != null) {
                            this.inputProcessor.touchDown(event.x, event.y, event.pointer, 0);
                        }
                        if (this.numTouched < 1) break;
                        this.justTouched = true;
                        break;
                    }
                    case Cancelled: 
                    case Ended: {
                        if (this.inputProcessor == null) break;
                        this.inputProcessor.touchUp(event.x, event.y, event.pointer, 0);
                        break;
                    }
                    case Moved: 
                    case Stationary: {
                        if (this.inputProcessor == null) break;
                        this.inputProcessor.touchDragged(event.x, event.y, event.pointer);
                    }
                }
            }
            this.touchEventPool.freeAll(this.touchEvents);
            this.touchEvents.clear();
        }
    }

    private int getFreePointer() {
        for (int i = 0; i < this.touchDown.length; ++i) {
            if (this.touchDown[i] != 0L) continue;
            return i;
        }
        throw new GdxRuntimeException("Couldn't find free pointer id!");
    }

    private int findPointer(UITouch touch) {
        long ptr = touch.getHandle();
        for (int i = 0; i < this.touchDown.length; ++i) {
            if (this.touchDown[i] != ptr) continue;
            return i;
        }
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < this.touchDown.length; ++i) {
            sb.append(i + ":" + this.touchDown[i] + " ");
        }
        Gdx.app.error("IOSInput", "Pointer ID lookup failed: " + ptr + ", " + sb.toString());
        return -1;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void toTouchEvents(long touches) {
        long array = NSSetExtensions.allObjects(touches);
        int length = (int)NSArrayExtensions.count(array);
        for (int i = 0; i < length; ++i) {
            long touchHandle = NSArrayExtensions.objectAtIndex$(array, i);
            UITouch touch = UI_TOUCH_WRAPPER.wrap(touchHandle);
            CGPoint loc = touch.getLocationInView((UIView)touch.getWindow());
            CGRect bounds = this.app.getCachedBounds();
            int locX = (int)(loc.getX() * (double)this.app.displayScaleFactor - bounds.getMinX());
            int locY = (int)(loc.getY() * (double)this.app.displayScaleFactor - bounds.getMinY());
            Array<TouchEvent> array2 = this.touchEvents;
            synchronized (array2) {
                UITouchPhase phase = touch.getPhase();
                TouchEvent event = (TouchEvent)this.touchEventPool.obtain();
                event.x = locX;
                event.y = locY;
                event.phase = phase;
                event.timestamp = (long)(touch.getTimestamp() * 1.0E9);
                if (phase == UITouchPhase.Began) {
                    event.pointer = this.getFreePointer();
                    this.touchDown[event.pointer] = touch.getHandle();
                    this.touchX[event.pointer] = event.x;
                    this.touchY[event.pointer] = event.y;
                    this.deltaX[event.pointer] = 0;
                    this.deltaY[event.pointer] = 0;
                    ++this.numTouched;
                } else if (phase == UITouchPhase.Moved || phase == UITouchPhase.Stationary) {
                    event.pointer = this.findPointer(touch);
                    if (event.pointer != -1) {
                        this.deltaX[event.pointer] = event.x - this.touchX[event.pointer];
                        this.deltaY[event.pointer] = event.y - this.touchY[event.pointer];
                        this.touchX[event.pointer] = event.x;
                        this.touchY[event.pointer] = event.y;
                    }
                } else if (phase == UITouchPhase.Cancelled || phase == UITouchPhase.Ended) {
                    event.pointer = this.findPointer(touch);
                    if (event.pointer != -1) {
                        this.touchDown[event.pointer] = 0L;
                        this.touchX[event.pointer] = event.x;
                        this.touchY[event.pointer] = event.y;
                        this.deltaX[event.pointer] = 0;
                        this.deltaY[event.pointer] = 0;
                        --this.numTouched;
                    }
                }
                if (event.pointer != -1) {
                    this.touchEvents.add((Object)event);
                } else {
                    this.touchEventPool.free((Object)event);
                }
                continue;
            }
        }
    }

    public float getGyroscopeX() {
        return 0.0f;
    }

    public float getGyroscopeY() {
        return 0.0f;
    }

    public float getGyroscopeZ() {
        return 0.0f;
    }

    static class TouchEvent {
        UITouchPhase phase;
        long timestamp;
        int x;
        int y;
        int pointer;

        TouchEvent() {
        }
    }

    private static class NSArrayExtensions
    extends NSExtensions {
        private NSArrayExtensions() {
        }

        @Method(selector="objectAtIndex:")
        @Pointer
        public static native long objectAtIndex$(@Pointer long var0, @MachineSizedUInt long var2);

        @Method(selector="count")
        @MachineSizedUInt
        public static native long count(@Pointer long var0);
    }

    private static class NSSetExtensions
    extends NSExtensions {
        private NSSetExtensions() {
        }

        @Method(selector="allObjects")
        @Pointer
        public static native long allObjects(@Pointer long var0);
    }

    private class HiddenTextField
    extends UITextField {
        public HiddenTextField(CGRect frame) {
            super(frame);
            this.setKeyboardType(UIKeyboardType.Default);
            this.setReturnKeyType(UIReturnKeyType.Done);
            this.setAutocapitalizationType(UITextAutocapitalizationType.None);
            this.setAutocorrectionType(UITextAutocorrectionType.No);
            this.setSpellCheckingType(UITextSpellCheckingType.No);
            this.setHidden(true);
        }

        public void deleteBackward() {
            IOSInput.this.app.input.inputProcessor.keyTyped('\b');
            super.deleteBackward();
            Gdx.graphics.requestRendering();
        }
    }

    private static class NSObjectWrapper<T extends NSObject> {
        private static final long HANDLE_OFFSET;
        private final T instance;

        public NSObjectWrapper(Class<T> cls) {
            this.instance = (NSObject)VM.allocateObject(cls);
        }

        public T wrap(long handle) {
            VM.setLong((long)(VM.getObjectAddress(this.instance) + HANDLE_OFFSET), (long)handle);
            return this.instance;
        }

        static {
            try {
                HANDLE_OFFSET = VM.getInstanceFieldOffset((long)VM.getFieldAddress((Field)NativeObject.class.getDeclaredField("handle")));
            }
            catch (Throwable t) {
                throw new Error(t);
            }
        }
    }
}

