/*
 * Decompiled with CFR 0.152.
 */
package com.badlogic.gdx.backends.iosrobovm;

import com.badlogic.gdx.Gdx;
import com.badlogic.gdx.Graphics;
import com.badlogic.gdx.LifecycleListener;
import com.badlogic.gdx.backends.iosrobovm.IOSApplication;
import com.badlogic.gdx.backends.iosrobovm.IOSApplicationConfiguration;
import com.badlogic.gdx.backends.iosrobovm.IOSDevice;
import com.badlogic.gdx.backends.iosrobovm.IOSInput;
import com.badlogic.gdx.backends.iosrobovm.custom.HWMachine;
import com.badlogic.gdx.graphics.Cursor;
import com.badlogic.gdx.graphics.GL20;
import com.badlogic.gdx.graphics.GL30;
import com.badlogic.gdx.graphics.Pixmap;
import com.badlogic.gdx.graphics.glutils.GLVersion;
import com.badlogic.gdx.utils.Array;
import org.robovm.apple.coregraphics.CGRect;
import org.robovm.apple.foundation.NSObject;
import org.robovm.apple.glkit.GLKView;
import org.robovm.apple.glkit.GLKViewController;
import org.robovm.apple.glkit.GLKViewControllerDelegate;
import org.robovm.apple.glkit.GLKViewDelegate;
import org.robovm.apple.glkit.GLKViewDrawableColorFormat;
import org.robovm.apple.glkit.GLKViewDrawableDepthFormat;
import org.robovm.apple.glkit.GLKViewDrawableMultisample;
import org.robovm.apple.glkit.GLKViewDrawableStencilFormat;
import org.robovm.apple.opengles.EAGLContext;
import org.robovm.apple.uikit.UIEvent;
import org.robovm.apple.uikit.UIInterfaceOrientation;
import org.robovm.apple.uikit.UIInterfaceOrientationMask;
import org.robovm.apple.uikit.UIRectEdge;
import org.robovm.apple.uikit.UIView;
import org.robovm.objc.Selector;
import org.robovm.objc.annotation.BindSelector;
import org.robovm.objc.annotation.Method;
import org.robovm.rt.bro.annotation.Callback;
import org.robovm.rt.bro.annotation.Pointer;

public class IOSGraphics
extends NSObject
implements Graphics,
GLKViewDelegate,
GLKViewControllerDelegate {
    private static final String tag = "IOSGraphics";
    IOSApplication app;
    IOSInput input;
    GL20 gl20;
    GL30 gl30;
    int width;
    int height;
    long lastFrameTime;
    float deltaTime;
    long framesStart;
    int frames;
    int fps;
    Graphics.BufferFormat bufferFormat;
    String extensions;
    private float ppiX = 0.0f;
    private float ppiY = 0.0f;
    private float ppcX = 0.0f;
    private float ppcY = 0.0f;
    private float density = 1.0f;
    volatile boolean appPaused;
    private long frameId = -1L;
    private boolean isContinuous = true;
    private boolean isFrameRequested = true;
    IOSApplicationConfiguration config;
    EAGLContext context;
    GLVersion glVersion;
    GLKView view;
    IOSUIViewController viewController;
    boolean created = false;

    public IOSGraphics(float scale, IOSApplication app, IOSApplicationConfiguration config, IOSInput input, boolean useGLES30) {
        this.config = config;
        CGRect bounds = app.getBounds();
        this.width = (int)bounds.getWidth();
        this.height = (int)bounds.getHeight();
        this.view = new GLKView(new CGRect(0.0, 0.0, bounds.getWidth(), bounds.getHeight()), this.context){

            @Method(selector="touchesBegan:withEvent:")
            public void touchesBegan(@Pointer long touches, UIEvent event) {
                IOSGraphics.this.input.onTouch(touches);
            }

            @Method(selector="touchesCancelled:withEvent:")
            public void touchesCancelled(@Pointer long touches, UIEvent event) {
                IOSGraphics.this.input.onTouch(touches);
            }

            @Method(selector="touchesEnded:withEvent:")
            public void touchesEnded(@Pointer long touches, UIEvent event) {
                IOSGraphics.this.input.onTouch(touches);
            }

            @Method(selector="touchesMoved:withEvent:")
            public void touchesMoved(@Pointer long touches, UIEvent event) {
                IOSGraphics.this.input.onTouch(touches);
            }

            public void draw(CGRect rect) {
                IOSGraphics.this.draw(this, rect);
            }
        };
        this.view.setDelegate((GLKViewDelegate)this);
        this.view.setDrawableColorFormat(config.colorFormat);
        this.view.setDrawableDepthFormat(config.depthFormat);
        this.view.setDrawableStencilFormat(config.stencilFormat);
        this.view.setDrawableMultisample(config.multisample);
        this.view.setMultipleTouchEnabled(true);
        this.viewController = new IOSUIViewController(app, this);
        this.viewController.setView((UIView)this.view);
        this.viewController.setDelegate(this);
        this.viewController.setPreferredFramesPerSecond(config.preferredFramesPerSecond);
        this.app = app;
        this.input = input;
        int r = 0;
        int g = 0;
        int b = 0;
        int a = 0;
        int depth = 0;
        int stencil = 0;
        int samples = 0;
        if (config.colorFormat == GLKViewDrawableColorFormat.RGB565) {
            r = 5;
            g = 6;
            b = 5;
            a = 0;
        } else {
            a = 8;
            b = 8;
            g = 8;
            r = 8;
        }
        depth = config.depthFormat == GLKViewDrawableDepthFormat._16 ? 16 : (config.depthFormat == GLKViewDrawableDepthFormat._24 ? 24 : 0);
        if (config.stencilFormat == GLKViewDrawableStencilFormat._8) {
            stencil = 8;
        }
        if (config.multisample == GLKViewDrawableMultisample._4X) {
            samples = 4;
        }
        this.bufferFormat = new Graphics.BufferFormat(r, g, b, a, depth, stencil, samples, false);
        String machineString = HWMachine.getMachineString();
        IOSDevice device = IOSDevice.getDevice(machineString);
        if (device == null) {
            app.error(tag, "Machine ID: " + machineString + " not found, please report to LibGDX");
        }
        int ppi = device != null ? device.ppi : 163;
        this.density = device != null ? (float)device.ppi / 160.0f : scale;
        this.ppiX = ppi;
        this.ppiY = ppi;
        this.ppcX = this.ppiX / 2.54f;
        this.ppcY = this.ppiY / 2.54f;
        app.debug(tag, "Display: ppi=" + ppi + ", density=" + this.density);
        this.framesStart = this.lastFrameTime = System.nanoTime();
        long viewPtr = this.view.getHandle();
        long viewControllerPtr = this.viewController.getHandle();
        app.debug(tag, "viewPtr: " + viewPtr + " viewControllerPtr: " + viewControllerPtr);
        this.appPaused = false;
    }

    public long getViewHandle() {
        return this.view.getHandle();
    }

    public long getViewControllerHandle() {
        return this.viewController.getHandle();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void resume() {
        Array<LifecycleListener> listeners;
        if (!this.appPaused) {
            return;
        }
        this.appPaused = false;
        Array<LifecycleListener> array = listeners = this.app.lifecycleListeners;
        synchronized (array) {
            for (LifecycleListener listener : listeners) {
                listener.resume();
            }
        }
        this.app.listener.resume();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void pause() {
        Array<LifecycleListener> listeners;
        if (this.appPaused) {
            return;
        }
        this.appPaused = true;
        Array<LifecycleListener> array = listeners = this.app.lifecycleListeners;
        synchronized (array) {
            for (LifecycleListener listener : listeners) {
                listener.pause();
            }
        }
        this.app.listener.pause();
    }

    public void draw(GLKView view, CGRect rect) {
        if (!this.created) {
            this.app.listener.create();
            this.app.listener.resize(this.width, this.height);
            this.created = true;
        }
        if (this.appPaused) {
            return;
        }
        long time = System.nanoTime();
        this.deltaTime = (float)(time - this.lastFrameTime) / 1.0E9f;
        this.lastFrameTime = time;
        ++this.frames;
        if (time - this.framesStart >= 1000000000L) {
            this.framesStart = time;
            this.fps = this.frames;
            this.frames = 0;
        }
        this.input.processEvents();
        ++this.frameId;
        this.app.listener.render();
    }

    void makeCurrent() {
    }

    public void update(GLKViewController controller) {
        this.app.processRunnables();
        if (!this.isContinuous && !this.isFrameRequested) {
            this.viewController.setPaused(true);
        }
        this.isFrameRequested = false;
    }

    public void willPause(GLKViewController controller, boolean pause) {
    }

    public GL20 getGL20() {
        return this.gl20;
    }

    public void setGL20(GL20 gl20) {
        this.gl20 = gl20;
        if (this.gl30 == null) {
            Gdx.gl = gl20;
            Gdx.gl20 = gl20;
        }
    }

    public boolean isGL30Available() {
        return this.gl30 != null;
    }

    public GL30 getGL30() {
        return this.gl30;
    }

    public void setGL30(GL30 gl30) {
        this.gl30 = gl30;
        if (gl30 != null) {
            Gdx.gl = this.gl20 = gl30;
            Gdx.gl20 = this.gl20;
            Gdx.gl30 = gl30;
        }
    }

    public int getWidth() {
        return this.width;
    }

    public int getHeight() {
        return this.height;
    }

    public int getBackBufferWidth() {
        return this.width;
    }

    public int getBackBufferHeight() {
        return this.height;
    }

    public float getDeltaTime() {
        return this.deltaTime;
    }

    public float getRawDeltaTime() {
        return this.deltaTime;
    }

    public int getFramesPerSecond() {
        return this.fps;
    }

    public Graphics.GraphicsType getType() {
        return Graphics.GraphicsType.iOSGL;
    }

    public GLVersion getGLVersion() {
        return this.glVersion;
    }

    public float getPpiX() {
        return this.ppiX;
    }

    public float getPpiY() {
        return this.ppiY;
    }

    public float getPpcX() {
        return this.ppcX;
    }

    public float getPpcY() {
        return this.ppcY;
    }

    public float getDensity() {
        return this.density;
    }

    public boolean supportsDisplayModeChange() {
        return false;
    }

    public Graphics.DisplayMode[] getDisplayModes() {
        return new Graphics.DisplayMode[]{this.getDisplayMode()};
    }

    public Graphics.DisplayMode getDisplayMode() {
        return new IOSDisplayMode(this.getWidth(), this.getHeight(), this.config.preferredFramesPerSecond, this.bufferFormat.r + this.bufferFormat.g + this.bufferFormat.b + this.bufferFormat.a);
    }

    public Graphics.Monitor getPrimaryMonitor() {
        return new IOSMonitor(0, 0, "Primary Monitor");
    }

    public Graphics.Monitor getMonitor() {
        return this.getPrimaryMonitor();
    }

    public Graphics.Monitor[] getMonitors() {
        return new Graphics.Monitor[]{this.getPrimaryMonitor()};
    }

    public Graphics.DisplayMode[] getDisplayModes(Graphics.Monitor monitor) {
        return this.getDisplayModes();
    }

    public Graphics.DisplayMode getDisplayMode(Graphics.Monitor monitor) {
        return this.getDisplayMode();
    }

    public boolean setFullscreenMode(Graphics.DisplayMode displayMode) {
        return false;
    }

    public boolean setWindowedMode(int width, int height) {
        return false;
    }

    public void setTitle(String title) {
    }

    public void setUndecorated(boolean undecorated) {
    }

    public void setResizable(boolean resizable) {
    }

    public void setVSync(boolean vsync) {
    }

    public Graphics.BufferFormat getBufferFormat() {
        return this.bufferFormat;
    }

    public boolean supportsExtension(String extension) {
        if (this.extensions == null) {
            this.extensions = Gdx.gl.glGetString(7939);
        }
        return this.extensions.contains(extension);
    }

    public void setContinuousRendering(boolean isContinuous) {
        if (isContinuous != this.isContinuous) {
            this.isContinuous = isContinuous;
            if (isContinuous) {
                this.viewController.setPaused(false);
            }
        }
    }

    public boolean isContinuousRendering() {
        return this.isContinuous;
    }

    public void requestRendering() {
        this.isFrameRequested = true;
        if (!this.isContinuous) {
            this.viewController.setPaused(false);
        }
    }

    public boolean isFullscreen() {
        return true;
    }

    public long getFrameId() {
        return this.frameId;
    }

    public Cursor newCursor(Pixmap pixmap, int xHotspot, int yHotspot) {
        return null;
    }

    public void setCursor(Cursor cursor) {
    }

    public void setSystemCursor(Cursor.SystemCursor systemCursor) {
    }

    private class IOSMonitor
    extends Graphics.Monitor {
        protected IOSMonitor(int virtualX, int virtualY, String name) {
            super(virtualX, virtualY, name);
        }
    }

    private class IOSDisplayMode
    extends Graphics.DisplayMode {
        protected IOSDisplayMode(int width, int height, int refreshRate, int bitsPerPixel) {
            super(width, height, refreshRate, bitsPerPixel);
        }
    }

    static class IOSUIView
    extends GLKView {
        public IOSUIView(CGRect frame, EAGLContext context) {
            super(frame, context);
        }
    }

    static class IOSUIViewController
    extends GLKViewController {
        final IOSApplication app;
        final IOSGraphics graphics;
        boolean created = false;

        IOSUIViewController(IOSApplication app, IOSGraphics graphics) {
            this.app = app;
            this.graphics = graphics;
        }

        public void viewWillAppear(boolean arg0) {
            super.viewWillAppear(arg0);
            this.setPaused(false);
        }

        public void viewDidAppear(boolean animated) {
            if (this.app.viewControllerListener != null) {
                this.app.viewControllerListener.viewDidAppear(animated);
            }
        }

        public UIInterfaceOrientationMask getSupportedInterfaceOrientations() {
            long mask = 0L;
            if (this.app.config.orientationLandscape) {
                mask |= (long)(1 << (int)UIInterfaceOrientation.LandscapeLeft.value() | 1 << (int)UIInterfaceOrientation.LandscapeRight.value());
            }
            if (this.app.config.orientationPortrait) {
                mask |= (long)(1 << (int)UIInterfaceOrientation.Portrait.value() | 1 << (int)UIInterfaceOrientation.PortraitUpsideDown.value());
            }
            return new UIInterfaceOrientationMask(mask);
        }

        public boolean shouldAutorotate() {
            return true;
        }

        public boolean shouldAutorotateToInterfaceOrientation(UIInterfaceOrientation orientation) {
            switch (orientation) {
                case LandscapeLeft: 
                case LandscapeRight: {
                    return this.app.config.orientationLandscape;
                }
            }
            return this.app.config.orientationPortrait;
        }

        public UIRectEdge preferredScreenEdgesDeferringSystemGestures() {
            return this.app.config.screenEdgesDeferringSystemGestures;
        }

        public void viewDidLayoutSubviews() {
            super.viewDidLayoutSubviews();
            CGRect bounds = this.app.getBounds();
            this.graphics.width = (int)bounds.getWidth();
            this.graphics.height = (int)bounds.getHeight();
            this.graphics.makeCurrent();
            if (this.graphics.created) {
                this.app.listener.resize(this.graphics.width, this.graphics.height);
            }
        }

        @Callback
        @BindSelector(value="shouldAutorotateToInterfaceOrientation:")
        private static boolean shouldAutorotateToInterfaceOrientation(IOSUIViewController self, Selector sel, UIInterfaceOrientation orientation) {
            return self.shouldAutorotateToInterfaceOrientation(orientation);
        }
    }
}

