/*
 * Decompiled with CFR 0.152.
 */
package org.openintents.sensorsimulator.hardware;

import android.content.Context;
import android.hardware.SensorManager;
import android.os.Build;
import android.widget.Toast;
import java.util.ArrayList;
import org.openintents.sensorsimulator.hardware.Sensor;
import org.openintents.sensorsimulator.hardware.SensorEventListener;
import org.openintents.sensorsimulator.hardware.SensorSimulatorClient;

public class SensorManagerSimulator {
    private static SensorManagerSimulator instance;
    private static final String TAG = "SensorManagerSimulator";
    private static SensorSimulatorClient mClient;
    private SensorManager mSensorManager = null;
    private Context mContext;
    public static final int SENSOR_DELAY_FASTEST = 0;
    public static final int SENSOR_DELAY_GAME = 1;
    public static final int SENSOR_DELAY_NORMAL = 3;
    public static final int SENSOR_DELAY_UI = 2;
    private static Sensor sensors;

    private SensorManagerSimulator(Context context, SensorManager systemsensormanager) {
        this.mContext = context;
        this.mSensorManager = systemsensormanager;
        mClient = new SensorSimulatorClient(this.mContext, this);
    }

    public static SensorManagerSimulator getSystemService(Context context, String sensorManager) {
        if (instance == null && sensorManager.equals("sensor")) {
            if (SensorManagerSimulator.isRealSensorsAvailable()) {
                instance = new SensorManagerSimulator(context, (SensorManager)context.getSystemService(sensorManager));
            } else {
                instance = new SensorManagerSimulator(context, null);
                Toast.makeText((Context)context, (CharSequence)"Android SensorManager disabled, 1.5 SDK emulator crashes when using it... Make sure to connect SensorSimulator", (int)1).show();
            }
        }
        return instance;
    }

    public void setDefaultSensorManager(SensorManager sensormanager) {
        this.mSensorManager = sensormanager;
    }

    public ArrayList<Integer> getSensors() {
        if (SensorManagerSimulator.mClient.connected) {
            return mClient.getSensors();
        }
        if (this.mSensorManager != null) {
            return null;
        }
        return null;
    }

    private static boolean isRealSensorsAvailable() {
        return !Build.VERSION.SDK.equals("3") || !Build.MODEL.contains("sdk");
    }

    public boolean registerListener(SensorEventListener listener, Sensor sensor, int rate) {
        if (SensorManagerSimulator.mClient.connected) {
            mClient.registerListener(listener, sensor, rate);
            return true;
        }
        if (this.mSensorManager == null) {
            return false;
        }
        return false;
    }

    public void unregisterListener(SensorEventListener listener, Sensor sensor) {
        if (SensorManagerSimulator.mClient.connected) {
            mClient.unregisterListener(listener, sensor);
        }
    }

    public void unregisterListener(SensorEventListener listener) {
        if (SensorManagerSimulator.mClient.connected) {
            mClient.unregisterListener(listener);
        }
    }

    public void connectSimulator() {
        mClient.connect();
    }

    public void disconnectSimulator() {
        mClient.disconnect();
    }

    public boolean isConnectedSimulator() {
        return SensorManagerSimulator.mClient.connected;
    }

    public Sensor getDefaultSensor(int type) {
        if (sensors == null) {
            sensors = new Sensor(this.mContext, type);
            return sensors;
        }
        if (sensors.checkList(type)) {
            sensors.addSensor(type);
            return sensors;
        }
        sensors.removeSensor(type);
        return sensors;
    }
}

