/*
 * Decompiled with CFR 0.152.
 */
package org.openintents.sensorsimulator.dbprovider;

import android.content.ContentProvider;
import android.content.ContentUris;
import android.content.ContentValues;
import android.content.Context;
import android.content.UriMatcher;
import android.content.res.Resources;
import android.database.Cursor;
import android.database.SQLException;
import android.database.sqlite.SQLiteDatabase;
import android.database.sqlite.SQLiteOpenHelper;
import android.database.sqlite.SQLiteQueryBuilder;
import android.net.Uri;
import android.text.TextUtils;
import android.util.Log;
import java.util.HashMap;
import org.openintents.sensorsimulator.db.SensorSimulator;

public class SensorSimulatorProvider
extends ContentProvider {
    private SQLiteOpenHelper mOpenHelper;
    private static final String TAG = "SensorSimulatorProvider";
    private static final String DATABASE_NAME = "sensorsimulator.db";
    private static final int DATABASE_VERSION = 1;
    private static final String DATABASE_TABLE_SETTINGS = "settings";
    private static HashMap<String, String> PREFERENCES_PROJECTION_MAP;
    private static final int SETTINGS = 1;
    private static final int SETTING_ID = 2;
    private static final UriMatcher URL_MATCHER;

    static {
        URL_MATCHER = new UriMatcher(-1);
        URL_MATCHER.addURI("org.openintents.sensorsimulator", DATABASE_TABLE_SETTINGS, 1);
        URL_MATCHER.addURI("org.openintents.sensorsimulator", "settings/#", 2);
        PREFERENCES_PROJECTION_MAP = new HashMap();
        PREFERENCES_PROJECTION_MAP.put("_id", "settings._id");
        PREFERENCES_PROJECTION_MAP.put("key", "settings.key");
        PREFERENCES_PROJECTION_MAP.put("value", "settings.value");
    }

    public boolean onCreate() {
        this.mOpenHelper = new DatabaseHelper(this.getContext());
        return true;
    }

    public Cursor query(Uri url, String[] projection, String selection, String[] selectionArgs, String sort) {
        SQLiteQueryBuilder qb = new SQLiteQueryBuilder();
        Log.i((String)TAG, (String)("Query for URL: " + url));
        String defaultOrderBy = null;
        switch (URL_MATCHER.match(url)) {
            case 1: {
                qb.setTables(DATABASE_TABLE_SETTINGS);
                qb.setProjectionMap(PREFERENCES_PROJECTION_MAP);
                defaultOrderBy = "_id ASC";
                break;
            }
            case 2: {
                qb.setTables(DATABASE_TABLE_SETTINGS);
                qb.appendWhere((CharSequence)("_id=" + (String)url.getPathSegments().get(1)));
                break;
            }
            default: {
                throw new IllegalArgumentException("Unknown URL " + url);
            }
        }
        String orderBy = TextUtils.isEmpty((CharSequence)sort) ? defaultOrderBy : sort;
        SQLiteDatabase db = this.mOpenHelper.getReadableDatabase();
        Cursor c = qb.query(db, projection, selection, selectionArgs, null, null, orderBy);
        c.setNotificationUri(this.getContext().getContentResolver(), url);
        return c;
    }

    public Uri insert(Uri url, ContentValues initialValues) {
        ContentValues values = initialValues != null ? new ContentValues(initialValues) : new ContentValues();
        switch (URL_MATCHER.match(url)) {
            case 1: {
                return this.insertPreferences(url, values);
            }
        }
        throw new IllegalArgumentException("Unknown URL " + url);
    }

    public Uri insertPreferences(Uri url, ContentValues values) {
        long rowID;
        SQLiteDatabase db = this.mOpenHelper.getWritableDatabase();
        Resources r = Resources.getSystem();
        if (!values.containsKey("key")) {
            values.put("key", r.getString(2130968597));
        }
        if (!values.containsKey("value")) {
            values.put("value", "");
        }
        if ((rowID = db.insert(DATABASE_TABLE_SETTINGS, "key", values)) > 0L) {
            Uri uri = ContentUris.withAppendedId((Uri)SensorSimulator.Settings.CONTENT_URI, (long)rowID);
            this.getContext().getContentResolver().notifyChange(uri, null);
            return uri;
        }
        throw new SQLException("Failed to insert row into " + url);
    }

    public int delete(Uri url, String where, String[] whereArgs) {
        int count;
        SQLiteDatabase db = this.mOpenHelper.getWritableDatabase();
        switch (URL_MATCHER.match(url)) {
            case 1: {
                count = db.delete(DATABASE_TABLE_SETTINGS, where, whereArgs);
                break;
            }
            case 2: {
                String segment = (String)url.getPathSegments().get(1);
                String whereString = !TextUtils.isEmpty((CharSequence)where) ? " AND (" + where + ')' : "";
                count = db.delete(DATABASE_TABLE_SETTINGS, "_id=" + segment + whereString, whereArgs);
                break;
            }
            default: {
                throw new IllegalArgumentException("Unknown URL " + url);
            }
        }
        this.getContext().getContentResolver().notifyChange(url, null);
        return count;
    }

    public int update(Uri url, ContentValues values, String where, String[] whereArgs) {
        int count;
        Log.i((String)TAG, (String)("update called for: " + url));
        SQLiteDatabase db = this.mOpenHelper.getWritableDatabase();
        switch (URL_MATCHER.match(url)) {
            case 1: {
                count = db.update(DATABASE_TABLE_SETTINGS, values, where, whereArgs);
                break;
            }
            case 2: {
                String segment = (String)url.getPathSegments().get(1);
                String whereString = !TextUtils.isEmpty((CharSequence)where) ? " AND (" + where + ')' : "";
                count = db.update(DATABASE_TABLE_SETTINGS, values, "_id=" + segment + whereString, whereArgs);
                break;
            }
            default: {
                Log.e((String)TAG, (String)("Update received unknown URL: " + url));
                throw new IllegalArgumentException("Unknown URL " + url);
            }
        }
        this.getContext().getContentResolver().notifyChange(url, null);
        return count;
    }

    public String getType(Uri url) {
        switch (URL_MATCHER.match(url)) {
            case 1: {
                return "vnd.android.cursor.dir/vnd.openintents.sensorsimulator.setting";
            }
            case 2: {
                return "vnd.android.cursor.item/vnd.openintents.sensorsimulator.setting";
            }
        }
        throw new IllegalArgumentException("Unknown URL " + url);
    }

    private static class DatabaseHelper
    extends SQLiteOpenHelper {
        DatabaseHelper(Context context) {
            super(context, SensorSimulatorProvider.DATABASE_NAME, null, 1);
        }

        public void onCreate(SQLiteDatabase db) {
            db.execSQL("CREATE TABLE settings (_id INTEGER PRIMARY KEY,key VARCHAR,value VARCHAR);");
        }

        public void onUpgrade(SQLiteDatabase db, int oldVersion, int newVersion) {
            Log.w((String)SensorSimulatorProvider.TAG, (String)("Upgrading database from version " + oldVersion + " to " + newVersion + ", which will destroy all old data"));
            db.execSQL("DROP TABLE IF EXISTS settings");
            this.onCreate(db);
        }
    }
}

