/*
 * Decompiled with CFR 0.152.
 */
package org.openintents.sensorsimulator;

import android.app.Activity;
import android.content.Context;
import android.content.res.Resources;
import android.location.Location;
import android.location.LocationListener;
import android.location.LocationManager;
import android.os.Bundle;
import android.util.Log;
import android.view.LayoutInflater;
import android.view.Menu;
import android.view.MenuItem;
import android.view.View;
import android.view.ViewGroup;
import android.widget.Button;
import android.widget.EditText;
import android.widget.LinearLayout;
import android.widget.TabHost;
import android.widget.TextView;
import android.widget.Toast;
import java.text.DecimalFormat;
import java.util.ArrayList;
import org.openintents.sensorsimulator.db.SensorSimulatorConvenience;
import org.openintents.sensorsimulator.hardware.Sensor;
import org.openintents.sensorsimulator.hardware.SensorEvent;
import org.openintents.sensorsimulator.hardware.SensorEventListener;
import org.openintents.sensorsimulator.hardware.SensorManagerSimulator;
import org.openintents.sensorsimulator.hardware.SensorNames;

public class SensorSimulatorSettingsActivity
extends Activity {
    private static final String TAG = "SensorSimulatorSettingsActivity";
    private SensorManagerSimulator mSensorManager;
    private EditText mEditTextIP;
    private EditText mEditTextSocket;
    private TextView mTextSensorType;
    private Button mButtonConnect;
    private Button mButtonDisconnect;
    private LinearLayout mSensorsList;
    DecimalFormat mDecimalFormat;
    ArrayList<String> mSupportedSensors = new ArrayList();
    int mNumSensors;
    boolean[] mSensorEnabled;
    SingleSensorView[] mSingleSensorView;
    String[] mDelayTypes = new String[]{"Fastest", "Game", "UI", "Normal"};
    private TabHost mTabHost;
    private SensorSimulatorConvenience mSensorSimulatorConvenience;
    private SensorEventListener listener = new SensorEventListener(){

        @Override
        public void onAccuracyChanged(Sensor sensor, int acc) {
        }

        @Override
        public void onSensorChanged(SensorEvent event) {
            String data;
            int sensor = event.type;
            float[] values = event.values;
            int i = 0;
            while (i < SensorSimulatorSettingsActivity.this.mNumSensors) {
                if (SensorSimulatorSettingsActivity.this.mSingleSensorView[i].mSensorBit == sensor && sensor != 9) {
                    data = "";
                    int num = SensorNames.getNumSensorValues(sensor);
                    int j = 0;
                    while (j < num) {
                        data = String.valueOf(data) + SensorSimulatorSettingsActivity.this.mDecimalFormat.format(values[j]);
                        if (j < num - 1) {
                            data = String.valueOf(data) + ", ";
                        }
                        ++j;
                    }
                    SensorSimulatorSettingsActivity.this.mSingleSensorView[i].mSensorDataTextView.setText((CharSequence)data);
                    break;
                }
                ++i;
            }
            i = 0;
            while (i < SensorSimulatorSettingsActivity.this.mNumSensors) {
                if (SensorSimulatorSettingsActivity.this.mSingleSensorView[i].mSensorBit == sensor && sensor == 9) {
                    data = "";
                    data = event.barcode;
                    SensorSimulatorSettingsActivity.this.mSingleSensorView[i].mSensorDataTextView.setText((CharSequence)data);
                    break;
                }
                ++i;
            }
        }
    };

    protected void onCreate(Bundle icicle) {
        String s;
        super.onCreate(icicle);
        this.setContentView(2130903040);
        this.mSensorManager = SensorManagerSimulator.getSystemService((Context)this, "sensor");
        this.mSensorSimulatorConvenience = new SensorSimulatorConvenience((Context)this);
        SensorSimulatorSettingsActivity context = this;
        Resources res = context.getResources();
        this.mTabHost = (TabHost)this.findViewById(2131034112);
        this.mTabHost.setup();
        TabHost.TabSpec tabspec = this.mTabHost.newTabSpec("settings");
        tabspec.setIndicator((CharSequence)res.getString(2130968578), res.getDrawable(2130837510));
        tabspec.setContent(2131034113);
        this.mTabHost.addTab(tabspec);
        tabspec = this.mTabHost.newTabSpec("testing");
        tabspec.setIndicator((CharSequence)res.getString(2130968580), res.getDrawable(2130837506));
        tabspec.setContent(2131034116);
        this.mTabHost.addTab(tabspec);
        this.mTabHost.setCurrentTab(0);
        this.mEditTextIP = (EditText)this.findViewById(2131034114);
        this.mEditTextSocket = (EditText)this.findViewById(2131034115);
        this.mButtonConnect = (Button)this.findViewById(2131034117);
        this.mButtonConnect.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                SensorSimulatorSettingsActivity.this.connect();
            }
        });
        this.mButtonDisconnect = (Button)this.findViewById(2131034118);
        this.mButtonDisconnect.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                SensorSimulatorSettingsActivity.this.disconnect();
            }
        });
        this.setButtonState();
        String ipAddress = this.mSensorSimulatorConvenience.getPreference("IP address");
        if (!ipAddress.contentEquals("")) {
            this.mEditTextIP.setText((CharSequence)ipAddress);
        }
        if ((s = this.mSensorSimulatorConvenience.getPreference("Socket")).contentEquals("")) {
            s = "8010";
        }
        this.mEditTextSocket.setText((CharSequence)s);
        this.mTextSensorType = (TextView)this.findViewById(2131034119);
        this.mDecimalFormat = new DecimalFormat("#0.00");
        this.readAllSensors();
        this.mSensorsList = (LinearLayout)this.findViewById(2131034120);
        this.fillSensorList();
        LocationManager mlocManager = (LocationManager)this.getSystemService("location");
        MyLocationListener mlocListener = new MyLocationListener();
        mlocManager.requestLocationUpdates("gps", 0L, 0.0f, (LocationListener)mlocListener);
    }

    protected void onResume() {
        super.onResume();
        this.mSensorManager.registerListener(this.listener, this.mSensorManager.getDefaultSensor(1), 0);
        this.mSensorManager.registerListener(this.listener, this.mSensorManager.getDefaultSensor(2), 0);
        this.mSensorManager.registerListener(this.listener, this.mSensorManager.getDefaultSensor(3), 0);
        this.mSensorManager.registerListener(this.listener, this.mSensorManager.getDefaultSensor(7), 0);
        this.mSensorManager.registerListener(this.listener, this.mSensorManager.getDefaultSensor(5), 0);
        this.mSensorManager.registerListener(this.listener, this.mSensorManager.getDefaultSensor(8), 0);
        this.mSensorManager.registerListener(this.listener, this.mSensorManager.getDefaultSensor(10), 0);
        this.mSensorManager.registerListener(this.listener, this.mSensorManager.getDefaultSensor(11), 0);
        this.mSensorManager.registerListener(this.listener, this.mSensorManager.getDefaultSensor(12), 0);
    }

    protected void onStop() {
        this.mSensorManager.unregisterListener(this.listener);
        super.onStop();
    }

    protected void onSaveInstanceState(Bundle outState) {
        super.onSaveInstanceState(outState);
    }

    protected void onPause() {
        super.onPause();
        String newIP = this.mEditTextIP.getText().toString();
        String newSocket = this.mEditTextSocket.getText().toString();
        String oldIP = this.mSensorSimulatorConvenience.getPreference("IP address");
        String oldSocket = this.mSensorSimulatorConvenience.getPreference("Socket");
        if (!newIP.contentEquals(oldIP) || !newSocket.contentEquals(oldSocket)) {
            this.mSensorManager.unregisterListener(this.listener);
            this.mSensorManager.disconnectSimulator();
            this.mSensorSimulatorConvenience.setPreference("IP address", newIP);
            this.mSensorSimulatorConvenience.setPreference("Socket", newSocket);
        }
    }

    public boolean onCreateOptionsMenu(Menu menu) {
        super.onCreateOptionsMenu(menu);
        return true;
    }

    public boolean onPrepareOptionsMenu(Menu menu) {
        super.onPrepareOptionsMenu(menu);
        return true;
    }

    public boolean onOptionsItemSelected(MenuItem item) {
        item.getItemId();
        return super.onOptionsItemSelected(item);
    }

    public void connect() {
        Log.i((String)TAG, (String)"Connect");
        String newIP = this.mEditTextIP.getText().toString();
        String newSocket = this.mEditTextSocket.getText().toString();
        String oldIP = this.mSensorSimulatorConvenience.getPreference("IP address");
        String oldSocket = this.mSensorSimulatorConvenience.getPreference("Socket");
        if (!newIP.contentEquals(oldIP) || !newSocket.contentEquals(oldSocket)) {
            this.mSensorManager.unregisterListener(this.listener);
            this.mSensorManager.disconnectSimulator();
            this.mSensorSimulatorConvenience.setPreference("IP address", newIP);
            this.mSensorSimulatorConvenience.setPreference("Socket", newSocket);
        }
        if (!this.mSensorManager.isConnectedSimulator()) {
            Log.i((String)TAG, (String)"Not connected yet -> Connect");
            this.mSensorManager.connectSimulator();
        }
        this.readAllSensors();
        this.setButtonState();
        if (this.mSensorManager.isConnectedSimulator()) {
            this.mTextSensorType.setText(2130968585);
        } else {
            this.mTextSensorType.setText(2130968584);
        }
        this.fillSensorList();
    }

    public void disconnect() {
        this.mSensorManager.unregisterListener(this.listener);
        this.mSensorManager.disconnectSimulator();
        this.readAllSensors();
        this.setButtonState();
        if (this.mSensorManager.isConnectedSimulator()) {
            this.mTextSensorType.setText(2130968585);
        } else {
            this.mTextSensorType.setText(2130968584);
        }
        this.mSensorsList.removeAllViews();
    }

    public void setButtonState() {
        boolean connected = this.mSensorManager.isConnectedSimulator();
        this.mButtonConnect.setEnabled(!connected);
        this.mButtonDisconnect.setEnabled(connected);
        this.mButtonConnect.invalidate();
        this.mButtonDisconnect.invalidate();
    }

    public void readAllSensors() {
        ArrayList<Integer> sensors = this.mSensorManager.getSensors();
        if (sensors != null) {
            this.mSupportedSensors = SensorNames.getSensorNames(sensors);
        }
        if (this.mSupportedSensors != null) {
            this.mNumSensors = this.mSupportedSensors.size();
        }
    }

    void fillSensorList() {
        if (this.mSupportedSensors != null) {
            this.mSensorsList.removeAllViews();
            int max = this.mSupportedSensors.size();
            this.mSingleSensorView = new SingleSensorView[max];
            int i = 0;
            while (i < max) {
                String[] sensorsNames = new String[this.mSupportedSensors.size()];
                ArrayList<Integer> sensorbit = SensorNames.getSensorsFromNames(this.mSupportedSensors.toArray(sensorsNames));
                SingleSensorView ssv = new SingleSensorView((Context)this, this.mSupportedSensors.get(i), sensorbit.get(i), i);
                ssv.setLayoutParams((ViewGroup.LayoutParams)new LinearLayout.LayoutParams(-1, -2));
                this.mSensorsList.addView((View)ssv, i);
                this.mSingleSensorView[i] = ssv;
                ++i;
            }
        }
    }

    public class MyLocationListener
    implements LocationListener {
        public void onLocationChanged(Location location) {
            location.getLatitude();
            location.getLongitude();
            location.getAltitude();
            String Text = "My current location is: Longitude = " + location.getLongitude() + " Latitude = " + location.getLatitude() + " Altitude = " + location.getAltitude();
            Toast.makeText((Context)SensorSimulatorSettingsActivity.this.getApplicationContext(), (CharSequence)Text, (int)0).show();
        }

        public void onProviderDisabled(String provider) {
        }

        public void onProviderEnabled(String provider) {
        }

        public void onStatusChanged(String provider, int status, Bundle extras) {
        }
    }

    private class SingleSensorView
    extends LinearLayout {
        private TextView mTitle;
        LinearLayout mL1;
        LinearLayout mL1a;
        LinearLayout mL1b;
        LinearLayout mL1c;
        TextView mSensorNameTextView;
        TextView mSensorDataTextView;
        Context mContext;
        int mSensorId;
        String mSensor;
        int mSensorBit;
        int mDefaultValueIndex;

        public SingleSensorView(Context context, String sensor, int sensorbit, int sensorId) {
            super(context);
            this.mContext = context;
            this.mSensorId = sensorId;
            this.mSensor = sensor;
            this.mSensorBit = sensorbit;
            this.mDefaultValueIndex = -1;
            LayoutInflater inf = (LayoutInflater)SensorSimulatorSettingsActivity.this.getSystemService("layout_inflater");
            View rowView = inf.inflate(2130903041, null);
            rowView.setTag((Object)this.mSensor);
            this.mSensorNameTextView = (TextView)rowView.findViewById(2131034121);
            this.mSensorNameTextView.setText((CharSequence)sensor);
            this.mSensorDataTextView = (TextView)rowView.findViewById(2131034122);
            this.addView(rowView, (ViewGroup.LayoutParams)new LinearLayout.LayoutParams(-1, -2));
            SensorSimulatorSettingsActivity.this.mSensorManager.registerListener(SensorSimulatorSettingsActivity.this.listener, SensorSimulatorSettingsActivity.this.mSensorManager.getDefaultSensor(this.mSensorBit), 0);
        }
    }
}

