/*
 * Decompiled with CFR 0.152.
 */
package com.badlogic.gdx.physics.bullet.extras;

import com.badlogic.gdx.math.Matrix4;
import com.badlogic.gdx.math.Vector3;
import com.badlogic.gdx.physics.bullet.BulletBase;
import com.badlogic.gdx.physics.bullet.collision.btBvhTriangleMeshShape;
import com.badlogic.gdx.physics.bullet.collision.btCollisionObject;
import com.badlogic.gdx.physics.bullet.collision.btCollisionShape;
import com.badlogic.gdx.physics.bullet.collision.btCompoundShape;
import com.badlogic.gdx.physics.bullet.collision.btConvexHullShape;
import com.badlogic.gdx.physics.bullet.collision.btGImpactMeshShape;
import com.badlogic.gdx.physics.bullet.collision.btMultiSphereShape;
import com.badlogic.gdx.physics.bullet.collision.btOptimizedBvh;
import com.badlogic.gdx.physics.bullet.collision.btScaledBvhTriangleMeshShape;
import com.badlogic.gdx.physics.bullet.collision.btStridingMeshInterface;
import com.badlogic.gdx.physics.bullet.collision.btStridingMeshInterfaceData;
import com.badlogic.gdx.physics.bullet.collision.btTriangleIndexVertexArray;
import com.badlogic.gdx.physics.bullet.collision.btTriangleInfoMap;
import com.badlogic.gdx.physics.bullet.dynamics.btConeTwistConstraint;
import com.badlogic.gdx.physics.bullet.dynamics.btContactSolverInfo;
import com.badlogic.gdx.physics.bullet.dynamics.btDynamicsWorld;
import com.badlogic.gdx.physics.bullet.dynamics.btGearConstraint;
import com.badlogic.gdx.physics.bullet.dynamics.btGeneric6DofConstraint;
import com.badlogic.gdx.physics.bullet.dynamics.btGeneric6DofSpring2Constraint;
import com.badlogic.gdx.physics.bullet.dynamics.btGeneric6DofSpringConstraint;
import com.badlogic.gdx.physics.bullet.dynamics.btHingeConstraint;
import com.badlogic.gdx.physics.bullet.dynamics.btPoint2PointConstraint;
import com.badlogic.gdx.physics.bullet.dynamics.btRigidBody;
import com.badlogic.gdx.physics.bullet.dynamics.btSliderConstraint;
import com.badlogic.gdx.physics.bullet.dynamics.btTypedConstraint;
import com.badlogic.gdx.physics.bullet.extras.ExtrasJNI;
import com.badlogic.gdx.physics.bullet.linearmath.btVector3;
import java.nio.FloatBuffer;

public class btWorldImporter
extends BulletBase {
    private long swigCPtr;

    protected btWorldImporter(String className, long cPtr, boolean cMemoryOwn) {
        super(className, cPtr, cMemoryOwn);
        this.swigCPtr = cPtr;
    }

    public btWorldImporter(long cPtr, boolean cMemoryOwn) {
        this("btWorldImporter", cPtr, cMemoryOwn);
        this.construct();
    }

    @Override
    protected void reset(long cPtr, boolean cMemoryOwn) {
        if (!this.destroyed) {
            this.destroy();
        }
        this.swigCPtr = cPtr;
        super.reset(this.swigCPtr, cMemoryOwn);
    }

    public static long getCPtr(btWorldImporter obj) {
        return obj == null ? 0L : obj.swigCPtr;
    }

    @Override
    protected void finalize() throws Throwable {
        if (!this.destroyed) {
            this.destroy();
        }
        super.finalize();
    }

    @Override
    protected synchronized void delete() {
        if (this.swigCPtr != 0L) {
            if (this.swigCMemOwn) {
                this.swigCMemOwn = false;
                ExtrasJNI.delete_btWorldImporter(this.swigCPtr);
            }
            this.swigCPtr = 0L;
        }
        super.delete();
    }

    public btWorldImporter(btDynamicsWorld world) {
        this(ExtrasJNI.new_btWorldImporter(btDynamicsWorld.getCPtr(world), world), true);
    }

    public void deleteAllData() {
        ExtrasJNI.btWorldImporter_deleteAllData(this.swigCPtr, this);
    }

    public void setVerboseMode(int verboseMode) {
        ExtrasJNI.btWorldImporter_setVerboseMode(this.swigCPtr, this, verboseMode);
    }

    public int getVerboseMode() {
        return ExtrasJNI.btWorldImporter_getVerboseMode(this.swigCPtr, this);
    }

    public int getNumCollisionShapes() {
        return ExtrasJNI.btWorldImporter_getNumCollisionShapes(this.swigCPtr, this);
    }

    public btCollisionShape getCollisionShapeByIndex(int index) {
        long cPtr = ExtrasJNI.btWorldImporter_getCollisionShapeByIndex(this.swigCPtr, this, index);
        return cPtr == 0L ? null : btCollisionShape.newDerivedObject(cPtr, false);
    }

    public int getNumRigidBodies() {
        return ExtrasJNI.btWorldImporter_getNumRigidBodies(this.swigCPtr, this);
    }

    public btCollisionObject getRigidBodyByIndex(int index) {
        return btCollisionObject.getInstance(ExtrasJNI.btWorldImporter_getRigidBodyByIndex(this.swigCPtr, this, index), false);
    }

    public int getNumConstraints() {
        return ExtrasJNI.btWorldImporter_getNumConstraints(this.swigCPtr, this);
    }

    public btTypedConstraint getConstraintByIndex(int index) {
        long cPtr = ExtrasJNI.btWorldImporter_getConstraintByIndex(this.swigCPtr, this, index);
        return cPtr == 0L ? null : new btTypedConstraint(cPtr, false);
    }

    public int getNumBvhs() {
        return ExtrasJNI.btWorldImporter_getNumBvhs(this.swigCPtr, this);
    }

    public btOptimizedBvh getBvhByIndex(int index) {
        long cPtr = ExtrasJNI.btWorldImporter_getBvhByIndex(this.swigCPtr, this, index);
        return cPtr == 0L ? null : new btOptimizedBvh(cPtr, false);
    }

    public int getNumTriangleInfoMaps() {
        return ExtrasJNI.btWorldImporter_getNumTriangleInfoMaps(this.swigCPtr, this);
    }

    public btTriangleInfoMap getTriangleInfoMapByIndex(int index) {
        long cPtr = ExtrasJNI.btWorldImporter_getTriangleInfoMapByIndex(this.swigCPtr, this, index);
        return cPtr == 0L ? null : new btTriangleInfoMap(cPtr, false);
    }

    public btCollisionShape getCollisionShapeByName(String name) {
        long cPtr = ExtrasJNI.btWorldImporter_getCollisionShapeByName(this.swigCPtr, this, name);
        return cPtr == 0L ? null : btCollisionShape.newDerivedObject(cPtr, false);
    }

    public btRigidBody getRigidBodyByName(String name) {
        return btRigidBody.getInstance(ExtrasJNI.btWorldImporter_getRigidBodyByName(this.swigCPtr, this, name), false);
    }

    public btTypedConstraint getConstraintByName(String name) {
        long cPtr = ExtrasJNI.btWorldImporter_getConstraintByName(this.swigCPtr, this, name);
        return cPtr == 0L ? null : new btTypedConstraint(cPtr, false);
    }

    public String getNameForPointer(long ptr) {
        return ExtrasJNI.btWorldImporter_getNameForPointer__SWIG_0(this.swigCPtr, this, ptr);
    }

    public void setDynamicsWorldInfo(Vector3 gravity, btContactSolverInfo solverInfo) {
        ExtrasJNI.btWorldImporter_setDynamicsWorldInfo(this.swigCPtr, this, gravity, btContactSolverInfo.getCPtr(solverInfo), solverInfo);
    }

    public btRigidBody createRigidBody(boolean isDynamic, float mass, Matrix4 startTransform, btCollisionShape shape, String bodyName) {
        return btRigidBody.getInstance(ExtrasJNI.btWorldImporter_createRigidBody(this.swigCPtr, this, isDynamic, mass, startTransform, btCollisionShape.getCPtr(shape), shape, bodyName), false);
    }

    public btCollisionObject createCollisionObject(Matrix4 startTransform, btCollisionShape shape, String bodyName) {
        return btCollisionObject.getInstance(ExtrasJNI.btWorldImporter_createCollisionObject(this.swigCPtr, this, startTransform, btCollisionShape.getCPtr(shape), shape, bodyName), false);
    }

    public btCollisionShape createPlaneShape(Vector3 planeNormal, float planeConstant) {
        long cPtr = ExtrasJNI.btWorldImporter_createPlaneShape(this.swigCPtr, this, planeNormal, planeConstant);
        return cPtr == 0L ? null : btCollisionShape.newDerivedObject(cPtr, false);
    }

    public btCollisionShape createBoxShape(Vector3 halfExtents) {
        long cPtr = ExtrasJNI.btWorldImporter_createBoxShape(this.swigCPtr, this, halfExtents);
        return cPtr == 0L ? null : btCollisionShape.newDerivedObject(cPtr, false);
    }

    public btCollisionShape createSphereShape(float radius) {
        long cPtr = ExtrasJNI.btWorldImporter_createSphereShape(this.swigCPtr, this, radius);
        return cPtr == 0L ? null : btCollisionShape.newDerivedObject(cPtr, false);
    }

    public btCollisionShape createCapsuleShapeX(float radius, float height) {
        long cPtr = ExtrasJNI.btWorldImporter_createCapsuleShapeX(this.swigCPtr, this, radius, height);
        return cPtr == 0L ? null : btCollisionShape.newDerivedObject(cPtr, false);
    }

    public btCollisionShape createCapsuleShapeY(float radius, float height) {
        long cPtr = ExtrasJNI.btWorldImporter_createCapsuleShapeY(this.swigCPtr, this, radius, height);
        return cPtr == 0L ? null : btCollisionShape.newDerivedObject(cPtr, false);
    }

    public btCollisionShape createCapsuleShapeZ(float radius, float height) {
        long cPtr = ExtrasJNI.btWorldImporter_createCapsuleShapeZ(this.swigCPtr, this, radius, height);
        return cPtr == 0L ? null : btCollisionShape.newDerivedObject(cPtr, false);
    }

    public btCollisionShape createCylinderShapeX(float radius, float height) {
        long cPtr = ExtrasJNI.btWorldImporter_createCylinderShapeX(this.swigCPtr, this, radius, height);
        return cPtr == 0L ? null : btCollisionShape.newDerivedObject(cPtr, false);
    }

    public btCollisionShape createCylinderShapeY(float radius, float height) {
        long cPtr = ExtrasJNI.btWorldImporter_createCylinderShapeY(this.swigCPtr, this, radius, height);
        return cPtr == 0L ? null : btCollisionShape.newDerivedObject(cPtr, false);
    }

    public btCollisionShape createCylinderShapeZ(float radius, float height) {
        long cPtr = ExtrasJNI.btWorldImporter_createCylinderShapeZ(this.swigCPtr, this, radius, height);
        return cPtr == 0L ? null : btCollisionShape.newDerivedObject(cPtr, false);
    }

    public btCollisionShape createConeShapeX(float radius, float height) {
        long cPtr = ExtrasJNI.btWorldImporter_createConeShapeX(this.swigCPtr, this, radius, height);
        return cPtr == 0L ? null : btCollisionShape.newDerivedObject(cPtr, false);
    }

    public btCollisionShape createConeShapeY(float radius, float height) {
        long cPtr = ExtrasJNI.btWorldImporter_createConeShapeY(this.swigCPtr, this, radius, height);
        return cPtr == 0L ? null : btCollisionShape.newDerivedObject(cPtr, false);
    }

    public btCollisionShape createConeShapeZ(float radius, float height) {
        long cPtr = ExtrasJNI.btWorldImporter_createConeShapeZ(this.swigCPtr, this, radius, height);
        return cPtr == 0L ? null : btCollisionShape.newDerivedObject(cPtr, false);
    }

    public btTriangleIndexVertexArray createTriangleMeshContainer() {
        long cPtr = ExtrasJNI.btWorldImporter_createTriangleMeshContainer(this.swigCPtr, this);
        return cPtr == 0L ? null : new btTriangleIndexVertexArray(cPtr, false);
    }

    public btBvhTriangleMeshShape createBvhTriangleMeshShape(btStridingMeshInterface trimesh, btOptimizedBvh bvh) {
        long cPtr = ExtrasJNI.btWorldImporter_createBvhTriangleMeshShape(this.swigCPtr, this, btStridingMeshInterface.getCPtr(trimesh), trimesh, btOptimizedBvh.getCPtr(bvh), bvh);
        return cPtr == 0L ? null : new btBvhTriangleMeshShape(cPtr, false);
    }

    public btCollisionShape createConvexTriangleMeshShape(btStridingMeshInterface trimesh) {
        long cPtr = ExtrasJNI.btWorldImporter_createConvexTriangleMeshShape(this.swigCPtr, this, btStridingMeshInterface.getCPtr(trimesh), trimesh);
        return cPtr == 0L ? null : btCollisionShape.newDerivedObject(cPtr, false);
    }

    public btGImpactMeshShape createGimpactShape(btStridingMeshInterface trimesh) {
        long cPtr = ExtrasJNI.btWorldImporter_createGimpactShape(this.swigCPtr, this, btStridingMeshInterface.getCPtr(trimesh), trimesh);
        return cPtr == 0L ? null : new btGImpactMeshShape(cPtr, false);
    }

    public btStridingMeshInterfaceData createStridingMeshInterfaceData(btStridingMeshInterfaceData interfaceData) {
        long cPtr = ExtrasJNI.btWorldImporter_createStridingMeshInterfaceData(this.swigCPtr, this, btStridingMeshInterfaceData.getCPtr(interfaceData), interfaceData);
        return cPtr == 0L ? null : new btStridingMeshInterfaceData(cPtr, false);
    }

    public btConvexHullShape createConvexHullShape() {
        long cPtr = ExtrasJNI.btWorldImporter_createConvexHullShape(this.swigCPtr, this);
        return cPtr == 0L ? null : new btConvexHullShape(cPtr, false);
    }

    public btCompoundShape createCompoundShape() {
        long cPtr = ExtrasJNI.btWorldImporter_createCompoundShape(this.swigCPtr, this);
        return cPtr == 0L ? null : new btCompoundShape(cPtr, false);
    }

    public btScaledBvhTriangleMeshShape createScaledTrangleMeshShape(btBvhTriangleMeshShape meshShape, Vector3 localScalingbtBvhTriangleMeshShape) {
        long cPtr = ExtrasJNI.btWorldImporter_createScaledTrangleMeshShape(this.swigCPtr, this, btBvhTriangleMeshShape.getCPtr(meshShape), meshShape, localScalingbtBvhTriangleMeshShape);
        return cPtr == 0L ? null : new btScaledBvhTriangleMeshShape(cPtr, false);
    }

    public btMultiSphereShape createMultiSphereShape(btVector3 positions, FloatBuffer radi, int numSpheres) {
        assert (radi.isDirect()) : "Buffer must be allocated direct.";
        long cPtr = ExtrasJNI.btWorldImporter_createMultiSphereShape(this.swigCPtr, this, btVector3.getCPtr(positions), positions, radi, numSpheres);
        return cPtr == 0L ? null : new btMultiSphereShape(cPtr, false);
    }

    public btTriangleIndexVertexArray createMeshInterface(btStridingMeshInterfaceData meshData) {
        long cPtr = ExtrasJNI.btWorldImporter_createMeshInterface(this.swigCPtr, this, btStridingMeshInterfaceData.getCPtr(meshData), meshData);
        return cPtr == 0L ? null : new btTriangleIndexVertexArray(cPtr, false);
    }

    public btOptimizedBvh createOptimizedBvh() {
        long cPtr = ExtrasJNI.btWorldImporter_createOptimizedBvh(this.swigCPtr, this);
        return cPtr == 0L ? null : new btOptimizedBvh(cPtr, false);
    }

    public btTriangleInfoMap createTriangleInfoMap() {
        long cPtr = ExtrasJNI.btWorldImporter_createTriangleInfoMap(this.swigCPtr, this);
        return cPtr == 0L ? null : new btTriangleInfoMap(cPtr, false);
    }

    public btPoint2PointConstraint createPoint2PointConstraint(btRigidBody rbA, btRigidBody rbB, Vector3 pivotInA, Vector3 pivotInB) {
        long cPtr = ExtrasJNI.btWorldImporter_createPoint2PointConstraint__SWIG_0(this.swigCPtr, this, btRigidBody.getCPtr(rbA), rbA, btRigidBody.getCPtr(rbB), rbB, pivotInA, pivotInB);
        return cPtr == 0L ? null : new btPoint2PointConstraint(cPtr, false);
    }

    public btPoint2PointConstraint createPoint2PointConstraint(btRigidBody rbA, Vector3 pivotInA) {
        long cPtr = ExtrasJNI.btWorldImporter_createPoint2PointConstraint__SWIG_1(this.swigCPtr, this, btRigidBody.getCPtr(rbA), rbA, pivotInA);
        return cPtr == 0L ? null : new btPoint2PointConstraint(cPtr, false);
    }

    public btHingeConstraint createHingeConstraint(btRigidBody rbA, btRigidBody rbB, Matrix4 rbAFrame, Matrix4 rbBFrame, boolean useReferenceFrameA) {
        long cPtr = ExtrasJNI.btWorldImporter_createHingeConstraint__SWIG_0(this.swigCPtr, this, btRigidBody.getCPtr(rbA), rbA, btRigidBody.getCPtr(rbB), rbB, rbAFrame, rbBFrame, useReferenceFrameA);
        return cPtr == 0L ? null : new btHingeConstraint(cPtr, false);
    }

    public btHingeConstraint createHingeConstraint(btRigidBody rbA, btRigidBody rbB, Matrix4 rbAFrame, Matrix4 rbBFrame) {
        long cPtr = ExtrasJNI.btWorldImporter_createHingeConstraint__SWIG_1(this.swigCPtr, this, btRigidBody.getCPtr(rbA), rbA, btRigidBody.getCPtr(rbB), rbB, rbAFrame, rbBFrame);
        return cPtr == 0L ? null : new btHingeConstraint(cPtr, false);
    }

    public btHingeConstraint createHingeConstraint(btRigidBody rbA, Matrix4 rbAFrame, boolean useReferenceFrameA) {
        long cPtr = ExtrasJNI.btWorldImporter_createHingeConstraint__SWIG_2(this.swigCPtr, this, btRigidBody.getCPtr(rbA), rbA, rbAFrame, useReferenceFrameA);
        return cPtr == 0L ? null : new btHingeConstraint(cPtr, false);
    }

    public btHingeConstraint createHingeConstraint(btRigidBody rbA, Matrix4 rbAFrame) {
        long cPtr = ExtrasJNI.btWorldImporter_createHingeConstraint__SWIG_3(this.swigCPtr, this, btRigidBody.getCPtr(rbA), rbA, rbAFrame);
        return cPtr == 0L ? null : new btHingeConstraint(cPtr, false);
    }

    public btConeTwistConstraint createConeTwistConstraint(btRigidBody rbA, btRigidBody rbB, Matrix4 rbAFrame, Matrix4 rbBFrame) {
        long cPtr = ExtrasJNI.btWorldImporter_createConeTwistConstraint__SWIG_0(this.swigCPtr, this, btRigidBody.getCPtr(rbA), rbA, btRigidBody.getCPtr(rbB), rbB, rbAFrame, rbBFrame);
        return cPtr == 0L ? null : new btConeTwistConstraint(cPtr, false);
    }

    public btConeTwistConstraint createConeTwistConstraint(btRigidBody rbA, Matrix4 rbAFrame) {
        long cPtr = ExtrasJNI.btWorldImporter_createConeTwistConstraint__SWIG_1(this.swigCPtr, this, btRigidBody.getCPtr(rbA), rbA, rbAFrame);
        return cPtr == 0L ? null : new btConeTwistConstraint(cPtr, false);
    }

    public btGeneric6DofConstraint createGeneric6DofConstraint(btRigidBody rbA, btRigidBody rbB, Matrix4 frameInA, Matrix4 frameInB, boolean useLinearReferenceFrameA) {
        long cPtr = ExtrasJNI.btWorldImporter_createGeneric6DofConstraint__SWIG_0(this.swigCPtr, this, btRigidBody.getCPtr(rbA), rbA, btRigidBody.getCPtr(rbB), rbB, frameInA, frameInB, useLinearReferenceFrameA);
        return cPtr == 0L ? null : new btGeneric6DofConstraint(cPtr, false);
    }

    public btGeneric6DofConstraint createGeneric6DofConstraint(btRigidBody rbB, Matrix4 frameInB, boolean useLinearReferenceFrameB) {
        long cPtr = ExtrasJNI.btWorldImporter_createGeneric6DofConstraint__SWIG_1(this.swigCPtr, this, btRigidBody.getCPtr(rbB), rbB, frameInB, useLinearReferenceFrameB);
        return cPtr == 0L ? null : new btGeneric6DofConstraint(cPtr, false);
    }

    public btGeneric6DofSpringConstraint createGeneric6DofSpringConstraint(btRigidBody rbA, btRigidBody rbB, Matrix4 frameInA, Matrix4 frameInB, boolean useLinearReferenceFrameA) {
        long cPtr = ExtrasJNI.btWorldImporter_createGeneric6DofSpringConstraint(this.swigCPtr, this, btRigidBody.getCPtr(rbA), rbA, btRigidBody.getCPtr(rbB), rbB, frameInA, frameInB, useLinearReferenceFrameA);
        return cPtr == 0L ? null : new btGeneric6DofSpringConstraint(cPtr, false);
    }

    public btGeneric6DofSpring2Constraint createGeneric6DofSpring2Constraint(btRigidBody rbA, btRigidBody rbB, Matrix4 frameInA, Matrix4 frameInB, int rotateOrder) {
        long cPtr = ExtrasJNI.btWorldImporter_createGeneric6DofSpring2Constraint(this.swigCPtr, this, btRigidBody.getCPtr(rbA), rbA, btRigidBody.getCPtr(rbB), rbB, frameInA, frameInB, rotateOrder);
        return cPtr == 0L ? null : new btGeneric6DofSpring2Constraint(cPtr, false);
    }

    public btSliderConstraint createSliderConstraint(btRigidBody rbA, btRigidBody rbB, Matrix4 frameInA, Matrix4 frameInB, boolean useLinearReferenceFrameA) {
        long cPtr = ExtrasJNI.btWorldImporter_createSliderConstraint__SWIG_0(this.swigCPtr, this, btRigidBody.getCPtr(rbA), rbA, btRigidBody.getCPtr(rbB), rbB, frameInA, frameInB, useLinearReferenceFrameA);
        return cPtr == 0L ? null : new btSliderConstraint(cPtr, false);
    }

    public btSliderConstraint createSliderConstraint(btRigidBody rbB, Matrix4 frameInB, boolean useLinearReferenceFrameA) {
        long cPtr = ExtrasJNI.btWorldImporter_createSliderConstraint__SWIG_1(this.swigCPtr, this, btRigidBody.getCPtr(rbB), rbB, frameInB, useLinearReferenceFrameA);
        return cPtr == 0L ? null : new btSliderConstraint(cPtr, false);
    }

    public btGearConstraint createGearConstraint(btRigidBody rbA, btRigidBody rbB, Vector3 axisInA, Vector3 axisInB, float ratio) {
        long cPtr = ExtrasJNI.btWorldImporter_createGearConstraint(this.swigCPtr, this, btRigidBody.getCPtr(rbA), rbA, btRigidBody.getCPtr(rbB), rbB, axisInA, axisInB, ratio);
        return cPtr == 0L ? null : new btGearConstraint(cPtr, false);
    }
}

