/*
 * Decompiled with CFR 0.152.
 */
package com.badlogic.gdx.physics.bullet.dynamics;

import com.badlogic.gdx.math.Vector3;
import com.badlogic.gdx.physics.bullet.collision.btCollisionWorld;
import com.badlogic.gdx.physics.bullet.dynamics.DynamicsJNI;
import com.badlogic.gdx.physics.bullet.dynamics.SWIGTYPE_p_f_p_btDynamicsWorld_float__void;
import com.badlogic.gdx.physics.bullet.dynamics.btActionInterface;
import com.badlogic.gdx.physics.bullet.dynamics.btConstraintSolver;
import com.badlogic.gdx.physics.bullet.dynamics.btContactSolverInfo;
import com.badlogic.gdx.physics.bullet.dynamics.btRigidBody;
import com.badlogic.gdx.physics.bullet.dynamics.btTypedConstraint;

public class btDynamicsWorld
extends btCollisionWorld {
    private long swigCPtr;

    protected btDynamicsWorld(String className, long cPtr, boolean cMemoryOwn) {
        super(className, DynamicsJNI.btDynamicsWorld_SWIGUpcast(cPtr), cMemoryOwn);
        this.swigCPtr = cPtr;
    }

    public btDynamicsWorld(long cPtr, boolean cMemoryOwn) {
        this("btDynamicsWorld", cPtr, cMemoryOwn);
        this.construct();
    }

    @Override
    protected void reset(long cPtr, boolean cMemoryOwn) {
        if (!this.destroyed) {
            this.destroy();
        }
        this.swigCPtr = cPtr;
        super.reset(DynamicsJNI.btDynamicsWorld_SWIGUpcast(this.swigCPtr), cMemoryOwn);
    }

    public static long getCPtr(btDynamicsWorld obj) {
        return obj == null ? 0L : obj.swigCPtr;
    }

    @Override
    protected void finalize() throws Throwable {
        if (!this.destroyed) {
            this.destroy();
        }
        super.finalize();
    }

    @Override
    protected synchronized void delete() {
        if (this.swigCPtr != 0L) {
            if (this.swigCMemOwn) {
                this.swigCMemOwn = false;
                DynamicsJNI.delete_btDynamicsWorld(this.swigCPtr);
            }
            this.swigCPtr = 0L;
        }
        super.delete();
    }

    public int stepSimulation(float timeStep, int maxSubSteps, float fixedTimeStep) {
        return DynamicsJNI.btDynamicsWorld_stepSimulation__SWIG_0(this.swigCPtr, this, timeStep, maxSubSteps, fixedTimeStep);
    }

    public int stepSimulation(float timeStep, int maxSubSteps) {
        return DynamicsJNI.btDynamicsWorld_stepSimulation__SWIG_1(this.swigCPtr, this, timeStep, maxSubSteps);
    }

    public int stepSimulation(float timeStep) {
        return DynamicsJNI.btDynamicsWorld_stepSimulation__SWIG_2(this.swigCPtr, this, timeStep);
    }

    public void addConstraint(btTypedConstraint constraint, boolean disableCollisionsBetweenLinkedBodies) {
        DynamicsJNI.btDynamicsWorld_addConstraint__SWIG_0(this.swigCPtr, this, btTypedConstraint.getCPtr(constraint), constraint, disableCollisionsBetweenLinkedBodies);
    }

    public void addConstraint(btTypedConstraint constraint) {
        DynamicsJNI.btDynamicsWorld_addConstraint__SWIG_1(this.swigCPtr, this, btTypedConstraint.getCPtr(constraint), constraint);
    }

    public void removeConstraint(btTypedConstraint constraint) {
        DynamicsJNI.btDynamicsWorld_removeConstraint(this.swigCPtr, this, btTypedConstraint.getCPtr(constraint), constraint);
    }

    public void addAction(btActionInterface action) {
        DynamicsJNI.btDynamicsWorld_addAction(this.swigCPtr, this, btActionInterface.getCPtr(action), action);
    }

    public void removeAction(btActionInterface action) {
        DynamicsJNI.btDynamicsWorld_removeAction(this.swigCPtr, this, btActionInterface.getCPtr(action), action);
    }

    public void setGravity(Vector3 gravity) {
        DynamicsJNI.btDynamicsWorld_setGravity(this.swigCPtr, this, gravity);
    }

    public Vector3 getGravity() {
        return DynamicsJNI.btDynamicsWorld_getGravity(this.swigCPtr, this);
    }

    public void synchronizeMotionStates() {
        DynamicsJNI.btDynamicsWorld_synchronizeMotionStates(this.swigCPtr, this);
    }

    public void addRigidBody(btRigidBody body) {
        DynamicsJNI.btDynamicsWorld_addRigidBody__SWIG_0(this.swigCPtr, this, btRigidBody.getCPtr(body), body);
    }

    public void addRigidBody(btRigidBody body, int group, int mask) {
        DynamicsJNI.btDynamicsWorld_addRigidBody__SWIG_1(this.swigCPtr, this, btRigidBody.getCPtr(body), body, group, mask);
    }

    public void removeRigidBody(btRigidBody body) {
        DynamicsJNI.btDynamicsWorld_removeRigidBody(this.swigCPtr, this, btRigidBody.getCPtr(body), body);
    }

    public void setConstraintSolver(btConstraintSolver solver) {
        DynamicsJNI.btDynamicsWorld_setConstraintSolver(this.swigCPtr, this, btConstraintSolver.getCPtr(solver), solver);
    }

    public btConstraintSolver getConstraintSolver() {
        long cPtr = DynamicsJNI.btDynamicsWorld_getConstraintSolver(this.swigCPtr, this);
        return cPtr == 0L ? null : new btConstraintSolver(cPtr, false);
    }

    public int getNumConstraints() {
        return DynamicsJNI.btDynamicsWorld_getNumConstraints(this.swigCPtr, this);
    }

    public btTypedConstraint getConstraint(int index) {
        long cPtr = DynamicsJNI.btDynamicsWorld_getConstraint(this.swigCPtr, this, index);
        return cPtr == 0L ? null : new btTypedConstraint(cPtr, false);
    }

    public btTypedConstraint getConstraintConst(int index) {
        long cPtr = DynamicsJNI.btDynamicsWorld_getConstraintConst(this.swigCPtr, this, index);
        return cPtr == 0L ? null : new btTypedConstraint(cPtr, false);
    }

    public int getWorldType() {
        return DynamicsJNI.btDynamicsWorld_getWorldType(this.swigCPtr, this);
    }

    public void clearForces() {
        DynamicsJNI.btDynamicsWorld_clearForces(this.swigCPtr, this);
    }

    public void setInternalTickCallback(SWIGTYPE_p_f_p_btDynamicsWorld_float__void cb, long worldUserInfo, boolean isPreTick) {
        DynamicsJNI.btDynamicsWorld_setInternalTickCallback__SWIG_0(this.swigCPtr, this, SWIGTYPE_p_f_p_btDynamicsWorld_float__void.getCPtr(cb), worldUserInfo, isPreTick);
    }

    public void setInternalTickCallback(SWIGTYPE_p_f_p_btDynamicsWorld_float__void cb, long worldUserInfo) {
        DynamicsJNI.btDynamicsWorld_setInternalTickCallback__SWIG_1(this.swigCPtr, this, SWIGTYPE_p_f_p_btDynamicsWorld_float__void.getCPtr(cb), worldUserInfo);
    }

    public void setInternalTickCallback(SWIGTYPE_p_f_p_btDynamicsWorld_float__void cb) {
        DynamicsJNI.btDynamicsWorld_setInternalTickCallback__SWIG_2(this.swigCPtr, this, SWIGTYPE_p_f_p_btDynamicsWorld_float__void.getCPtr(cb));
    }

    public void setWorldUserInfo(long worldUserInfo) {
        DynamicsJNI.btDynamicsWorld_setWorldUserInfo(this.swigCPtr, this, worldUserInfo);
    }

    public long getWorldUserInfo() {
        return DynamicsJNI.btDynamicsWorld_getWorldUserInfo(this.swigCPtr, this);
    }

    public btContactSolverInfo getSolverInfo() {
        return new btContactSolverInfo(DynamicsJNI.btDynamicsWorld_getSolverInfo(this.swigCPtr, this), false);
    }

    public btContactSolverInfo getSolverInfoConst() {
        return new btContactSolverInfo(DynamicsJNI.btDynamicsWorld_getSolverInfoConst(this.swigCPtr, this), false);
    }

    public void addVehicle(btActionInterface vehicle) {
        DynamicsJNI.btDynamicsWorld_addVehicle(this.swigCPtr, this, btActionInterface.getCPtr(vehicle), vehicle);
    }

    public void removeVehicle(btActionInterface vehicle) {
        DynamicsJNI.btDynamicsWorld_removeVehicle(this.swigCPtr, this, btActionInterface.getCPtr(vehicle), vehicle);
    }

    public void addCharacter(btActionInterface character) {
        DynamicsJNI.btDynamicsWorld_addCharacter(this.swigCPtr, this, btActionInterface.getCPtr(character), character);
    }

    public void removeCharacter(btActionInterface character) {
        DynamicsJNI.btDynamicsWorld_removeCharacter(this.swigCPtr, this, btActionInterface.getCPtr(character), character);
    }
}

