/*
 * Decompiled with CFR 0.152.
 */
package com.badlogic.gdx.physics.bullet.dynamics;

import com.badlogic.gdx.math.Matrix3;
import com.badlogic.gdx.math.Matrix4;
import com.badlogic.gdx.math.Quaternion;
import com.badlogic.gdx.math.Vector3;
import com.badlogic.gdx.physics.bullet.collision.btCollisionObject;
import com.badlogic.gdx.physics.bullet.dynamics.DynamicsConstants;
import com.badlogic.gdx.physics.bullet.dynamics.DynamicsJNI;
import com.badlogic.gdx.physics.bullet.dynamics.SWIGTYPE_p_float;
import com.badlogic.gdx.physics.bullet.dynamics.btContactSolverInfo;
import com.badlogic.gdx.physics.bullet.dynamics.btDantzigScratchMemory;
import com.badlogic.gdx.physics.bullet.dynamics.btDynamicsWorld;
import com.badlogic.gdx.physics.bullet.dynamics.btRigidBody;
import com.badlogic.gdx.utils.Pool;
import java.nio.FloatBuffer;
import java.nio.IntBuffer;

public class Dynamics
implements DynamicsConstants {
    public static final Vector3 staticVector3 = new Vector3();
    public static final Pool<Vector3> poolVector3 = new Pool<Vector3>(){

        protected Vector3 newObject() {
            return new Vector3();
        }
    };
    public static final Quaternion staticQuaternion = new Quaternion();
    public static final Pool<Quaternion> poolQuaternion = new Pool<Quaternion>(){

        protected Quaternion newObject() {
            return new Quaternion();
        }
    };
    public static final Matrix3 staticMatrix3 = new Matrix3();
    public static final Pool<Matrix3> poolMatrix3 = new Pool<Matrix3>(){

        protected Matrix3 newObject() {
            return new Matrix3();
        }
    };
    public static final Matrix4 staticMatrix4 = new Matrix4();
    public static final Pool<Matrix4> poolMatrix4 = new Pool<Matrix4>(){

        protected Matrix4 newObject() {
            return new Matrix4();
        }
    };

    public static void setGDeactivationTime(float value) {
        DynamicsJNI.gDeactivationTime_set(value);
    }

    public static float getGDeactivationTime() {
        return DynamicsJNI.gDeactivationTime_get();
    }

    public static void setGDisableDeactivation(boolean value) {
        DynamicsJNI.gDisableDeactivation_set(value);
    }

    public static boolean getGDisableDeactivation() {
        return DynamicsJNI.gDisableDeactivation_get();
    }

    public static float btAdjustAngleToLimits(float angleInRadians, float angleLowerLimitInRadians, float angleUpperLimitInRadians) {
        return DynamicsJNI.btAdjustAngleToLimits(angleInRadians, angleLowerLimitInRadians, angleUpperLimitInRadians);
    }

    public static void InternalTickCallback_CB(btDynamicsWorld world, float timeStep) {
        DynamicsJNI.InternalTickCallback_CB(btDynamicsWorld.getCPtr(world), world, timeStep);
    }

    public static float resolveSingleCollision(btRigidBody body1, btCollisionObject colObj2, Vector3 contactPositionWorld, Vector3 contactNormalOnB, btContactSolverInfo solverInfo, float distance) {
        return DynamicsJNI.resolveSingleCollision(btRigidBody.getCPtr(body1), body1, btCollisionObject.getCPtr(colObj2), colObj2, contactPositionWorld, contactNormalOnB, btContactSolverInfo.getCPtr(solverInfo), solverInfo, distance);
    }

    public static void resolveSingleBilateral(btRigidBody body1, Vector3 pos1, btRigidBody body2, Vector3 pos2, float distance, Vector3 normal, SWIGTYPE_p_float impulse, float timeStep) {
        DynamicsJNI.resolveSingleBilateral(btRigidBody.getCPtr(body1), body1, pos1, btRigidBody.getCPtr(body2), body2, pos2, distance, normal, SWIGTYPE_p_float.getCPtr(impulse), timeStep);
    }

    public static boolean btSolveDantzigLCP(int n, FloatBuffer A, FloatBuffer x, FloatBuffer b, FloatBuffer w, int nub, FloatBuffer lo, FloatBuffer hi, IntBuffer findex, btDantzigScratchMemory scratch) {
        assert (A.isDirect()) : "Buffer must be allocated direct.";
        assert (x.isDirect()) : "Buffer must be allocated direct.";
        assert (b.isDirect()) : "Buffer must be allocated direct.";
        assert (w.isDirect()) : "Buffer must be allocated direct.";
        assert (lo.isDirect()) : "Buffer must be allocated direct.";
        assert (hi.isDirect()) : "Buffer must be allocated direct.";
        assert (findex.isDirect()) : "Buffer must be allocated direct.";
        return DynamicsJNI.btSolveDantzigLCP(n, A, x, b, w, nub, lo, hi, findex, btDantzigScratchMemory.getCPtr(scratch), scratch);
    }
}

