/*
 * Decompiled with CFR 0.152.
 */
package com.badlogic.gdx.physics.bullet.collision;

import com.badlogic.gdx.math.Matrix4;
import com.badlogic.gdx.math.Vector3;
import com.badlogic.gdx.physics.bullet.collision.CollisionJNI;
import com.badlogic.gdx.physics.bullet.collision.btCollisionShape;
import com.badlogic.gdx.physics.bullet.collision.btCompoundShapeChild;
import com.badlogic.gdx.physics.bullet.collision.btDbvt;
import com.badlogic.gdx.utils.Array;
import java.nio.FloatBuffer;

public class btCompoundShape
extends btCollisionShape {
    private long swigCPtr;
    protected Array<btCollisionShape> children = new Array();

    protected btCompoundShape(String className, long cPtr, boolean cMemoryOwn) {
        super(className, CollisionJNI.btCompoundShape_SWIGUpcast(cPtr), cMemoryOwn);
        this.swigCPtr = cPtr;
    }

    public btCompoundShape(long cPtr, boolean cMemoryOwn) {
        this("btCompoundShape", cPtr, cMemoryOwn);
        this.construct();
    }

    @Override
    protected void reset(long cPtr, boolean cMemoryOwn) {
        if (!this.destroyed) {
            this.destroy();
        }
        this.swigCPtr = cPtr;
        super.reset(CollisionJNI.btCompoundShape_SWIGUpcast(this.swigCPtr), cMemoryOwn);
    }

    public static long getCPtr(btCompoundShape obj) {
        return obj == null ? 0L : obj.swigCPtr;
    }

    @Override
    protected void finalize() throws Throwable {
        if (!this.destroyed) {
            this.destroy();
        }
        super.finalize();
    }

    @Override
    protected synchronized void delete() {
        if (this.swigCPtr != 0L) {
            if (this.swigCMemOwn) {
                this.swigCMemOwn = false;
                CollisionJNI.delete_btCompoundShape(this.swigCPtr);
            }
            this.swigCPtr = 0L;
        }
        super.delete();
    }

    public void addChildShape(Matrix4 localTransform, btCollisionShape shape) {
        this.internalAddChildShape(localTransform, shape);
        this.children.add((Object)shape);
        shape.obtain();
    }

    public void removeChildShape(btCollisionShape shape) {
        this.internalRemoveChildShape(shape);
        int idx = this.children.indexOf((Object)shape, false);
        if (idx >= 0) {
            ((btCollisionShape)this.children.removeIndex(idx)).release();
        }
    }

    public void removeChildShapeByIndex(int index) {
        this.internalRemoveChildShapeByIndex(index);
        ((btCollisionShape)this.children.removeIndex(index)).release();
    }

    public btCollisionShape getChildShape(int index) {
        return (btCollisionShape)this.children.get(index);
    }

    @Override
    public void dispose() {
        for (btCollisionShape child : this.children) {
            child.release();
        }
        this.children.clear();
        super.dispose();
    }

    @Override
    public long operatorNew(long sizeInBytes) {
        return CollisionJNI.btCompoundShape_operatorNew__SWIG_0(this.swigCPtr, this, sizeInBytes);
    }

    @Override
    public void operatorDelete(long ptr) {
        CollisionJNI.btCompoundShape_operatorDelete__SWIG_0(this.swigCPtr, this, ptr);
    }

    @Override
    public long operatorNew(long arg0, long ptr) {
        return CollisionJNI.btCompoundShape_operatorNew__SWIG_1(this.swigCPtr, this, arg0, ptr);
    }

    @Override
    public void operatorDelete(long arg0, long arg1) {
        CollisionJNI.btCompoundShape_operatorDelete__SWIG_1(this.swigCPtr, this, arg0, arg1);
    }

    @Override
    public long operatorNewArray(long sizeInBytes) {
        return CollisionJNI.btCompoundShape_operatorNewArray__SWIG_0(this.swigCPtr, this, sizeInBytes);
    }

    @Override
    public void operatorDeleteArray(long ptr) {
        CollisionJNI.btCompoundShape_operatorDeleteArray__SWIG_0(this.swigCPtr, this, ptr);
    }

    @Override
    public long operatorNewArray(long arg0, long ptr) {
        return CollisionJNI.btCompoundShape_operatorNewArray__SWIG_1(this.swigCPtr, this, arg0, ptr);
    }

    @Override
    public void operatorDeleteArray(long arg0, long arg1) {
        CollisionJNI.btCompoundShape_operatorDeleteArray__SWIG_1(this.swigCPtr, this, arg0, arg1);
    }

    public btCompoundShape(boolean enableDynamicAabbTree, int initialChildCapacity) {
        this(CollisionJNI.new_btCompoundShape__SWIG_0(enableDynamicAabbTree, initialChildCapacity), true);
    }

    public btCompoundShape(boolean enableDynamicAabbTree) {
        this(CollisionJNI.new_btCompoundShape__SWIG_1(enableDynamicAabbTree), true);
    }

    public btCompoundShape() {
        this(CollisionJNI.new_btCompoundShape__SWIG_2(), true);
    }

    private void internalAddChildShape(Matrix4 localTransform, btCollisionShape shape) {
        CollisionJNI.btCompoundShape_internalAddChildShape(this.swigCPtr, this, localTransform, btCollisionShape.getCPtr(shape), shape);
    }

    private void internalRemoveChildShape(btCollisionShape shape) {
        CollisionJNI.btCompoundShape_internalRemoveChildShape(this.swigCPtr, this, btCollisionShape.getCPtr(shape), shape);
    }

    private void internalRemoveChildShapeByIndex(int childShapeindex) {
        CollisionJNI.btCompoundShape_internalRemoveChildShapeByIndex(this.swigCPtr, this, childShapeindex);
    }

    public int getNumChildShapes() {
        return CollisionJNI.btCompoundShape_getNumChildShapes(this.swigCPtr, this);
    }

    public Matrix4 getChildTransform(int index) {
        return CollisionJNI.btCompoundShape_getChildTransform(this.swigCPtr, this, index);
    }

    public Matrix4 getChildTransformConst(int index) {
        return CollisionJNI.btCompoundShape_getChildTransformConst(this.swigCPtr, this, index);
    }

    public void updateChildTransform(int childIndex, Matrix4 newChildTransform, boolean shouldRecalculateLocalAabb) {
        CollisionJNI.btCompoundShape_updateChildTransform__SWIG_0(this.swigCPtr, this, childIndex, newChildTransform, shouldRecalculateLocalAabb);
    }

    public void updateChildTransform(int childIndex, Matrix4 newChildTransform) {
        CollisionJNI.btCompoundShape_updateChildTransform__SWIG_1(this.swigCPtr, this, childIndex, newChildTransform);
    }

    public btCompoundShapeChild getChildList() {
        long cPtr = CollisionJNI.btCompoundShape_getChildList(this.swigCPtr, this);
        return cPtr == 0L ? null : new btCompoundShapeChild(cPtr, false);
    }

    public void recalculateLocalAabb() {
        CollisionJNI.btCompoundShape_recalculateLocalAabb(this.swigCPtr, this);
    }

    public btDbvt getDynamicAabbTreeConst() {
        long cPtr = CollisionJNI.btCompoundShape_getDynamicAabbTreeConst(this.swigCPtr, this);
        return cPtr == 0L ? null : new btDbvt(cPtr, false);
    }

    public btDbvt getDynamicAabbTree() {
        long cPtr = CollisionJNI.btCompoundShape_getDynamicAabbTree(this.swigCPtr, this);
        return cPtr == 0L ? null : new btDbvt(cPtr, false);
    }

    public void createAabbTreeFromChildren() {
        CollisionJNI.btCompoundShape_createAabbTreeFromChildren(this.swigCPtr, this);
    }

    public void calculatePrincipalAxisTransform(FloatBuffer masses, Matrix4 principal, Vector3 inertia) {
        assert (masses.isDirect()) : "Buffer must be allocated direct.";
        CollisionJNI.btCompoundShape_calculatePrincipalAxisTransform(this.swigCPtr, this, masses, principal, inertia);
    }

    public int getUpdateRevision() {
        return CollisionJNI.btCompoundShape_getUpdateRevision(this.swigCPtr, this);
    }
}

