/*
 * Decompiled with CFR 0.152.
 */
package com.badlogic.gdx.physics.bullet.collision;

import com.badlogic.gdx.math.Vector3;
import com.badlogic.gdx.physics.bullet.BulletBase;
import com.badlogic.gdx.physics.bullet.collision.CollisionJNI;
import com.badlogic.gdx.physics.bullet.collision.LocalShapeInfo;
import com.badlogic.gdx.physics.bullet.collision.btCollisionObject;
import com.badlogic.gdx.physics.bullet.linearmath.btVector3;

public class LocalRayResult
extends BulletBase {
    private long swigCPtr;

    protected LocalRayResult(String className, long cPtr, boolean cMemoryOwn) {
        super(className, cPtr, cMemoryOwn);
        this.swigCPtr = cPtr;
    }

    public LocalRayResult(long cPtr, boolean cMemoryOwn) {
        this("LocalRayResult", cPtr, cMemoryOwn);
        this.construct();
    }

    @Override
    protected void reset(long cPtr, boolean cMemoryOwn) {
        if (!this.destroyed) {
            this.destroy();
        }
        this.swigCPtr = cPtr;
        super.reset(this.swigCPtr, cMemoryOwn);
    }

    public static long getCPtr(LocalRayResult obj) {
        return obj == null ? 0L : obj.swigCPtr;
    }

    @Override
    protected void finalize() throws Throwable {
        if (!this.destroyed) {
            this.destroy();
        }
        super.finalize();
    }

    @Override
    protected synchronized void delete() {
        if (this.swigCPtr != 0L) {
            if (this.swigCMemOwn) {
                this.swigCMemOwn = false;
                CollisionJNI.delete_LocalRayResult(this.swigCPtr);
            }
            this.swigCPtr = 0L;
        }
        super.delete();
    }

    public LocalRayResult(btCollisionObject collisionObject, LocalShapeInfo localShapeInfo, Vector3 hitNormalLocal, float hitFraction) {
        this(CollisionJNI.new_LocalRayResult(btCollisionObject.getCPtr(collisionObject), collisionObject, LocalShapeInfo.getCPtr(localShapeInfo), localShapeInfo, hitNormalLocal, hitFraction), true);
    }

    public void setCollisionObject(btCollisionObject value) {
        CollisionJNI.LocalRayResult_collisionObject_set(this.swigCPtr, this, btCollisionObject.getCPtr(value), value);
    }

    public btCollisionObject getCollisionObject() {
        return btCollisionObject.getInstance(CollisionJNI.LocalRayResult_collisionObject_get(this.swigCPtr, this), false);
    }

    public void setLocalShapeInfo(LocalShapeInfo value) {
        CollisionJNI.LocalRayResult_localShapeInfo_set(this.swigCPtr, this, LocalShapeInfo.getCPtr(value), value);
    }

    public LocalShapeInfo getLocalShapeInfo() {
        long cPtr = CollisionJNI.LocalRayResult_localShapeInfo_get(this.swigCPtr, this);
        return cPtr == 0L ? null : new LocalShapeInfo(cPtr, false);
    }

    public void setHitNormalLocal(btVector3 value) {
        CollisionJNI.LocalRayResult_hitNormalLocal_set(this.swigCPtr, this, btVector3.getCPtr(value), value);
    }

    public btVector3 getHitNormalLocal() {
        long cPtr = CollisionJNI.LocalRayResult_hitNormalLocal_get(this.swigCPtr, this);
        return cPtr == 0L ? null : new btVector3(cPtr, false);
    }

    public void setHitFraction(float value) {
        CollisionJNI.LocalRayResult_hitFraction_set(this.swigCPtr, this, value);
    }

    public float getHitFraction() {
        return CollisionJNI.LocalRayResult_hitFraction_get(this.swigCPtr, this);
    }
}

