/*
 * Decompiled with CFR 0.152.
 */
package com.badlogic.gdx.physics.bullet;

import com.badlogic.gdx.Gdx;
import com.badlogic.gdx.physics.bullet.Bullet;
import com.badlogic.gdx.utils.Disposable;

public class BulletBase
implements Disposable {
    private long cPointer;
    protected boolean swigCMemOwn;
    private boolean disposed;
    protected boolean destroyed;
    public final String className;
    private int refCount;

    protected BulletBase(String className, long cPtr, boolean cMemoryOwn) {
        this.className = className;
        this.swigCMemOwn = cMemoryOwn;
        this.cPointer = cPtr;
    }

    public void obtain() {
        ++this.refCount;
    }

    public void release() {
        if (--this.refCount <= 0 && Bullet.useRefCounting) {
            this.dispose();
        }
    }

    public boolean isObtained() {
        return this.refCount > 0;
    }

    protected void construct() {
        this.destroyed = false;
    }

    protected void reset(long cPtr, boolean cMemoryOwn) {
        if (!this.destroyed) {
            this.destroy();
        }
        this.swigCMemOwn = cMemoryOwn;
        this.cPointer = cPtr;
        this.construct();
    }

    public boolean equals(Object obj) {
        return obj instanceof BulletBase && ((BulletBase)obj).cPointer == this.cPointer;
    }

    public int hashCode() {
        return (int)this.cPointer;
    }

    public long getCPointer() {
        return this.cPointer;
    }

    public void takeOwnership() {
        this.swigCMemOwn = true;
    }

    public void releaseOwnership() {
        this.swigCMemOwn = false;
    }

    public boolean hasOwnership() {
        return this.swigCMemOwn;
    }

    protected void delete() {
        this.cPointer = 0L;
    }

    public void dispose() {
        if (this.refCount > 0 && Bullet.useRefCounting && Bullet.enableLogging) {
            Gdx.app.error("Bullet", "Disposing " + this.toString() + " while it still has " + this.refCount + " references.");
        }
        this.disposed = true;
        this.delete();
    }

    public boolean isDisposed() {
        return this.disposed;
    }

    public String toString() {
        return this.className + "(" + this.cPointer + "," + this.swigCMemOwn + ")";
    }

    protected void destroy() {
        try {
            if (this.destroyed && Bullet.enableLogging) {
                Gdx.app.error("Bullet", "Already destroyed " + this.toString());
            }
            this.destroyed = true;
            if (this.swigCMemOwn && !this.disposed) {
                if (Bullet.enableLogging) {
                    Gdx.app.error("Bullet", "Disposing " + this.toString() + " due to garbage collection.");
                }
                this.dispose();
            }
        }
        catch (Throwable e) {
            Gdx.app.error("Bullet", "Exception while destroying " + this.toString(), e);
        }
    }

    protected void finalize() throws Throwable {
        if (!this.destroyed && Bullet.enableLogging) {
            Gdx.app.error("Bullet", "The " + this.className + " class does not override the finalize method.");
        }
        super.finalize();
    }
}

