/*
 * Decompiled with CFR 0.152.
 */
package com.badlogic.gdx.sqlite.android;

import android.content.Context;
import android.database.Cursor;
import android.database.SQLException;
import android.database.sqlite.SQLiteDatabase;
import android.database.sqlite.SQLiteException;
import com.badlogic.gdx.Gdx;
import com.badlogic.gdx.backends.android.AndroidApplication;
import com.badlogic.gdx.sql.Database;
import com.badlogic.gdx.sql.DatabaseCursor;
import com.badlogic.gdx.sql.DatabaseManager;
import com.badlogic.gdx.sql.SQLiteGdxException;
import com.badlogic.gdx.sqlite.android.AndroidCursor;
import com.badlogic.gdx.sqlite.android.SQLiteDatabaseHelper;

public class AndroidDatabaseManager
implements DatabaseManager {
    private Context context;

    public AndroidDatabaseManager() {
        AndroidApplication app = (AndroidApplication)Gdx.app;
        this.context = app.getApplicationContext();
    }

    public Database getNewDatabase(String databaseName, int databaseVersion, String databaseCreateQuery, String dbOnUpgradeQuery) {
        return new AndroidDatabase(this.context, databaseName, databaseVersion, databaseCreateQuery, dbOnUpgradeQuery);
    }

    private class AndroidDatabase
    implements Database {
        private SQLiteDatabaseHelper helper;
        private SQLiteDatabase database;
        private Context context;
        private final String dbName;
        private final int dbVersion;
        private final String dbOnCreateQuery;
        private final String dbOnUpgradeQuery;

        private AndroidDatabase(Context context, String dbName, int dbVersion, String dbOnCreateQuery, String dbOnUpgradeQuery) {
            this.context = context;
            this.dbName = dbName;
            this.dbVersion = dbVersion;
            this.dbOnCreateQuery = dbOnCreateQuery;
            this.dbOnUpgradeQuery = dbOnUpgradeQuery;
        }

        public void setupDatabase() {
            this.helper = new SQLiteDatabaseHelper(this.context, this.dbName, null, this.dbVersion, this.dbOnCreateQuery, this.dbOnUpgradeQuery);
        }

        public void openOrCreateDatabase() throws SQLiteGdxException {
            try {
                this.database = this.helper.getWritableDatabase();
            }
            catch (SQLiteException e) {
                throw new SQLiteGdxException((Throwable)e);
            }
        }

        public void closeDatabase() throws SQLiteGdxException {
            try {
                this.helper.close();
            }
            catch (SQLiteException e) {
                throw new SQLiteGdxException((Throwable)e);
            }
        }

        public void execSQL(String sql) throws SQLiteGdxException {
            try {
                this.database.execSQL(sql);
            }
            catch (SQLException e) {
                throw new SQLiteGdxException((Throwable)e);
            }
        }

        public DatabaseCursor rawQuery(String sql) throws SQLiteGdxException {
            AndroidCursor aCursor = new AndroidCursor();
            try {
                Cursor tmp = this.database.rawQuery(sql, null);
                aCursor.setNativeCursor(tmp);
                return aCursor;
            }
            catch (SQLiteException e) {
                throw new SQLiteGdxException((Throwable)e);
            }
        }

        public DatabaseCursor rawQuery(DatabaseCursor cursor, String sql) throws SQLiteGdxException {
            AndroidCursor aCursor = (AndroidCursor)cursor;
            try {
                Cursor tmp = this.database.rawQuery(sql, null);
                aCursor.setNativeCursor(tmp);
                return aCursor;
            }
            catch (SQLiteException e) {
                throw new SQLiteGdxException((Throwable)e);
            }
        }
    }
}

