/*
 * Decompiled with CFR 0.152.
 */
package com.esotericsoftware.kryonet.rmi;

import com.esotericsoftware.kryo.Kryo;
import com.esotericsoftware.kryo.KryoException;
import com.esotericsoftware.kryo.KryoSerializable;
import com.esotericsoftware.kryo.Serializer;
import com.esotericsoftware.kryo.io.Input;
import com.esotericsoftware.kryo.io.Output;
import com.esotericsoftware.kryo.serializers.FieldSerializer;
import com.esotericsoftware.kryo.util.IntMap;
import com.esotericsoftware.kryo.util.Util;
import com.esotericsoftware.kryonet.Connection;
import com.esotericsoftware.kryonet.FrameworkMessage;
import com.esotericsoftware.kryonet.KryoNetException;
import com.esotericsoftware.kryonet.Listener;
import com.esotericsoftware.kryonet.rmi.RemoteObject;
import com.esotericsoftware.kryonet.rmi.TimeoutException;
import com.esotericsoftware.kryonet.util.ObjectIntMap;
import com.esotericsoftware.minlog.Log;
import com.esotericsoftware.reflectasm.MethodAccess;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.lang.reflect.Proxy;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.concurrent.Executor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.ReentrantLock;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ObjectSpace {
    private static final int returnValueMask = 128;
    private static final int returnExceptionMask = 64;
    private static final int responseIdMask = 63;
    private static final Object instancesLock = new Object();
    static ObjectSpace[] instances = new ObjectSpace[0];
    private static final HashMap<Class, CachedMethod[]> methodCache = new HashMap();
    private static boolean asm = true;
    final IntMap idToObject = new IntMap();
    final ObjectIntMap objectToID = new ObjectIntMap();
    Connection[] connections = new Connection[0];
    final Object connectionsLock = new Object();
    Executor executor;
    private final Listener invokeListener = new Listener(){

        public void received(final Connection connection, Object object) {
            if (!(object instanceof InvokeMethod)) {
                return;
            }
            if (ObjectSpace.this.connections != null) {
                int i;
                int n = ObjectSpace.this.connections.length;
                for (i = 0; i < n && connection != ObjectSpace.this.connections[i]; ++i) {
                }
                if (i == n) {
                    return;
                }
            }
            final InvokeMethod invokeMethod = (InvokeMethod)object;
            final Object target = ObjectSpace.this.idToObject.get(invokeMethod.objectID);
            if (target == null) {
                if (Log.WARN) {
                    Log.warn("kryonet", "Ignoring remote invocation request for unknown object ID: " + invokeMethod.objectID);
                }
                return;
            }
            if (ObjectSpace.this.executor == null) {
                ObjectSpace.this.invoke(connection, target, invokeMethod);
            } else {
                ObjectSpace.this.executor.execute(new Runnable(){

                    public void run() {
                        ObjectSpace.this.invoke(connection, target, invokeMethod);
                    }
                });
            }
        }

        public void disconnected(Connection connection) {
            ObjectSpace.this.removeConnection(connection);
        }
    };

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ObjectSpace() {
        Object object = instancesLock;
        synchronized (object) {
            ObjectSpace[] instances = ObjectSpace.instances;
            ObjectSpace[] newInstances = new ObjectSpace[instances.length + 1];
            newInstances[0] = this;
            System.arraycopy(instances, 0, newInstances, 1, instances.length);
            ObjectSpace.instances = newInstances;
        }
    }

    public ObjectSpace(Connection connection) {
        this();
        this.addConnection(connection);
    }

    public void setExecutor(Executor executor) {
        this.executor = executor;
    }

    public void register(int objectID, Object object) {
        if (objectID == Integer.MAX_VALUE) {
            throw new IllegalArgumentException("objectID cannot be Integer.MAX_VALUE.");
        }
        if (object == null) {
            throw new IllegalArgumentException("object cannot be null.");
        }
        this.idToObject.put(objectID, object);
        this.objectToID.put(object, objectID);
        if (Log.TRACE) {
            Log.trace("kryonet", "Object registered with ObjectSpace as " + objectID + ": " + object);
        }
    }

    public void remove(int objectID) {
        Object object = this.idToObject.remove(objectID);
        if (object != null) {
            this.objectToID.remove(object, 0);
        }
        if (Log.TRACE) {
            Log.trace("kryonet", "Object " + objectID + " removed from ObjectSpace: " + object);
        }
    }

    public void remove(Object object) {
        if (!this.idToObject.containsValue(object, true)) {
            return;
        }
        int objectID = this.idToObject.findKey(object, true, -1);
        this.idToObject.remove(objectID);
        this.objectToID.remove(object, 0);
        if (Log.TRACE) {
            Log.trace("kryonet", "Object " + objectID + " removed from ObjectSpace: " + object);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() {
        Connection[] connections = this.connections;
        for (int i = 0; i < connections.length; ++i) {
            connections[i].removeListener(this.invokeListener);
        }
        Object object = instancesLock;
        synchronized (object) {
            ArrayList<ObjectSpace> temp = new ArrayList<ObjectSpace>(Arrays.asList(instances));
            temp.remove(this);
            instances = temp.toArray(new ObjectSpace[temp.size()]);
        }
        if (Log.TRACE) {
            Log.trace("kryonet", "Closed ObjectSpace.");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addConnection(Connection connection) {
        if (connection == null) {
            throw new IllegalArgumentException("connection cannot be null.");
        }
        Object object = this.connectionsLock;
        synchronized (object) {
            Connection[] newConnections = new Connection[this.connections.length + 1];
            newConnections[0] = connection;
            System.arraycopy(this.connections, 0, newConnections, 1, this.connections.length);
            this.connections = newConnections;
        }
        connection.addListener(this.invokeListener);
        if (Log.TRACE) {
            Log.trace("kryonet", "Added connection to ObjectSpace: " + connection);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeConnection(Connection connection) {
        if (connection == null) {
            throw new IllegalArgumentException("connection cannot be null.");
        }
        connection.removeListener(this.invokeListener);
        Object object = this.connectionsLock;
        synchronized (object) {
            ArrayList<Connection> temp = new ArrayList<Connection>(Arrays.asList(this.connections));
            temp.remove(connection);
            this.connections = temp.toArray(new Connection[temp.size()]);
        }
        if (Log.TRACE) {
            Log.trace("kryonet", "Removed connection from ObjectSpace: " + connection);
        }
    }

    protected void invoke(Connection connection, Object target, InvokeMethod invokeMethod) {
        byte responseData;
        if (Log.DEBUG) {
            String argString = "";
            if (invokeMethod.args != null) {
                argString = Arrays.deepToString(invokeMethod.args);
                argString = argString.substring(1, argString.length() - 1);
            }
            Log.debug("kryonet", connection + " received: " + target.getClass().getSimpleName() + "#" + invokeMethod.cachedMethod.method.getName() + "(" + argString + ")");
        }
        boolean transmitReturnValue = ((responseData = invokeMethod.responseData) & 0x80) == 128;
        boolean transmitExceptions = (responseData & 0x40) == 64;
        int responseID = responseData & 0x3F;
        CachedMethod cachedMethod = invokeMethod.cachedMethod;
        Object result = null;
        try {
            result = cachedMethod.invoke(target, invokeMethod.args);
        }
        catch (InvocationTargetException ex) {
            if (transmitExceptions) {
                result = ex.getCause();
            }
            throw new KryoNetException("Error invoking method: " + cachedMethod.method.getDeclaringClass().getName() + "." + cachedMethod.method.getName(), ex);
        }
        catch (Exception ex) {
            throw new KryoNetException("Error invoking method: " + cachedMethod.method.getDeclaringClass().getName() + "." + cachedMethod.method.getName(), ex);
        }
        if (responseID == 0) {
            return;
        }
        InvokeMethodResult invokeMethodResult = new InvokeMethodResult();
        invokeMethodResult.objectID = invokeMethod.objectID;
        invokeMethodResult.responseID = (byte)responseID;
        invokeMethodResult.result = !transmitReturnValue && !invokeMethod.cachedMethod.method.getReturnType().isPrimitive() ? null : result;
        int length = connection.sendTCP(invokeMethodResult);
        if (Log.DEBUG) {
            Log.debug("kryonet", connection + " sent TCP: " + result + " (" + length + ")");
        }
    }

    public static <T> T getRemoteObject(Connection connection, int objectID, Class<T> iface) {
        return (T)ObjectSpace.getRemoteObject(connection, objectID, new Class[]{iface});
    }

    public static RemoteObject getRemoteObject(Connection connection, int objectID, Class ... ifaces) {
        if (connection == null) {
            throw new IllegalArgumentException("connection cannot be null.");
        }
        if (ifaces == null) {
            throw new IllegalArgumentException("ifaces cannot be null.");
        }
        Class[] temp = new Class[ifaces.length + 1];
        temp[0] = RemoteObject.class;
        System.arraycopy(ifaces, 0, temp, 1, ifaces.length);
        return (RemoteObject)Proxy.newProxyInstance(ObjectSpace.class.getClassLoader(), temp, (InvocationHandler)new RemoteInvocationHandler(connection, objectID));
    }

    static CachedMethod[] getMethods(Kryo kryo, Class type) {
        CachedMethod[] cachedMethods = methodCache.get(type);
        if (cachedMethods != null) {
            return cachedMethods;
        }
        ArrayList allMethods = new ArrayList();
        Class nextClass = type;
        while (nextClass != null) {
            Collections.addAll(allMethods, nextClass.getDeclaredMethods());
            if ((nextClass = nextClass.getSuperclass()) != Object.class) continue;
        }
        ArrayList<Method> methods = new ArrayList<Method>(Math.max(1, allMethods.size()));
        int n = allMethods.size();
        for (int i = 0; i < n; ++i) {
            Method method = (Method)allMethods.get(i);
            int modifiers = method.getModifiers();
            if (Modifier.isStatic(modifiers) || Modifier.isPrivate(modifiers) || method.isSynthetic()) continue;
            methods.add(method);
        }
        Collections.sort(methods, new Comparator<Method>(){

            @Override
            public int compare(Method o1, Method o2) {
                Class<?>[] argTypes2;
                int diff = o1.getName().compareTo(o2.getName());
                if (diff != 0) {
                    return diff;
                }
                Class<?>[] argTypes1 = o1.getParameterTypes();
                if (argTypes1.length > (argTypes2 = o2.getParameterTypes()).length) {
                    return 1;
                }
                if (argTypes1.length < argTypes2.length) {
                    return -1;
                }
                for (int i = 0; i < argTypes1.length; ++i) {
                    diff = argTypes1[i].getName().compareTo(argTypes2[i].getName());
                    if (diff == 0) continue;
                    return diff;
                }
                throw new RuntimeException("Two methods with same signature!");
            }
        });
        MethodAccess methodAccess = null;
        if (asm && !Util.isAndroid && Modifier.isPublic(type.getModifiers())) {
            methodAccess = MethodAccess.get(type);
        }
        n = methods.size();
        cachedMethods = new CachedMethod[n];
        for (int i = 0; i < n; ++i) {
            Method method = (Method)methods.get(i);
            Class[] parameterTypes = method.getParameterTypes();
            CachedMethod cachedMethod = null;
            if (methodAccess != null) {
                try {
                    AsmCachedMethod asmCachedMethod = new AsmCachedMethod();
                    asmCachedMethod.methodAccessIndex = methodAccess.getIndex(method.getName(), parameterTypes);
                    asmCachedMethod.methodAccess = methodAccess;
                    cachedMethod = asmCachedMethod;
                }
                catch (RuntimeException asmCachedMethod) {
                    // empty catch block
                }
            }
            if (cachedMethod == null) {
                cachedMethod = new CachedMethod();
            }
            cachedMethod.method = method;
            cachedMethod.methodClassID = kryo.getRegistration(method.getDeclaringClass()).getId();
            cachedMethod.methodIndex = i;
            cachedMethod.serializers = new Serializer[parameterTypes.length];
            int nn = parameterTypes.length;
            for (int ii = 0; ii < nn; ++ii) {
                if (!kryo.isFinal(parameterTypes[ii])) continue;
                cachedMethod.serializers[ii] = kryo.getSerializer(parameterTypes[ii]);
            }
            cachedMethods[i] = cachedMethod;
        }
        methodCache.put(type, cachedMethods);
        return cachedMethods;
    }

    static Object getRegisteredObject(Connection connection, int objectID) {
        for (ObjectSpace objectSpace : instances) {
            Connection[] connections = objectSpace.connections;
            for (int j = 0; j < connections.length; ++j) {
                Object object;
                if (connections[j] != connection || (object = objectSpace.idToObject.get(objectID)) == null) continue;
                return object;
            }
        }
        return null;
    }

    static int getRegisteredID(Connection connection, Object object) {
        for (ObjectSpace objectSpace : instances) {
            Connection[] connections = objectSpace.connections;
            for (int j = 0; j < connections.length; ++j) {
                int id;
                if (connections[j] != connection || (id = objectSpace.objectToID.get(object, Integer.MAX_VALUE)) == Integer.MAX_VALUE) continue;
                return id;
            }
        }
        return Integer.MAX_VALUE;
    }

    public static void registerClasses(Kryo kryo) {
        kryo.register(Object[].class);
        kryo.register(InvokeMethod.class);
        FieldSerializer<InvokeMethodResult> resultSerializer = new FieldSerializer<InvokeMethodResult>(kryo, InvokeMethodResult.class){

            @Override
            public void write(Kryo kryo, Output output, InvokeMethodResult result) {
                super.write(kryo, output, result);
                output.writeInt(result.objectID, true);
            }

            @Override
            public InvokeMethodResult read(Kryo kryo, Input input, Class<InvokeMethodResult> type) {
                InvokeMethodResult result = super.read(kryo, input, type);
                result.objectID = input.readInt(true);
                return result;
            }
        };
        resultSerializer.removeField("objectID");
        kryo.register(InvokeMethodResult.class, resultSerializer);
        kryo.register(InvocationHandler.class, new Serializer(){

            public void write(Kryo kryo, Output output, Object object) {
                RemoteInvocationHandler handler = (RemoteInvocationHandler)Proxy.getInvocationHandler(object);
                output.writeInt(handler.objectID, true);
            }

            public Object read(Kryo kryo, Input input, Class type) {
                int objectID = input.readInt(true);
                Connection connection = (Connection)kryo.getContext().get("connection");
                Object object = ObjectSpace.getRegisteredObject(connection, objectID);
                if (Log.WARN && object == null) {
                    Log.warn("kryonet", "Unknown object ID " + objectID + " for connection: " + connection);
                }
                return object;
            }
        });
    }

    public static void setAsm(boolean asm) {
        ObjectSpace.asm = asm;
    }

    public static class RemoteObjectSerializer
    extends Serializer {
        public void write(Kryo kryo, Output output, Object object) {
            Connection connection = (Connection)kryo.getContext().get("connection");
            int id = ObjectSpace.getRegisteredID(connection, object);
            if (id == Integer.MAX_VALUE) {
                throw new KryoNetException("Object not found in an ObjectSpace: " + object);
            }
            output.writeInt(id, true);
        }

        public Object read(Kryo kryo, Input input, Class type) {
            int objectID = input.readInt(true);
            Connection connection = (Connection)kryo.getContext().get("connection");
            return ObjectSpace.getRemoteObject(connection, objectID, type);
        }
    }

    static class AsmCachedMethod
    extends CachedMethod {
        MethodAccess methodAccess;
        int methodAccessIndex = -1;

        AsmCachedMethod() {
        }

        public Object invoke(Object target, Object[] args) throws IllegalAccessException, InvocationTargetException {
            try {
                return this.methodAccess.invoke(target, this.methodAccessIndex, args);
            }
            catch (Exception ex) {
                throw new InvocationTargetException(ex);
            }
        }
    }

    static class CachedMethod {
        Method method;
        int methodClassID;
        int methodIndex;
        Serializer[] serializers;

        CachedMethod() {
        }

        public Object invoke(Object target, Object[] args) throws IllegalAccessException, InvocationTargetException {
            return this.method.invoke(target, args);
        }
    }

    public static class InvokeMethodResult
    implements FrameworkMessage {
        public int objectID;
        public byte responseID;
        public Object result;
    }

    public static class InvokeMethod
    implements FrameworkMessage,
    KryoSerializable {
        public int objectID;
        public CachedMethod cachedMethod;
        public Object[] args;
        public byte responseData;

        public void write(Kryo kryo, Output output) {
            output.writeInt(this.objectID, true);
            output.writeInt(this.cachedMethod.methodClassID, true);
            output.writeByte(this.cachedMethod.methodIndex);
            Serializer[] serializers = this.cachedMethod.serializers;
            Object[] args = this.args;
            int n = serializers.length;
            for (int i = 0; i < n; ++i) {
                Serializer serializer = serializers[i];
                if (serializer != null) {
                    kryo.writeObjectOrNull(output, args[i], serializer);
                    continue;
                }
                kryo.writeClassAndObject(output, args[i]);
            }
            output.writeByte(this.responseData);
        }

        public void read(Kryo kryo, Input input) {
            this.objectID = input.readInt(true);
            int methodClassID = input.readInt(true);
            Class methodClass = kryo.getRegistration(methodClassID).getType();
            byte methodIndex = input.readByte();
            try {
                this.cachedMethod = ObjectSpace.getMethods(kryo, methodClass)[methodIndex];
            }
            catch (IndexOutOfBoundsException ex) {
                throw new KryoException("Invalid method index " + methodIndex + " for class: " + methodClass.getName());
            }
            Serializer[] serializers = this.cachedMethod.serializers;
            Class<?>[] parameterTypes = this.cachedMethod.method.getParameterTypes();
            Object[] args = new Object[serializers.length];
            this.args = args;
            int n = args.length;
            for (int i = 0; i < n; ++i) {
                Serializer serializer = serializers[i];
                args[i] = serializer != null ? kryo.readObjectOrNull(input, parameterTypes[i], serializer) : kryo.readClassAndObject(input);
            }
            this.responseData = input.readByte();
        }
    }

    private static class RemoteInvocationHandler
    implements InvocationHandler {
        private final Connection connection;
        final int objectID;
        private int timeoutMillis = 3000;
        private boolean nonBlocking;
        private boolean transmitReturnValue = true;
        private boolean transmitExceptions = true;
        private boolean remoteToString;
        private boolean udp;
        private Byte lastResponseID;
        private byte nextResponseId = 1;
        private Listener responseListener;
        final ReentrantLock lock = new ReentrantLock();
        final Condition responseCondition = this.lock.newCondition();
        final InvokeMethodResult[] responseTable = new InvokeMethodResult[64];
        final boolean[] pendingResponses = new boolean[64];

        public RemoteInvocationHandler(Connection connection, final int objectID) {
            this.connection = connection;
            this.objectID = objectID;
            this.responseListener = new Listener(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public void received(Connection connection, Object object) {
                    if (!(object instanceof InvokeMethodResult)) {
                        return;
                    }
                    InvokeMethodResult invokeMethodResult = (InvokeMethodResult)object;
                    if (invokeMethodResult.objectID != objectID) {
                        return;
                    }
                    byte responseID = invokeMethodResult.responseID;
                    1 var5_5 = this;
                    synchronized (var5_5) {
                        if (RemoteInvocationHandler.this.pendingResponses[responseID]) {
                            RemoteInvocationHandler.this.responseTable[responseID] = invokeMethodResult;
                        }
                    }
                    RemoteInvocationHandler.this.lock.lock();
                    try {
                        RemoteInvocationHandler.this.responseCondition.signalAll();
                    }
                    finally {
                        RemoteInvocationHandler.this.lock.unlock();
                    }
                }

                public void disconnected(Connection connection) {
                    RemoteInvocationHandler.this.close();
                }
            };
            connection.addListener(this.responseListener);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Object invoke(Object proxy, Method method, Object[] args) throws Exception {
            int n;
            Class<?> declaringClass = method.getDeclaringClass();
            if (declaringClass == RemoteObject.class) {
                String name = method.getName();
                if (name.equals("close")) {
                    this.close();
                    return null;
                }
                if (name.equals("setResponseTimeout")) {
                    this.timeoutMillis = (Integer)args[0];
                    return null;
                }
                if (name.equals("setNonBlocking")) {
                    this.nonBlocking = (Boolean)args[0];
                    return null;
                }
                if (name.equals("setTransmitReturnValue")) {
                    this.transmitReturnValue = (Boolean)args[0];
                    return null;
                }
                if (name.equals("setUDP")) {
                    this.udp = (Boolean)args[0];
                    return null;
                }
                if (name.equals("setTransmitExceptions")) {
                    this.transmitExceptions = (Boolean)args[0];
                    return null;
                }
                if (name.equals("setRemoteToString")) {
                    this.remoteToString = (Boolean)args[0];
                    return null;
                }
                if (name.equals("waitForLastResponse")) {
                    if (this.lastResponseID == null) {
                        throw new IllegalStateException("There is no last response to wait for.");
                    }
                    return this.waitForResponse(this.lastResponseID);
                }
                if (name.equals("getLastResponseID")) {
                    if (this.lastResponseID == null) {
                        throw new IllegalStateException("There is no last response ID.");
                    }
                    return this.lastResponseID;
                }
                if (name.equals("waitForResponse")) {
                    if (!this.transmitReturnValue && !this.transmitExceptions && this.nonBlocking) {
                        throw new IllegalStateException("This RemoteObject is currently set to ignore all responses.");
                    }
                    return this.waitForResponse((Byte)args[0]);
                }
                if (name.equals("getConnection")) {
                    return this.connection;
                }
                throw new KryoNetException("Invocation handler could not find RemoteObject method. Check ObjectSpace.java");
            }
            if (!this.remoteToString && declaringClass == Object.class && method.getName().equals("toString")) {
                return "<proxy>";
            }
            InvokeMethod invokeMethod = new InvokeMethod();
            invokeMethod.objectID = this.objectID;
            invokeMethod.args = args;
            for (CachedMethod cachedMethod : ObjectSpace.getMethods(this.connection.getEndPoint().getKryo(), method.getDeclaringClass())) {
                if (!cachedMethod.method.equals(method)) continue;
                invokeMethod.cachedMethod = cachedMethod;
                break;
            }
            if (invokeMethod.cachedMethod == null) {
                throw new KryoNetException("Method not found: " + method);
            }
            boolean needsResponse = !this.udp && (this.transmitReturnValue || this.transmitExceptions || !this.nonBlocking);
            byte responseID = 0;
            if (needsResponse) {
                byte by;
                byte by2;
                RemoteInvocationHandler remoteInvocationHandler = this;
                synchronized (remoteInvocationHandler) {
                    byte by3 = this.nextResponseId;
                    this.nextResponseId = (byte)(by3 + 1);
                    responseID = by3;
                    if (this.nextResponseId > 63) {
                        this.nextResponseId = 1;
                    }
                    this.pendingResponses[responseID] = true;
                }
                byte by4 = responseID;
                if (this.transmitReturnValue) {
                    by2 = (byte)(by4 | 0x80);
                }
                if (this.transmitExceptions) {
                    by = (byte)(by2 | 0x40);
                }
                invokeMethod.responseData = by;
            } else {
                invokeMethod.responseData = 0;
            }
            int n2 = n = this.udp ? this.connection.sendUDP(invokeMethod) : this.connection.sendTCP(invokeMethod);
            if (Log.DEBUG) {
                String argString = "";
                if (args != null) {
                    argString = Arrays.deepToString(args);
                    argString = argString.substring(1, argString.length() - 1);
                }
                Log.debug("kryonet", this.connection + " sent " + (this.udp ? "UDP" : "TCP") + ": " + method.getDeclaringClass().getSimpleName() + "#" + method.getName() + "(" + argString + ") (" + n + ")");
            }
            this.lastResponseID = (byte)(invokeMethod.responseData & 0x3F);
            if (this.nonBlocking || this.udp) {
                Class<?> returnType = method.getReturnType();
                if (returnType.isPrimitive()) {
                    if (returnType == Integer.TYPE) {
                        return 0;
                    }
                    if (returnType == Boolean.TYPE) {
                        return Boolean.FALSE;
                    }
                    if (returnType == Float.TYPE) {
                        return Float.valueOf(0.0f);
                    }
                    if (returnType == Character.TYPE) {
                        return Character.valueOf('\u0000');
                    }
                    if (returnType == Long.TYPE) {
                        return 0L;
                    }
                    if (returnType == Short.TYPE) {
                        return (short)0;
                    }
                    if (returnType == Byte.TYPE) {
                        return (byte)0;
                    }
                    if (returnType == Double.TYPE) {
                        return 0.0;
                    }
                }
                return null;
            }
            try {
                Object result = this.waitForResponse(this.lastResponseID);
                if (result != null && result instanceof Exception) {
                    throw (Exception)result;
                }
                Object object = result;
                return object;
            }
            catch (TimeoutException ex) {
                throw new TimeoutException("Response timed out: " + method.getDeclaringClass().getName() + "." + method.getName());
            }
            finally {
                RemoteInvocationHandler remoteInvocationHandler = this;
                synchronized (remoteInvocationHandler) {
                    this.pendingResponses[responseID] = false;
                    this.responseTable[responseID] = null;
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private Object waitForResponse(byte responseID) {
            if (this.connection.getEndPoint().getUpdateThread() == Thread.currentThread()) {
                throw new IllegalStateException("Cannot wait for an RMI response on the connection's update thread.");
            }
            long endTime = System.currentTimeMillis() + (long)this.timeoutMillis;
            while (true) {
                InvokeMethodResult invokeMethodResult;
                long remaining = endTime - System.currentTimeMillis();
                RemoteInvocationHandler remoteInvocationHandler = this;
                synchronized (remoteInvocationHandler) {
                    invokeMethodResult = this.responseTable[responseID];
                }
                if (invokeMethodResult != null) {
                    this.lastResponseID = null;
                    return invokeMethodResult.result;
                }
                if (remaining <= 0L) {
                    throw new TimeoutException("Response timed out.");
                }
                this.lock.lock();
                try {
                    this.responseCondition.await(remaining, TimeUnit.MILLISECONDS);
                    continue;
                }
                catch (InterruptedException e) {
                    Thread.currentThread().interrupt();
                    throw new KryoNetException(e);
                }
                finally {
                    this.lock.unlock();
                    continue;
                }
                break;
            }
        }

        void close() {
            this.connection.removeListener(this.responseListener);
        }
    }
}

