/*
 * Decompiled with CFR 0.152.
 */
package com.badlogic.gdx.sql;

import com.badlogic.gdx.Gdx;
import com.badlogic.gdx.sql.Database;
import com.badlogic.gdx.sql.DatabaseManager;
import com.badlogic.gdx.utils.GdxRuntimeException;

public class DatabaseFactory {
    public static final String ERROR_TAG = "DATABASE";
    private static final String androidClassname = "com.badlogic.gdx.sqlite.android.AndroidDatabaseManager";
    private static final String desktopClassname = "com.badlogic.gdx.sqlite.desktop.DesktopDatabaseManager";
    private static DatabaseManager databaseManager = null;

    public static Database getNewDatabase(String dbName, int dbVersion, String dbOnCreateQuery, String dbOnUpgradeQuery) {
        if (databaseManager == null) {
            switch (Gdx.app.getType()) {
                case Android: {
                    try {
                        databaseManager = (DatabaseManager)Class.forName(androidClassname).newInstance();
                        break;
                    }
                    catch (Throwable ex) {
                        throw new GdxRuntimeException("Error getting database: com.badlogic.gdx.sqlite.android.AndroidDatabaseManager", ex);
                    }
                }
                case Desktop: {
                    try {
                        databaseManager = (DatabaseManager)Class.forName(desktopClassname).newInstance();
                        break;
                    }
                    catch (Throwable ex) {
                        throw new GdxRuntimeException("Error getting database: com.badlogic.gdx.sqlite.desktop.DesktopDatabaseManager", ex);
                    }
                }
                case Applet: {
                    throw new GdxRuntimeException("SQLite is currently not supported in Applets by this libgdx extension.");
                }
                case WebGL: {
                    throw new GdxRuntimeException("SQLite is currently not supported in WebGL by this libgdx extension.");
                }
                case iOS: {
                    throw new GdxRuntimeException("SQLite is currently not supported in iOS by this libgdx extension.");
                }
            }
        }
        return databaseManager.getNewDatabase(dbName, dbVersion, dbOnCreateQuery, dbOnUpgradeQuery);
    }

    private DatabaseFactory() {
    }
}

