require 'spec_helper'

# This spec was generated by rspec-rails when you ran the scaffold generator.
# It demonstrates how one might use RSpec to specify the controller code that
# was generated by Rails when you ran the scaffold generator.
#
# It assumes that the implementation code is generated by the rails scaffold
# generator.  If you are using any extension libraries to generate different
# controller code, this generated spec may or may not pass.
#
# It only uses APIs available in rails and/or rspec-rails.  There are a number
# of tools you can use to make these specs even more expressive, but we're
# sticking to rails and rspec-rails APIs to keep things simple and stable.
#
# Compared to earlier versions of this generator, there is very limited use of
# stubs and message expectations in this spec.  Stubs are only used when there
# is no simpler way to get a handle on the object needed for the example.
# Message expectations are only used when there is no simpler way to specify
# that an instance is receiving a specific message.

describe DlLogEntriesController do

  # This should return the minimal set of attributes required to create a valid
  # DlLogEntry. As you add validations to DlLogEntry, be sure to
  # adjust the attributes here as well.
  let(:valid_attributes) { { "ident" => "MyString" } }

  # This should return the minimal set of values that should be in the session
  # in order to pass any filters (e.g. authentication) defined in
  # DlLogEntriesController. Be sure to keep this updated too.
  let(:valid_session) { {} }

  describe "GET index" do
    it "assigns all dl_log_entries as @dl_log_entries" do
      dl_log_entry = DlLogEntry.create! valid_attributes
      get :index, {}, valid_session
      assigns(:dl_log_entries).should eq([dl_log_entry])
    end
  end

  describe "GET show" do
    it "assigns the requested dl_log_entry as @dl_log_entry" do
      dl_log_entry = DlLogEntry.create! valid_attributes
      get :show, {:id => dl_log_entry.to_param}, valid_session
      assigns(:dl_log_entry).should eq(dl_log_entry)
    end
  end

  describe "GET new" do
    it "assigns a new dl_log_entry as @dl_log_entry" do
      get :new, {}, valid_session
      assigns(:dl_log_entry).should be_a_new(DlLogEntry)
    end
  end

  describe "GET edit" do
    it "assigns the requested dl_log_entry as @dl_log_entry" do
      dl_log_entry = DlLogEntry.create! valid_attributes
      get :edit, {:id => dl_log_entry.to_param}, valid_session
      assigns(:dl_log_entry).should eq(dl_log_entry)
    end
  end

  describe "POST create" do
    describe "with valid params" do
      it "creates a new DlLogEntry" do
        expect {
          post :create, {:dl_log_entry => valid_attributes}, valid_session
        }.to change(DlLogEntry, :count).by(1)
      end

      it "assigns a newly created dl_log_entry as @dl_log_entry" do
        post :create, {:dl_log_entry => valid_attributes}, valid_session
        assigns(:dl_log_entry).should be_a(DlLogEntry)
        assigns(:dl_log_entry).should be_persisted
      end

      it "redirects to the created dl_log_entry" do
        post :create, {:dl_log_entry => valid_attributes}, valid_session
        response.should redirect_to(DlLogEntry.last)
      end
    end

    describe "with invalid params" do
      it "assigns a newly created but unsaved dl_log_entry as @dl_log_entry" do
        # Trigger the behavior that occurs when invalid params are submitted
        DlLogEntry.any_instance.stub(:save).and_return(false)
        post :create, {:dl_log_entry => { "ident" => "invalid value" }}, valid_session
        assigns(:dl_log_entry).should be_a_new(DlLogEntry)
      end

      it "re-renders the 'new' template" do
        # Trigger the behavior that occurs when invalid params are submitted
        DlLogEntry.any_instance.stub(:save).and_return(false)
        post :create, {:dl_log_entry => { "ident" => "invalid value" }}, valid_session
        response.should render_template("new")
      end
    end
  end

  describe "PUT update" do
    describe "with valid params" do
      it "updates the requested dl_log_entry" do
        dl_log_entry = DlLogEntry.create! valid_attributes
        # Assuming there are no other dl_log_entries in the database, this
        # specifies that the DlLogEntry created on the previous line
        # receives the :update_attributes message with whatever params are
        # submitted in the request.
        DlLogEntry.any_instance.should_receive(:update).with({ "ident" => "MyString" })
        put :update, {:id => dl_log_entry.to_param, :dl_log_entry => { "ident" => "MyString" }}, valid_session
      end

      it "assigns the requested dl_log_entry as @dl_log_entry" do
        dl_log_entry = DlLogEntry.create! valid_attributes
        put :update, {:id => dl_log_entry.to_param, :dl_log_entry => valid_attributes}, valid_session
        assigns(:dl_log_entry).should eq(dl_log_entry)
      end

      it "redirects to the dl_log_entry" do
        dl_log_entry = DlLogEntry.create! valid_attributes
        put :update, {:id => dl_log_entry.to_param, :dl_log_entry => valid_attributes}, valid_session
        response.should redirect_to(dl_log_entry)
      end
    end

    describe "with invalid params" do
      it "assigns the dl_log_entry as @dl_log_entry" do
        dl_log_entry = DlLogEntry.create! valid_attributes
        # Trigger the behavior that occurs when invalid params are submitted
        DlLogEntry.any_instance.stub(:save).and_return(false)
        put :update, {:id => dl_log_entry.to_param, :dl_log_entry => { "ident" => "invalid value" }}, valid_session
        assigns(:dl_log_entry).should eq(dl_log_entry)
      end

      it "re-renders the 'edit' template" do
        dl_log_entry = DlLogEntry.create! valid_attributes
        # Trigger the behavior that occurs when invalid params are submitted
        DlLogEntry.any_instance.stub(:save).and_return(false)
        put :update, {:id => dl_log_entry.to_param, :dl_log_entry => { "ident" => "invalid value" }}, valid_session
        response.should render_template("edit")
      end
    end
  end

  describe "DELETE destroy" do
    it "destroys the requested dl_log_entry" do
      dl_log_entry = DlLogEntry.create! valid_attributes
      expect {
        delete :destroy, {:id => dl_log_entry.to_param}, valid_session
      }.to change(DlLogEntry, :count).by(-1)
    end

    it "redirects to the dl_log_entries list" do
      dl_log_entry = DlLogEntry.create! valid_attributes
      delete :destroy, {:id => dl_log_entry.to_param}, valid_session
      response.should redirect_to(dl_log_entries_url)
    end
  end

end
