class NaviVoicesController < ApplicationController
  before_action :set_navi_voice, only: [:show, :edit, :update, :destroy, :ini, :preview, :archive]

  # GET /navi_voices
  # GET /navi_voices.json
  def index
    @navi_voices = NaviVoice.page(params[:page])
    if params[:order] == 'rating'
      @navi_voices = @navi_voices.reorder('rating desc, id desc')
    elsif params[:order] == 'dlcount'
      @navi_voices = @navi_voices.reorder('dlcount desc, id desc')
    end
    if !params[:q].blank?
      q = "%#{params[:q]}%"
      @navi_voices = @navi_voices.where('title like ? or description like ?', q, q)
    end
    respond_with @navi_voices
  end

  # GET /navi_voices/1
  # GET /navi_voices/1.json
  def show
  end

  # GET /navi_voices/new
  def new
    @navi_voice = NaviVoice.new
    @navi_voice.lang = request.env['HTTP_ACCEPT_LANGUAGE'].to_s.scan(/^[a-z]{2}/).first
    respond_with @navi_voice
  end

  # GET /navi_voices/1/edit
  def edit
  end

  # POST /navi_voices
  # POST /navi_voices.json
  def create
    @navi_voice = NaviVoice.new(navi_voice_params)
    @navi_voice.save
    respond_with @navi_voice, location: navi_voices_path
  end

  # PATCH/PUT /navi_voices/1
  # PATCH/PUT /navi_voices/1.json
  def update
    raise_error_403
    @navi_voice.update(navi_voice_params)
    respond_with @navi_voice
  end

  # DELETE /navi_voices/1
  # DELETE /navi_voices/1.json
  def destroy
    if @navi_voice.delete_key_valid?(params[:delete_key])
      logger.info "Delete NaviVoice ##{@navi_voice.id}, from #{request.remote_ip})"
      @navi_voice.destroy
    else
      @navi_voice.errors[:delete_key] << 'is not matched.'
      logger.info "Delete denied: Key validation failed for ##{@navi_voice.id}, from #{request.remote_ip}"
    end
    respond_with(@navi_voice)
  end

  def ini
    render content_type: 'text/plain', layout: false, text: @navi_voice.to_ini
  end

  def preview
    redirect_to @navi_voice.archive.url(:preview_ogg)
  end

  def archive
    redirect_to @navi_voice.archive.url
  end

  private
    # Use callbacks to share common setup or constraints between actions.
    def set_navi_voice
      @navi_voice = NaviVoice.find(params[:id])
    end

    # Never trust parameters from the scary internet, only allow the white list through.
    def navi_voice_params
      params.require(:navi_voice).permit(:title, :archive, :description, :unit, :lang, :author, :raw_delete_key, :tos_agree)
    end
end
