namespace :update_dlcount do
  desc 'Update all download count of NaviVoice'
  task :all => :environment do
    NaviVoice.all.each do |nv|
      nv.update_dlcount
    end
  end
  task :recent => :environment do
    nvids = DlLogEntry.where('created_at > ?', Time.now - 1.day).
      group(:navi_voice_id).map {|n| n.navi_voice_id }
    nvids.blank? and next
    NaviVoice.where(id: nvids).each do |nv|
      nv.update_dlcount
    end
  end
end

desc 'Update all download count of NaviVoice'
task :update_dlcount => 'update_dlcount:recent'
