﻿using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Drawing;
using System.Data;
using System.Linq;
using System.Text;
using System.Windows.Forms;
using MikuMikuPlugin;

namespace MMM_GraphEditor
{
    public partial class FrameRuler : UserControl
    {
        public FrameRuler()
        {
            InitializeComponent();
        }

        private void mouse_down(object sender, MouseEventArgs e)
        {
            Scene s = null;
            float frame_width = 12.0f;
            try
            {
                s = ((GraphEditorControl)this.Parent.Parent).Scene;
                frame_width = ((GraphEditorControl)this.Parent.Parent).graphPort1.frame_width;
            }
            catch (System.Exception)
            {
                return;
            }
            if (e.Button == System.Windows.Forms.MouseButtons.Left && s != null)
            {
                s.MarkerPosition = (long)Math.Round((e.Location.X + 0.5f) / frame_width);
            }
        }

        private void key_down(object sender, PreviewKeyDownEventArgs e)
        {
            try {
                ((GraphEditorControl)this.Parent.Parent).graphPort1.key_down(sender, e);
            } catch (System.Exception) {
                // ignore
            }
        }
    }
}
