/*
 * Decompiled with CFR 0.152.
 */
package net.arnx.jsonic;

import java.io.BufferedWriter;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.Serializable;
import java.io.Writer;
import java.lang.reflect.Constructor;
import java.lang.reflect.Member;
import java.lang.reflect.Modifier;
import java.lang.reflect.Type;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.net.URI;
import java.net.URL;
import java.nio.charset.Charset;
import java.sql.Array;
import java.sql.Struct;
import java.sql.Time;
import java.sql.Timestamp;
import java.text.DateFormat;
import java.text.MessageFormat;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.Date;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.IdentityHashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Properties;
import java.util.RandomAccess;
import java.util.ResourceBundle;
import java.util.Set;
import java.util.SortedMap;
import java.util.SortedSet;
import java.util.TimeZone;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.UUID;
import java.util.regex.Pattern;
import net.arnx.jsonic.AppendableConverter;
import net.arnx.jsonic.ArrayConverter;
import net.arnx.jsonic.BigDecimalConverter;
import net.arnx.jsonic.BigIntegerConverter;
import net.arnx.jsonic.BooleanArrayFormatter;
import net.arnx.jsonic.BooleanConverter;
import net.arnx.jsonic.ByteArrayFormatter;
import net.arnx.jsonic.ByteConverter;
import net.arnx.jsonic.ByteFormatter;
import net.arnx.jsonic.CalendarConverter;
import net.arnx.jsonic.CalendarFormatter;
import net.arnx.jsonic.CharArrayFormatter;
import net.arnx.jsonic.CharSequenceConverter;
import net.arnx.jsonic.CharacterConverter;
import net.arnx.jsonic.CharacterDataFormatter;
import net.arnx.jsonic.CharsetConverter;
import net.arnx.jsonic.CharsetFormatter;
import net.arnx.jsonic.ClassConverter;
import net.arnx.jsonic.ClassFormatter;
import net.arnx.jsonic.CollectionConverter;
import net.arnx.jsonic.Converter;
import net.arnx.jsonic.DOMDocumentFormatter;
import net.arnx.jsonic.DOMElementFormatter;
import net.arnx.jsonic.DateConverter;
import net.arnx.jsonic.DateFormatter;
import net.arnx.jsonic.DoubleArrayFormatter;
import net.arnx.jsonic.DoubleConverter;
import net.arnx.jsonic.DynaBeanFormatter;
import net.arnx.jsonic.EnumConverter;
import net.arnx.jsonic.EnumFormatter;
import net.arnx.jsonic.EnumerationFormatter;
import net.arnx.jsonic.FileConverter;
import net.arnx.jsonic.FloatArrayFormatter;
import net.arnx.jsonic.FloatConverter;
import net.arnx.jsonic.FloatFormatter;
import net.arnx.jsonic.FormatConverter;
import net.arnx.jsonic.Formatter;
import net.arnx.jsonic.InetAddressConverter;
import net.arnx.jsonic.InetAddressFormatter;
import net.arnx.jsonic.IntArrayFormatter;
import net.arnx.jsonic.IntegerConverter;
import net.arnx.jsonic.IterableFormatter;
import net.arnx.jsonic.IteratorFormatter;
import net.arnx.jsonic.JSONException;
import net.arnx.jsonic.JSONHint;
import net.arnx.jsonic.JSONReader;
import net.arnx.jsonic.ListFormatter;
import net.arnx.jsonic.LocaleConverter;
import net.arnx.jsonic.LocaleFormatter;
import net.arnx.jsonic.LongArrayFormatter;
import net.arnx.jsonic.LongConverter;
import net.arnx.jsonic.MapConverter;
import net.arnx.jsonic.MapFormatter;
import net.arnx.jsonic.NamingStyle;
import net.arnx.jsonic.NullConverter;
import net.arnx.jsonic.NullFormatter;
import net.arnx.jsonic.NumberFormatter;
import net.arnx.jsonic.ObjectArrayFormatter;
import net.arnx.jsonic.ObjectConverter;
import net.arnx.jsonic.ObjectFormatter;
import net.arnx.jsonic.PatternConverter;
import net.arnx.jsonic.PlainConverter;
import net.arnx.jsonic.PlainFormatter;
import net.arnx.jsonic.PropertiesConverter;
import net.arnx.jsonic.SQLArrayFormatter;
import net.arnx.jsonic.SerializableConverter;
import net.arnx.jsonic.SerializableFormatter;
import net.arnx.jsonic.ShortArrayFormatter;
import net.arnx.jsonic.ShortConverter;
import net.arnx.jsonic.StringFormatter;
import net.arnx.jsonic.StringSerializableConverter;
import net.arnx.jsonic.StructFormmatter;
import net.arnx.jsonic.TimeZoneConverter;
import net.arnx.jsonic.TimeZoneFormatter;
import net.arnx.jsonic.TypeReference;
import net.arnx.jsonic.URIConverter;
import net.arnx.jsonic.URLConverter;
import net.arnx.jsonic.UUIDConverter;
import net.arnx.jsonic.io.AppendableOutputSource;
import net.arnx.jsonic.io.CharSequenceInputSource;
import net.arnx.jsonic.io.OutputSource;
import net.arnx.jsonic.io.ReaderInputSource;
import net.arnx.jsonic.io.StringBufferInputSource;
import net.arnx.jsonic.io.StringBuilderInputSource;
import net.arnx.jsonic.io.StringBuilderOutputSource;
import net.arnx.jsonic.io.StringInputSource;
import net.arnx.jsonic.io.WriterOutputSource;
import net.arnx.jsonic.util.ClassUtil;
import net.arnx.jsonic.util.LocalCache;
import org.w3c.dom.CharacterData;
import org.w3c.dom.Comment;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JSON {
    public static volatile Class<? extends JSON> prototype = JSON.class;
    private static final Map<Class<?>, Formatter> FORMAT_MAP = new HashMap(50);
    private static final Map<Class<?>, Converter> CONVERT_MAP = new HashMap(50);
    Object contextObject;
    Locale locale = Locale.getDefault();
    TimeZone timeZone = TimeZone.getDefault();
    boolean prettyPrint = false;
    int initialIndent = 0;
    String indentText = "\t";
    int maxDepth = 32;
    boolean suppressNull = false;
    Mode mode = Mode.TRADITIONAL;
    String dateFormat;
    String numberFormat;
    NamingStyle propertyStyle = NamingStyle.NOOP;
    NamingStyle enumStyle = NamingStyle.NOOP;

    static JSON newInstance() {
        JSON instance = null;
        try {
            instance = prototype.newInstance();
        }
        catch (Exception e) {
            throw new IllegalStateException(e);
        }
        return instance;
    }

    public static String encode(Object source) throws JSONException {
        return JSON.encode(source, false);
    }

    public static String encode(Object source, boolean prettyPrint) throws JSONException {
        JSON json = JSON.newInstance();
        json.setPrettyPrint(prettyPrint);
        return json.format(source);
    }

    public static void encode(Object source, OutputStream out) throws IOException, JSONException {
        JSON.newInstance().format(source, new OutputStreamWriter(out, "UTF-8"));
    }

    public static void encode(Object source, OutputStream out, boolean prettyPrint) throws IOException, JSONException {
        JSON json = JSON.newInstance();
        json.setPrettyPrint(prettyPrint);
        json.format(source, new OutputStreamWriter(out, "UTF-8"));
    }

    public static void encode(Object source, Appendable appendable) throws IOException, JSONException {
        JSON.newInstance().format(source, appendable);
    }

    public static void encode(Object source, Appendable appendable, boolean prettyPrint) throws IOException, JSONException {
        JSON json = JSON.newInstance();
        json.setPrettyPrint(prettyPrint);
        json.format(source, appendable);
    }

    public static String escapeScript(Object source) throws JSONException {
        JSON json = JSON.newInstance();
        json.setMode(Mode.SCRIPT);
        return json.format(source);
    }

    public static void escapeScript(Object source, OutputStream out) throws IOException, JSONException {
        JSON json = JSON.newInstance();
        json.setMode(Mode.SCRIPT);
        json.format(source, out);
    }

    public static void escapeScript(Object source, Appendable appendable) throws IOException, JSONException {
        JSON json = JSON.newInstance();
        json.setMode(Mode.SCRIPT);
        json.format(source, appendable);
    }

    public static <T> T decode(String source) throws JSONException {
        return JSON.newInstance().parse(source);
    }

    public static <T> T decode(String source, Class<? extends T> cls) throws JSONException {
        return JSON.newInstance().parse((CharSequence)source, cls);
    }

    public static <T> T decode(String source, Type type) throws JSONException {
        return JSON.newInstance().parse((CharSequence)source, type);
    }

    public static <T> T decode(InputStream in) throws IOException, JSONException {
        return JSON.newInstance().parse(in);
    }

    public static <T> T decode(InputStream in, Class<? extends T> cls) throws IOException, JSONException {
        return JSON.newInstance().parse(in, cls);
    }

    public static <T> T decode(InputStream in, Type type) throws IOException, JSONException {
        return JSON.newInstance().parse(in, type);
    }

    public static <T> T decode(Reader reader) throws IOException, JSONException {
        return JSON.newInstance().parse(reader);
    }

    public static <T> T decode(Reader reader, Class<? extends T> cls) throws IOException, JSONException {
        return JSON.newInstance().parse(reader, cls);
    }

    public static <T> T decode(Reader reader, Type type) throws IOException, JSONException {
        return JSON.newInstance().parse(reader, type);
    }

    public static void validate(CharSequence cs) throws JSONException {
        JSON json = JSON.newInstance();
        json.setMode(Mode.STRICT);
        json.setMaxDepth(0);
        json.parse(cs);
    }

    public static void validate(InputStream in) throws IOException, JSONException {
        JSON json = JSON.newInstance();
        json.setMode(Mode.STRICT);
        json.setMaxDepth(0);
        json.parse(in);
    }

    public static void validate(Reader reader) throws IOException, JSONException {
        JSON json = JSON.newInstance();
        json.setMode(Mode.STRICT);
        json.setMaxDepth(0);
        json.parse(reader);
    }

    public JSON() {
    }

    public JSON(int maxDepth) {
        this.setMaxDepth(maxDepth);
    }

    public JSON(Mode mode) {
        this.setMode(mode);
    }

    public void setContext(Object value) {
        this.contextObject = value;
    }

    public void setLocale(Locale locale) {
        if (locale == null) {
            throw new NullPointerException();
        }
        this.locale = locale;
    }

    public void setTimeZone(TimeZone timeZone) {
        if (timeZone == null) {
            throw new NullPointerException();
        }
        this.timeZone = timeZone;
    }

    public void setPrettyPrint(boolean value) {
        this.prettyPrint = value;
    }

    public void setInitialIndent(int indent) {
        if (indent < 0) {
            throw new IllegalArgumentException(this.getMessage("json.TooSmallArgumentError", "initialIndent", 0));
        }
        this.initialIndent = indent;
    }

    public void setIndentText(String text) {
        this.indentText = text;
    }

    public void setMaxDepth(int value) {
        if (value < 0) {
            throw new IllegalArgumentException(this.getMessage("json.TooSmallArgumentError", "maxDepth", 0));
        }
        this.maxDepth = value;
    }

    public int getMaxDepth() {
        return this.maxDepth;
    }

    public void setSuppressNull(boolean value) {
        this.suppressNull = value;
    }

    public void setMode(Mode mode) {
        if (mode == null) {
            throw new NullPointerException();
        }
        this.mode = mode;
    }

    public Mode getMode() {
        return this.mode;
    }

    public void setDateFormat(String format) {
        this.dateFormat = format;
    }

    public void setNumberFormat(String format) {
        this.numberFormat = format;
    }

    public void setPropertyStyle(NamingStyle style) {
        this.propertyStyle = style;
    }

    public void setEnumStyle(NamingStyle style) {
        this.enumStyle = style;
    }

    public String format(Object source) {
        String text = null;
        try {
            text = this.format(source, new StringBuilder(1000)).toString();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return text;
    }

    public OutputStream format(Object source, OutputStream out) throws IOException {
        this.format(source, new BufferedWriter(new OutputStreamWriter(out, "UTF-8")));
        return out;
    }

    public Appendable format(Object source, Appendable ap) throws IOException {
        Context context = new Context();
        OutputSource fs = ap instanceof Writer ? new WriterOutputSource((Writer)ap) : (ap instanceof StringBuilder ? new StringBuilderOutputSource((StringBuilder)ap) : new AppendableOutputSource(ap));
        context.enter(Character.valueOf('$'), null);
        source = context.preformatInternal(source);
        if (context.isPrettyPrint() && context.getInitialIndent() > 0) {
            int indent = context.getInitialIndent();
            for (int j = 0; j < indent; ++j) {
                ap.append(context.getIndentText());
            }
        }
        context.formatInternal(source, fs);
        context.exit();
        fs.flush();
        return ap;
    }

    protected Object preformat(Context context, Object value) throws Exception {
        return value;
    }

    public <T> T parse(CharSequence cs) throws JSONException {
        CharSequenceInputSource is = cs instanceof String ? new StringInputSource((String)cs) : (cs instanceof StringBuilder ? new StringBuilderInputSource((StringBuilder)cs) : (cs instanceof StringBuffer ? new StringBufferInputSource((StringBuffer)cs) : new CharSequenceInputSource(cs)));
        Object value = null;
        try {
            JSONReader jreader = new JSONReader(new Context(), is, false, true);
            value = jreader.next() != null ? jreader.getValue() : null;
        }
        catch (IOException e) {
            // empty catch block
        }
        return (T)value;
    }

    public <T> T parse(CharSequence s, Class<? extends T> cls) throws JSONException {
        return this.parse(s, (Type)cls);
    }

    public <T> T parse(CharSequence cs, Type type) throws JSONException {
        CharSequenceInputSource is = cs instanceof String ? new StringInputSource((String)cs) : (cs instanceof StringBuilder ? new StringBuilderInputSource((StringBuilder)cs) : (cs instanceof StringBuffer ? new StringBufferInputSource((StringBuffer)cs) : new CharSequenceInputSource(cs)));
        T value = null;
        try {
            Context context = new Context();
            JSONReader jreader = new JSONReader(context, is, false, true);
            Object result = jreader.next() != null ? jreader.getValue() : null;
            value = context.convertInternal(result, type);
        }
        catch (IOException e) {
            // empty catch block
        }
        return value;
    }

    public <T> T parse(InputStream in) throws IOException, JSONException {
        JSONReader jreader = new JSONReader(new Context(), new ReaderInputSource(in), false, true);
        return (T)(jreader.next() != null ? jreader.getValue() : null);
    }

    public <T> T parse(InputStream in, Class<? extends T> cls) throws IOException, JSONException {
        return this.parse(in, (Type)cls);
    }

    public <T> T parse(InputStream in, Type type) throws IOException, JSONException {
        Context context = new Context();
        JSONReader jreader = new JSONReader(context, new ReaderInputSource(in), false, true);
        Object result = jreader.next() != null ? jreader.getValue() : null;
        return context.convertInternal(result, type);
    }

    public <T> T parse(Reader reader) throws IOException, JSONException {
        JSONReader jreader = new JSONReader(new Context(), new ReaderInputSource(reader), false, true);
        return (T)(jreader.next() != null ? jreader.getValue() : null);
    }

    public <T> T parse(Reader reader, Class<? extends T> cls) throws IOException, JSONException {
        return this.parse(reader, (Type)cls);
    }

    public <T> T parse(Reader reader, Type type) throws IOException, JSONException {
        Context context = new Context();
        JSONReader jreader = new JSONReader(context, new ReaderInputSource(reader), false, true);
        Object result = jreader.next() != null ? jreader.getValue() : null;
        return context.convertInternal(result, type);
    }

    public JSONReader getReader(CharSequence cs) {
        return this.getReader(cs, true);
    }

    public JSONReader getReader(InputStream in) {
        return this.getReader(in, true);
    }

    public JSONReader getReader(Reader reader) {
        return this.getReader(reader, true);
    }

    public JSONReader getReader(CharSequence cs, boolean ignoreWhitespace) {
        CharSequenceInputSource in = cs instanceof String ? new StringInputSource((String)cs) : (cs instanceof StringBuilder ? new StringBuilderInputSource((StringBuilder)cs) : (cs instanceof StringBuffer ? new StringBufferInputSource((StringBuffer)cs) : new CharSequenceInputSource(cs)));
        return new JSONReader(new Context(), in, true, ignoreWhitespace);
    }

    public JSONReader getReader(InputStream in, boolean ignoreWhitespace) {
        return new JSONReader(new Context(), new ReaderInputSource(in), true, ignoreWhitespace);
    }

    public JSONReader getReader(Reader reader, boolean ignoreWhitespace) {
        return new JSONReader(new Context(), new ReaderInputSource(reader), true, ignoreWhitespace);
    }

    String getMessage(String id, Object ... args) {
        ResourceBundle bundle = ResourceBundle.getBundle("net.arnx.jsonic.Messages", this.locale);
        return MessageFormat.format(bundle.getString(id), args);
    }

    public Object convert(Object value, Type type) throws JSONException {
        return new Context().convertInternal(value, type);
    }

    protected <T> T postparse(Context context, Object value, Class<? extends T> cls, Type type) throws Exception {
        Converter c = null;
        if (value == null) {
            if (!cls.isPrimitive()) {
                c = NullConverter.INSTANCE;
            }
        } else {
            JSONHint hint = context.getHint();
            if (hint != null) {
                if (hint.serialized() && hint != context.skipHint) {
                    c = FormatConverter.INSTANCE;
                } else if (Serializable.class.equals(hint.type())) {
                    c = SerializableConverter.INSTANCE;
                } else if (String.class.equals(hint.type())) {
                    c = StringSerializableConverter.INSTANCE;
                }
            }
        }
        if (c == null) {
            c = value != null && cls.equals(type) && cls.isAssignableFrom(value.getClass()) ? PlainConverter.INSTANCE : CONVERT_MAP.get(cls);
        }
        if (c == null && context.memberCache != null) {
            c = (Converter)context.memberCache.get(cls);
        }
        if (c == null) {
            c = Properties.class.isAssignableFrom(cls) ? PropertiesConverter.INSTANCE : (Map.class.isAssignableFrom(cls) ? MapConverter.INSTANCE : (Collection.class.isAssignableFrom(cls) ? CollectionConverter.INSTANCE : (cls.isArray() ? ArrayConverter.INSTANCE : (cls.isEnum() ? EnumConverter.INSTANCE : (Date.class.isAssignableFrom(cls) ? DateConverter.INSTANCE : (Calendar.class.isAssignableFrom(cls) ? CalendarConverter.INSTANCE : (CharSequence.class.isAssignableFrom(cls) ? CharSequenceConverter.INSTANCE : (Appendable.class.isAssignableFrom(cls) ? AppendableConverter.INSTANCE : (cls.equals(ClassUtil.findClass("java.net.InetAddress")) ? InetAddressConverter.INSTANCE : (Array.class.isAssignableFrom(cls) || Struct.class.isAssignableFrom(cls) ? NullConverter.INSTANCE : new ObjectConverter(cls)))))))))));
            if (context.memberCache == null) {
                context.memberCache = new HashMap();
            }
            context.memberCache.put(cls, c);
        }
        if (c != null) {
            Object ret = c.convert(context, value, cls, type);
            return (T)ret;
        }
        throw new UnsupportedOperationException();
    }

    protected String normalize(String name) {
        return name;
    }

    protected boolean ignore(Context context, Class<?> target, Member member) {
        if (Modifier.isTransient(member.getModifiers())) {
            return true;
        }
        return member.getDeclaringClass().equals(Object.class);
    }

    protected <T> T create(Context context, Class<? extends T> c) throws Exception {
        Serializable instance = null;
        JSONHint hint = context.getHint();
        if (hint != null && hint.type() != Object.class) {
            c = hint.type().asSubclass(c);
        }
        if (c.isInterface()) {
            if (SortedMap.class.equals(c)) {
                instance = new TreeMap();
            } else if (Map.class.equals(c)) {
                instance = new LinkedHashMap();
            } else if (SortedSet.class.equals(c)) {
                instance = new TreeSet();
            } else if (Set.class.equals(c)) {
                instance = new LinkedHashSet();
            } else if (List.class.equals(c)) {
                instance = new ArrayList();
            } else if (Collection.class.equals(c)) {
                instance = new ArrayList();
            } else if (Appendable.class.equals(c)) {
                instance = new StringBuilder();
            }
        } else if (Modifier.isAbstract(c.getModifiers())) {
            if (Calendar.class.equals(c)) {
                instance = Calendar.getInstance();
            }
        } else if ((c.isMemberClass() || c.isAnonymousClass()) && !Modifier.isStatic(c.getModifiers())) {
            Class<?> eClass = c.getEnclosingClass();
            Constructor<T> con = c.getDeclaredConstructor(eClass);
            con.setAccessible(true);
            instance = context.contextObject != null && eClass.isAssignableFrom(context.contextObject.getClass()) ? con.newInstance(context.contextObject) : con.newInstance(new Object[]{null});
        } else {
            Constructor<T> con;
            if (Date.class.isAssignableFrom(c)) {
                try {
                    con = c.getDeclaredConstructor(Long.TYPE);
                    con.setAccessible(true);
                    instance = con.newInstance(0L);
                }
                catch (NoSuchMethodException e) {
                    // empty catch block
                }
            }
            if (instance == null) {
                con = c.getDeclaredConstructor(new Class[0]);
                con.setAccessible(true);
                instance = con.newInstance(new Object[0]);
            }
        }
        return c.cast(instance);
    }

    private static boolean isAssignableFrom(Class<?> target, Class<?> cls) {
        return target != null && target.isAssignableFrom(cls);
    }

    static {
        FORMAT_MAP.put(Boolean.TYPE, PlainFormatter.INSTANCE);
        FORMAT_MAP.put(Character.TYPE, StringFormatter.INSTANCE);
        FORMAT_MAP.put(Byte.TYPE, ByteFormatter.INSTANCE);
        FORMAT_MAP.put(Short.TYPE, NumberFormatter.INSTANCE);
        FORMAT_MAP.put(Integer.TYPE, NumberFormatter.INSTANCE);
        FORMAT_MAP.put(Long.TYPE, NumberFormatter.INSTANCE);
        FORMAT_MAP.put(Float.TYPE, FloatFormatter.INSTANCE);
        FORMAT_MAP.put(Double.TYPE, FloatFormatter.INSTANCE);
        FORMAT_MAP.put(boolean[].class, BooleanArrayFormatter.INSTANCE);
        FORMAT_MAP.put(char[].class, CharArrayFormatter.INSTANCE);
        FORMAT_MAP.put(byte[].class, ByteArrayFormatter.INSTANCE);
        FORMAT_MAP.put(short[].class, ShortArrayFormatter.INSTANCE);
        FORMAT_MAP.put(int[].class, IntArrayFormatter.INSTANCE);
        FORMAT_MAP.put(long[].class, LongArrayFormatter.INSTANCE);
        FORMAT_MAP.put(float[].class, FloatArrayFormatter.INSTANCE);
        FORMAT_MAP.put(double[].class, DoubleArrayFormatter.INSTANCE);
        FORMAT_MAP.put(Object[].class, ObjectArrayFormatter.INSTANCE);
        FORMAT_MAP.put(Boolean.class, PlainFormatter.INSTANCE);
        FORMAT_MAP.put(Character.class, StringFormatter.INSTANCE);
        FORMAT_MAP.put(Byte.class, ByteFormatter.INSTANCE);
        FORMAT_MAP.put(Short.class, NumberFormatter.INSTANCE);
        FORMAT_MAP.put(Integer.class, NumberFormatter.INSTANCE);
        FORMAT_MAP.put(Long.class, NumberFormatter.INSTANCE);
        FORMAT_MAP.put(Float.class, FloatFormatter.INSTANCE);
        FORMAT_MAP.put(Double.class, FloatFormatter.INSTANCE);
        FORMAT_MAP.put(BigInteger.class, NumberFormatter.INSTANCE);
        FORMAT_MAP.put(BigDecimal.class, NumberFormatter.INSTANCE);
        FORMAT_MAP.put(String.class, StringFormatter.INSTANCE);
        FORMAT_MAP.put(Date.class, DateFormatter.INSTANCE);
        FORMAT_MAP.put(java.sql.Date.class, DateFormatter.INSTANCE);
        FORMAT_MAP.put(Time.class, DateFormatter.INSTANCE);
        FORMAT_MAP.put(Timestamp.class, DateFormatter.INSTANCE);
        FORMAT_MAP.put(URI.class, StringFormatter.INSTANCE);
        FORMAT_MAP.put(URL.class, StringFormatter.INSTANCE);
        FORMAT_MAP.put(UUID.class, StringFormatter.INSTANCE);
        FORMAT_MAP.put(Pattern.class, StringFormatter.INSTANCE);
        FORMAT_MAP.put(Class.class, ClassFormatter.INSTANCE);
        FORMAT_MAP.put(Locale.class, LocaleFormatter.INSTANCE);
        FORMAT_MAP.put(ArrayList.class, ListFormatter.INSTANCE);
        FORMAT_MAP.put(LinkedList.class, IterableFormatter.INSTANCE);
        FORMAT_MAP.put(HashSet.class, IterableFormatter.INSTANCE);
        FORMAT_MAP.put(TreeSet.class, IterableFormatter.INSTANCE);
        FORMAT_MAP.put(LinkedHashSet.class, IterableFormatter.INSTANCE);
        FORMAT_MAP.put(HashMap.class, MapFormatter.INSTANCE);
        FORMAT_MAP.put(IdentityHashMap.class, MapFormatter.INSTANCE);
        FORMAT_MAP.put(Properties.class, MapFormatter.INSTANCE);
        FORMAT_MAP.put(TreeMap.class, MapFormatter.INSTANCE);
        FORMAT_MAP.put(LinkedHashMap.class, MapFormatter.INSTANCE);
        CONVERT_MAP.put(Boolean.TYPE, BooleanConverter.INSTANCE);
        CONVERT_MAP.put(Character.TYPE, CharacterConverter.INSTANCE);
        CONVERT_MAP.put(Byte.TYPE, ByteConverter.INSTANCE);
        CONVERT_MAP.put(Short.TYPE, ShortConverter.INSTANCE);
        CONVERT_MAP.put(Integer.TYPE, IntegerConverter.INSTANCE);
        CONVERT_MAP.put(Long.TYPE, LongConverter.INSTANCE);
        CONVERT_MAP.put(Float.TYPE, FloatConverter.INSTANCE);
        CONVERT_MAP.put(Double.TYPE, DoubleConverter.INSTANCE);
        CONVERT_MAP.put(boolean[].class, ArrayConverter.INSTANCE);
        CONVERT_MAP.put(char[].class, ArrayConverter.INSTANCE);
        CONVERT_MAP.put(byte[].class, ArrayConverter.INSTANCE);
        CONVERT_MAP.put(short[].class, ArrayConverter.INSTANCE);
        CONVERT_MAP.put(int[].class, ArrayConverter.INSTANCE);
        CONVERT_MAP.put(long[].class, ArrayConverter.INSTANCE);
        CONVERT_MAP.put(float[].class, ArrayConverter.INSTANCE);
        CONVERT_MAP.put(double[].class, ArrayConverter.INSTANCE);
        CONVERT_MAP.put(Object[].class, ArrayConverter.INSTANCE);
        CONVERT_MAP.put(Boolean.class, BooleanConverter.INSTANCE);
        CONVERT_MAP.put(Character.class, CharacterConverter.INSTANCE);
        CONVERT_MAP.put(Byte.class, ByteConverter.INSTANCE);
        CONVERT_MAP.put(Short.class, ShortConverter.INSTANCE);
        CONVERT_MAP.put(Integer.class, IntegerConverter.INSTANCE);
        CONVERT_MAP.put(Long.class, LongConverter.INSTANCE);
        CONVERT_MAP.put(Float.class, FloatConverter.INSTANCE);
        CONVERT_MAP.put(Double.class, DoubleConverter.INSTANCE);
        CONVERT_MAP.put(BigInteger.class, BigIntegerConverter.INSTANCE);
        CONVERT_MAP.put(BigDecimal.class, BigDecimalConverter.INSTANCE);
        CONVERT_MAP.put(Number.class, BigDecimalConverter.INSTANCE);
        CONVERT_MAP.put(Pattern.class, PatternConverter.INSTANCE);
        CONVERT_MAP.put(TimeZone.class, TimeZoneConverter.INSTANCE);
        CONVERT_MAP.put(Locale.class, LocaleConverter.INSTANCE);
        CONVERT_MAP.put(File.class, FileConverter.INSTANCE);
        CONVERT_MAP.put(URL.class, URLConverter.INSTANCE);
        CONVERT_MAP.put(URI.class, URIConverter.INSTANCE);
        CONVERT_MAP.put(UUID.class, UUIDConverter.INSTANCE);
        CONVERT_MAP.put(Charset.class, CharsetConverter.INSTANCE);
        CONVERT_MAP.put(Class.class, ClassConverter.INSTANCE);
        CONVERT_MAP.put(Date.class, DateConverter.INSTANCE);
        CONVERT_MAP.put(java.sql.Date.class, DateConverter.INSTANCE);
        CONVERT_MAP.put(Time.class, DateConverter.INSTANCE);
        CONVERT_MAP.put(Timestamp.class, DateConverter.INSTANCE);
        CONVERT_MAP.put(Calendar.class, CalendarConverter.INSTANCE);
        CONVERT_MAP.put(Collection.class, CollectionConverter.INSTANCE);
        CONVERT_MAP.put(Set.class, CollectionConverter.INSTANCE);
        CONVERT_MAP.put(List.class, CollectionConverter.INSTANCE);
        CONVERT_MAP.put(SortedSet.class, CollectionConverter.INSTANCE);
        CONVERT_MAP.put(LinkedList.class, CollectionConverter.INSTANCE);
        CONVERT_MAP.put(HashSet.class, CollectionConverter.INSTANCE);
        CONVERT_MAP.put(TreeSet.class, CollectionConverter.INSTANCE);
        CONVERT_MAP.put(LinkedHashSet.class, CollectionConverter.INSTANCE);
        CONVERT_MAP.put(Map.class, MapConverter.INSTANCE);
        CONVERT_MAP.put(SortedMap.class, MapConverter.INSTANCE);
        CONVERT_MAP.put(HashMap.class, MapConverter.INSTANCE);
        CONVERT_MAP.put(IdentityHashMap.class, MapConverter.INSTANCE);
        CONVERT_MAP.put(TreeMap.class, MapConverter.INSTANCE);
        CONVERT_MAP.put(LinkedHashMap.class, MapConverter.INSTANCE);
        CONVERT_MAP.put(Properties.class, PropertiesConverter.INSTANCE);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public final class Context {
        private final Locale locale;
        private final TimeZone timeZone;
        private final Object contextObject;
        private final int maxDepth;
        private final boolean prettyPrint;
        private final int initialIndent;
        private final String indentText;
        private final boolean suppressNull;
        private final Mode mode;
        private final String numberFormat;
        private final String dateFormat;
        private final NamingStyle propertyStyle;
        private final NamingStyle enumStyle;
        private Object[] path;
        private int depth = -1;
        private Map<Class<?>, Object> memberCache;
        private final LocalCache cache;
        JSONHint skipHint;

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Context() {
            JSON jSON2 = JSON.this;
            synchronized (jSON2) {
                this.locale = JSON.this.locale;
                this.timeZone = JSON.this.timeZone;
                this.contextObject = JSON.this.contextObject;
                this.maxDepth = JSON.this.maxDepth;
                this.prettyPrint = JSON.this.prettyPrint;
                this.initialIndent = JSON.this.initialIndent;
                this.indentText = JSON.this.indentText;
                this.suppressNull = JSON.this.suppressNull;
                this.mode = JSON.this.mode;
                this.numberFormat = JSON.this.numberFormat;
                this.dateFormat = JSON.this.dateFormat;
                this.propertyStyle = JSON.this.propertyStyle;
                this.enumStyle = JSON.this.enumStyle;
                this.cache = new LocalCache("net.arnx.jsonic.Messages", this.locale, this.timeZone);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private Context(Context context) {
            Context context2 = context;
            synchronized (context2) {
                this.locale = context.locale;
                this.timeZone = context.timeZone;
                this.contextObject = context.contextObject;
                this.maxDepth = context.maxDepth;
                this.prettyPrint = context.prettyPrint;
                this.initialIndent = context.initialIndent;
                this.indentText = context.indentText;
                this.suppressNull = context.suppressNull;
                this.mode = context.mode;
                this.numberFormat = context.numberFormat;
                this.dateFormat = context.dateFormat;
                this.propertyStyle = context.propertyStyle;
                this.enumStyle = context.enumStyle;
                this.depth = context.depth;
                this.path = (Object[])context.path.clone();
                this.cache = context.cache;
            }
        }

        Context copy() {
            return new Context(this);
        }

        public Locale getLocale() {
            return this.locale;
        }

        public TimeZone getTimeZone() {
            return this.timeZone;
        }

        public int getMaxDepth() {
            return this.maxDepth;
        }

        public boolean isPrettyPrint() {
            return this.prettyPrint;
        }

        public int getInitialIndent() {
            return this.initialIndent;
        }

        public String getIndentText() {
            return this.indentText;
        }

        public boolean isSuppressNull() {
            return this.suppressNull;
        }

        public Mode getMode() {
            return this.mode;
        }

        public NamingStyle getPropertyStyle() {
            return this.propertyStyle;
        }

        public NamingStyle getEnumStyle() {
            return this.enumStyle;
        }

        public LocalCache getLocalCache() {
            return this.cache;
        }

        @Deprecated
        public int getLevel() {
            return this.getDepth();
        }

        public int getDepth() {
            return this.depth;
        }

        public Object getKey() {
            return this.path[this.depth * 2];
        }

        public Object getKey(int depth) {
            if (depth < 0) {
                depth = this.getDepth() + depth;
            }
            return this.path[depth * 2];
        }

        public JSONHint getHint() {
            return (JSONHint)this.path[this.depth * 2 + 1];
        }

        public <T> T convert(Object key, Object value, Class<? extends T> c) throws Exception {
            this.enter(key, this.getHint());
            T o = JSON.this.postparse(this, value, c, c);
            this.exit();
            return (T)(c.isPrimitive() ? PlainConverter.getDefaultValue(c).getClass() : c).cast(o);
        }

        public Object convert(Object key, Object value, Type t) throws Exception {
            Class<?> c = ClassUtil.getRawType(t);
            this.enter(key, this.getHint());
            Object o = JSON.this.postparse(this, value, c, t);
            this.exit();
            return (c.isPrimitive() ? PlainConverter.getDefaultValue(c).getClass() : c).cast(o);
        }

        void enter(Object key, JSONHint hint) {
            ++this.depth;
            if (this.path == null) {
                this.path = new Object[8];
            }
            if (this.path.length < this.depth * 2 + 2) {
                Object[] newPath = new Object[Math.max(this.path.length * 2, this.depth * 2 + 2)];
                System.arraycopy(this.path, 0, newPath, 0, this.path.length);
                this.path = newPath;
            }
            this.path[this.depth * 2] = key;
            this.path[this.depth * 2 + 1] = hint;
        }

        void enter(Object key) {
            this.enter(key, this.getHint());
        }

        void exit() {
            --this.depth;
        }

        NumberFormat getNumberFormat() {
            JSONHint hint = this.getHint();
            String format = hint != null && hint.format().length() > 0 ? hint.format() : this.numberFormat;
            return format != null ? this.getLocalCache().getNumberFormat(format) : null;
        }

        DateFormat getDateFormat() {
            JSONHint hint = this.getHint();
            String format = hint != null && hint.format().length() > 0 ? hint.format() : this.dateFormat;
            return format != null ? this.getLocalCache().getDateFormat(format) : null;
        }

        public String toString() {
            StringBuilderOutputSource sb = new StringBuilderOutputSource(new StringBuilder());
            for (int i = 0; i < this.path.length; i += 2) {
                Object key = this.path[i];
                if (key == null) {
                    sb.append("[null]");
                    continue;
                }
                if (key instanceof Number) {
                    sb.append('[');
                    sb.append(key.toString());
                    sb.append(']');
                    continue;
                }
                if (key instanceof Character) {
                    sb.append(key.toString());
                    continue;
                }
                String str = key.toString();
                boolean escape = false;
                for (int j = 0; j < str.length(); ++j) {
                    if (j == 0) {
                        escape = !Character.isJavaIdentifierStart(str.charAt(j));
                    } else {
                        boolean bl = escape = !Character.isJavaIdentifierPart(str.charAt(j));
                    }
                    if (escape) break;
                }
                if (escape) {
                    sb.append('[');
                    try {
                        StringFormatter.serialize(this, str, sb);
                    }
                    catch (Exception e) {
                        // empty catch block
                    }
                    sb.append(']');
                    continue;
                }
                sb.append('.');
                sb.append(str);
            }
            return sb.toString();
        }

        final Object preformatInternal(Object value) {
            if (value == null) {
                return null;
            }
            if (this.getDepth() > this.getMaxDepth()) {
                return null;
            }
            if (JSON.this.getClass() != JSON.class) {
                try {
                    return JSON.this.preformat(this, value);
                }
                catch (Exception e) {
                    throw new JSONException(JSON.this.getMessage("json.format.ConversionError", value, this), 150, e);
                }
            }
            return value;
        }

        final Formatter formatInternal(Object src, OutputSource ap) throws IOException {
            boolean isStruct;
            Object o = src;
            Formatter f = null;
            if (o == null) {
                f = NullFormatter.INSTANCE;
            } else {
                JSONHint hint = this.getHint();
                if (hint != null) {
                    if (hint.serialized() && hint != this.skipHint) {
                        f = PlainFormatter.INSTANCE;
                    } else if (String.class.equals(hint.type())) {
                        f = StringFormatter.INSTANCE;
                    } else if (Serializable.class.equals(hint.type())) {
                        f = SerializableFormatter.INSTANCE;
                    }
                }
            }
            if (f == null) {
                f = (Formatter)FORMAT_MAP.get(o.getClass());
            }
            if (f == null && this.memberCache != null) {
                f = (Formatter)this.memberCache.get(o.getClass());
            }
            if (f == null) {
                if (o.getClass().isEnum()) {
                    f = EnumFormatter.INSTANCE;
                } else if (o instanceof Map) {
                    f = MapFormatter.INSTANCE;
                } else if (o instanceof Iterable) {
                    f = o instanceof RandomAccess && o instanceof List ? ListFormatter.INSTANCE : IterableFormatter.INSTANCE;
                } else if (o.getClass().isArray()) {
                    f = ObjectArrayFormatter.INSTANCE;
                } else if (o instanceof CharSequence) {
                    f = StringFormatter.INSTANCE;
                } else if (o instanceof Date) {
                    f = DateFormatter.INSTANCE;
                } else if (o instanceof Calendar) {
                    f = CalendarFormatter.INSTANCE;
                } else if (o instanceof Number) {
                    f = NumberFormatter.INSTANCE;
                } else if (o instanceof Iterator) {
                    f = IteratorFormatter.INSTANCE;
                } else if (o instanceof Enumeration) {
                    f = EnumerationFormatter.INSTANCE;
                } else if (o instanceof Type || o instanceof Member || o instanceof File) {
                    f = StringFormatter.INSTANCE;
                } else if (o instanceof TimeZone) {
                    f = TimeZoneFormatter.INSTANCE;
                } else if (o instanceof Charset) {
                    f = CharsetFormatter.INSTANCE;
                } else if (o instanceof Array) {
                    f = SQLArrayFormatter.INSTANCE;
                } else if (o instanceof Struct) {
                    f = StructFormmatter.INSTANCE;
                } else if (o instanceof Node) {
                    if (o instanceof CharacterData && !(o instanceof Comment)) {
                        f = CharacterDataFormatter.INSTANCE;
                    } else if (o instanceof Document) {
                        f = DOMDocumentFormatter.INSTANCE;
                    } else if (o instanceof Element) {
                        f = DOMElementFormatter.INSTANCE;
                    }
                } else {
                    f = JSON.isAssignableFrom(ClassUtil.findClass("java.sql.RowId"), o.getClass()) ? SerializableFormatter.INSTANCE : (JSON.isAssignableFrom(ClassUtil.findClass("java.net.InetAddress"), o.getClass()) ? InetAddressFormatter.INSTANCE : (JSON.isAssignableFrom(ClassUtil.findClass("org.apache.commons.beanutils.DynaBean"), o.getClass()) ? DynaBeanFormatter.INSTANCE : new ObjectFormatter(o.getClass())));
                }
                if (this.memberCache == null) {
                    this.memberCache = new HashMap();
                }
                this.memberCache.put(o.getClass(), f);
            }
            try {
                isStruct = f.format(this, src, o, ap);
            }
            catch (IOException e) {
                throw e;
            }
            catch (Exception e) {
                throw new JSONException(JSON.this.getMessage("json.format.ConversionError", src instanceof CharSequence ? "\"" + src + "\"" : src, this), 100, e);
            }
            if (!isStruct && this.getDepth() == 0 && this.getMode() != Mode.SCRIPT) {
                throw new JSONException(JSON.this.getMessage("json.format.IllegalRootTypeError", new Object[0]), 100);
            }
            return f;
        }

        <T> T postparseInternal(Object value, Class<? extends T> cls, Type type) throws Exception {
            return JSON.this.postparse(this, value, cls, type);
        }

        <T> T convertInternal(Object value, Type type) throws JSONException {
            if (type instanceof TypeReference) {
                type = ((TypeReference)type).getType();
            }
            Class<?> cls = ClassUtil.getRawType(type);
            T result = null;
            try {
                this.enter(Character.valueOf('$'), null);
                result = (T)JSON.this.postparse(this, value, cls, type);
                this.exit();
            }
            catch (Exception e) {
                String text;
                if (value instanceof CharSequence) {
                    text = "\"" + value + "\"";
                } else {
                    try {
                        text = value.toString();
                    }
                    catch (Exception e2) {
                        text = value.getClass().toString();
                    }
                }
                throw new JSONException(JSON.this.getMessage("json.parse.ConversionError", text, type, this), 250, e);
            }
            return result;
        }

        <T> T createInternal(Class<? extends T> c) throws Exception {
            return JSON.this.create(this, c);
        }

        boolean ignoreInternal(Class<?> target, Member member) {
            return JSON.this.ignore(this, target, member);
        }

        String normalizeInternal(String name) {
            return JSON.this.normalize(name);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Mode {
        TRADITIONAL,
        STRICT,
        SCRIPT;

    }
}

