package jp.nekoteki.android.demowatcher;

import android.R.bool;
import android.os.Bundle;
import android.os.Environment;
import android.preference.PreferenceManager;
import android.app.Activity;
import android.app.AlarmManager;
import android.app.PendingIntent;
import android.content.Context;
import android.content.Intent;
import android.content.SharedPreferences;
import android.content.SharedPreferences.Editor;
import android.sax.TextElementListener;
import android.text.Editable;
import android.text.TextWatcher;
import android.util.Log;
import android.view.Menu;
import android.view.View;
import android.widget.CheckBox;
import android.widget.CompoundButton;
import android.widget.EditText;
import android.widget.RadioButton;
import android.widget.RadioGroup;
import android.widget.RadioGroup.OnCheckedChangeListener;

public class MainActivity extends Activity {
	protected SharedPreferences prefs;
	protected WatchService watcher;

	@Override
	protected void onCreate(Bundle savedInstanceState) {
		super.onCreate(savedInstanceState);
		setContentView(R.layout.activity_main);
		
		this.prefs = PreferenceManager.getDefaultSharedPreferences(this);
		this.watcher = new WatchService();

		RadioGroup enable_raidos = (RadioGroup) findViewById(R.id.radioGroupEnabled);
		enable_raidos.setOnCheckedChangeListener(new OnCheckedChangeListener() {
			@Override
			public void onCheckedChanged(RadioGroup group, int checkedId) {
				if (checkedId == R.id.radio_disabled) {
					MainActivity.this.cancelSchedule();
				} else {
					MainActivity.this.schedule();
				}
				
			}
		});
		
		if (prefs.getString("method", "package").equals("url")) {
			((RadioButton) findViewById(R.id.radio_launch_url)).setChecked(true);
		} else {
			((RadioButton) findViewById(R.id.radio_launch_package)).setChecked(true);;
		}
		RadioGroup method_raidos = (RadioGroup) findViewById(R.id.radioGroupMethod);
		method_raidos.setOnCheckedChangeListener(new OnCheckedChangeListener() {
			@Override
			public void onCheckedChanged(RadioGroup group, int checkedId) {
				Editor peditor = MainActivity.this.prefs.edit();
				if (checkedId == R.id.radio_launch_url) {
					peditor.putString("method", "url");
				} else {
					peditor.putString("method", "package");
				}
				peditor.commit();
				MainActivity.this.reSchdule();
			}
		});

		EditText interval = (EditText) findViewById(R.id.text_interval);
		interval.setText(String.valueOf(prefs.getInt("interval", WatchService.DEFAULT_INTERVAL)));
		interval.addTextChangedListener(new TextWatcher() {
			@Override
			public void onTextChanged(CharSequence s, int start, int before, int count) {}
			
			@Override
			public void beforeTextChanged(CharSequence s, int start, int count, int after) {}
			
			@Override
			public void afterTextChanged(Editable s) {
				Editor peditor = MainActivity.this.prefs.edit();
				peditor.putInt("interval", MainActivity.this.getInterval()/1000);
				peditor.commit();
				MainActivity.this.reSchdule();
			}
		});
		
		EditText open = (EditText) findViewById(R.id.text_open);
		open.setText(prefs.getString("open", WatchService.DEFAULT_OPEN));
		open.addTextChangedListener(new TextWatcher() {
			@Override
			public void onTextChanged(CharSequence s, int start, int before, int count) {}
			
			@Override
			public void beforeTextChanged(CharSequence s, int start, int count, int after) {}

			@Override
			public void afterTextChanged(Editable s) {
				Editor peditor = MainActivity.this.prefs.edit();
				peditor.putString("open", s.toString());
				peditor.commit();
				MainActivity.this.reSchdule();
			}
		});
		
		EditText watch = (EditText) findViewById(R.id.text_watch);
		watch.setText(prefs.getString("watch", WatchService.DEFAULT_WATCH));
		watch.addTextChangedListener(new TextWatcher() {
			@Override
			public void onTextChanged(CharSequence s, int start, int before, int count) {}

			@Override
			public void beforeTextChanged(CharSequence s, int start, int count, int after) {}
			
			@Override
			public void afterTextChanged(Editable s) {
				Editor peditor = MainActivity.this.prefs.edit();
				peditor.putString("watch", s.toString());
				peditor.commit();
				MainActivity.this.reSchdule();
			}
		});
		
		CheckBox check_boot = (CheckBox) findViewById(R.id.check_boot);
		check_boot.setChecked(prefs.getBoolean("handle_boot", true));
		check_boot.setOnClickListener(new View.OnClickListener() {
			@Override
			public void onClick(View v) {
				Editor peditor = MainActivity.this.prefs.edit();
				peditor.putBoolean("handle_boot", ((CheckBox) v).isChecked()); 
				peditor.commit();
			}
		});
			
		CheckBox check_pc = (CheckBox) findViewById(R.id.check_power_connected);
		check_pc.setChecked(prefs.getBoolean("handle_boot", true));
		check_pc.setOnClickListener(new View.OnClickListener() {
			@Override
			public void onClick(View v) {
				Editor peditor = MainActivity.this.prefs.edit();
				peditor.putBoolean("handle_power_connected", ((CheckBox) v).isChecked()); 
				peditor.commit();
			}
		});
			
		CheckBox check_pd = (CheckBox) findViewById(R.id.check_power_disconnected);
		check_pd.setChecked(prefs.getBoolean("handle_boot", true));
		check_pd.setOnClickListener(new View.OnClickListener() {
			@Override
			public void onClick(View v) {
				Editor peditor = MainActivity.this.prefs.edit();
				peditor.putBoolean("handle_power_disconnected", ((CheckBox) v).isChecked()); 
				peditor.commit();
			}
		});
		
		if (prefs.getBoolean("enabled", false))
			schedule();
	}
	
	@Override
	protected void onResume() {
		super.onResume();
		
		if (this.prefs.getBoolean("enabled", false)) {
			((RadioButton) findViewById(R.id.radio_enabled)).setChecked(true);;
		} else {
			((RadioButton) findViewById(R.id.radio_disabled)).setChecked(true);
		}
	}

	@Override
	public boolean onCreateOptionsMenu(Menu menu) {
		// Inflate the menu; this adds items to the action bar if it is present.
		getMenuInflater().inflate(R.menu.main, menu);
		return true;
	}
	
	public void reSchdule() {
		if (cancelSchedule())
			schedule();
	}
	
	public boolean cancelSchedule() {
		return watcher.cancelSchedule(getApplicationContext());
	}
	
	public boolean schedule() {
		Log.d(this.getClass().getSimpleName(), "Enable watch schedule");
		Editor peditor = this.prefs.edit();
		peditor.putBoolean("enabled", true);
		peditor.commit();
		return watcher.schedule(getApplicationContext());
	}
	
	public int getInterval() {
		int sec;
		try {
			sec = Integer.valueOf(((EditText) findViewById(R.id.text_interval)).getText().toString());
		} catch (Exception e) {
			sec = 0;
		}
		if (sec < 1)
			sec = WatchService.DEFAULT_INTERVAL;
		Log.d(this.getClass().getSimpleName(), "getInterval: "+String.valueOf(sec));
		return sec * 1000;
	}
	
}
