﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;
using System.Windows;
using System.Windows.Controls;
using System.Windows.Data;
using System.Windows.Documents;
using System.Windows.Input;
using System.Windows.Media;
using System.Windows.Media.Imaging;
using System.Windows.Shapes;
using NationalInstruments.NI4882;


namespace SpiderNet
{
	/// <summary>
	/// WarningDialog.xaml の相互作用ロジック
	/// </summary>
	public partial class WarningDialog : Window
	{

		public WarningDialog(string MessageIDString) {
			System.Resources.ResourceManager rm =
			new System.Resources.ResourceManager("SpiderNet.Properties.Resources", typeof(WarningDialog).Assembly);
			DialogText.Content = rm.GetString(MessageIDString);
			ShowDialog();
		}

		public WarningDialog(string MessageIDString, string AdditionalMessage) {
			System.Resources.ResourceManager rm =
			new System.Resources.ResourceManager("SpiderNet.Properties.Resources", typeof(WarningDialog).Assembly);
			DialogText.Content = rm.GetString(MessageIDString);
			DialogText.Content += "\n" + AdditionalMessage;
			ShowDialog();
		}

		private void Button_Click(object sender, RoutedEventArgs e) {
			DialogResult = true;
			Close();
		}
	}
}
