#!/usr/bin/perl
# SourceForge.JP Wiki manipulator
# by hylom
# This code is under GPL.
#

use warnings;
use strict;

use utf8;
use open IO => ':utf8';
use open ':std';

use Getopt::Std;
use SourceForgeJP;
use IO::File;
use Term::Prompt;
use URI::Escape;
use Encode;
use File::Temp;

my $usage = <<EOD;
upload.pl {login|upload} [<file>]
EOD

my $command = shift @ARGV;
unless( $command ) {
  print $usage;
  exit;
}

if( $command eq 'login' ) {   #login
  my $login_name;
  my $password;

  $login_name = prompt( 'x', 'loginname:', '', '' );
  $password = prompt( 'p', 'password:', '', '' );
  print "do login...\n";
  if( login( $login_name, $password) ) {
	print "ok.\n";
  } else {
	print "login failed.\n"
  }
} elsif( $command eq 'upload' ) {
  my $file_name = shift @ARGV;
  
  add_attachment( $project, $page, $file );
} else {    #other
  print $usage;
  exit;
}

sub login {
  my $login_name = shift @_;
  my $password = shift @_;

  my $sf = WWW::SourceForgeJP->new();
  $sf->login( $login_name, $password );
  print "save cookie to " . $sf->{"cookies_file"} . "\n" ;
}

sub logout {
  my $sf = WWW::SourceForgeJP->new();
  $sf->logout();
}

sub edit {
  my $project = shift @_;
  my $page = shift @_;
  my $file = shift @_;
  my $comment = shift @_;

  $comment = "" if( ! defined $comment );

  my $file_handle = IO::File->new($file, "r") or die "$! : $file\n" ;
  my $text = do { local $/; <$file_handle> };

  my $sf = WWW::SourceForgeJP->new();

  $sf->Wiki->edit_page( project => $project,
						page => $page,
						text => $text,
						comment => $comment );
}

sub add_attachment {
  my $project = shift @_;
  my $page = shift @_;
  my $file = shift @_;

  if( ! -e $file ) {
	die "$file is not exist.\n";
  }

  my $sf = WWW::SourceForgeJP->new();

  my $ret = $sf->Wiki->post_attachment( project => $project,
										page => $page,
										file => $file );
  if( $ret ) {
	print "$file: upload succeed.\n";
  } else {
	print "$file: upload failed.\n";
  }
}

