#!/usr/bin/python
# -*- coding: utf-8 -*-

import smtplib
from email.mime.text import MIMEText
import email.utils
import json
import os.path
import sys

MAIL_ACCOUNT_FILE = '~/local/linkchecker/.mailaccount'

def get_mail_config():
    realpath = os.path.expanduser(MAIL_ACCOUNT_FILE)
    if(os.path.isfile(realpath)):
        f = open(realpath)
        acc  =json.load(f)
        f.close()
        return acc
    return None

def send(msg_subject, msg_body):
    acc = get_mail_config()
    if acc == None:
        sys.stderr.write("can't open mail account file: %s\n" % MAIL_ACCOUNT_FILE)
        sys.exit(1)
    msg = MIMEText(msg_body)
    msg['Subject'] = msg_subject
    msg['From'] = acc["from"]
    msg['To'] = acc["to"]
    msg['Date'] = email.utils.formatdate()

    con = smtplib.SMTP_SSL(acc["host"])
    con.login(acc["user"], acc["password"])
    con.sendmail(acc["from"], [acc["to"]], msg.as_string())
    con.close()

if __name__ == '__main__':
    send('SourceForge.JP Magazine Alert', 
         'Alert from linkchecker.')
