# declaration of function
function(get_build_type var)
  if(MSVC)
      set(${var} "msvc-build" PARENT_SCOPE)
  else()
    string(TOLOWER ${CMAKE_BUILD_TYPE} CMAKE_BUILD_TYPE_TOLOWER)
    if(MINGW)
      set(${var} "${CMAKE_BUILD_TYPE_TOLOWER}-mingw" PARENT_SCOPE)
    else()
      set(${var} ${CMAKE_BUILD_TYPE_TOLOWER} PARENT_SCOPE)
    endif()
  endif()
endfunction()

function(link_bullet target)
  if(BUILD_SHARED_LIBS OR MSVC)
    if(VPVL2_NO_BULLET)
      target_link_libraries(${target} ${BULLET_LINEARMATH_LIB})
    else()
      target_link_libraries(${target} ${BULLET_COLLISION_LIB} ${BULLET_DYNAMICS_LIB} ${BULLET_SOFTBODY_LIB} ${BULLET_LINEARMATH_LIB})
        endif()
  endif()
endfunction()

function(find_bullet target)
  get_build_type(BULLET_BUILD_TYPE)
  set(BULLET_SOURCE_DIRECTORY "${CMAKE_CURRENT_SOURCE_DIR}/../bullet-src")
  set(BULLET_LIBRARY_LOCAL_DIR "${BULLET_SOURCE_DIRECTORY}/${BULLET_BUILD_TYPE}/lib")
  # find from MMDAI/bullet or environment variables
  find_path(BULLET_INCLUDE_DIR btBulletCollisionCommon.h PATHS "${BULLET_SOURCE_DIRECTORY}/src" $ENV{BULLET_INCLUDE_DIR})
  if(BULLET_INCLUDE_DIR)
    include_directories(${BULLET_INCLUDE_DIR})
  else()
    find_path(BULLET_INCLUDE_DIR bullet/btBulletCollisionCommon.h PATHS "${BULLET_SOURCE_DIRECTORY}/src" $ENV{BULLET_INCLUDE_DIR})
    include_directories(${BULLET_INCLUDE_DIR}/bullet)
  endif()
  if(BUILD_SHARED_LIBS OR MSVC)
    find_library(BULLET_LINEARMATH_LIB LinearMath PATHS ${BULLET_LIBRARY_LOCAL_DIR} $ENV{BULLET_LIBRARY_DIR})
    if(NOT VPVL2_NO_BULLET)
      find_library(BULLET_COLLISION_LIB BulletCollision PATHS ${BULLET_LIBRARY_LOCAL_DIR} $ENV{BULLET_LIBRARY_DIR})
      find_library(BULLET_DYNAMICS_LIB BulletDynamics PATHS ${BULLET_LIBRARY_LOCAL_DIR} $ENV{BULLET_LIBRARY_DIR})
      find_library(BULLET_SOFTBODY_LIB BulletSoftBody PATHS ${BULLET_LIBRARY_LOCAL_DIR} $ENV{BULLET_LIBRARY_DIR})
    endif()
  endif()
  link_bullet(${target})
endfunction()

function(link_assimp target)
  if((BUILD_SHARED_LIBS OR MSVC) AND VPVL2_LINK_ASSIMP)
    target_link_libraries(${target} ${ASSIMP_LIBRARY})
  endif()
endfunction()

function(find_assimp target)
  if(VPVL2_LINK_ASSIMP)
    get_build_type(ASSIMP_BUILD_TYPE)
    set(ASSIMP_SOURCE_DIRECTORY "${CMAKE_CURRENT_SOURCE_DIR}/../assimp-src")
    set(ASSIMP_LOCAL_LIBRARY_DIR "${ASSIMP_SOURCE_DIRECTORY}/${ASSIMP_BUILD_TYPE}/code")
    set(ASSIMP_LOCAL_INCLUDE_DIR "${ASSIMP_SOURCE_DIRECTORY}/include")
    find_path(ASSIMP_INCLUDE_DIR assimp.hpp PATHS ${ASSIMP_LOCAL_INCLUDE_DIR} $ENV{ASSIMP_INCLUDE_DIR})
    if(ASSIMP_INCLUDE_DIR)
      include_directories(${ASSIMP_INCLUDE_DIR})
    else()
      find_path(ASSIMP_INCLUDE_DIR assimp/assimp.hpp PATHS ${ASSIMP_LOCAL_INCLUDE_DIR} $ENV{ASSIMP_INCLUDE_DIR})
      include_directories(${ASSIMP_INCLUDE_DIR}/assimp)
    endif()
    if(BUILD_SHARED_LIBS OR MSVC)
      find_library(ASSIMP_LIBRARY assimp PATHS ${ASSIMP_LOCAL_LIBRARY_DIR} $ENV{ASSIMP_LIBRARY_DIR})
    endif()
    link_assimp(${target})
  endif()
endfunction()

function(link_vpvl target)
  if((BUILD_SHARED_LIBS OR MSVC) AND VPVL2_LINK_VPVL)
    target_link_libraries(${target} ${VPVL_LIBRARY})
  endif()
endfunction()

function(find_vpvl target)
  if(VPVL2_LINK_VPVL)
    get_build_type(VPVL_BUILD_TYPE)
    set(VPVL_SOURCE_DIRECTORY "${CMAKE_CURRENT_SOURCE_DIR}/../libvpvl")
    set(VPVL_LOCAL_BUILD_DIR "${VPVL_SOURCE_DIRECTORY}/${VPVL_BUILD_TYPE}")
    set(VPVL_LOCAL_INCLUDE_DIR "${VPVL_SOURCE_DIRECTORY}/include")
    find_path(VPVL_INCLUDE_DIR vpvl/vpvl.h PATHS ${VPVL_LOCAL_INCLUDE_DIR} $ENV{VPVL_INCLUDE_DIR})
    find_path(VPVL_CONFIG_DIR vpvl/config.h PATHS "${VPVL_LOCAL_BUILD_DIR}/include" $ENV{VPVL_CONFIG_DIR})
    include_directories(${VPVL_INCLUDE_DIR} ${VPVL_CONFIG_DIR})
    if(BUILD_SHARED_LIBS OR MSVC)
      set(VPVL_LIBRARY_NAME vpvl)
      append_lib_type_suffix(VPVL_LIBRARY_NAME)
      find_library(VPVL_LIBRARY ${VPVL_LIBRARY_NAME} PATHS "${VPVL_LOCAL_BUILD_DIR}/lib" $ENV{VPVL_LIBRARY_DIR})
    endif()
    link_vpvl(${target})
  endif()
endfunction()

function(link_glew target)
  if(VPVL2_OPENGL_RENDERER AND VPVL2_LINK_GLEW)
    target_link_libraries(${target} ${GLEW_LIBRARY})
    if(MSVC)
      target_link_libraries(${target} ${GLEW_MX_LIBRARY})
    endif()
  endif()
endfunction()

function(find_glew target)
  if(VPVL2_OPENGL_RENDERER AND VPVL2_LINK_GLEW)
    if(BUILD_SHARED_LIBS)
      find_library(GLEW_LIBRARY GLEW glew glew32 PATHS ${CMAKE_CURRENT_SOURCE_DIR}/../glew-src/lib)
    else()
      find_library(GLEW_LIBRARY GLEW glew glew32s PATHS ${CMAKE_CURRENT_SOURCE_DIR}/../glew-src/lib)
    endif()
    if(MSVC)
      if(BUILD_SHARED_LIBS)
        find_library(GLEW_MX_LIBRARY glew32mx PATHS ${CMAKE_CURRENT_SOURCE_DIR}/../glew-src/lib)
      else()
        find_library(GLEW_MX_LIBRARY glew32mxs PATHS ${CMAKE_CURRENT_SOURCE_DIR}/../glew-src/lib)
      endif()
    endif()
    find_path(GLEW_INCLUDE_DIR GL/glew.h PATHS ${CMAKE_CURRENT_SOURCE_DIR}/../glew-src/include)
    include_directories(${GLEW_INCLUDE_DIR})
    link_glew(${target})
  endif()
endfunction()

function(link_nvtt target)
  if((BUILD_SHARED_LIBS OR MSVC) AND VPVL2_LINK_NVTT)
    target_link_libraries(${target} ${NVTT_NVCORE_LIBRARY} ${NVTT_NVIMAGE_LIBRARY} ${NVTT_NVMATH_LIBRARY})
  endif()
endfunction()

function(find_nvtt target)
  if(VPVL2_OPENGL_RENDERER AND VPVL2_LINK_NVTT)
    get_build_type(NVTT_BUILD_TYPE)
    set(NVTT_SOURCE_DIRECTORY "${CMAKE_CURRENT_SOURCE_DIR}/../nvtt-src")
    set(NVTT_INCLUDE_DIRECTORY "${NVTT_SOURCE_DIRECTORY}/src")
    set(NVTT_LOCAL_LIBRARY_DIR "${NVTT_SOURCE_DIRECTORY}/build-${NVTT_BUILD_TYPE}/lib")
    find_path(NVTT_CONFIG_INCLUDE_DIR nvconfig.h PATHS "${NVTT_LOCAL_LIBRARY_DIR}/../src" $ENV{NVTT_CONFIG_INCLUDE_DIR})
    find_path(NVTT_BASE_INCLUDE_DIR nvcore/nvcore.h PATHS ${NVTT_INCLUDE_DIRECTORY} $ENV{NVTT_BASE_INCLUDE_DIR})
    find_path(NVTT_POSH_INCLUDE_DIR posh.h PATHS "${NVTT_SOURCE_DIRECTORY}/extern/poshlib" $ENV{NVTT_POSHLIB_INCLUDE_DIR})
    find_library(NVTT_NVCORE_LIBRARY nvcore PATHS ${NVTT_LOCAL_LIBRARY_DIR} $ENV{NVTT_LIBRARY_DIR})
    find_library(NVTT_NVIMAGE_LIBRARY nvimage PATHS ${NVTT_LOCAL_LIBRARY_DIR} $ENV{NVTT_LIBRARY_DIR})
    find_library(NVTT_NVMATH_LIBRARY nvmath PATHS ${NVTT_LOCAL_LIBRARY_DIR} $ENV{NVTT_LIBRARY_DIR})
    if (NVTT_CONFIG_INCLUDE_DIR AND NVTT_BASE_INCLUDE_DIR AND NVTT_POSH_INCLUDE_DIR)
      include_directories(${NVTT_CONFIG_INCLUDE_DIR} ${NVTT_BASE_INCLUDE_DIR} ${NVTT_POSH_INCLUDE_DIR})
    else()
      message(FATAL_ERROR "Required nvtt is not found.")
    endif()
  endif()
endfunction()

function(find_openmp)
  if(VPVL2_ENABLE_OPENMP)
    find_package(OpenMP)
    if(OPENMP_FOUND)
      set(CMAKE_C_FLAGS "${CMAKE_C_FLAGS} ${OpenMP_C_FLAGS}")
      set(CMAKE_CXX_FLAGS "${CMAKE_CXX_FLAGS} ${OpenMP_CXX_FLAGS}")
    endif()
  endif()
endfunction()

function(link_icu_or_iconv target)
  find_library(ICU_LIBRARY_I18N icui18n)
  find_library(ICU_LIBRARY_UC icuuc)
  find_path(ICU_INCLUDE_DIR unicode/unistr.h)
  if(ICU_LIBRARY_I18N AND ICU_LIBRARY_UC AND ICU_INCLUDE_DIR)
    add_definitions(-DVPVL2_HAS_ICU)
    target_link_libraries(${target} ${ICU_LIBRARY_I18N} ${ICU_LIBRARY_IO} ${ICU_LIBRARY_UC})
    include_directories(${ICU_INCLUDE_DIR})
  else()
    find_library(ICONV_LIBRARY iconv)
    if(ICONV_LIBRARY)
      add_definitions(-DVPVL2_HAS_ICONV)
      target_link_libraries(${target} ${ICONV_LIBRARY})
    endif()
  endif()
endfunction()
# end of functions

# imported functions from Allegro5's cmake
function(append_lib_type_suffix var)
  string(TOLOWER "${CMAKE_BUILD_TYPE}" CMAKE_BUILD_TYPE_TOLOWER)
  if(CMAKE_BUILD_TYPE_TOLOWER STREQUAL "debug")
    set(${var} "${${var}}_debug" PARENT_SCOPE)
  endif()
  if(CMAKE_BUILD_TYPE_TOLOWER MATCHES "profile")
    set(${var} "${${var}}_profile" PARENT_SCOPE)
  endif()
endfunction()

function(append_lib_linkage_suffix var)
  if(NOT BUILD_SHARED_LIBS)
    #set(${var} "${${var}}_static" PARENT_SCOPE)
  endif()
endfunction()
# end of imported

