/*
 * CAN/LIN/UART/PORT Checker for RL78/F14
 *
 * Target: QB-R5F10PPJ-TB (RL78/F14, 100pin, 256KB ROM, 20KB RAM)
 * Author: Yasushi Tanaka
 *
 * [ fobOj^ ]
 */

#include "common.h"
#include "uart.h"
#include "log.h"
#include "debug.h"

/*
 * fobOj^
 * UART`l`
 */
#define DEBUG_UART_CH			((u1)(0x00))
									/* fobOj^UART`l(0 or 1) */

/*
 * fobOj^
 * sobt@TCY`
 */
#define DEBUG_LINE_SIZE			((u1)(0x50))
									/* X^bNɊmۂTCY */

/*
 * fobOj^
 * R[h`
 */
#define DEBUG_CODE_BS			((u1)(0x08))
									/* BS */
#define DEBUG_CODE_CR			((u1)(0x0d))
									/* CR */
#define DEBUG_CODE_LF			((u1)(0x0a))
									/* LF */
#define DEBUG_CODE_SPACE		((u1)(0x20))
									/* Xy[X */
#define DEBUG_CODE_PROMPT		((u1)(0x3e))
									/* > */
#define DEBUG_CODE_0			((u1)(0x30))
									/* 0 */
#define DEBUG_CODE_9			((u1)(0x39))
									/* 9 */
#define DEBUG_CODE_QUESTION		((u1)(0x3f))
									/* ? */
#define DEBUG_CODE_A			((u1)(0x61))
									/* a */
#define DEBUG_CODE_Z			((u1)(0x7a))
									/* z */
#define DEBUG_CODE_TERM			((u1)(0x00))
									/* I[ */

/*
 * fobOj^
 * Ԓ`
 */
#define DEBUG_STATE_DISABLE		((u1)(0x00))
									/* fobOj^֎~(ftHg) */
#define DEBUG_STATE_MENU		((u1)(0x01))
									/* TuR}h҂ */
#define DEBUG_STATE_UART		((u1)(0x02))
									/* UARTTu[h */

/*
 * fobOj^
 * vvg`
 */
#define DEBUG_PROMPT_MENU		((u1)('m'))
									/* TuR}h҂ */
#define DEBUG_PROMPT_UART		((u1)('u'))
									/* UARTTu[h */

/*
 * fobOj^
 * R}h`
 */
#define DEBUG_CMD_ENTER			((u1)('e'))
									/* fobOj^ɓ */
#define DEBUG_CMD_LEAVE			((u1)('l'))
									/* fobOj^甲 */
#define DEBUG_CMD_UART			((u1)('u'))
									/* UARTTu[h */
#define DEBUG_CMD_STATUS		((u1)('s'))
									/* Xe[^X\ */

/*
 * fobOj^
 * CҏW`
 */
#define DEBUG_EDIT_CMD			((u1)(0x02))
									/* R}hʒu */

/*
 * fobOj^
 * CҏWGA
 */
static u1 debug_edit_prompt;
									/* CҏW̐擪ɕ\镶R[h */
static u1 debug_edit_buf[DEBUG_LINE_SIZE];
									/* CҏWobt@ */
static u1 debug_edit_pos;
									/* CҏW|WV */

/*
 * fobOj^
 * ԊǗGA
 */
static u1 debug_state;
									/* ݂̏ */

/*
 * fobOj^
 * 
 */
void debug_init(void)
{
	/* fobOԂ */
	debug_state = DEBUG_STATE_DISABLE;
}

/*
 * fobOj^
 * bZ[Wo(s)
 */
static void debug_msg(char* msg)
{
	u1 buf[DEBUG_LINE_SIZE];
	u1 loop;

	/* CR, LF, I[lsizeof(buf) - 3܂ł̓Rs[ł */
	for (loop=0; loop < (sizeof(buf) - 3); loop++)
	{
		/* \0ŏI[ */
		if (*msg == '\0')
		{
			/* sƏI[ */
			buf[loop + 0] = DEBUG_CODE_CR;
			buf[loop + 1] = DEBUG_CODE_LF;
			buf[loop + 2] = DEBUG_CODE_TERM;

			/* for[vI */
			loop = (u1)(sizeof(buf) - 3);
		}
		else
		{
			/* ʏ̃Rs[ */
			buf[loop] = (u1)*msg++;
		}
	}

	/* Oo */
	log_output(buf);
}

/*
 * fobOj^
 * bZ[Wo(u2, s)
 */
static void debug_u2(char* msg, u2 value)
{
	u1 buf[DEBUG_LINE_SIZE];
	u1 loop;

	/* l, CR, LF, I[lsizeof(buf) - 7܂ł̓Rs[ł */
	for (loop=0; loop < (sizeof(buf) - 7); loop++)
	{
		/* \0ŏI[ */
		if (*msg == '\0')
		{
			/* 16i4ݒ */
			log_u2_4hex(&buf[loop], value);

			/* sƏI[ */
			buf[loop + 4] = DEBUG_CODE_CR;
			buf[loop + 5] = DEBUG_CODE_LF;
			buf[loop + 6] = DEBUG_CODE_TERM;

			/* for[vI */
			loop = (u1)(sizeof(buf) - 7);
		}
		else
		{
			/* ʏ̃Rs[ */
			buf[loop] = (u1)*msg++;
		}
	}

	/* Oo */
	log_output(buf);
}

/*
 * fobOj^
 * bZ[Wo(u4, s)
 */
static void debug_u4(char* msg, u2 high, u2 low)
{
	u1 buf[DEBUG_LINE_SIZE];
	u1 loop;

	/* l, CR, LF, I[lsizeof(buf) - 11܂ł̓Rs[ł */
	for (loop=0; loop < (sizeof(buf) - 11); loop++)
	{
		/* \0ŏI[ */
		if (*msg == '\0')
		{
			/* 16i8ݒ */
			log_u2_4hex(&buf[loop + 0], high);
			log_u2_4hex(&buf[loop + 4], low);

			/* sƏI[ */
			buf[loop + 8] = DEBUG_CODE_CR;
			buf[loop + 9] = DEBUG_CODE_LF;
			buf[loop + 10] = DEBUG_CODE_TERM;

			/* for[vI */
			loop = (u1)(sizeof(buf) - 11);
		}
		else
		{
			/* ʏ̃Rs[ */
			buf[loop] = (u1)*msg++;
		}
	}

	/* Oo */
	log_output(buf);
}

/*
 * fobOj^
 * CҏW
 */
static u1 debug_edit(u1 key)
{
	u1 ret;

	/* ߂l */
	ret = U1_FALSE;

	/* DEBUG_CODE_TERM̏ꍇ͐VK */
	if (DEBUG_CODE_TERM == key)
	{
		/* VKҏW */
		debug_edit_buf[0] = debug_edit_prompt;
		debug_edit_buf[1] = DEBUG_CODE_PROMPT;
		debug_edit_buf[2] = DEBUG_CODE_TERM;
		debug_edit_pos = DEBUG_EDIT_CMD;

		/* Oo */
		log_output(debug_edit_buf);
	}
	else
	{
		/* ̕ҏW */
		switch (key)
		{
			/* obNXy[X */
			case DEBUG_CODE_BS:
				/* debug_edit_pos`FbN */
				if (DEBUG_EDIT_CMD != debug_edit_pos)
				{
					/* obNXy[X\ */
					debug_edit_pos--;
					debug_edit_buf[debug_edit_pos + 0] = DEBUG_CODE_BS;
					debug_edit_buf[debug_edit_pos + 1] = DEBUG_CODE_SPACE;
					debug_edit_buf[debug_edit_pos + 2] = DEBUG_CODE_BS;
					debug_edit_buf[debug_edit_pos + 3] = DEBUG_CODE_TERM;

					/* o */
					log_output(&debug_edit_buf[debug_edit_pos]);
				}
				break;

			/* s */
			case DEBUG_CODE_CR:
				/* sƏI[ */
				debug_edit_buf[debug_edit_pos + 0] = DEBUG_CODE_CR;
				debug_edit_buf[debug_edit_pos + 1] = DEBUG_CODE_LF;
				debug_edit_buf[debug_edit_pos + 2] = DEBUG_CODE_TERM;

				/* o */
				log_output(&debug_edit_buf[debug_edit_pos]);

				/* ߂lU1_TRUEƂ */
				ret = U1_TRUE;

			/* ̑̕ */
			default:
				/* debug_edit_pos`FbN */
				if (debug_edit_pos != (sizeof(debug_edit_buf) - 4))
				{
					/* } */
					debug_edit_buf[debug_edit_pos] = key;
					uart_tx_start(LOG_UART_CH, &key, 1);

					/* ֐i߂ */
					debug_edit_pos++;
				}
				break;
		}
	}

	return ret;
}

/*
 * fobOj^
 * ̓G[
 */
static void debug_error(void)
{
	/* bZ[W */
	debug_msg("command or syntax error");

	/* CҏWJn */
	debug_edit(DEBUG_CODE_TERM);
}

/*
 * fobOj^
 * Cj[(̃Tu[h߂ꍇ)
 */
static void debug_menu(void)
{
	/* ԑJ */
	debug_state = DEBUG_STATE_MENU;

	/* vvgύX */
	debug_edit_prompt = DEBUG_PROMPT_MENU;

	/* CҏWJn */
	debug_edit(DEBUG_CODE_TERM);
}

/*
 * fobOj^
 * fobO[hɓ
 */
static void debug_enter(void)
{
	/* ԑJ */
	debug_state = DEBUG_STATE_MENU;

	/* O֎~ */
	log_disable();

	/* bZ[W */
	debug_msg("enter debug mode");

	/* ̃Tuj[JڂꍇƋ */
	debug_menu();
}

/*
 * fobOj^
 * fobO[h甲
 */
static void debug_leave(void)
{
	/* ԑJ */
	debug_state = DEBUG_STATE_DISABLE;

	/* bZ[W */
	debug_msg("leave debug mode");

	/* O */
	log_enable();
}

/*
 * fobOj^
 * UARTTu[h
 */
static void debug_uart(void)
{
	/* ԑJ */
	debug_state = DEBUG_STATE_UART;

	/* bZ[W */
	debug_msg("uart sub mode");

	/* vvgύX */
	debug_edit_prompt = DEBUG_PROMPT_UART;

	/* CҏWJn */
	debug_edit(DEBUG_CODE_TERM);
}

/*
 * fobOj^
 * p[X(TuR}h҂)
 */
static void debug_parse_menu(void)
{
	switch (debug_edit_buf[DEBUG_EDIT_CMD])
	{
		/* L:fobO[h甲 */
		case DEBUG_CMD_LEAVE:
			debug_leave();
			break;

		/* U:UARTTu[h */
		case DEBUG_CMD_UART:
			debug_uart();
			break;

		/* ̑:R}hG[ */
		default:
			debug_error();
			break;
	}
}

/*
 * fobOj^
 * UARTTu[h(Xe[^X)
 */
static void debug_uart_status(void)
{
	uart_stat stat;

	/* bZ[W */
	debug_msg("uart0");

	/* Xe[^X擾 */
	uart_get_stat(0, &stat);

	/* bZ[W */
	debug_msg("uart1");

	/* Xe[^X擾 */
	uart_get_stat(0, &stat);

	/* CҏWJn */
	debug_edit(DEBUG_CODE_TERM);
}

/*
 * fobOj^
 * UARTTu[h(p[X)
 */
static void debug_parse_uart(void)
{
	uart_stat stat;

	switch (debug_edit_buf[DEBUG_EDIT_CMD])
	{
		/* S:Xe[^X\ */
		case DEBUG_CMD_STATUS:
			debug_uart_status();
			break;

		/* L:Cj[֖߂ */
		case DEBUG_CMD_LEAVE:
			debug_menu();
			break;
	}
}

/*
 * fobOj^
 * p[X
 */
static void debug_parse(void)
{
	/* ԑJڂŕ */
	switch (debug_state)
	{
		/* TuR}h҂ */
		case DEBUG_STATE_MENU:
			debug_parse_menu();
			break;

		/* UARTTu[h */
		case DEBUG_STATE_UART:
			debug_parse_uart();
			break;
	}
}

/*
 * fobOj^
 * LL[̃`FbN
 *
 * LȃL[łU1_TRUEԂ
 */
static debug_chk_key(u1* key)
{
	u1 ret;
	u1 code;

	/* ߂l */
	ret = U1_FALSE;

	/* code擾 */
	code = *key;

	/* 0x20ȉBS, CR̂݋ */
	if (code < 0x20)
	{
		if ((DEBUG_CODE_BS == code) || (DEBUG_CODE_CR == code))
		{
			ret = U1_TRUE;
		}
	}

	/* 0x20̓Xy[XȂ̂ŋ */
	if (DEBUG_CODE_SPACE == code)
	{
		ret = U1_TRUE;
	}

	/* 0-9͐Ȃ̂ŋ */
	if ((code >= DEBUG_CODE_0) && (code <= DEBUG_CODE_9))
	{
		ret = U1_TRUE;
	}

	/* 0x3f̓wv(?)Ȃ̂ŋ */
	if (DEBUG_CODE_QUESTION == code)
	{
		ret = U1_TRUE;
	}

	/* 0x40-0x7fł΁A0x20OR */
	if ((code >= 0x40) && (code <= 0x7f))
	{
		/* 啶 */
		code |= 0x20;

		/* a-zł΋(code߂) */
		if ((code >= DEBUG_CODE_A) && (code <= DEBUG_CODE_Z))
		{
			*key = code;
			ret = U1_TRUE;
		}
	}

	return ret;
}

/*
 * fobOj^
 * ACh
 */
void debug_idle(void)
{
	u1 num;
	u1 key;
	u1 ret;

	/* UARThCoM𓾂 */
	num = uart_ring_get(LOG_UART_CH);

	/* 0ȊO */
	if (0 != num)
	{
		/* 1oCg擾 */
		uart_ring_deque(LOG_UART_CH, &key, 1);

		/* L[`FbN */
		ret = debug_chk_key(&key);

		/* L[`FbNɍiꍇ̂ */
		if (U1_TRUE == ret)
		{
			/* fobOj^֎~ */
			if (DEBUG_STATE_DISABLE == debug_state)
			{
				/* DBUG_CMD_ENTERł΃[hJ */
				if (DEBUG_CMD_ENTER == key)
				{
					debug_enter();
				}
			}
			else
			{
				/* sҏW */
				ret = debug_edit(key);

				/* ߂lU1_TRUEł΃p[X */
				if (U1_TRUE == ret)
				{
					debug_parse();
				}
			}
		}
	}
}
